/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.HashMap;
import java.util.Objects;
import xeij.EFPBox;
import xeij.ExpressionEvaluator;
import xeij.Multilingual;
import xeij.XEiJ;

public class Assembler {
    protected static final String ASM_MNEMONIC_BASE = "-b------- 2 2 abcd,-bwl----- 2 2 add,--wl----- 2 2 adda,-bwl----- 2 2 addi,-bwl----- 2 2 addq,-bwl----- 2 2 addx,u-------- 1 1 aline,-bwl----- 2 2 and,-bwl----- 2 2 andi,-bwl----- 1 2 asl,-bwl----- 1 2 asr,--wl-s--- 1 1 bcc,-b-l----- 2 2 bchg,-b-l----- 2 2 bclr,--wl-s--- 1 1 bcs,--wl-s--- 1 1 beq,u-------- 1 1 bfchg,u-------- 1 1 bfclr,u-------- 2 2 bfexts,u-------- 2 2 bfextu,u-------- 2 2 bfffo,u-------- 2 2 bfins,u-------- 1 1 bfset,u-------- 1 1 bftst,--wl-s--- 1 1 bge,--wl-s--- 1 1 bgt,--wl-s--- 1 1 bhi,--wl-s--- 1 1 bhs,---l----- 1 1 bitrev,u-------- 1 1 bkpt,--wl-s--- 1 1 ble,--wl-s--- 1 1 blo,--wl-s--- 1 1 bls,--wl-s--- 1 1 blt,--wl-s--- 1 1 bmi,--wl-s--- 1 1 bncc,--wl-s--- 1 1 bncs,--wl-s--- 1 1 bne,--wl-s--- 1 1 bneq,--wl-s--- 1 1 bnge,--wl-s--- 1 1 bngt,--wl-s--- 1 1 bnhi,--wl-s--- 1 1 bnhs,--wl-s--- 1 1 bnle,--wl-s--- 1 1 bnlo,--wl-s--- 1 1 bnls,--wl-s--- 1 1 bnlt,--wl-s--- 1 1 bnmi,--wl-s--- 1 1 bnne,--wl-s--- 1 1 bnnz,--wl-s--- 1 1 bnpl,--wl-s--- 1 1 bnvc,--wl-s--- 1 1 bnvs,--wl-s--- 1 1 bnz,--wl-s--- 1 1 bnze,--wl-s--- 1 1 bpl,--wl-s--- 1 1 bra,-b-l----- 2 2 bset,--wl-s--- 1 1 bsr,-b-l----- 2 2 btst,--wl-s--- 1 1 bvc,--wl-s--- 1 1 bvs,---l----- 1 1 byterev,--wl-s--- 1 1 bze,u-------- 2 2 callm,-bwl----- 3 3 cas,--wl----- 3 3 cas2,--wl----- 2 2 chk,-bwl----- 2 2 chk2,u-------- 1 1 cinva,u-------- 2 2 cinvl,u-------- 2 2 cinvp,-bwl----- 1 1 clr,-bwl----- 2 2 cmp,-bwl----- 2 2 cmp2,--wl----- 2 2 cmpa,-bwl----- 2 2 cmpi,-bwl----- 2 2 cmpm,u-------- 1 1 cpusha,u-------- 2 2 cpushl,u-------- 2 2 cpushp,--w------ 2 2 dbcc,--w------ 2 2 dbcs,--w------ 2 2 dbeq,--w------ 2 2 dbf,--w------ 2 2 dbge,--w------ 2 2 dbgt,--w------ 2 2 dbhi,--w------ 2 2 dbhs,--w------ 2 2 dble,--w------ 2 2 dblo,--w------ 2 2 dbls,--w------ 2 2 dblt,--w------ 2 2 dbmi,--w------ 2 2 dbncc,--w------ 2 2 dbncs,--w------ 2 2 dbne,--w------ 2 2 dbneq,--w------ 2 2 dbnf,--w------ 2 2 dbnge,--w------ 2 2 dbngt,--w------ 2 2 dbnhi,--w------ 2 2 dbnhs,--w------ 2 2 dbnle,--w------ 2 2 dbnlo,--w------ 2 2 dbnls,--w------ 2 2 dbnlt,--w------ 2 2 dbnmi,--w------ 2 2 dbnne,--w------ 2 2 dbnnz,--w------ 2 2 dbnpl,--w------ 2 2 dbnt,--w------ 2 2 dbnvc,--w------ 2 2 dbnvs,--w------ 2 2 dbnz,--w------ 2 2 dbnze,--w------ 2 2 dbpl,--w------ 2 2 dbra,--w------ 2 2 dbt,--w------ 2 2 dbvc,--w------ 2 2 dbvs,--w------ 2 2 dbze,-bwl----- 1 1 dec,--wl----- 2 2 divs,---l----- 2 2 divsl,--wl----- 2 2 divu,---l----- 2 2 divul,u-------- 1 1 dos,-bwl----- 2 2 eor,-bwl----- 2 2 eori,---l----- 2 2 exg,--wl----- 1 1 ext,---l----- 1 1 extb,-bwl-sdxp 2 2 fabs,-bwl-sdxp 2 2 facos,-bwl-sdxp 2 2 fadd,-bwl-sdxp 2 2 fasin,-bwl-sdxp 2 2 fatan,-bwl-sdxp 2 2 fatanh,--wl----- 1 1 fbeq,--wl----- 1 1 fbf,--wl----- 1 1 fbge,--wl----- 1 1 fbgl,--wl----- 1 1 fbgle,--wl----- 1 1 fbgt,--wl----- 1 1 fble,--wl----- 1 1 fblt,--wl----- 1 1 fbne,--wl----- 1 1 fbnge,--wl----- 1 1 fbngl,--wl----- 1 1 fbngle,--wl----- 1 1 fbngt,--wl----- 1 1 fbnle,--wl----- 1 1 fbnlt,--wl----- 1 1 fboge,--wl----- 1 1 fbogl,--wl----- 1 1 fbogt,--wl----- 1 1 fbole,--wl----- 1 1 fbolt,--wl----- 1 1 fbor,--wl----- 1 1 fbra,--wl----- 1 1 fbseq,--wl----- 1 1 fbsf,--wl----- 1 1 fbsne,--wl----- 1 1 fbst,--wl----- 1 1 fbt,--wl----- 1 1 fbueq,--wl----- 1 1 fbuge,--wl----- 1 1 fbugt,--wl----- 1 1 fbule,--wl----- 1 1 fbult,--wl----- 1 1 fbun,-bwl-sdxp 2 2 fcmp,-bwl-sdxp 2 2 fcos,-bwl-sdxp 2 2 fcosh,-bwl-sdxp 2 2 fdabs,-bwl-sdxp 2 2 fdadd,u-------- 2 2 fdbeq,u-------- 2 2 fdbf,u-------- 2 2 fdbge,u-------- 2 2 fdbgl,u-------- 2 2 fdbgle,u-------- 2 2 fdbgt,u-------- 2 2 fdble,u-------- 2 2 fdblt,u-------- 2 2 fdbne,u-------- 2 2 fdbnge,u-------- 2 2 fdbngl,u-------- 2 2 fdbngle,u-------- 2 2 fdbngt,u-------- 2 2 fdbnle,u-------- 2 2 fdbnlt,u-------- 2 2 fdboge,u-------- 2 2 fdbogl,u-------- 2 2 fdbogt,u-------- 2 2 fdbole,u-------- 2 2 fdbolt,u-------- 2 2 fdbor,u-------- 2 2 fdbra,u-------- 2 2 fdbseq,u-------- 2 2 fdbsf,u-------- 2 2 fdbsne,u-------- 2 2 fdbst,u-------- 2 2 fdbt,u-------- 2 2 fdbueq,u-------- 2 2 fdbuge,u-------- 2 2 fdbugt,u-------- 2 2 fdbule,u-------- 2 2 fdbult,u-------- 2 2 fdbun,-bwl-sdxp 2 2 fddiv,-bwl-sdxp 2 2 fdiv,-bwl-sdxp 2 2 fdmove,-bwl-sdxp 2 2 fdmul,-bwl-sdxp 2 2 fdneg,-bwl-sdxp 2 2 fdsqrt,-bwl-sdxp 2 2 fdsub,-bwl-sdxp 2 2 fetox,-bwl-sdxp 2 2 fetoxm1,---l----- 1 1 ff1,-bwl-sdxp 2 2 fgetexp,-bwl-sdxp 2 2 fgetman,-bwl-sdxp 2 2 fint,-bwl-sdxp 2 2 fintrz,u-------- 1 1 fline,-bwl-sdxp 2 2 flog10,-bwl-sdxp 2 2 flog2,-bwl-sdxp 2 2 flogn,-bwl-sdxp 2 2 flognp1,-bwl-sdxp 2 2 fmod,-bwl-sdxp 2 2 fmove,-------x- 2 2 fmovecr,---l---x- 2 4 fmovem,-bwl-sdxp 2 2 fmul,-bwl-sdxp 2 2 fneg,u-------- 0 0 fnop,u-------- 1 1 fpack,-bwl-sdxp 2 2 frem,u-------- 1 1 frestore,-bwl-sdxp 2 2 fsabs,-bwl-sdxp 2 2 fsadd,u-------- 1 1 fsave,-bwl-sdxp 2 2 fscale,-bwl-sdxp 2 2 fsdiv,-b------- 1 1 fseq,-b------- 1 1 fsf,-b------- 1 1 fsge,-b------- 1 1 fsgl,-bwl-sdxp 2 2 fsgldiv,-b------- 1 1 fsgle,-bwl-sdxp 2 2 fsglmul,-b------- 1 1 fsgt,-bwl-sdxp 2 2 fsin,-bwl-sdxp 2 2 fsincos,-bwl-sdxp 2 2 fsinh,-b------- 1 1 fsle,-b------- 1 1 fslt,-bwl-sdxp 2 2 fsmove,-bwl-sdxp 2 2 fsmul,-b------- 1 1 fsne,-bwl-sdxp 2 2 fsneg,-b------- 1 1 fsnge,-b------- 1 1 fsngl,-b------- 1 1 fsngle,-b------- 1 1 fsngt,-b------- 1 1 fsnle,-b------- 1 1 fsnlt,-b------- 1 1 fsoge,-b------- 1 1 fsogl,-b------- 1 1 fsogt,-b------- 1 1 fsole,-b------- 1 1 fsolt,-b------- 1 1 fsor,-bwl-sdxp 2 2 fsqrt,-b------- 1 1 fsseq,-b------- 1 1 fssf,-b------- 1 1 fssne,-bwl-sdxp 2 2 fssqrt,-b------- 1 1 fsst,-bwl-sdxp 2 2 fssub,-b------- 1 1 fst,-bwl-sdxp 2 2 fsub,-b------- 1 1 fsueq,-b------- 1 1 fsuge,-b------- 1 1 fsugt,-b------- 1 1 fsule,-b------- 1 1 fsult,-b------- 1 1 fsun,-bwl-sdxp 2 2 ftan,-bwl-sdxp 2 2 ftanh,-bwl-sdxp 2 2 ftentox,u-wl----- 0 1 ftrapeq,u-wl----- 0 1 ftrapf,u-wl----- 0 1 ftrapge,u-wl----- 0 1 ftrapgl,u-wl----- 0 1 ftrapgle,u-wl----- 0 1 ftrapgt,u-wl----- 0 1 ftraple,u-wl----- 0 1 ftraplt,u-wl----- 0 1 ftrapne,u-wl----- 0 1 ftrapnge,u-wl----- 0 1 ftrapngl,u-wl----- 0 1 ftrapngle,u-wl----- 0 1 ftrapngt,u-wl----- 0 1 ftrapnle,u-wl----- 0 1 ftrapnlt,u-wl----- 0 1 ftrapoge,u-wl----- 0 1 ftrapogl,u-wl----- 0 1 ftrapogt,u-wl----- 0 1 ftrapole,u-wl----- 0 1 ftrapolt,u-wl----- 0 1 ftrapor,u-wl----- 0 1 ftrapseq,u-wl----- 0 1 ftrapsf,u-wl----- 0 1 ftrapsne,u-wl----- 0 1 ftrapst,u-wl----- 0 1 ftrapt,u-wl----- 0 1 ftrapueq,u-wl----- 0 1 ftrapuge,u-wl----- 0 1 ftrapugt,u-wl----- 0 1 ftrapule,u-wl----- 0 1 ftrapult,u-wl----- 0 1 ftrapun,-bwl-sdxp 1 1 ftst,-bwl-sdxp 2 2 ftwotox,u-------- 0 0 illegal,-bwl----- 1 1 inc,u-------- 1 1 iocs,--wl-s--- 1 1 jbcc,--wl-s--- 1 1 jbcs,--wl-s--- 1 1 jbeq,--wl-s--- 1 1 jbge,--wl-s--- 1 1 jbgt,--wl-s--- 1 1 jbhi,--wl-s--- 1 1 jbhs,--wl-s--- 1 1 jble,--wl-s--- 1 1 jblo,--wl-s--- 1 1 jbls,--wl-s--- 1 1 jblt,--wl-s--- 1 1 jbmi,--wl-s--- 1 1 jbncc,--wl-s--- 1 1 jbncs,--wl-s--- 1 1 jbne,--wl-s--- 1 1 jbneq,--wl-s--- 1 1 jbnge,--wl-s--- 1 1 jbngt,--wl-s--- 1 1 jbnhi,--wl-s--- 1 1 jbnhs,--wl-s--- 1 1 jbnle,--wl-s--- 1 1 jbnlo,--wl-s--- 1 1 jbnls,--wl-s--- 1 1 jbnlt,--wl-s--- 1 1 jbnmi,--wl-s--- 1 1 jbnne,--wl-s--- 1 1 jbnnz,--wl-s--- 1 1 jbnpl,--wl-s--- 1 1 jbnvc,--wl-s--- 1 1 jbnvs,--wl-s--- 1 1 jbnz,--wl-s--- 1 1 jbnze,--wl-s--- 1 1 jbpl,--wl-s--- 1 1 jbra,--wl-s--- 1 1 jbsr,--wl-s--- 1 1 jbvc,--wl-s--- 1 1 jbvs,--wl-s--- 1 1 jbze,u-------- 1 1 jmp,u-------- 1 1 jsr,---l----- 2 2 lea,--wl----- 2 2 link,--w------ 1 1 lpstop,-bwl----- 1 2 lsl,-bwl----- 1 2 lsr,-bwl----- 2 2 move,u-------- 2 2 move16,--wl----- 2 2 movea,---l----- 2 2 movec,--wl----- 2 2 movem,--wl----- 2 2 movep,---l----- 2 2 moveq,-bwl----- 2 2 moves,--wl----- 2 2 muls,--wl----- 2 2 mulu,-bw------ 2 2 mvs,-bw------ 2 2 mvz,-b------- 1 1 nbcd,-bwl----- 1 1 neg,-bwl----- 1 1 negx,u-------- 0 0 nop,-bwl----- 1 1 not,-bwl----- 2 2 or,-bwl----- 2 2 ori,u-------- 3 3 pack,--wl----- 1 1 pbac,--wl----- 1 1 pbas,--wl----- 1 1 pbbc,--wl----- 1 1 pbbs,--wl----- 1 1 pbcc,--wl----- 1 1 pbcs,--wl----- 1 1 pbgc,--wl----- 1 1 pbgs,--wl----- 1 1 pbic,--wl----- 1 1 pbis,--wl----- 1 1 pblc,--wl----- 1 1 pbls,--wl----- 1 1 pbsc,--wl----- 1 1 pbss,--wl----- 1 1 pbwc,--wl----- 1 1 pbws,--w------ 2 2 pdbac,--w------ 2 2 pdbas,--w------ 2 2 pdbbc,--w------ 2 2 pdbbs,--w------ 2 2 pdbcc,--w------ 2 2 pdbcs,--w------ 2 2 pdbgc,--w------ 2 2 pdbgs,--w------ 2 2 pdbic,--w------ 2 2 pdbis,--w------ 2 2 pdblc,--w------ 2 2 pdbls,--w------ 2 2 pdbsc,--w------ 2 2 pdbss,--w------ 2 2 pdbwc,--w------ 2 2 pdbws,---l----- 1 1 pea,u-------- 1 3 pflush,u-------- 0 0 pflusha,u-------- 0 0 pflushan,u-------- 1 1 pflushn,u-------- 1 1 pflushr,u-------- 2 3 pflushs,u-------- 2 2 ploadr,u-------- 2 2 ploadw,u-------- 1 1 plpar,u-------- 1 1 plpaw,-bwlq---- 2 2 pmove,---lq---- 2 2 pmovefd,u-------- 1 1 prestore,-b------- 1 1 psac,-b------- 1 1 psas,u-------- 1 1 psave,-b------- 1 1 psbc,-b------- 1 1 psbs,-b------- 1 1 pscc,-b------- 1 1 pscs,-b------- 1 1 psgc,-b------- 1 1 psgs,-b------- 1 1 psic,-b------- 1 1 psis,-b------- 1 1 pslc,-b------- 1 1 psls,-b------- 1 1 pssc,-b------- 1 1 psss,-b------- 1 1 pswc,-b------- 1 1 psws,u-------- 1 4 ptestr,u-------- 1 4 ptestw,u-wl----- 0 1 ptrapac,u-wl----- 0 1 ptrapas,u-wl----- 0 1 ptrapbc,u-wl----- 0 1 ptrapbs,u-wl----- 0 1 ptrapcc,u-wl----- 0 1 ptrapcs,u-wl----- 0 1 ptrapgc,u-wl----- 0 1 ptrapgs,u-wl----- 0 1 ptrapic,u-wl----- 0 1 ptrapis,u-wl----- 0 1 ptraplc,u-wl----- 0 1 ptrapls,u-wl----- 0 1 ptrapsc,u-wl----- 0 1 ptrapss,u-wl----- 0 1 ptrapwc,u-wl----- 0 1 ptrapws,---l----- 2 2 pvalid,u-------- 0 0 reset,-bwl----- 1 2 rol,-bwl----- 1 2 ror,-bwl----- 1 2 roxl,-bwl----- 1 2 roxr,u-------- 1 1 rtd,u-------- 0 0 rte,u-------- 1 1 rtm,u-------- 0 0 rtr,u-------- 0 0 rts,---l----- 1 1 sats,-b------- 2 2 sbcd,-b------- 1 1 scc,-b------- 1 1 scs,-b------- 1 1 seq,-b------- 1 1 sf,-b------- 1 1 sge,-b------- 1 1 sgt,-b------- 1 1 shi,-b------- 1 1 shs,-b------- 1 1 sle,-b------- 1 1 slo,-b------- 1 1 sls,-b------- 1 1 slt,-b------- 1 1 smi,-b------- 1 1 sncc,-b------- 1 1 sncs,-b------- 1 1 sne,-b------- 1 1 sneq,-b------- 1 1 snf,-b------- 1 1 snge,-b------- 1 1 sngt,-b------- 1 1 snhi,-b------- 1 1 snhs,-b------- 1 1 snle,-b------- 1 1 snlo,-b------- 1 1 snls,-b------- 1 1 snlt,-b------- 1 1 snmi,-b------- 1 1 snne,-b------- 1 1 snnz,-b------- 1 1 snpl,-b------- 1 1 snt,-b------- 1 1 snvc,-b------- 1 1 snvs,-b------- 1 1 snz,-b------- 1 1 snze,-b------- 1 1 spl,-b------- 1 1 st,u-------- 1 1 stop,-bwl----- 2 2 sub,--wl----- 2 2 suba,-bwl----- 2 2 subi,-bwl----- 2 2 subq,-bwl----- 2 2 subx,-b------- 1 1 svc,-b------- 1 1 svs,--w------ 1 1 swap,u-------- 1 1 sxcall,-b------- 1 1 sze,-b------- 1 1 tas,u-wl----- 0 1 tpcc,u-wl----- 0 1 tpcs,u-wl----- 0 1 tpeq,u-wl----- 0 1 tpf,u-wl----- 0 1 tpge,u-wl----- 0 1 tpgt,u-wl----- 0 1 tphi,u-wl----- 0 1 tphs,u-wl----- 0 1 tple,u-wl----- 0 1 tplo,u-wl----- 0 1 tpls,u-wl----- 0 1 tplt,u-wl----- 0 1 tpmi,u-wl----- 0 1 tpncc,u-wl----- 0 1 tpncs,u-wl----- 0 1 tpne,u-wl----- 0 1 tpneq,u-wl----- 0 1 tpnf,u-wl----- 0 1 tpnge,u-wl----- 0 1 tpngt,u-wl----- 0 1 tpnhi,u-wl----- 0 1 tpnhs,u-wl----- 0 1 tpnle,u-wl----- 0 1 tpnlo,u-wl----- 0 1 tpnls,u-wl----- 0 1 tpnlt,u-wl----- 0 1 tpnmi,u-wl----- 0 1 tpnne,u-wl----- 0 1 tpnnz,u-wl----- 0 1 tpnpl,u-wl----- 0 1 tpnt,u-wl----- 0 1 tpnvc,u-wl----- 0 1 tpnvs,u-wl----- 0 1 tpnz,u-wl----- 0 1 tpnze,u-wl----- 0 1 tppl,u-wl----- 0 1 tpt,u-wl----- 0 1 tpvc,u-wl----- 0 1 tpvs,u-wl----- 0 1 tpze,u-------- 1 1 trap,u-wl----- 0 1 trapcc,u-wl----- 0 1 trapcs,u-wl----- 0 1 trapeq,u-wl----- 0 1 trapf,u-wl----- 0 1 trapge,u-wl----- 0 1 trapgt,u-wl----- 0 1 traphi,u-wl----- 0 1 traphs,u-wl----- 0 1 traple,u-wl----- 0 1 traplo,u-wl----- 0 1 trapls,u-wl----- 0 1 traplt,u-wl----- 0 1 trapmi,u-wl----- 0 1 trapncc,u-wl----- 0 1 trapncs,u-wl----- 0 1 trapne,u-wl----- 0 1 trapneq,u-wl----- 0 1 trapnf,u-wl----- 0 1 trapnge,u-wl----- 0 1 trapngt,u-wl----- 0 1 trapnhi,u-wl----- 0 1 trapnhs,u-wl----- 0 1 trapnle,u-wl----- 0 1 trapnlo,u-wl----- 0 1 trapnls,u-wl----- 0 1 trapnlt,u-wl----- 0 1 trapnmi,u-wl----- 0 1 trapnne,u-wl----- 0 1 trapnnz,u-wl----- 0 1 trapnpl,u-wl----- 0 1 trapnt,u-wl----- 0 1 trapnvc,u-wl----- 0 1 trapnvs,u-wl----- 0 1 trapnz,u-wl----- 0 1 trapnze,u-wl----- 0 1 trappl,u-wl----- 0 1 trapt,u-------- 0 0 trapv,u-wl----- 0 1 trapvc,u-wl----- 0 1 trapvs,u-wl----- 0 1 trapze,-bwl----- 1 1 tst,u-------- 1 1 unlk,u-------- 3 3 unpk,-bwlqsdxp 1 9 dc,-bwlqsdxp 2 2 dcb,";
    protected static final HashMap<String, String> ASM_MNEMONIC_MAP = new HashMap();

    public static int asmSizeToLength(int n) {
        return n == 98 ? 1 : (n == 119 ? 2 : (n == 108 || n == 115 ? 4 : (n == 113 || n == 100 ? 8 : (n == 120 || n == 116 || n == 112 ? 12 : -1))));
    }

    public static byte[] asmAssemble(int n, String string) {
        Object object;
        ExpressionEvaluator expressionEvaluator = XEiJ.fpuBox;
        expressionEvaluator.evxLocalLabelCount = new HashMap();
        expressionEvaluator.evxLocalLabelMap = new HashMap();
        ExpressionEvaluator.ExpressionElement expressionElement = expressionEvaluator.evxParse(string, 3);
        if (expressionElement == null) {
            return new byte[0];
        }
        ExpressionEvaluator.ExpressionElement[] expressionElementArray = expressionElement.exlToSeparatorList().toArray(new ExpressionEvaluator.ExpressionElement[0]);
        int n2 = expressionElementArray.length;
        int[] nArray = new int[n2];
        ExpressionEvaluator.ExpressionElement[][] expressionElementArrayArray = new ExpressionEvaluator.ExpressionElement[n2][];
        byte[][] byArrayArray = new byte[n2][];
        int n3 = n;
        for (int i = 0; i < expressionElementArray.length; ++i) {
            Object object2;
            ExpressionEvaluator.ExpressionElement expressionElement2 = expressionElementArray[i];
            ExpressionEvaluator.ExpressionElement expressionElement3 = expressionElement2.exlParamX;
            if (expressionElement3 != null) {
                if (expressionElement3.exlType == ExpressionEvaluator.ElementType.ETY_LABEL_DEFINITION) {
                    object = expressionElement3.exlStringValue;
                    object2 = expressionEvaluator.evxVariableMap.get(object);
                    if (object2 == null) {
                        ExpressionEvaluator expressionEvaluator2 = expressionEvaluator;
                        Objects.requireNonNull(expressionEvaluator2);
                        object2 = new ExpressionEvaluator.ExpressionElement(expressionEvaluator2, ExpressionEvaluator.ElementType.ETY_VARIABLE_FLOAT, 0, ExpressionEvaluator.ElementType.ETY_FLOAT, new EFPBox.EFP(expressionEvaluator), "", expressionElement3.exlSource, expressionElement3.exlOffset, expressionElement3.exlLength);
                        expressionEvaluator.evxVariableMap.put((String)object, (ExpressionEvaluator.ExpressionElement)object2);
                    }
                    expressionElement3.exlType = ExpressionEvaluator.ElementType.ETY_VARIABLE_FLOAT;
                    expressionElement3.exlValueType = ExpressionEvaluator.ElementType.ETY_FLOAT;
                    expressionElement3.exlParamX = object2;
                    object2.exlFloatValue.seti(n3);
                } else if (expressionElement3.exlType == ExpressionEvaluator.ElementType.ETY_LABEL_DEFINITION) {
                    int n4 = expressionElement3.exlSubscript;
                    int n5 = expressionEvaluator.evxLocalLabelCount.containsKey(n4) ? expressionEvaluator.evxLocalLabelCount.get(n4) : 0;
                    expressionEvaluator.evxLocalLabelMap.put(n5 << 16 | n4, n3);
                    expressionEvaluator.evxLocalLabelCount.put(n4, n5 + 1);
                }
            }
            object = expressionElement2.exlStringValue;
            object2 = new ExpressionEvaluator.ExpressionElement[]{};
            byte[] byArray = new byte[]{};
            if (object != null) {
                String string2;
                int n6 = expressionElement2.exlSubscript;
                if (expressionElement2.exlParamY != null) {
                    object2 = expressionElement2.exlParamY.exlToCommaList().toArray((T[])object2);
                }
                if ((string2 = ASM_MNEMONIC_MAP.get(object)) == null) {
                    ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u6587\u6cd5\u30a8\u30e9\u30fc" : "syntax error", expressionElement2.exlSource, expressionElement2.exlOffset, expressionElement2.exlLength);
                    return null;
                }
                if (string2.indexOf(n6 < 0 ? 117 : n6) < 0) {
                    if (n6 < 0) {
                        ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u30aa\u30da\u30ec\u30fc\u30b7\u30e7\u30f3\u30b5\u30a4\u30ba\u304c\u5fc5\u8981\u3067\u3059" : "operation size is required", expressionElement2.exlSource, expressionElement2.exlOffset, expressionElement2.exlLength);
                    } else {
                        ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u6307\u5b9a\u3067\u304d\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30b7\u30e7\u30f3\u30b5\u30a4\u30ba\u3067\u3059" : "unavailable operation size", expressionElement2.exlSource, expressionElement2.exlOffset, expressionElement2.exlLength);
                    }
                    return null;
                }
                if (((ExpressionEvaluator.ExpressionElement[])object2).length < string2.charAt(10) - 48) {
                    ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u8db3\u308a\u307e\u305b\u3093" : "not enough operands", expressionElement2.exlSource, expressionElement2.exlOffset, expressionElement2.exlLength);
                    return null;
                }
                if (string2.charAt(12) < '9' && string2.charAt(12) - 48 < ((ExpressionEvaluator.ExpressionElement[])object2).length) {
                    ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u591a\u3059\u304e\u307e\u3059" : "too many operands", expressionElement2.exlSource, expressionElement2.exlOffset, expressionElement2.exlLength);
                    return null;
                }
                byArray = Assembler.asmAssembleSub(n3, (String)object, n6, object2);
            }
            nArray[i] = n3;
            expressionElementArrayArray[i] = object2;
            byArrayArray[i] = byArray;
            n3 += byArray.length;
        }
        byte[] byArray = new byte[n3 - n];
        int n7 = 0;
        for (int i = 0; i < expressionElementArray.length; ++i) {
            object = byArrayArray[i];
            for (int j = 0; j < ((Object)object).length; ++j) {
                byArray[n7] = (byte)object[j];
                ++n7;
            }
        }
        return byArray;
    }

    public static byte[] asmAssembleSub(int n, String string, int n2, ExpressionEvaluator.ExpressionElement[] expressionElementArray) {
        switch (string) {
            case "abcd": {
                break;
            }
            case "add": {
                break;
            }
            case "adda": {
                break;
            }
            case "addi": {
                break;
            }
            case "addq": {
                break;
            }
            case "addx": {
                break;
            }
            case "aline": {
                break;
            }
            case "and": {
                break;
            }
            case "andi": {
                break;
            }
            case "asl": {
                break;
            }
            case "asr": {
                break;
            }
            case "bcc": {
                break;
            }
            case "bchg": {
                break;
            }
            case "bclr": {
                break;
            }
            case "bcs": {
                break;
            }
            case "beq": {
                break;
            }
            case "bfchg": {
                break;
            }
            case "bfclr": {
                break;
            }
            case "bfexts": {
                break;
            }
            case "bfextu": {
                break;
            }
            case "bfffo": {
                break;
            }
            case "bfins": {
                break;
            }
            case "bfset": {
                break;
            }
            case "bftst": {
                break;
            }
            case "bge": {
                break;
            }
            case "bgt": {
                break;
            }
            case "bhi": {
                break;
            }
            case "bhs": {
                break;
            }
            case "bitrev": {
                break;
            }
            case "bkpt": {
                break;
            }
            case "ble": {
                break;
            }
            case "blo": {
                break;
            }
            case "bls": {
                break;
            }
            case "blt": {
                break;
            }
            case "bmi": {
                break;
            }
            case "bncc": {
                break;
            }
            case "bncs": {
                break;
            }
            case "bne": {
                break;
            }
            case "bneq": {
                break;
            }
            case "bnge": {
                break;
            }
            case "bngt": {
                break;
            }
            case "bnhi": {
                break;
            }
            case "bnhs": {
                break;
            }
            case "bnle": {
                break;
            }
            case "bnlo": {
                break;
            }
            case "bnls": {
                break;
            }
            case "bnlt": {
                break;
            }
            case "bnmi": {
                break;
            }
            case "bnne": {
                break;
            }
            case "bnnz": {
                break;
            }
            case "bnpl": {
                break;
            }
            case "bnvc": {
                break;
            }
            case "bnvs": {
                break;
            }
            case "bnz": {
                break;
            }
            case "bnze": {
                break;
            }
            case "bpl": {
                break;
            }
            case "bra": {
                break;
            }
            case "bset": {
                break;
            }
            case "bsr": {
                break;
            }
            case "btst": {
                break;
            }
            case "bvc": {
                break;
            }
            case "bvs": {
                break;
            }
            case "byterev": {
                break;
            }
            case "bze": {
                break;
            }
            case "callm": {
                break;
            }
            case "cas": {
                break;
            }
            case "cas2": {
                break;
            }
            case "chk": {
                break;
            }
            case "chk2": {
                break;
            }
            case "cinva": {
                break;
            }
            case "cinvl": {
                break;
            }
            case "cinvp": {
                break;
            }
            case "clr": {
                break;
            }
            case "cmp": {
                break;
            }
            case "cmp2": {
                break;
            }
            case "cmpa": {
                break;
            }
            case "cmpi": {
                break;
            }
            case "cmpm": {
                break;
            }
            case "cpusha": {
                break;
            }
            case "cpushl": {
                break;
            }
            case "cpushp": {
                break;
            }
            case "dbcc": {
                break;
            }
            case "dbcs": {
                break;
            }
            case "dbeq": {
                break;
            }
            case "dbf": {
                break;
            }
            case "dbge": {
                break;
            }
            case "dbgt": {
                break;
            }
            case "dbhi": {
                break;
            }
            case "dbhs": {
                break;
            }
            case "dble": {
                break;
            }
            case "dblo": {
                break;
            }
            case "dbls": {
                break;
            }
            case "dblt": {
                break;
            }
            case "dbmi": {
                break;
            }
            case "dbncc": {
                break;
            }
            case "dbncs": {
                break;
            }
            case "dbne": {
                break;
            }
            case "dbneq": {
                break;
            }
            case "dbnf": {
                break;
            }
            case "dbnge": {
                break;
            }
            case "dbngt": {
                break;
            }
            case "dbnhi": {
                break;
            }
            case "dbnhs": {
                break;
            }
            case "dbnle": {
                break;
            }
            case "dbnlo": {
                break;
            }
            case "dbnls": {
                break;
            }
            case "dbnlt": {
                break;
            }
            case "dbnmi": {
                break;
            }
            case "dbnne": {
                break;
            }
            case "dbnnz": {
                break;
            }
            case "dbnpl": {
                break;
            }
            case "dbnt": {
                break;
            }
            case "dbnvc": {
                break;
            }
            case "dbnvs": {
                break;
            }
            case "dbnz": {
                break;
            }
            case "dbnze": {
                break;
            }
            case "dbpl": {
                break;
            }
            case "dbra": {
                break;
            }
            case "dbt": {
                break;
            }
            case "dbvc": {
                break;
            }
            case "dbvs": {
                break;
            }
            case "dbze": {
                break;
            }
            case "dec": {
                break;
            }
            case "divs": {
                break;
            }
            case "divsl": {
                break;
            }
            case "divu": {
                break;
            }
            case "divul": {
                break;
            }
            case "dos": {
                break;
            }
            case "eor": {
                break;
            }
            case "eori": {
                break;
            }
            case "exg": {
                break;
            }
            case "ext": {
                break;
            }
            case "extb": {
                break;
            }
            case "fabs": {
                break;
            }
            case "facos": {
                break;
            }
            case "fadd": {
                break;
            }
            case "fasin": {
                break;
            }
            case "fatan": {
                break;
            }
            case "fatanh": {
                break;
            }
            case "fbeq": {
                break;
            }
            case "fbf": {
                break;
            }
            case "fbge": {
                break;
            }
            case "fbgl": {
                break;
            }
            case "fbgle": {
                break;
            }
            case "fbgt": {
                break;
            }
            case "fble": {
                break;
            }
            case "fblt": {
                break;
            }
            case "fbne": {
                break;
            }
            case "fbnge": {
                break;
            }
            case "fbngl": {
                break;
            }
            case "fbngle": {
                break;
            }
            case "fbngt": {
                break;
            }
            case "fbnle": {
                break;
            }
            case "fbnlt": {
                break;
            }
            case "fboge": {
                break;
            }
            case "fbogl": {
                break;
            }
            case "fbogt": {
                break;
            }
            case "fbole": {
                break;
            }
            case "fbolt": {
                break;
            }
            case "fbor": {
                break;
            }
            case "fbra": {
                break;
            }
            case "fbseq": {
                break;
            }
            case "fbsf": {
                break;
            }
            case "fbsne": {
                break;
            }
            case "fbst": {
                break;
            }
            case "fbt": {
                break;
            }
            case "fbueq": {
                break;
            }
            case "fbuge": {
                break;
            }
            case "fbugt": {
                break;
            }
            case "fbule": {
                break;
            }
            case "fbult": {
                break;
            }
            case "fbun": {
                break;
            }
            case "fcmp": {
                break;
            }
            case "fcos": {
                break;
            }
            case "fcosh": {
                break;
            }
            case "fdabs": {
                break;
            }
            case "fdadd": {
                break;
            }
            case "fdbeq": {
                break;
            }
            case "fdbf": {
                break;
            }
            case "fdbge": {
                break;
            }
            case "fdbgl": {
                break;
            }
            case "fdbgle": {
                break;
            }
            case "fdbgt": {
                break;
            }
            case "fdble": {
                break;
            }
            case "fdblt": {
                break;
            }
            case "fdbne": {
                break;
            }
            case "fdbnge": {
                break;
            }
            case "fdbngl": {
                break;
            }
            case "fdbngle": {
                break;
            }
            case "fdbngt": {
                break;
            }
            case "fdbnle": {
                break;
            }
            case "fdbnlt": {
                break;
            }
            case "fdboge": {
                break;
            }
            case "fdbogl": {
                break;
            }
            case "fdbogt": {
                break;
            }
            case "fdbole": {
                break;
            }
            case "fdbolt": {
                break;
            }
            case "fdbor": {
                break;
            }
            case "fdbra": {
                break;
            }
            case "fdbseq": {
                break;
            }
            case "fdbsf": {
                break;
            }
            case "fdbsne": {
                break;
            }
            case "fdbst": {
                break;
            }
            case "fdbt": {
                break;
            }
            case "fdbueq": {
                break;
            }
            case "fdbuge": {
                break;
            }
            case "fdbugt": {
                break;
            }
            case "fdbule": {
                break;
            }
            case "fdbult": {
                break;
            }
            case "fdbun": {
                break;
            }
            case "fddiv": {
                break;
            }
            case "fdiv": {
                break;
            }
            case "fdmove": {
                break;
            }
            case "fdmul": {
                break;
            }
            case "fdneg": {
                break;
            }
            case "fdsqrt": {
                break;
            }
            case "fdsub": {
                break;
            }
            case "fetox": {
                break;
            }
            case "fetoxm1": {
                break;
            }
            case "ff1": {
                break;
            }
            case "fgetexp": {
                break;
            }
            case "fgetman": {
                break;
            }
            case "fint": {
                break;
            }
            case "fintrz": {
                break;
            }
            case "fline": {
                break;
            }
            case "flog10": {
                break;
            }
            case "flog2": {
                break;
            }
            case "flogn": {
                break;
            }
            case "flognp1": {
                break;
            }
            case "fmod": {
                break;
            }
            case "fmove": {
                break;
            }
            case "fmovecr": {
                break;
            }
            case "fmovem": {
                break;
            }
            case "fmul": {
                break;
            }
            case "fneg": {
                break;
            }
            case "fnop": {
                break;
            }
            case "fpack": {
                break;
            }
            case "frem": {
                break;
            }
            case "frestore": {
                break;
            }
            case "fsabs": {
                break;
            }
            case "fsadd": {
                break;
            }
            case "fsave": {
                break;
            }
            case "fscale": {
                break;
            }
            case "fsdiv": {
                break;
            }
            case "fseq": {
                break;
            }
            case "fsf": {
                break;
            }
            case "fsge": {
                break;
            }
            case "fsgl": {
                break;
            }
            case "fsgldiv": {
                break;
            }
            case "fsgle": {
                break;
            }
            case "fsglmul": {
                break;
            }
            case "fsgt": {
                break;
            }
            case "fsin": {
                break;
            }
            case "fsincos": {
                break;
            }
            case "fsinh": {
                break;
            }
            case "fsle": {
                break;
            }
            case "fslt": {
                break;
            }
            case "fsmove": {
                break;
            }
            case "fsmul": {
                break;
            }
            case "fsne": {
                break;
            }
            case "fsneg": {
                break;
            }
            case "fsnge": {
                break;
            }
            case "fsngl": {
                break;
            }
            case "fsngle": {
                break;
            }
            case "fsngt": {
                break;
            }
            case "fsnle": {
                break;
            }
            case "fsnlt": {
                break;
            }
            case "fsoge": {
                break;
            }
            case "fsogl": {
                break;
            }
            case "fsogt": {
                break;
            }
            case "fsole": {
                break;
            }
            case "fsolt": {
                break;
            }
            case "fsor": {
                break;
            }
            case "fsqrt": {
                break;
            }
            case "fsseq": {
                break;
            }
            case "fssf": {
                break;
            }
            case "fssne": {
                break;
            }
            case "fssqrt": {
                break;
            }
            case "fsst": {
                break;
            }
            case "fssub": {
                break;
            }
            case "fst": {
                break;
            }
            case "fsub": {
                break;
            }
            case "fsueq": {
                break;
            }
            case "fsuge": {
                break;
            }
            case "fsugt": {
                break;
            }
            case "fsule": {
                break;
            }
            case "fsult": {
                break;
            }
            case "fsun": {
                break;
            }
            case "ftan": {
                break;
            }
            case "ftanh": {
                break;
            }
            case "ftentox": {
                break;
            }
            case "ftrapeq": {
                break;
            }
            case "ftrapf": {
                break;
            }
            case "ftrapge": {
                break;
            }
            case "ftrapgl": {
                break;
            }
            case "ftrapgle": {
                break;
            }
            case "ftrapgt": {
                break;
            }
            case "ftraple": {
                break;
            }
            case "ftraplt": {
                break;
            }
            case "ftrapne": {
                break;
            }
            case "ftrapnge": {
                break;
            }
            case "ftrapngl": {
                break;
            }
            case "ftrapngle": {
                break;
            }
            case "ftrapngt": {
                break;
            }
            case "ftrapnle": {
                break;
            }
            case "ftrapnlt": {
                break;
            }
            case "ftrapoge": {
                break;
            }
            case "ftrapogl": {
                break;
            }
            case "ftrapogt": {
                break;
            }
            case "ftrapole": {
                break;
            }
            case "ftrapolt": {
                break;
            }
            case "ftrapor": {
                break;
            }
            case "ftrapseq": {
                break;
            }
            case "ftrapsf": {
                break;
            }
            case "ftrapsne": {
                break;
            }
            case "ftrapst": {
                break;
            }
            case "ftrapt": {
                break;
            }
            case "ftrapueq": {
                break;
            }
            case "ftrapuge": {
                break;
            }
            case "ftrapugt": {
                break;
            }
            case "ftrapule": {
                break;
            }
            case "ftrapult": {
                break;
            }
            case "ftrapun": {
                break;
            }
            case "ftst": {
                break;
            }
            case "ftwotox": {
                break;
            }
            case "illegal": {
                break;
            }
            case "inc": {
                break;
            }
            case "iocs": {
                break;
            }
            case "jbcc": {
                break;
            }
            case "jbcs": {
                break;
            }
            case "jbeq": {
                break;
            }
            case "jbge": {
                break;
            }
            case "jbgt": {
                break;
            }
            case "jbhi": {
                break;
            }
            case "jbhs": {
                break;
            }
            case "jble": {
                break;
            }
            case "jblo": {
                break;
            }
            case "jbls": {
                break;
            }
            case "jblt": {
                break;
            }
            case "jbmi": {
                break;
            }
            case "jbncc": {
                break;
            }
            case "jbncs": {
                break;
            }
            case "jbne": {
                break;
            }
            case "jbneq": {
                break;
            }
            case "jbnge": {
                break;
            }
            case "jbngt": {
                break;
            }
            case "jbnhi": {
                break;
            }
            case "jbnhs": {
                break;
            }
            case "jbnle": {
                break;
            }
            case "jbnlo": {
                break;
            }
            case "jbnls": {
                break;
            }
            case "jbnlt": {
                break;
            }
            case "jbnmi": {
                break;
            }
            case "jbnne": {
                break;
            }
            case "jbnnz": {
                break;
            }
            case "jbnpl": {
                break;
            }
            case "jbnvc": {
                break;
            }
            case "jbnvs": {
                break;
            }
            case "jbnz": {
                break;
            }
            case "jbnze": {
                break;
            }
            case "jbpl": {
                break;
            }
            case "jbra": {
                break;
            }
            case "jbsr": {
                break;
            }
            case "jbvc": {
                break;
            }
            case "jbvs": {
                break;
            }
            case "jbze": {
                break;
            }
            case "jmp": {
                break;
            }
            case "jsr": {
                break;
            }
            case "lea": {
                break;
            }
            case "link": {
                break;
            }
            case "lpstop": {
                break;
            }
            case "lsl": {
                break;
            }
            case "lsr": {
                break;
            }
            case "move": {
                break;
            }
            case "move16": {
                break;
            }
            case "movea": {
                break;
            }
            case "movec": {
                break;
            }
            case "movem": {
                break;
            }
            case "movep": {
                break;
            }
            case "moveq": {
                break;
            }
            case "moves": {
                break;
            }
            case "muls": {
                break;
            }
            case "mulu": {
                break;
            }
            case "mvs": {
                break;
            }
            case "mvz": {
                break;
            }
            case "nbcd": {
                break;
            }
            case "neg": {
                break;
            }
            case "negx": {
                break;
            }
            case "nop": {
                return new byte[]{78, 113};
            }
            case "not": {
                break;
            }
            case "or": {
                break;
            }
            case "ori": {
                break;
            }
            case "pack": {
                break;
            }
            case "pbac": {
                break;
            }
            case "pbas": {
                break;
            }
            case "pbbc": {
                break;
            }
            case "pbbs": {
                break;
            }
            case "pbcc": {
                break;
            }
            case "pbcs": {
                break;
            }
            case "pbgc": {
                break;
            }
            case "pbgs": {
                break;
            }
            case "pbic": {
                break;
            }
            case "pbis": {
                break;
            }
            case "pblc": {
                break;
            }
            case "pbls": {
                break;
            }
            case "pbsc": {
                break;
            }
            case "pbss": {
                break;
            }
            case "pbwc": {
                break;
            }
            case "pbws": {
                break;
            }
            case "pdbac": {
                break;
            }
            case "pdbas": {
                break;
            }
            case "pdbbc": {
                break;
            }
            case "pdbbs": {
                break;
            }
            case "pdbcc": {
                break;
            }
            case "pdbcs": {
                break;
            }
            case "pdbgc": {
                break;
            }
            case "pdbgs": {
                break;
            }
            case "pdbic": {
                break;
            }
            case "pdbis": {
                break;
            }
            case "pdblc": {
                break;
            }
            case "pdbls": {
                break;
            }
            case "pdbsc": {
                break;
            }
            case "pdbss": {
                break;
            }
            case "pdbwc": {
                break;
            }
            case "pdbws": {
                break;
            }
            case "pea": {
                break;
            }
            case "pflush": {
                break;
            }
            case "pflusha": {
                break;
            }
            case "pflushan": {
                break;
            }
            case "pflushn": {
                break;
            }
            case "pflushr": {
                break;
            }
            case "pflushs": {
                break;
            }
            case "ploadr": {
                break;
            }
            case "ploadw": {
                break;
            }
            case "plpar": {
                break;
            }
            case "plpaw": {
                break;
            }
            case "pmove": {
                break;
            }
            case "pmovefd": {
                break;
            }
            case "prestore": {
                break;
            }
            case "psac": {
                break;
            }
            case "psas": {
                break;
            }
            case "psave": {
                break;
            }
            case "psbc": {
                break;
            }
            case "psbs": {
                break;
            }
            case "pscc": {
                break;
            }
            case "pscs": {
                break;
            }
            case "psgc": {
                break;
            }
            case "psgs": {
                break;
            }
            case "psic": {
                break;
            }
            case "psis": {
                break;
            }
            case "pslc": {
                break;
            }
            case "psls": {
                break;
            }
            case "pssc": {
                break;
            }
            case "psss": {
                break;
            }
            case "pswc": {
                break;
            }
            case "psws": {
                break;
            }
            case "ptestr": {
                break;
            }
            case "ptestw": {
                break;
            }
            case "ptrapac": {
                break;
            }
            case "ptrapas": {
                break;
            }
            case "ptrapbc": {
                break;
            }
            case "ptrapbs": {
                break;
            }
            case "ptrapcc": {
                break;
            }
            case "ptrapcs": {
                break;
            }
            case "ptrapgc": {
                break;
            }
            case "ptrapgs": {
                break;
            }
            case "ptrapic": {
                break;
            }
            case "ptrapis": {
                break;
            }
            case "ptraplc": {
                break;
            }
            case "ptrapls": {
                break;
            }
            case "ptrapsc": {
                break;
            }
            case "ptrapss": {
                break;
            }
            case "ptrapwc": {
                break;
            }
            case "ptrapws": {
                break;
            }
            case "pvalid": {
                break;
            }
            case "reset": {
                break;
            }
            case "rol": {
                break;
            }
            case "ror": {
                break;
            }
            case "roxl": {
                break;
            }
            case "roxr": {
                break;
            }
            case "rtd": {
                break;
            }
            case "rte": {
                break;
            }
            case "rtm": {
                break;
            }
            case "rtr": {
                break;
            }
            case "rts": {
                break;
            }
            case "sats": {
                break;
            }
            case "sbcd": {
                break;
            }
            case "scc": {
                break;
            }
            case "scs": {
                break;
            }
            case "seq": {
                break;
            }
            case "sf": {
                break;
            }
            case "sge": {
                break;
            }
            case "sgt": {
                break;
            }
            case "shi": {
                break;
            }
            case "shs": {
                break;
            }
            case "sle": {
                break;
            }
            case "slo": {
                break;
            }
            case "sls": {
                break;
            }
            case "slt": {
                break;
            }
            case "smi": {
                break;
            }
            case "sncc": {
                break;
            }
            case "sncs": {
                break;
            }
            case "sne": {
                break;
            }
            case "sneq": {
                break;
            }
            case "snf": {
                break;
            }
            case "snge": {
                break;
            }
            case "sngt": {
                break;
            }
            case "snhi": {
                break;
            }
            case "snhs": {
                break;
            }
            case "snle": {
                break;
            }
            case "snlo": {
                break;
            }
            case "snls": {
                break;
            }
            case "snlt": {
                break;
            }
            case "snmi": {
                break;
            }
            case "snne": {
                break;
            }
            case "snnz": {
                break;
            }
            case "snpl": {
                break;
            }
            case "snt": {
                break;
            }
            case "snvc": {
                break;
            }
            case "snvs": {
                break;
            }
            case "snz": {
                break;
            }
            case "snze": {
                break;
            }
            case "spl": {
                break;
            }
            case "st": {
                break;
            }
            case "stop": {
                break;
            }
            case "sub": {
                break;
            }
            case "suba": {
                break;
            }
            case "subi": {
                break;
            }
            case "subq": {
                break;
            }
            case "subx": {
                break;
            }
            case "svc": {
                break;
            }
            case "svs": {
                break;
            }
            case "swap": {
                break;
            }
            case "sxcall": {
                break;
            }
            case "sze": {
                break;
            }
            case "tas": {
                break;
            }
            case "tpcc": {
                break;
            }
            case "tpcs": {
                break;
            }
            case "tpeq": {
                break;
            }
            case "tpf": {
                break;
            }
            case "tpge": {
                break;
            }
            case "tpgt": {
                break;
            }
            case "tphi": {
                break;
            }
            case "tphs": {
                break;
            }
            case "tple": {
                break;
            }
            case "tplo": {
                break;
            }
            case "tpls": {
                break;
            }
            case "tplt": {
                break;
            }
            case "tpmi": {
                break;
            }
            case "tpncc": {
                break;
            }
            case "tpncs": {
                break;
            }
            case "tpne": {
                break;
            }
            case "tpneq": {
                break;
            }
            case "tpnf": {
                break;
            }
            case "tpnge": {
                break;
            }
            case "tpngt": {
                break;
            }
            case "tpnhi": {
                break;
            }
            case "tpnhs": {
                break;
            }
            case "tpnle": {
                break;
            }
            case "tpnlo": {
                break;
            }
            case "tpnls": {
                break;
            }
            case "tpnlt": {
                break;
            }
            case "tpnmi": {
                break;
            }
            case "tpnne": {
                break;
            }
            case "tpnnz": {
                break;
            }
            case "tpnpl": {
                break;
            }
            case "tpnt": {
                break;
            }
            case "tpnvc": {
                break;
            }
            case "tpnvs": {
                break;
            }
            case "tpnz": {
                break;
            }
            case "tpnze": {
                break;
            }
            case "tppl": {
                break;
            }
            case "tpt": {
                break;
            }
            case "tpvc": {
                break;
            }
            case "tpvs": {
                break;
            }
            case "tpze": {
                break;
            }
            case "trap": {
                break;
            }
            case "trapcc": {
                break;
            }
            case "trapcs": {
                break;
            }
            case "trapeq": {
                break;
            }
            case "trapf": {
                break;
            }
            case "trapge": {
                break;
            }
            case "trapgt": {
                break;
            }
            case "traphi": {
                break;
            }
            case "traphs": {
                break;
            }
            case "traple": {
                break;
            }
            case "traplo": {
                break;
            }
            case "trapls": {
                break;
            }
            case "traplt": {
                break;
            }
            case "trapmi": {
                break;
            }
            case "trapncc": {
                break;
            }
            case "trapncs": {
                break;
            }
            case "trapne": {
                break;
            }
            case "trapneq": {
                break;
            }
            case "trapnf": {
                break;
            }
            case "trapnge": {
                break;
            }
            case "trapngt": {
                break;
            }
            case "trapnhi": {
                break;
            }
            case "trapnhs": {
                break;
            }
            case "trapnle": {
                break;
            }
            case "trapnlo": {
                break;
            }
            case "trapnls": {
                break;
            }
            case "trapnlt": {
                break;
            }
            case "trapnmi": {
                break;
            }
            case "trapnne": {
                break;
            }
            case "trapnnz": {
                break;
            }
            case "trapnpl": {
                break;
            }
            case "trapnt": {
                break;
            }
            case "trapnvc": {
                break;
            }
            case "trapnvs": {
                break;
            }
            case "trapnz": {
                break;
            }
            case "trapnze": {
                break;
            }
            case "trappl": {
                break;
            }
            case "trapt": {
                break;
            }
            case "trapv": {
                break;
            }
            case "trapvc": {
                break;
            }
            case "trapvs": {
                break;
            }
            case "trapze": {
                break;
            }
            case "tst": {
                break;
            }
            case "unlk": {
                break;
            }
            case "unpk": {
                break;
            }
            case "hfsboot": {
                break;
            }
            case "hfsinst": {
                break;
            }
            case "hfsstr": {
                break;
            }
            case "hfsint": {
                break;
            }
            case "dc": {
                return Assembler.asmDC(n2, expressionElementArray);
            }
            case "dcb": {
                return Assembler.asmDCB(n2, expressionElementArray);
            }
            case "ds": {
                break;
            }
        }
        return new byte[0];
    }

    public static byte[] asmDC(int n, ExpressionEvaluator.ExpressionElement[] expressionElementArray) {
        byte[] byArray = new byte[Assembler.asmSizeToLength(n) * expressionElementArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            EFPBox.EFP eFP = expressionElementArray[n2].exlEval((int)1).exlFloatValue;
            switch (n) {
                case 98: {
                    byArray[n2] = (byte)eFP.geti();
                    ++n2;
                    break;
                }
                case 119: {
                    short s = (short)eFP.geti();
                    byArray[n2] = (byte)(s >> 8);
                    byArray[n2 + 1] = (byte)s;
                    n2 += 2;
                    break;
                }
                case 108: {
                    int n3 = eFP.geti();
                    byArray[n2] = (byte)(n3 >> 24);
                    byArray[n2 + 1] = (byte)(n3 >> 16);
                    byArray[n2 + 2] = (byte)(n3 >> 8);
                    byArray[n2 + 3] = (byte)n3;
                    n2 += 4;
                    break;
                }
                case 113: {
                    long l = eFP.getl();
                    int n4 = (int)(l >> 32);
                    byArray[n2] = (byte)(n4 >> 24);
                    byArray[n2 + 1] = (byte)(n4 >> 16);
                    byArray[n2 + 2] = (byte)(n4 >> 8);
                    byArray[n2 + 3] = (byte)n4;
                    n4 = (int)l;
                    byArray[n2 + 4] = (byte)(n4 >> 24);
                    byArray[n2 + 5] = (byte)(n4 >> 16);
                    byArray[n2 + 6] = (byte)(n4 >> 8);
                    byArray[n2 + 7] = (byte)n4;
                    n2 += 8;
                    break;
                }
                case 115: {
                    eFP.getf0(byArray, n2);
                    n2 += 4;
                    break;
                }
                case 100: {
                    eFP.getd01(byArray, n2);
                    n2 += 8;
                    break;
                }
                case 120: {
                    eFP.getx012(byArray, n2);
                    n2 += 12;
                    break;
                }
                case 116: {
                    eFP.gety012(byArray, n2);
                    n2 += 12;
                    break;
                }
                case 112: {
                    eFP.getp012(byArray, n2);
                    n2 += 12;
                }
            }
        }
        return byArray;
    }

    public static byte[] asmDCB(int n, ExpressionEvaluator.ExpressionElement[] expressionElementArray) {
        int n2 = expressionElementArray[0].exlEval((int)1).exlFloatValue.geti();
        if (n2 < 0) {
            ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u7e70\u308a\u8fd4\u3057\u56de\u6570\u304c\u8ca0\u3067\u3059" : "negative repeat count", expressionElementArray[0].exlSource, expressionElementArray[0].exlOffset, expressionElementArray[0].exlLength);
            return null;
        }
        int n3 = Assembler.asmSizeToLength(n) * n2;
        if (n3 < 0 || 0x10000000 <= n3) {
            ExpressionEvaluator.evxPrintError(Multilingual.mlnJapanese ? "\u7e70\u308a\u8fd4\u3057\u56de\u6570\u304c\u5927\u304d\u3059\u304e\u307e\u3059" : "too large repeat count", expressionElementArray[0].exlSource, expressionElementArray[0].exlOffset, expressionElementArray[0].exlLength);
            return null;
        }
        EFPBox.EFP eFP = expressionElementArray[1].exlEval((int)1).exlFloatValue;
        byte[] byArray = new byte[n3];
        if (n3 == 0) {
            return byArray;
        }
        switch (n) {
            case 98: {
                byte by = (byte)eFP.geti();
                for (int i = 0; i < n3; ++i) {
                    byArray[i] = by;
                }
                break;
            }
            case 119: {
                short s = (short)eFP.geti();
                byte by = (byte)(s >> 8);
                byte by2 = (byte)s;
                for (int i = 0; i < n3; i += 2) {
                    byArray[i] = by;
                    byArray[i + 1] = by2;
                }
                break;
            }
            case 108: {
                int n4 = eFP.geti();
                byte by = (byte)(n4 >> 24);
                byte by3 = (byte)(n4 >> 16);
                byte by4 = (byte)(n4 >> 8);
                byte by5 = (byte)n4;
                for (int i = 0; i < n3; i += 4) {
                    byArray[i] = by;
                    byArray[i + 1] = by3;
                    byArray[i + 2] = by4;
                    byArray[i + 3] = by5;
                }
                break;
            }
            case 113: {
                long l = eFP.getl();
                int n5 = (int)(l >> 32);
                byte by = (byte)(n5 >> 24);
                byte by6 = (byte)(n5 >> 16);
                byte by7 = (byte)(n5 >> 8);
                byte by8 = (byte)n5;
                n5 = (int)l;
                byte by9 = (byte)(n5 >> 24);
                byte by10 = (byte)(n5 >> 16);
                byte by11 = (byte)(n5 >> 8);
                byte by12 = (byte)n5;
                for (int i = 0; i < n3; i += 8) {
                    byArray[i] = by;
                    byArray[i + 1] = by6;
                    byArray[i + 2] = by7;
                    byArray[i + 3] = by8;
                    byArray[i + 4] = by9;
                    byArray[i + 5] = by10;
                    byArray[i + 6] = by11;
                    byArray[i + 7] = by12;
                }
                break;
            }
            case 115: {
                int n6 = eFP.getf0();
                byte by = (byte)(n6 >> 24);
                byte by13 = (byte)(n6 >> 16);
                byte by14 = (byte)(n6 >> 8);
                byte by15 = (byte)n6;
                for (int i = 0; i < n3; i += 4) {
                    byArray[i] = by;
                    byArray[i + 1] = by13;
                    byArray[i + 2] = by14;
                    byArray[i + 3] = by15;
                }
                break;
            }
            case 100: {
                long l = eFP.getd01();
                int n7 = (int)(l >> 32);
                byte by = (byte)(n7 >> 24);
                byte by16 = (byte)(n7 >> 16);
                byte by17 = (byte)(n7 >> 8);
                byte by18 = (byte)n7;
                n7 = (int)l;
                byte by19 = (byte)(n7 >> 24);
                byte by20 = (byte)(n7 >> 16);
                byte by21 = (byte)(n7 >> 8);
                byte by22 = (byte)n7;
                for (int i = 0; i < n3; i += 8) {
                    byArray[i] = by;
                    byArray[i + 1] = by16;
                    byArray[i + 2] = by17;
                    byArray[i + 3] = by18;
                    byArray[i + 4] = by19;
                    byArray[i + 5] = by20;
                    byArray[i + 6] = by21;
                    byArray[i + 7] = by22;
                }
                break;
            }
            case 120: {
                eFP.getx012(byArray, 0);
                for (int i = 12; i < n3; ++i) {
                    byArray[i] = byArray[i - 12];
                }
                break;
            }
            case 116: {
                eFP.gety012(byArray, 0);
                for (int i = 12; i < n3; ++i) {
                    byArray[i] = byArray[i - 12];
                }
                break;
            }
            case 112: {
                eFP.getp012(byArray, 0);
                for (int i = 12; i < n3; ++i) {
                    byArray[i] = byArray[i - 12];
                }
                break;
            }
        }
        return byArray;
    }

    static {
        for (String string : ASM_MNEMONIC_BASE.split(",")) {
            ASM_MNEMONIC_MAP.put(string.substring(14), string.substring(0, 13));
        }
    }
}

