/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import xeij.AbstractOpenDialog;
import xeij.AbstractUnit;
import xeij.ComponentFactory;
import xeij.FDMedia;
import xeij.FUK;
import xeij.HD63450;
import xeij.IOInterrupt;
import xeij.JFileChooser2;
import xeij.Multilingual;
import xeij.Settings;
import xeij.TickerQueue;
import xeij.XEiJ;

public class FDC {
    public static final boolean FDC_DEBUG_TRACE = false;
    public static final boolean FDC_DEBUG_DEFAULT = true;
    public static boolean fdcDebugLogOn;
    public static final int FDC_STATUS_PORT = 15286273;
    public static final int FDC_DATA_PORT = 15286275;
    public static final int FDC_DRIVE_STATUS = 15286277;
    public static final int FDC_DRIVE_SELECT = 15286279;
    public static final int FDC_MIN_UNITS = 2;
    public static final int FDC_MAX_UNITS = 4;
    public static FDUnit[] fdcUnitArray;
    public static JMenu fdcMenu;
    public static FileFilter fdcFileFilter;
    public static OpenDialog fdcOpenDialog;
    public static int fdcOpenUnit;
    public static ArrayList<File[]> fdcOpenHistory;
    public static JDialog fdcFormatDialog;
    public static JCheckBox fdcFormatX86SafeCheckBox;
    public static JFileChooser2 fdcFormatFileChooser;
    public static FDMedia fdcFormatMedia;
    public static boolean fdcFormatX86SafeOn;
    public static JCheckBox fdcFormatCopyHumanSysCheckBox;
    public static JCheckBox fdcFormatCopyCommandXCheckBox;
    public static boolean fdcFormatCopyHumanSysOn;
    public static boolean fdcFormatCopyCommandXOn;
    public static final int FDC_RQM = 128;
    public static final int FDC_MPU_TO_FDC = 0;
    public static final int FDC_FDC_TO_MPU = 64;
    public static final int FDC_NDM = 32;
    public static final int FDC_CB = 16;
    public static final int FDC_D3B = 8;
    public static final int FDC_D2B = 4;
    public static final int FDC_D1B = 2;
    public static final int FDC_D0B = 1;
    public static int fdcStatus;
    public static int fdcLastStatus;
    public static final int FDC_ST0_NT = 0;
    public static final int FDC_ST0_AT = 0x40000000;
    public static final int FDC_ST0_IC = Integer.MIN_VALUE;
    public static final int FDC_ST0_AI = -1073741824;
    public static final int FDC_ST0_SE = 0x20000000;
    public static final int FDC_ST0_EC = 0x10000000;
    public static final int FDC_ST0_NR = 0x8000000;
    public static final int FDC_ST1_EN = 0x800000;
    public static final int FDC_ST1_DE = 0x200000;
    public static final int FDC_ST1_OR = 0x100000;
    public static final int FDC_ST1_ND = 262144;
    public static final int FDC_ST1_NW = 131072;
    public static final int FDC_ST1_MA = 65536;
    public static final int FDC_ST2_CM = 16384;
    public static final int FDC_ST2_DD = 8192;
    public static final int FDC_ST2_NC = 4096;
    public static final int FDC_ST2_SH = 2048;
    public static final int FDC_ST2_SN = 1024;
    public static final int FDC_ST2_BC = 512;
    public static final int FDC_ST2_MD = 256;
    public static final int FDC_ST3_FT = 128;
    public static final int FDC_ST3_WP = 64;
    public static final int FDC_ST3_RY = 32;
    public static final int FDC_ST3_T0 = 16;
    public static final int FDC_ST3_TS = 8;
    public static final String[] FDC_COMMAND_NAME;
    public static final byte[] FDC_COMMAND_LENGTH;
    public static int fdcCommandNumber;
    public static final byte[] fdcCommandBuffer;
    public static final byte[] fdcResultBuffer;
    public static final byte[] fdcTempBuffer;
    public static byte[] fdcReadHandle;
    public static byte[] fdcWriteHandle;
    public static int fdcIndex;
    public static int fdcStart;
    public static int fdcLimit;
    public static boolean fdcEnforcedReady;
    public static FDUnit fdcDriveLastSelected;
    public static int fdcSRT;

    public static void fdcInit() {
        int n;
        fdcFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                if (!file.isFile()) {
                    return false;
                }
                String string2 = file.getPath();
                if (FDC.fdcIsInsertedPath(string2)) {
                    return false;
                }
                int n = string2.lastIndexOf(46);
                String string3 = string = n < 0 ? "" : string2.substring(n + 1).toUpperCase();
                if (string.equals("DIM")) {
                    return true;
                }
                long l = file.length();
                if (0x1000000L <= l) {
                    return false;
                }
                int n2 = (int)l;
                for (FDMedia fDMedia : FDMedia.FDM_ARRAY) {
                    if (fDMedia.fdmBytesPerDisk != n2) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "\u30d5\u30ed\u30c3\u30d4\u30fc\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb (*.XDF,*.2HD,*.2HC,*.DIM,etc.)" : "Floppy disk image files (*.XDF,*.2HD,*.2HC,*.DIM,etc.)";
            }
        };
        fdcOpenDialog = null;
        fdcOpenUnit = 0;
        fdcOpenHistory = new ArrayList();
        for (n = 99; 0 <= n; --n) {
            FDC.fdcAddHistory(JFileChooser2.pathsToFiles(Settings.sgsGetString("fdhistory" + n)));
        }
        fdcFormatDialog = null;
        fdcFormatX86SafeCheckBox = null;
        fdcFormatFileChooser = null;
        fdcFormatMedia = FDMedia.FDM_2HD;
        fdcFormatX86SafeOn = true;
        fdcFormatCopyHumanSysCheckBox = null;
        fdcFormatCopyCommandXCheckBox = null;
        fdcFormatCopyHumanSysOn = true;
        fdcFormatCopyCommandXOn = true;
        fdcUnitArray = new FDUnit[4];
        for (n = 0; n < 4; ++n) {
            boolean bl;
            FDUnit fDUnit = FDC.fdcUnitArray[n] = new FDUnit(n);
            if (n < 2) {
                fDUnit.connect(false);
            }
            String string = Settings.sgsGetString("fd" + n);
            boolean bl2 = false;
            if (string.toUpperCase().endsWith(":R")) {
                string = string.substring(0, string.length() - 2);
                bl2 = true;
            }
            boolean bl3 = bl = !new File(string).canWrite();
            if (string.length() == 0) continue;
            fDUnit.connect(true);
            if (!fDUnit.insert(string, bl2 || bl)) continue;
            FDC.fdcAddHistory(new File(string).getAbsoluteFile());
        }
        FDC.fdcCPhase();
        fdcEnforcedReady = false;
        fdcDriveLastSelected = null;
        fdcSRT = 3;
    }

    public static void fdcReset() {
        FDC.fdcCPhase();
        fdcEnforcedReady = false;
        fdcDriveLastSelected = null;
        fdcSRT = 3;
        for (int i = 0; i <= 3; ++i) {
            FDUnit fDUnit = fdcUnitArray[i];
            if (!fDUnit.fduIsInserted()) continue;
            IOInterrupt.ioiFddFall();
            IOInterrupt.ioiFddRise();
            break;
        }
    }

    public static void fdcTini() {
        for (FDUnit fDUnit : fdcUnitArray) {
            fDUnit.fduTini();
        }
        if (fdcOpenDialog != null) {
            int n;
            Settings.sgsPutOnOff("fdreadonly", fdcOpenDialog.getReadOnly());
            Settings.sgsPutOnOff("fdappreboot", fdcOpenDialog.getReboot());
            ArrayList<String> arrayList = fdcOpenDialog.getHistory();
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                Settings.sgsPutString("fdhistory" + n, (String)arrayList.get(n));
            }
            for (n = n2; n < 4; ++n) {
                Settings.sgsPutString("fdhistory" + n, "");
            }
        }
        for (int i = 0; i < 4; ++i) {
            FDUnit fDUnit = fdcUnitArray[i];
            Settings.sgsPutString("fd" + i, (String)(fDUnit.abuConnected && fDUnit.abuInserted ? (fDUnit.abuWriteProtected ? fDUnit.abuPath + ":R" : fDUnit.abuPath) : ""));
        }
    }

    public static void fdcMakeMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Create new floppy disk image files": {
                        FDC.fdcOpenFormatDialog();
                        break;
                    }
                }
            }
        };
        fdcMenu = ComponentFactory.createMenu("FD", new JComponent[0]);
        ComponentFactory.addComponents(fdcMenu, ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Floppy disk"), "ja", "\u30d5\u30ed\u30c3\u30d4\u30fc\u30c7\u30a3\u30b9\u30af")), ComponentFactory.createHorizontalSeparator());
        for (FDUnit fDUnit : fdcUnitArray) {
            fdcMenu.add(fDUnit.getMenuBox());
        }
        ComponentFactory.addComponents(fdcMenu, ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenuItem("Create new floppy disk image files", actionListener), "ja", "\u30d5\u30ed\u30c3\u30d4\u30fc\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210"), FUK.fukGetMenu(), null);
    }

    public static boolean fdcIsInsertedPath(String string) {
        boolean bl = false;
        for (FDUnit fDUnit : fdcUnitArray) {
            if (fDUnit == null || !fDUnit.abuConnected || !fDUnit.fduIsInserted() || !fDUnit.abuPath.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void fdcOpenFiles(File[] fileArray, boolean bl) {
        boolean bl2 = true;
        int n = fdcOpenUnit;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file;
            if (4 <= n) {
                bl2 = false;
                break;
            }
            FDUnit fDUnit = fdcUnitArray[n];
            if (!fDUnit.abuConnected) {
                ++n;
                continue;
            }
            if (!(file = fileArray[n2++]).isFile()) {
                bl2 = false;
                continue;
            }
            if (!fDUnit.insert(file.getPath(), fdcOpenDialog.getReadOnly() || !file.canWrite())) {
                bl2 = false;
                continue;
            }
            ++n;
        }
        if (bl2) {
            FDC.fdcAddHistory(fileArray);
            if (bl) {
                XEiJ.mpuReset(0x9070 | fdcOpenUnit << 8, -1);
            }
        }
    }

    public static void fdcMakeFormatDialog() {
        ActionListener actionListener = new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getActionCommand()) {
                    case "ApproveSelection": 
                    case "Start formatting": {
                        File[] fileArray = fdcFormatFileChooser.getSelectedFiles();
                        if (fileArray.length <= 0) return;
                        fdcFormatDialog.setVisible(false);
                        if (FDC.fdcFormatFiles(fileArray)) return;
                    }
                    case "CancelSelection": 
                    case "Cancel": {
                        fdcFormatDialog.setVisible(false);
                        return;
                    }
                    case "2HD (1232KB)": {
                        fdcFormatMedia = FDMedia.FDM_2HD;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2HC (1200KB)": {
                        fdcFormatMedia = FDMedia.FDM_2HC;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2DD (640KB)": {
                        fdcFormatMedia = FDMedia.FDM_2DD8;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2DD (720KB)": {
                        fdcFormatMedia = FDMedia.FDM_2DD9;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2HQ (1440KB)": {
                        fdcFormatMedia = FDMedia.FDM_2HQ;
                        fdcFormatX86SafeCheckBox.setEnabled(true);
                        fdcFormatX86SafeCheckBox.setSelected(fdcFormatX86SafeOn);
                        return;
                    }
                    case "2DD (800KB)": {
                        fdcFormatMedia = FDMedia.FDM_2DD10;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2HDE(1440KB)": {
                        fdcFormatMedia = FDMedia.FDM_2HDE;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "2HS (1440KB)": {
                        fdcFormatMedia = FDMedia.FDM_2HS;
                        fdcFormatX86SafeCheckBox.setSelected(false);
                        fdcFormatX86SafeCheckBox.setEnabled(false);
                        return;
                    }
                    case "HUMAN.SYS": {
                        fdcFormatCopyHumanSysOn = fdcFormatCopyHumanSysCheckBox.isSelected();
                        if (fdcFormatCopyHumanSysOn) {
                            fdcFormatCopyCommandXCheckBox.setEnabled(true);
                            fdcFormatCopyCommandXCheckBox.setSelected(fdcFormatCopyCommandXOn);
                            return;
                        }
                        fdcFormatCopyCommandXCheckBox.setEnabled(false);
                        fdcFormatCopyCommandXCheckBox.setSelected(false);
                        return;
                    }
                    case "COMMAND.X": {
                        fdcFormatCopyCommandXOn = fdcFormatCopyCommandXCheckBox.isSelected();
                        return;
                    }
                    case "x86-safe": {
                        fdcFormatX86SafeOn = ((JCheckBox)actionEvent.getSource()).isSelected();
                    }
                }
            }
        };
        FDC.fdcMakeFormatFileChooser();
        fdcFormatFileChooser.setFileFilter(fdcFileFilter);
        fdcFormatFileChooser.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        JComponent[] jComponentArray = new JComponent[1];
        Component[] componentArray = new Component[5];
        componentArray[0] = fdcFormatFileChooser;
        Component[] componentArray2 = new Component[5];
        componentArray2[0] = Box.createHorizontalStrut(12);
        componentArray2[1] = Box.createHorizontalGlue();
        Component[] componentArray3 = new Component[2];
        componentArray3[0] = ComponentFactory.createHorizontalBox(ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2HD, "2HD (1232KB)", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2HC, "2HC (1200KB)", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2DD8, "2DD (640KB)", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2DD9, "2DD (720KB)", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2HQ, "2HQ (1440KB)", actionListener));
        Component[] componentArray4 = new Component[6];
        componentArray4[0] = ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2DD10, "2DD (800KB)", actionListener);
        componentArray4[1] = ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2HDE, "2HDE(1440KB)", actionListener);
        componentArray4[2] = ComponentFactory.createRadioButtonMenuItem(buttonGroup, fdcFormatMedia == FDMedia.FDM_2HS, "2HS (1440KB)", actionListener);
        componentArray4[3] = Box.createHorizontalGlue();
        fdcFormatX86SafeCheckBox = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createCheckBox(fdcFormatMedia == FDMedia.FDM_2HQ && fdcFormatX86SafeOn, "x86-safe", actionListener), "ja", "x86 \u30bb\u30fc\u30d5"), fdcFormatMedia == FDMedia.FDM_2HQ);
        componentArray4[4] = fdcFormatX86SafeCheckBox;
        componentArray4[5] = Box.createHorizontalStrut(12);
        componentArray3[1] = ComponentFactory.createHorizontalBox(componentArray4);
        componentArray2[2] = ComponentFactory.createVerticalBox(componentArray3);
        componentArray2[3] = Box.createHorizontalGlue();
        componentArray2[4] = Box.createHorizontalStrut(12);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
        componentArray[2] = Box.createVerticalStrut(12);
        Component[] componentArray5 = new Component[11];
        componentArray5[0] = Box.createHorizontalStrut(12);
        componentArray5[1] = Box.createHorizontalGlue();
        fdcFormatCopyHumanSysCheckBox = ComponentFactory.createCheckBox(fdcFormatCopyHumanSysOn, "HUMAN.SYS", actionListener);
        componentArray5[2] = fdcFormatCopyHumanSysCheckBox;
        componentArray5[3] = Box.createHorizontalStrut(12);
        fdcFormatCopyCommandXCheckBox = ComponentFactory.setEnabled(ComponentFactory.createCheckBox(fdcFormatCopyHumanSysOn && fdcFormatCopyCommandXOn, "COMMAND.X", actionListener), fdcFormatCopyHumanSysOn);
        componentArray5[4] = fdcFormatCopyCommandXCheckBox;
        componentArray5[5] = Box.createHorizontalGlue();
        componentArray5[6] = Box.createHorizontalStrut(12);
        componentArray5[7] = Multilingual.mlnText(ComponentFactory.createButton("Start formatting", 70, actionListener), "ja", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3092\u958b\u59cb\u3059\u308b");
        componentArray5[8] = Box.createHorizontalStrut(12);
        componentArray5[9] = Multilingual.mlnText(ComponentFactory.createButton("Cancel", 67, actionListener), "ja", "\u30ad\u30e3\u30f3\u30bb\u30eb");
        componentArray5[10] = Box.createHorizontalStrut(12);
        componentArray[3] = ComponentFactory.createHorizontalBox(componentArray5);
        componentArray[4] = Box.createVerticalStrut(12);
        jComponentArray[0] = ComponentFactory.createVerticalBox(componentArray);
        fdcFormatDialog = Multilingual.mlnTitle(ComponentFactory.createModalDialog(XEiJ.frmFrame, "Create new floppy disk image files", ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30d5\u30ed\u30c3\u30d4\u30fc\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210");
    }

    public static void fdcMakeFormatFileChooser() {
        if (fdcFormatFileChooser == null) {
            fdcFormatFileChooser = new JFileChooser2();
            fdcFormatFileChooser.setControlButtonsAreShown(false);
        }
    }

    public static void fdcOpenFormatDialog() {
        if (fdcFormatDialog == null) {
            FDC.fdcMakeFormatDialog();
        }
        fdcFormatFileChooser.rescanCurrentDirectory();
        XEiJ.pnlExitFullScreen(true);
        fdcFormatDialog.setVisible(true);
    }

    public static boolean fdcFormatFiles(File[] fileArray) {
        boolean bl = true;
        byte[] byArray = new byte[FDC.fdcFormatMedia.fdmBytesPerDisk];
        if (!fdcFormatMedia.fdmMakeFormatData(byArray, fdcFormatCopyHumanSysOn, fdcFormatCopyCommandXOn, fdcFormatX86SafeOn)) {
            bl = false;
        } else {
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            block0: for (File file : fileArray) {
                Object object = file.getPath();
                String string = ((String)object).toUpperCase();
                if (string.endsWith(".DIM")) {
                    if (FDC.fdcIsInsertedPath((String)object)) {
                        bl = false;
                        break;
                    }
                    if (byArray2 == null && (n = fdcFormatMedia.fdmMakeDimImage(byArray2 = new byte[256 + FDC.fdcFormatMedia.fdmBytesPerDisk], byArray)) < 0) {
                        bl = false;
                        break;
                    }
                    if (!XEiJ.rscPutFile((String)object, byArray2, 0, n)) {
                        bl = false;
                        break;
                    }
                } else {
                    boolean bl2 = true;
                    for (String string2 : FDC.fdcFormatMedia.fdmExtensionArray) {
                        if (!string.endsWith(string2)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        if (!((String)object).endsWith(".")) {
                            object = (String)object + ".";
                        }
                        object = (String)object + FDC.fdcFormatMedia.fdmExtensionArray[0].toLowerCase();
                        string = ((String)object).toUpperCase();
                    }
                    if (FDC.fdcIsInsertedPath((String)object)) {
                        bl = false;
                        break;
                    }
                    if (!XEiJ.rscPutFile((String)object, byArray, 0, FDC.fdcFormatMedia.fdmBytesPerDisk)) {
                        bl = false;
                        break;
                    }
                }
                while (n2 < 4) {
                    FDUnit fDUnit = fdcUnitArray[n2++];
                    if (!fDUnit.abuConnected || fDUnit.fduIsInserted() || !fDUnit.insert((String)object, false)) continue;
                    continue block0;
                }
            }
        }
        if (bl) {
            FDC.fdcAddHistory(fileArray);
        }
        return bl;
    }

    public static void fdcAddHistory(File file) {
        FDC.fdcAddHistory(new File[]{file});
    }

    public static void fdcAddHistory(File[] fileArray) {
        if (fdcOpenDialog == null) {
            fdcOpenHistory.add(fileArray);
        } else {
            fdcOpenDialog.addHistory(fileArray);
        }
        FDC.fdcMakeFormatFileChooser();
        fdcFormatFileChooser.addHistory(fileArray);
        fdcFormatFileChooser.selectLastFiles();
    }

    public static int fdcPeekStatus() {
        return fdcStatus;
    }

    public static int fdcReadStatus() {
        int n = fdcStatus;
        return n;
    }

    public static int fdcPeekData() {
        return fdcReadHandle == null ? 0 : fdcReadHandle[fdcIndex] & 0xFF;
    }

    public static int fdcReadData() {
        if (fdcReadHandle == null) {
            return 0;
        }
        int n = fdcReadHandle[fdcIndex] & 0xFF;
        if (++fdcIndex < fdcLimit) {
            if (fdcReadHandle != fdcResultBuffer) {
                HD63450.dmaFallPCL(0);
            } else if (fdcIndex == 1) {
                fdcStatus &= ~(1 << (n & 3));
            }
        } else if (fdcReadHandle != fdcResultBuffer) {
            FDC.fdcEPhaseEnd();
        } else {
            FDC.fdcRPhaseEnd();
        }
        return n;
    }

    public static int fdcPeekDriveStatus() {
        return fdcDriveLastSelected == null ? 0 : fdcDriveLastSelected.fduDriveStatus();
    }

    public static int fdcReadDriveStatus() {
        int n = fdcDriveLastSelected == null ? 0 : fdcDriveLastSelected.fduDriveStatus();
        return n;
    }

    public static void fdcWriteCommand(int n) {
        if (fdcWriteHandle != fdcCommandBuffer) {
            return;
        }
        FDC.fdcWriteHandle[FDC.fdcIndex++] = (byte)n;
        if (fdcLimit <= fdcIndex) {
            FDC.fdcCPhaseEnd();
        }
    }

    public static void fdcWriteData(int n) {
        if (fdcWriteHandle == null) {
            return;
        }
        FDC.fdcWriteHandle[FDC.fdcIndex++] = (byte)n;
        if (fdcIndex < fdcLimit) {
            if (fdcWriteHandle != fdcCommandBuffer) {
                HD63450.dmaFallPCL(0);
            }
        } else if (fdcWriteHandle == fdcCommandBuffer) {
            FDC.fdcCPhaseEnd();
        } else {
            FDC.fdcEPhaseEnd();
        }
    }

    public static void fdcCPhase() {
        fdcStatus = 0x80 | fdcStatus & 0xF;
        fdcReadHandle = null;
        fdcWriteHandle = fdcCommandBuffer;
        fdcStart = 0;
        fdcIndex = 0;
        fdcLimit = 1;
        fdcCommandNumber = -1;
        for (int i = 0; i <= 3; ++i) {
            FDUnit fDUnit = fdcUnitArray[i];
            if (fDUnit.fduSeekStepWaiting) {
                fDUnit.fduSeekStepWaiting = false;
                fDUnit.fduSeekStep();
            }
            if ((fdcStatus & 1 << i) != 0) {
                if (!fDUnit.fduSeekEndInterruptWaiting) continue;
                fDUnit.fduSeekEndInterruptWaiting = false;
                fDUnit.fduSeekEndInterruptRequest = true;
                IOInterrupt.ioiFdcRise();
                continue;
            }
            if (!fDUnit.fduAttentionCheckWaiting) continue;
            fDUnit.fduAttentionCheckWaiting = false;
            boolean bl = fDUnit.fduIsReady();
            if (bl == fDUnit.fduSavedReady) continue;
            fDUnit.fduSavedReady = bl;
            if (fDUnit.fduAttentionInterruptRequest) continue;
            fDUnit.fduAttentionInterruptRequest = true;
            IOInterrupt.ioiFdcRise();
        }
    }

    public static void fdcCPhaseEnd() {
        if (fdcCommandNumber < 0 && 1 < (fdcLimit = FDC_COMMAND_LENGTH[fdcCommandNumber = fdcCommandBuffer[0] & 0x1F])) {
            fdcStatus |= 0x10;
            return;
        }
        FDUnit fDUnit = fdcUnitArray[fdcCommandBuffer[1] & 3];
        switch (fdcCommandNumber) {
            case 3: {
                FDC.fdcCommandSpecify();
                break;
            }
            case 4: {
                fDUnit.fduCommandSenseDeviceStatus();
                break;
            }
            case 5: {
                fDUnit.fduCommandWriteData();
                break;
            }
            case 6: {
                fDUnit.fduCommandReadData();
                break;
            }
            case 7: {
                fDUnit.fduCommandRecalibrate();
                break;
            }
            case 8: {
                FDC.fdcCommandSenseInterruptStatus();
                break;
            }
            case 10: {
                fDUnit.fduCommandReadId();
                break;
            }
            case 13: {
                fDUnit.fduCommandWriteId();
                break;
            }
            case 15: {
                fDUnit.fduCommandSeek();
                break;
            }
            case 17: {
                fDUnit.fduCommandScan();
                break;
            }
            case 22: {
                FDC.fdcCommandSoftwareReset();
                break;
            }
            case 25: {
                fDUnit.fduCommandScan();
                break;
            }
            case 29: {
                fDUnit.fduCommandScan();
                break;
            }
            default: {
                FDC.fdcCommandInvalid();
            }
        }
    }

    public static void fdcEPhaseEnd() {
        FDUnit fDUnit = fdcUnitArray[fdcCommandBuffer[1] & 3];
        switch (fDUnit.fduCommandNumber) {
            case 5: {
                fDUnit.fduWriteDataEPhaseEnd();
                break;
            }
            case 6: {
                fDUnit.fduReadDataEPhaseEnd();
                break;
            }
            case 13: {
                fDUnit.fduWriteIdEPhaseEnd();
                break;
            }
            case 17: {
                fDUnit.fduScanEqualEPhaseEnd();
                break;
            }
            case 25: {
                fDUnit.fduScanLowOrEqualEPhaseEnd();
                break;
            }
            case 29: {
                fDUnit.fduScanHighOrEqualEPhaseEnd();
            }
        }
    }

    public static void fdcRPhase(int n) {
        fdcStatus = 0xD0 | fdcStatus & 0xF;
        fdcReadHandle = fdcResultBuffer;
        fdcWriteHandle = null;
        fdcStart = 0;
        fdcIndex = 0;
        fdcLimit = n;
    }

    public static void fdcRPhaseEnd() {
        FDC.fdcCPhase();
        for (int i = 0; i <= 3; ++i) {
            FDUnit fDUnit = fdcUnitArray[i];
            if (!fDUnit.fduSeekEndInterruptRequest) continue;
            IOInterrupt.ioiFdcRise();
            break;
        }
    }

    public static void fdcWriteDriveControl(int n) {
        IOInterrupt.ioiFddFall();
        int n2 = Integer.numberOfTrailingZeros(n & 0xF);
        if (n2 < 4) {
            FDUnit fDUnit = fdcUnitArray[n2];
            if (fDUnit.abuConnected) {
                fDUnit.fduDriveControl(n);
            }
            fdcDriveLastSelected = fDUnit;
        } else {
            fdcDriveLastSelected = null;
        }
    }

    public static void fdcWriteDriveSelect(int n) {
        IOInterrupt.ioiFddFall();
        FDUnit fDUnit = fdcUnitArray[n & 3];
        if (fDUnit.abuConnected && fDUnit.fduIsInserted()) {
            boolean bl = fDUnit.fduDoubleDensity = n << 27 < 0;
            if ((byte)n < 0) {
                fDUnit.fduMotorOn();
            } else {
                fDUnit.fduMotorOff();
            }
        }
    }

    public static void fdcSetEnforcedReady(boolean bl) {
        fdcEnforcedReady = bl;
    }

    public static void fdcCommandSpecify() {
        int n = fdcCommandBuffer[1] >> 4 & 0xF;
        int n2 = fdcCommandBuffer[1] & 0xF;
        int n3 = fdcCommandBuffer[2] >> 1 & 0x7F;
        int n4 = fdcCommandBuffer[2] & 1;
        fdcSRT = n;
        FDC.fdcCPhase();
    }

    public static void fdcCommandSenseInterruptStatus() {
        int n;
        IOInterrupt.ioiFdcFall();
        for (n = 0; n <= 3; ++n) {
            FDUnit fDUnit = fdcUnitArray[n];
            if ((fdcStatus & 1 << n) == 0) continue;
            if (fDUnit.fduSeekEndInterruptWaiting) {
                fDUnit.fduSeekEndInterruptWaiting = false;
                fDUnit.fduSeekEndInterruptRequest = true;
                continue;
            }
            if (!fDUnit.fduAttentionCheckWaiting) continue;
            fDUnit.fduAttentionCheckWaiting = false;
            boolean bl = fDUnit.fduIsReady();
            if (bl == fDUnit.fduSavedReady) continue;
            fDUnit.fduSavedReady = bl;
            if (fDUnit.fduAttentionInterruptRequest) continue;
            fDUnit.fduAttentionInterruptRequest = true;
        }
        n = Integer.MIN_VALUE;
        for (int i = 0; i <= 3; ++i) {
            FDUnit fDUnit = fdcUnitArray[i];
            if (fDUnit.fduSeekEndInterruptRequest) {
                fDUnit.fduSeekEndInterruptRequest = false;
                n = fDUnit.fduSeekResultStatus | i << 24 | (fDUnit.fduPCN & 0xFF) << 16;
                break;
            }
            if (!fDUnit.fduAttentionInterruptRequest) continue;
            fDUnit.fduAttentionInterruptRequest = false;
            n = 0xC0000000 | i << 24 | (fDUnit.fduPCN & 0xFF) << 16;
            break;
        }
        FDC.fdcResultBuffer[0] = (byte)(n >> 24);
        if (n == Integer.MIN_VALUE) {
            FDC.fdcRPhase(1);
        } else {
            FDC.fdcResultBuffer[1] = (byte)(n >> 16);
            FDC.fdcRPhase(2);
        }
    }

    public static void fdcCommandResetStandby() {
        FDC.fdcCPhase();
    }

    public static void fdcCommandSetStandby() {
        FDC.fdcCPhase();
    }

    public static void fdcCommandSoftwareReset() {
        FDC.fdcCPhase();
    }

    public static void fdcCommandInvalid() {
        int n = Integer.MIN_VALUE;
        FDC.fdcResultBuffer[0] = (byte)(n >> 24);
        FDC.fdcRPhase(1);
    }

    public static String fdcResultStatusToString(int n) {
        int n2 = n >> 30 & 3;
        return String.format("0x%08x\n\t\tST0=0x%02x(IC=%d(%s) SE=%d EC=%d NR=%d HD=%d US=%d)\n\t\tST1=0x%02x(EN=%d DE=%d OR=%d ND=%d NW=%d MA=%d)\n\t\tST2=0x%02x(CM=%d DD=%d NC=%d SH=%d SN=%d BC=%d MD=%d)", n, n >> 24 & 0xFF, n2, n2 == 0 ? "NT" : (n2 == 1 ? "AT" : (n2 == 2 ? "IC" : "AI")), n >> 29 & 1, n >> 28 & 1, n >> 27 & 1, n >> 26 & 1, n >> 24 & 3, n >> 16 & 0xFF, n >> 23 & 1, n >> 21 & 1, n >> 20 & 1, n >> 18 & 1, n >> 17 & 1, n >> 16 & 1, n >> 8 & 0xFF, n >> 14 & 1, n >> 13 & 1, n >> 12 & 1, n >> 11 & 1, n >> 10 & 1, n >> 9 & 1, n >> 8 & 1);
    }

    public static String fdcStatusToString(int n) {
        return String.format("0x%02x(RQM=%d DIO=%d(%s) NDM=%d CB=%d D3B=%d D2B=%d D1B=%d D0B=%d)", n, n >> 7, n >> 6 & 1, (n >> 6 & 1) == 0 ? "MPU->FDC" : "FDC->MPU", n >> 5 & 1, n >> 4 & 1, n >> 3 & 1, n >> 2 & 1, n >> 1 & 1, n & 1);
    }

    static {
        FDC_COMMAND_NAME = new String[]{"INVALID", "INVALID", "READ DIAGNOSTIC", "SPECIFY", "SENSE DEVICE STATUS", "WRITE DATA", "READ DATA", "RECALIBRATE", "SENSE INTERRUPT STATUS", "WRITE DELETED DATA", "READ ID", "INVALID", "READ DELETED DATA", "WRITE ID", "INVALID", "SEEK", "INVALID", "SCAN EQUAL", "INVALID", "INVALID", "RESET STANDBY", "SET STANDBY", "SOFTWARE RESET", "INVALID", "INVALID", "SCAN LOW OR EQUAL", "INVALID", "INVALID", "INVALID", "SCAN HIGH OR EQUAL", "INVALID", "INVALID"};
        FDC_COMMAND_LENGTH = "\u0001\u0001\t\u0003\u0002\t\t\u0002\u0001\t\u0002\u0001\t\u0006\u0001\u0003\u0001\t\u0001\u0001\u0001\u0001\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001".getBytes(XEiJ.ISO_8859_1);
        fdcCommandBuffer = new byte[256];
        fdcResultBuffer = new byte[256];
        fdcTempBuffer = new byte[16384];
    }

    static class OpenDialog
    extends AbstractOpenDialog {
        public OpenDialog() {
            super(XEiJ.frmFrame, "Open floppy disk image files", "\u30d5\u30ed\u30c3\u30d4\u30fc\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", false, fdcFileFilter);
        }

        @Override
        public void openFiles(File[] fileArray, boolean bl) {
            FDC.fdcOpenFiles(fileArray, bl);
        }
    }

    public static class FDUnit
    extends AbstractUnit {
        public FDMedia fduMedia = null;
        public byte[] fduImage = null;
        public boolean fduWritten = false;
        public int fduCommandNumber;
        public boolean fduBlinking = false;
        public boolean fduPrevented = false;
        public boolean fduDoubleDensity = false;
        public static final int FDU_ACCESS_OFF = 0;
        public static final int FDU_ACCESS_GREEN_BLINKING = 1;
        public static final int FDU_ACCESS_GREEN_ON = 2;
        public static final int FDU_ACCESS_RED_ON = 3;
        public static final int FDU_EJECT_OFF = 0;
        public static final int FDU_EJECT_GREEN_ON = 1;
        public static final long FDU_SEEK_INTERVAL = 1000000000L;
        public int fduNCN = 0;
        public int fduPCN = 0;
        public int fduPHN = 0;
        public int fduPRN = 1;
        public int fduPNN = 3;
        public int fduEOT = 1;
        public int fduSTP = 1;
        public int fduSRC;
        public boolean fduSeekStepWaiting = false;
        public boolean fduSeekEndInterruptWaiting = false;
        public boolean fduSeekEndInterruptRequest = false;
        public int fduSeekResultStatus;
        public final TickerQueue.Ticker fduSeekTicker = new TickerQueue.Ticker(this){
            final /* synthetic */ FDUnit this$0;
            {
                FDUnit fDUnit2 = fDUnit;
                Objects.requireNonNull(fDUnit2);
                this.this$0 = fDUnit2;
            }

            @Override
            protected void tick() {
                if ((fdcStatus & 1 << this.this$0.abuNumber) != 0) {
                    if ((fdcStatus & 0x10) != 0) {
                        this.this$0.fduSeekStepWaiting = true;
                    } else {
                        this.this$0.fduSeekStep();
                    }
                } else {
                    this.this$0.fduSeekStep();
                }
            }
        };
        public static final int FDU_MOTOR_SLEEPING = 0;
        public static final int FDU_MOTOR_ACCELERATING = 1;
        public static final int FDU_MOTOR_SLEEP_SOON = 2;
        public static final int FDU_MOTOR_RUN_SOON = 3;
        public static final int FDU_MOTOR_DECELERATING = 4;
        public static final int FDU_MOTOR_RUNNING = 5;
        public int fduMotorStatus = 0;
        public static final long FDU_MOTOR_ON_DELAY = 100000000L;
        public static final long FDU_MOTOR_OFF_DELAY = 3000000000000L;
        public static final long FDU_MOTOR_INTERRUPT_DELAY = 100000000L;
        public boolean fduSavedReady = false;
        public boolean fduAttentionCheckWaiting = false;
        public boolean fduAttentionInterruptRequest = false;
        public final TickerQueue.Ticker fduMotorAcceleratingTicker = new TickerQueue.Ticker(this){
            final /* synthetic */ FDUnit this$0;
            {
                FDUnit fDUnit2 = fDUnit;
                Objects.requireNonNull(fDUnit2);
                this.this$0 = fDUnit2;
            }

            @Override
            protected void tick() {
                this.this$0.fduMotorStatus = 3;
                TickerQueue.tkqAdd(this.this$0.fduMotorRunSoonTicker, XEiJ.mpuClockTime + 100000000L);
            }
        };
        public final TickerQueue.Ticker fduMotorRunSoonTicker = new TickerQueue.Ticker(this){
            final /* synthetic */ FDUnit this$0;
            {
                FDUnit fDUnit2 = fDUnit;
                Objects.requireNonNull(fDUnit2);
                this.this$0 = fDUnit2;
            }

            @Override
            protected void tick() {
                this.this$0.fduMotorStatus = 5;
                this.this$0.fduMotorInterrupt();
            }
        };
        public final TickerQueue.Ticker fduMotorDeceleratingTicker = new TickerQueue.Ticker(this){
            final /* synthetic */ FDUnit this$0;
            {
                FDUnit fDUnit2 = fDUnit;
                Objects.requireNonNull(fDUnit2);
                this.this$0 = fDUnit2;
            }

            @Override
            protected void tick() {
                this.this$0.fduMotorStatus = 2;
                TickerQueue.tkqAdd(this.this$0.fduMotorSleepSoonTicker, XEiJ.mpuClockTime + 100000000L);
            }
        };
        public final TickerQueue.Ticker fduMotorSleepSoonTicker = new TickerQueue.Ticker(this){
            final /* synthetic */ FDUnit this$0;
            {
                FDUnit fDUnit2 = fDUnit;
                Objects.requireNonNull(fDUnit2);
                this.this$0 = fDUnit2;
            }

            @Override
            protected void tick() {
                this.this$0.fduMotorStatus = 0;
                if (!this.this$0.fduPrevented) {
                    this.this$0.allow();
                }
                this.this$0.fduMotorInterrupt();
            }
        };

        public boolean fduIsInserted() {
            return this.abuConnected && this.abuInserted && this.fduMedia != null;
        }

        public boolean fduIsWriteProtected() {
            return this.abuWriteProtected;
        }

        public boolean fduIsReady() {
            return fdcEnforcedReady || this.abuConnected && this.fduIsInserted() && (this.fduMotorStatus == 3 || this.fduMotorStatus == 4 || this.fduMotorStatus == 5);
        }

        public void fduSeekStep() {
            if (this.fduPCN != this.fduNCN) {
                --this.fduSRC;
                if (this.fduSRC == 0) {
                    this.fduSRC = 16 - fdcSRT;
                    this.fduPCN = this.fduPCN < this.fduNCN ? ++this.fduPCN : --this.fduPCN;
                }
                TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
                return;
            }
            switch (this.fduCommandNumber) {
                case 5: {
                    this.fduWriteDataEPhase();
                    break;
                }
                case 6: {
                    this.fduReadDataEPhase();
                    break;
                }
                case 7: 
                case 15: {
                    this.fduSeekEnd();
                    break;
                }
                case 17: 
                case 25: 
                case 29: {
                    this.fduScanEPhase();
                }
            }
        }

        public void fduSeekEnd() {
            if ((fdcStatus & 0x10) != 0) {
                this.fduSeekEndInterruptWaiting = true;
            } else if (!this.fduSeekEndInterruptRequest) {
                this.fduSeekEndInterruptRequest = true;
                IOInterrupt.ioiFdcRise();
            }
        }

        public void fduMotorOn() {
            if (!this.fduIsInserted()) {
                return;
            }
            switch (this.fduMotorStatus) {
                case 0: {
                    this.fduMotorStatus = 1;
                    if (!this.fduPrevented) {
                        this.prevent();
                    }
                    TickerQueue.tkqAdd(this.fduMotorAcceleratingTicker, XEiJ.mpuClockTime + 100000000L);
                    break;
                }
                case 2: {
                    TickerQueue.tkqRemove(this.fduMotorSleepSoonTicker);
                    this.fduMotorStatus = 1;
                    TickerQueue.tkqAdd(this.fduMotorAcceleratingTicker, XEiJ.mpuClockTime + 100000000L);
                    break;
                }
                case 4: {
                    TickerQueue.tkqRemove(this.fduMotorDeceleratingTicker);
                    this.fduMotorStatus = 3;
                    TickerQueue.tkqAdd(this.fduMotorRunSoonTicker, XEiJ.mpuClockTime + 100000000L);
                }
            }
        }

        public void fduMotorOff() {
            if (!this.fduIsInserted()) {
                return;
            }
            switch (this.fduMotorStatus) {
                case 1: {
                    TickerQueue.tkqRemove(this.fduMotorAcceleratingTicker);
                    this.fduMotorStatus = 2;
                    TickerQueue.tkqAdd(this.fduMotorSleepSoonTicker, XEiJ.mpuClockTime + 100000000L);
                    break;
                }
                case 3: {
                    TickerQueue.tkqRemove(this.fduMotorRunSoonTicker);
                }
                case 5: {
                    this.fduMotorStatus = 4;
                    TickerQueue.tkqAdd(this.fduMotorDeceleratingTicker, XEiJ.mpuClockTime + 3000000000000L);
                }
            }
        }

        public void fduMotorInterrupt() {
            if ((fdcStatus & 1 << this.abuNumber) != 0) {
                this.fduAttentionCheckWaiting = true;
            } else if ((fdcStatus & 0x10) != 0) {
                this.fduAttentionCheckWaiting = true;
            } else {
                boolean bl = this.fduIsReady();
                if (bl != this.fduSavedReady) {
                    this.fduSavedReady = bl;
                    if (!this.fduAttentionInterruptRequest) {
                        this.fduAttentionInterruptRequest = true;
                        IOInterrupt.ioiFdcRise();
                    }
                }
            }
        }

        public FDUnit(int n) {
            super(n);
            this.fduSeekResultStatus = Integer.MIN_VALUE;
        }

        public void fduTini() {
            if (this.fduIsInserted()) {
                this.fduFlush();
            }
        }

        public boolean fduFlush() {
            String string;
            if (!(this.abuConnected && this.fduIsInserted() && this.fduWritten)) {
                return true;
            }
            if (this.fduIsWriteProtected()) {
                return false;
            }
            int n = this.abuPath.lastIndexOf(46);
            String string2 = string = n < 0 ? "" : this.abuPath.substring(n + 1).toUpperCase();
            if (string.equals("DIM")) {
                byte[] byArray = new byte[256 + this.fduMedia.fdmBytesPerDisk];
                int n2 = this.fduMedia.fdmMakeDimImage(byArray, this.fduImage);
                if (n2 < 0) {
                    XEiJ.pnlExitFullScreen(true);
                    JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? this.fduMedia.fdmName + " \u3092 *.DIM \u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093" : this.fduMedia.fdmName + " cannot be converted to *.DIM");
                    return false;
                }
                if (!XEiJ.rscPutFile(this.abuPath, byArray, 0, n2)) {
                    return false;
                }
            } else if (!XEiJ.rscPutFile(this.abuPath, this.fduImage, 0, this.fduMedia.fdmBytesPerDisk)) {
                return false;
            }
            this.fduWritten = false;
            return true;
        }

        @Override
        protected void connect(boolean bl) {
            super.connect(bl);
            this.fduImage = new byte[0x190110];
        }

        @Override
        protected void disconnect() {
            super.disconnect();
            this.fduImage = null;
        }

        public void blink() {
            if (!this.abuConnected || this.fduBlinking) {
                return;
            }
            this.fduBlinking = true;
        }

        public void darken() {
            if (!this.abuConnected || !this.fduBlinking) {
                return;
            }
            this.fduBlinking = false;
        }

        @Override
        protected boolean eject() {
            if (!this.fduFlush()) {
                return false;
            }
            this.fduMotorStatus = 0;
            boolean bl = this.fduIsInserted();
            String string = this.abuPath;
            if (!super.eject()) {
                return false;
            }
            if (this.fduMedia != null) {
                FDC.fdcAddHistory(new File(string).getAbsoluteFile());
                System.out.println(Multilingual.mlnJapanese ? string + " \u3092 fd" + this.abuNumber + " \u304b\u3089\u53d6\u308a\u51fa\u3057\u307e\u3057\u305f" : string + " was ejected from fd" + this.abuNumber);
            }
            this.fduMedia = null;
            this.fduPCN = 0;
            this.fduPHN = 0;
            this.fduPRN = 1;
            this.fduPNN = 3;
            if (bl) {
                IOInterrupt.ioiFddFall();
                IOInterrupt.ioiFddRise();
            }
            return true;
        }

        @Override
        protected boolean open() {
            if (!super.open()) {
                return false;
            }
            fdcOpenUnit = this.abuNumber;
            if (fdcOpenDialog == null) {
                fdcOpenDialog = new OpenDialog();
                fdcOpenDialog.setReadOnly(Settings.sgsGetOnOff("fdreadonly"));
                fdcOpenDialog.setReboot(Settings.sgsGetOnOff("fdappreboot"));
                for (File[] fileArray : fdcOpenHistory) {
                    fdcOpenDialog.addHistory(fileArray);
                }
                fdcOpenHistory.clear();
            }
            fdcOpenDialog.rescanCurrentDirectory();
            XEiJ.pnlExitFullScreen(true);
            fdcOpenDialog.setVisible(true);
            return true;
        }

        @Override
        public boolean insert(String string, boolean bl) {
            if (FDC.fdcIsInsertedPath(string)) {
                return false;
            }
            if (!super.insert(string, bl)) {
                return false;
            }
            if (this.fduMedia != null) {
                IOInterrupt.ioiFddFall();
                IOInterrupt.ioiFddRise();
            }
            return true;
        }

        @Override
        protected boolean load(String string) {
            this.fduMedia = FDMedia.fdmPathToMedia(string, this.fduImage);
            if (this.fduMedia == null) {
                return false;
            }
            if (this.abuWriteProtected && !this.abuUnprotectable) {
                this.fduMedia.fdmReviveFiles(this.fduImage);
            }
            this.fduWritten = false;
            FDC.fdcAddHistory(new File(string).getAbsoluteFile());
            System.out.println(Multilingual.mlnJapanese ? string + " \u3092 fd" + this.abuNumber + " \u306b\u633f\u5165\u3057\u307e\u3057\u305f" : string + " was inserted in fd" + this.abuNumber);
            return true;
        }

        @Override
        public String getName() {
            return this.abuPath.substring(this.abuPath.lastIndexOf(File.separatorChar) + 1);
        }

        public int fduDriveStatus() {
            return this.fduIsInserted() ? 128 : 0;
        }

        public void fduDriveControl(int n) {
            if (n << 26 < 0) {
                this.eject();
            }
            if (n << 25 < 0) {
                this.fduPrevented = true;
                this.prevent();
            } else {
                this.fduPrevented = false;
                this.allow();
            }
            if ((byte)n < 0) {
                this.fduBlinking = true;
                this.blink();
            } else {
                this.fduBlinking = false;
                this.darken();
            }
        }

        public void fduCommandReadDiagnostic() {
            FDC.fdcCommandInvalid();
        }

        public void fduCommandSenseDeviceStatus() {
            int n = (this.fduIsWriteProtected() ? 64 : 0) | (this.fduIsReady() ? 32 : 0) | (this.fduIsInserted() && this.fduIsReady() && this.fduPCN == 0 ? 16 : 0) | (this.fduPHN & 1) << 2 | this.abuNumber;
            FDC.fdcResultBuffer[0] = (byte)n;
            FDC.fdcRPhase(1);
        }

        public void fduCommandWriteData() {
            int n = fdcCommandBuffer[2] & 0xFF;
            int n2 = fdcCommandBuffer[3] & 0xFF;
            int n3 = fdcCommandBuffer[4] & 0xFF;
            int n4 = fdcCommandBuffer[5] & 0xFF;
            int n5 = fdcCommandBuffer[6] & 0xFF;
            this.fduCommandNumber = fdcCommandNumber;
            if (!this.fduIsReady()) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            if (this.fduIsWriteProtected()) {
                this.fduEPhaseEnd(0x40020000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduNCN = n;
            this.fduPHN = n2;
            this.fduPRN = n3;
            this.fduPNN = n4;
            this.fduEOT = n5;
            this.fduSRC = 16 - fdcSRT;
            fdcStatus = 0x10 | fdcStatus & 0xF;
            TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
        }

        public void fduWriteDataEPhase() {
            if (this.fduPCN != this.fduNCN) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduWritten = true;
            fdcStatus = 0x90 | fdcStatus & 0xF;
            int n = this.fduCalcOffset();
            if (n < 0) {
                this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            fdcReadHandle = null;
            fdcWriteHandle = this.fduImage;
            fdcIndex = fdcStart = n;
            fdcLimit = n + (128 << this.fduPNN);
            HD63450.dmaFallPCL(0);
        }

        public void fduWriteDataEPhaseEnd() {
            if (this.fduPRN == this.fduEOT) {
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN = this.fduMedia == FDMedia.FDM_2HS && this.fduPCN == 0 && this.fduPHN == 0 && this.fduPRN == 1 ? 11 : ++this.fduPRN;
            int n = this.fduCalcOffset();
            if (n < 0) {
                this.fduEPhaseEnd(0x40010000 | (this.fduPHN << 2 | this.abuNumber << 24));
                return;
            }
            fdcIndex = fdcStart = n;
            fdcLimit = n + (128 << this.fduPNN);
        }

        public void fduCommandReadData() {
            int n = fdcCommandBuffer[2] & 0xFF;
            int n2 = fdcCommandBuffer[3] & 0xFF;
            int n3 = fdcCommandBuffer[4] & 0xFF;
            int n4 = fdcCommandBuffer[5] & 0xFF;
            int n5 = fdcCommandBuffer[6] & 0xFF;
            this.fduCommandNumber = fdcCommandNumber;
            if (!this.fduIsReady()) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduNCN = n;
            this.fduPHN = n2;
            this.fduPRN = n3;
            this.fduPNN = n4;
            this.fduEOT = n5;
            this.fduSRC = 16 - fdcSRT;
            fdcStatus = 0x10 | fdcStatus & 0xF;
            fdcReadHandle = null;
            fdcWriteHandle = null;
            TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
        }

        public void fduReadDataEPhase() {
            if (this.fduPCN != this.fduNCN) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            fdcStatus = 0xD0 | fdcStatus & 0xF;
            int n = this.fduCalcOffset();
            if (n < 0) {
                this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            fdcReadHandle = this.fduImage;
            fdcWriteHandle = null;
            fdcIndex = fdcStart = n;
            fdcLimit = n + (128 << this.fduPNN);
            HD63450.dmaFallPCL(0);
        }

        public void fduReadDataEPhaseEnd() {
            if (this.fduPRN == this.fduEOT) {
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN = this.fduMedia == FDMedia.FDM_2HS && this.fduPCN == 0 && this.fduPHN == 0 && this.fduPRN == 1 ? 11 : ++this.fduPRN;
            int n = this.fduCalcOffset();
            if (n < 0) {
                this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            fdcIndex = fdcStart = n;
            fdcLimit = n + (128 << this.fduPNN);
        }

        public void fduCommandRecalibrate() {
            this.fduCommandNumber = fdcCommandNumber;
            fdcStatus |= 1 << this.abuNumber;
            this.fduNCN = 0;
            this.fduSRC = 16 - fdcSRT;
            if (fdcEnforcedReady && !this.abuConnected) {
                this.fduSeekResultStatus = 0x70000000;
                FDC.fdcCPhase();
                this.fduSeekEnd();
            } else if (!this.fduIsReady()) {
                this.fduSeekResultStatus = 0x68000000;
                FDC.fdcCPhase();
                this.fduSeekEnd();
            } else {
                this.fduSeekResultStatus = 0x20000000;
                TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
                FDC.fdcCPhase();
            }
        }

        public void fduCommandWriteDeletedData() {
            FDC.fdcCommandInvalid();
        }

        public void fduCommandReadId() {
            int n = fdcCommandBuffer[1] >> 2 & 1;
            this.fduCommandNumber = fdcCommandNumber;
            this.fduPHN = n;
            if (!this.fduIsReady()) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN = this.fduMedia == FDMedia.FDM_2HS ? (this.fduPCN == 0 && this.fduPHN == 0 ? (this.fduPRN == 1 ? 11 : (this.fduPRN == 18 ? 1 : ++this.fduPRN)) : (this.fduPRN == 18 ? 10 : ++this.fduPRN)) : (this.fduPRN == this.fduMedia.fdmSectorsPerTrack ? 1 : ++this.fduPRN);
            if (this.fduMedia == FDMedia.FDM_2HDE && (this.fduPCN != 0 || this.fduPHN != 0 || this.fduPRN != 1)) {
                this.fduPHN |= 0x80;
            }
            this.fduPNN = this.fduMedia.fdmSectorScale;
            int n2 = this.fduCalcOffset();
            if (n2 < 0) {
                this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
        }

        public void fduCommandReadDeletedData() {
            FDC.fdcCommandInvalid();
        }

        public void fduCommandWriteId() {
            this.fduCommandNumber = fdcCommandNumber;
            if (!this.fduIsReady()) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            if (this.fduIsWriteProtected()) {
                this.fduEPhaseEnd(0x40020000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            fdcStatus = 0x90 | fdcStatus & 0xF;
            fdcReadHandle = null;
            fdcWriteHandle = fdcTempBuffer;
            fdcStart = 0;
            fdcIndex = 0;
            fdcLimit = (fdcCommandBuffer[3] & 0xFF) << 2;
            HD63450.dmaFallPCL(0);
        }

        public void fduWriteIdEPhaseEnd() {
            int n;
            int n2;
            HD63450.dmaRisePCL(0);
            if (fdcTempBuffer[0] == 0 && fdcTempBuffer[1] == 0) {
                n2 = fdcTempBuffer[2] & 0xFF;
                n = fdcTempBuffer[3] & 0xFF;
                int n3 = fdcTempBuffer[4] & 0xFF;
                int n4 = fdcTempBuffer[5] & 0xFF;
                int n5 = fdcTempBuffer[6] & 0xFF;
                int n6 = fdcTempBuffer[7] & 0xFF;
                int n7 = fdcLimit >> 2;
                FDMedia fDMedia = null;
                if (n4 == 0 && n2 == 1 && n5 == 2) {
                    if (!this.fduDoubleDensity) {
                        if (n == 3 && n6 == 3) {
                            if (n7 == 8) {
                                fDMedia = FDMedia.FDM_2HD;
                            }
                        } else if (n == 2 && n6 == 2) {
                            if (n7 == 15) {
                                fDMedia = FDMedia.FDM_2HC;
                            } else if (n7 == 18) {
                                fDMedia = FDMedia.FDM_2HQ;
                            }
                        }
                    } else if (n == 2 && n6 == 2) {
                        if (n7 == 8) {
                            fDMedia = FDMedia.FDM_2DD8;
                        } else if (n7 == 9) {
                            fDMedia = FDMedia.FDM_2DD9;
                        } else if (n7 == 10) {
                            fDMedia = FDMedia.FDM_2DD10;
                        }
                    }
                } else if (n4 == 128 && n2 == 1 && n5 == 2) {
                    if (!this.fduDoubleDensity && n == 3 && n6 == 3 && n7 == 9) {
                        fDMedia = FDMedia.FDM_2HDE;
                    }
                } else if (n4 == 0 && n2 == 1 && n5 == 11 && !this.fduDoubleDensity && n == 3 && n6 == 3 && n7 == 9) {
                    fDMedia = FDMedia.FDM_2HS;
                }
                this.fduMedia = fDMedia != null ? fDMedia : FDMedia.FDM_2HD;
            }
            for (n2 = 0; n2 < fdcLimit; n2 += 4) {
                this.fduPCN = fdcTempBuffer[n2] & 0xFF;
                this.fduPHN = fdcTempBuffer[n2 + 1] & 0xFF;
                this.fduPRN = fdcTempBuffer[n2 + 2] & 0xFF;
                this.fduPNN = fdcTempBuffer[n2 + 3] & 0xFF;
                n = this.fduCalcOffset();
                if (n < 0) {
                    if (0 < this.fduPCN) {
                        --this.fduPCN;
                        n = this.fduCalcOffset();
                        ++this.fduPCN;
                    }
                    if (n >= 0) continue;
                    this.fduEPhaseEnd(0x50000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                    return;
                }
                Arrays.fill(this.fduImage, n, n + (128 << this.fduPNN), fdcCommandBuffer[5]);
                this.fduWritten = true;
            }
            this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
        }

        public void fduCommandSeek() {
            int n = fdcCommandBuffer[2] & 0xFF;
            this.fduCommandNumber = fdcCommandNumber;
            fdcStatus |= 1 << this.abuNumber;
            this.fduNCN = n;
            this.fduSRC = 16 - fdcSRT;
            if (fdcEnforcedReady && !this.abuConnected) {
                this.fduSeekResultStatus = 0x70000000;
                FDC.fdcCPhase();
                this.fduSeekEnd();
            } else if (!this.fduIsReady()) {
                this.fduSeekResultStatus = 0x68000000;
                FDC.fdcCPhase();
                this.fduSeekEnd();
            } else {
                this.fduSeekResultStatus = 0x20000000;
                TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
                FDC.fdcCPhase();
            }
        }

        public void fduCommandScan() {
            int n = fdcCommandBuffer[2] & 0xFF;
            int n2 = fdcCommandBuffer[3] & 0xFF;
            int n3 = fdcCommandBuffer[4] & 0xFF;
            int n4 = fdcCommandBuffer[5] & 0xFF;
            int n5 = fdcCommandBuffer[6] & 0xFF;
            int n6 = fdcCommandBuffer[8] & 3;
            this.fduCommandNumber = fdcCommandNumber;
            if (!this.fduIsReady()) {
                this.fduEPhaseEnd(0x48000000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduNCN = n;
            this.fduPHN = n2;
            this.fduPRN = n3;
            this.fduPNN = n4;
            this.fduEOT = n5;
            this.fduSTP = n6;
            this.fduSRC = 16 - fdcSRT;
            fdcStatus = 0x10 | fdcStatus & 0xF;
            fdcReadHandle = null;
            fdcWriteHandle = null;
            TickerQueue.tkqAdd(this.fduSeekTicker, XEiJ.mpuClockTime + 1000000000L);
        }

        public void fduScanEPhase() {
            fdcStatus = 0x90 | fdcStatus & 0xF;
            fdcReadHandle = null;
            fdcWriteHandle = fdcTempBuffer;
            fdcStart = 0;
            fdcIndex = 0;
            fdcLimit = 128 << this.fduPNN;
            HD63450.dmaFallPCL(0);
        }

        public void fduScanEqualEPhaseEnd() {
            block4: {
                int n = this.fduCalcOffset();
                if (n < 0) {
                    this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                    return;
                }
                int n2 = 128 << this.fduPNN;
                for (int i = 0; i < n2; ++i) {
                    int n3 = fdcTempBuffer[i] & 0xFF;
                    if (n3 == 255 || (this.fduImage[n + i] & 0xFF) == n3) {
                        continue;
                    }
                    break block4;
                }
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0x800 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            if (this.fduPRN == this.fduEOT) {
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0x400 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN += this.fduSTP;
            fdcStart = 0;
            fdcIndex = 0;
        }

        public void fduScanLowOrEqualEPhaseEnd() {
            block4: {
                int n = this.fduCalcOffset();
                if (n < 0) {
                    this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                    return;
                }
                int n2 = 128 << this.fduPNN;
                for (int i = 0; i < n2; ++i) {
                    int n3 = fdcTempBuffer[i] & 0xFF;
                    if (n3 == 255 || (this.fduImage[n + i] & 0xFF) <= n3) {
                        continue;
                    }
                    break block4;
                }
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            if (this.fduPRN == this.fduEOT) {
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0x400 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN += this.fduSTP;
            fdcStart = 0;
            fdcIndex = 0;
            fdcLimit = 128 << this.fduPNN;
        }

        public void fduScanHighOrEqualEPhaseEnd() {
            block4: {
                int n = this.fduCalcOffset();
                if (n < 0) {
                    this.fduEPhaseEnd(0x40010000 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                    return;
                }
                int n2 = 128 << this.fduPNN;
                for (int i = 0; i < n2; ++i) {
                    int n3 = fdcTempBuffer[i] & 0xFF;
                    if (n3 == 255 || (this.fduImage[n + i] & 0xFF) >= n3) {
                        continue;
                    }
                    break block4;
                }
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            if (this.fduPRN == this.fduEOT) {
                HD63450.dmaRisePCL(0);
                this.fduEPhaseEnd(0x400 | ((this.fduPHN & 1) << 2 | this.abuNumber) << 24);
                return;
            }
            this.fduPRN += this.fduSTP;
            fdcStart = 0;
            fdcIndex = 0;
            fdcLimit = 128 << this.fduPNN;
        }

        public int fduCalcOffset() {
            int n = this.fduMedia == null ? -1 : (this.fduDoubleDensity == this.fduMedia.fdmDoubleDensity && this.fduPNN == this.fduMedia.fdmSectorScale && this.fduPCN < this.fduMedia.fdmCylindersPerDisk && (this.fduMedia == FDMedia.FDM_2HDE ? this.fduPHN == (this.fduPCN == 0 && this.fduPRN == 1 ? 0 : 128) || this.fduPHN == 129 : this.fduPHN < this.fduMedia.fdmTracksPerCylinder) && (this.fduMedia == FDMedia.FDM_2HS ? (this.fduPCN == 0 && this.fduPHN == 0 ? this.fduPRN == 1 || 11 <= this.fduPRN && this.fduPRN <= 18 : 10 <= this.fduPRN && this.fduPRN <= 18) : 1 <= this.fduPRN && this.fduPRN <= this.fduMedia.fdmSectorsPerTrack) ? this.fduMedia.fdmBytesPerSector * ((this.fduPRN <= this.fduMedia.fdmSectorsPerTrack ? this.fduPRN : this.fduPRN - this.fduMedia.fdmSectorsPerTrack) - 1 + this.fduMedia.fdmSectorsPerTrack * ((this.fduPHN & 1) + this.fduMedia.fdmTracksPerCylinder * this.fduPCN)) : -1);
            return n;
        }

        public void fduEPhaseEnd(int n) {
            FDC.fdcResultBuffer[0] = (byte)(n >> 24);
            FDC.fdcResultBuffer[1] = (byte)(n >> 16);
            FDC.fdcResultBuffer[2] = (byte)(n >> 8);
            FDC.fdcResultBuffer[3] = (byte)this.fduPCN;
            FDC.fdcResultBuffer[4] = (byte)this.fduPHN;
            FDC.fdcResultBuffer[5] = (byte)this.fduPRN;
            FDC.fdcResultBuffer[6] = (byte)this.fduPNN;
            FDC.fdcRPhase(7);
            IOInterrupt.ioiFdcRise();
        }
    }
}

