/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.DataBreakPoint;
import xeij.M68kException;
import xeij.MemoryMappedDevice;
import xeij.SUK;
import xeij.TickerQueue;
import xeij.XEiJ;

public class HD63450 {
    public static final int DMA_DEBUG_TRACE = 0;
    public static final boolean DMA_ALERT_HIMEM = true;
    public static final int DMA_CSR = 0;
    public static final int DMA_COC = 128;
    public static final int DMA_BLC = 64;
    public static final int DMA_NDT = 32;
    public static final int DMA_ERR = 16;
    public static final int DMA_ACT = 8;
    public static final int DMA_DIT = 4;
    public static final int DMA_PCT = 2;
    public static final int DMA_PCS = 1;
    public static final int DMA_CER = 1;
    public static final int DMA_ERROR_CODE = 31;
    public static final int DMA_NO_ERROR = 0;
    public static final int DMA_CONFIGURATION_ERROR = 1;
    public static final int DMA_TIMING_ERROR = 2;
    public static final int DMA_MEMORY_ADDRESS_ERROR = 5;
    public static final int DMA_DEVICE_ADDRESS_ERROR = 6;
    public static final int DMA_BASE_ADDRESS_ERROR = 7;
    public static final int DMA_MEMORY_BUS_ERROR = 9;
    public static final int DMA_DEVICE_BUS_ERROR = 10;
    public static final int DMA_BASE_BUS_ERROR = 11;
    public static final int DMA_MEMORY_COUNT_ERROR = 13;
    public static final int DMA_BASE_COUNT_ERROR = 15;
    public static final int DMA_EXTERNAL_ABORT = 16;
    public static final int DMA_SOFTWARE_ABORT = 17;
    public static final int DMA_DCR = 4;
    public static final int DMA_XRM = 192;
    public static final int DMA_BURST_TRANSFER = 0;
    public static final int DMA_NO_HOLD_CYCLE_STEAL = 128;
    public static final int DMA_HOLD_CYCLE_STEAL = 192;
    public static final int DMA_DTYP = 48;
    public static final int DMA_HD68000_COMPATIBLE = 0;
    public static final int DMA_HD6800_COMPATIBLE = 16;
    public static final int DMA_ACK_DEVICE = 32;
    public static final int DMA_ACK_READY_DEVICE = 48;
    public static final int DMA_DPS = 8;
    public static final int DMA_PORT_8_BIT = 0;
    public static final int DMA_PORT_16_BIT = 8;
    public static final int DMA_PCL = 3;
    public static final int DMA_STATUS_INPUT = 0;
    public static final int DMA_STATUS_INPUT_INTERRUPT = 1;
    public static final int DMA_EIGHTH_START_PULSE = 2;
    public static final int DMA_ABORT_INPUT = 3;
    public static final int DMA_OCR = 5;
    public static final int DMA_DIR = 128;
    public static final int DMA_MEMORY_TO_DEVICE = 0;
    public static final int DMA_DEVICE_TO_MEMORY = 128;
    public static final int DMA_BTD = 64;
    public static final int DMA_SIZE = 48;
    public static final int DMA_BYTE_SIZE = 0;
    public static final int DMA_WORD_SIZE = 16;
    public static final int DMA_LONG_WORD_SIZE = 32;
    public static final int DMA_UNPACKED_8_BIT = 48;
    public static final int DMA_CHAIN = 12;
    public static final int DMA_NO_CHAINING = 0;
    public static final int DMA_ARRAY_CHAINING = 8;
    public static final int DMA_LINK_ARRAY_CHAINING = 12;
    public static final int DMA_REQG = 3;
    public static final int DMA_AUTO_REQUEST = 0;
    public static final int DMA_AUTO_REQUEST_MAX = 1;
    public static final int DMA_EXTERNAL_REQUEST = 2;
    public static final int DMA_DUAL_REQUEST = 3;
    public static final int DMA_SCR = 6;
    public static final int DMA_MAC = 12;
    public static final int DMA_STATIC_MAR = 0;
    public static final int DMA_INC_MAR = 4;
    public static final int DMA_DEC_MAR = 8;
    public static final int DMA_DAC = 3;
    public static final int DMA_STATIC_DAR = 0;
    public static final int DMA_INC_DAR = 1;
    public static final int DMA_DEC_DAR = 2;
    public static final int DMA_CCR = 7;
    public static final int DMA_STR = 128;
    public static final int DMA_CNT = 64;
    public static final int DMA_HLT = 32;
    public static final int DMA_SAB = 16;
    public static final int DMA_ITE = 8;
    public static final int DMA_MTC = 10;
    public static final int DMA_MAR = 12;
    public static final int DMA_DAR = 20;
    public static final int DMA_BTC = 26;
    public static final int DMA_BAR = 28;
    public static final int DMA_NIV = 37;
    public static final int DMA_EIV = 39;
    public static final int DMA_MFC = 41;
    public static final int DMA_FC2 = 4;
    public static final int DMA_FC1 = 2;
    public static final int DMA_FC0 = 1;
    public static final int DMA_CPR = 45;
    public static final int DMA_CP = 3;
    public static final int DMA_DFC = 49;
    public static final int DMA_BFC = 57;
    public static final int DMA_GCR = 255;
    public static final int DMA_BT = 12;
    public static final int DMA_BR = 3;
    public static final int[] dmaPCS = new int[4];
    public static final int[] dmaPCT = new int[4];
    public static final int[] dmaDIT = new int[4];
    public static final int[] dmaACT = new int[4];
    public static final int[] dmaERR = new int[4];
    public static final int[] dmaNDT = new int[4];
    public static final int[] dmaBLC = new int[4];
    public static final int[] dmaCOC = new int[4];
    public static final int[] dmaErrorCode = new int[4];
    public static final int[] dmaPCL = new int[4];
    public static final int[] dmaDPS = new int[4];
    public static final int[] dmaDTYP = new int[4];
    public static final int[] dmaXRM = new int[4];
    public static final int[] dmaREQG = new int[4];
    public static final int[] dmaCHAIN = new int[4];
    public static final int[] dmaSIZE = new int[4];
    public static final int[] dmaBTD = new int[4];
    public static final int[] dmaDIR = new int[4];
    public static final int[] dmaDAC = new int[4];
    public static final int[] dmaDACValue = new int[4];
    public static final int[] dmaMAC = new int[4];
    public static final int[] dmaMACValue = new int[4];
    public static final int[] dmaITE = new int[4];
    public static final int[] dmaSAB = new int[4];
    public static final int[] dmaHLT = new int[4];
    public static final int[] dmaCNT = new int[4];
    public static final int[] dmaSTR = new int[4];
    public static final int[] dmaMTC = new int[4];
    public static final int[] dmaMAR = new int[4];
    public static final int[] dmaDAR = new int[4];
    public static final int[] dmaBTC = new int[4];
    public static final int[] dmaBAR = new int[4];
    public static final int[] dmaNIV = new int[4];
    public static final int[] dmaEIV = new int[4];
    public static final int[] dmaMFC = new int[4];
    public static final MemoryMappedDevice[][] dmaMFCMap = new MemoryMappedDevice[4][];
    public static final int[] dmaCP = new int[4];
    public static final int[] dmaDFC = new int[4];
    public static final MemoryMappedDevice[][] dmaDFCMap = new MemoryMappedDevice[4][];
    public static final int[] dmaBFC = new int[4];
    public static final MemoryMappedDevice[][] dmaBFCMap = new MemoryMappedDevice[4][];
    public static int dmaBR;
    public static int dmaBT;
    public static long dmaBurstSpan;
    public static long dmaBurstInterval;
    public static long dmaBurstStart;
    public static long dmaBurstEnd;
    public static long[] dmaRequestTime;
    public static final int[] dmaInnerRequest;
    public static final int[] dmaInnerAcknowleged;
    public static final long[] dmaInnerClock;
    public static final int[] dmaMemoryCarry;
    public static final int[] dmaDeviceCarry;
    public static final int[] dmaAdditionalCycles;
    public static int dmaReadCycles;
    public static int dmaWriteCycles;
    public static final TickerQueue.Ticker[] dmaTickerArray;

    public static void dmaInit() {
        HD63450.dmaPCS[0] = 0;
        HD63450.dmaPCS[1] = 0;
        HD63450.dmaPCS[2] = 1;
        HD63450.dmaPCS[3] = 0;
        HD63450.dmaReset();
    }

    public static void dmaReset() {
        int n;
        for (n = 0; n < 4; ++n) {
            HD63450.dmaPCT[n] = 0;
            HD63450.dmaDIT[n] = 0;
            HD63450.dmaACT[n] = 0;
            HD63450.dmaERR[n] = 0;
            HD63450.dmaNDT[n] = 0;
            HD63450.dmaBLC[n] = 0;
            HD63450.dmaCOC[n] = 0;
            HD63450.dmaErrorCode[n] = 0;
            HD63450.dmaPCL[n] = 0;
            HD63450.dmaDPS[n] = 0;
            HD63450.dmaDTYP[n] = 0;
            HD63450.dmaXRM[n] = 0;
            HD63450.dmaREQG[n] = 0;
            HD63450.dmaCHAIN[n] = 0;
            HD63450.dmaSIZE[n] = 0;
            HD63450.dmaBTD[n] = 0;
            HD63450.dmaDIR[n] = 0;
            HD63450.dmaDAC[n] = 0;
            HD63450.dmaDACValue[n] = 0;
            HD63450.dmaMAC[n] = 0;
            HD63450.dmaMACValue[n] = 0;
            HD63450.dmaITE[n] = 0;
            HD63450.dmaSAB[n] = 0;
            HD63450.dmaHLT[n] = 0;
            HD63450.dmaCNT[n] = 0;
            HD63450.dmaSTR[n] = 0;
            HD63450.dmaMTC[n] = 0;
            HD63450.dmaMAR[n] = 0;
            HD63450.dmaDAR[n] = 0;
            HD63450.dmaBTC[n] = 0;
            HD63450.dmaBAR[n] = 0;
            HD63450.dmaNIV[n] = 15;
            HD63450.dmaEIV[n] = 15;
            HD63450.dmaMFC[n] = 0;
            HD63450.dmaMFCMap[n] = DataBreakPoint.dbpUserMap;
            HD63450.dmaCP[n] = 0;
            HD63450.dmaDFC[n] = 0;
            HD63450.dmaDFCMap[n] = DataBreakPoint.dbpUserMap;
            HD63450.dmaBFC[n] = 0;
            HD63450.dmaBFCMap[n] = DataBreakPoint.dbpUserMap;
            HD63450.dmaRequestTime[n] = Long.MAX_VALUE;
        }
        dmaBR = 0;
        dmaBT = 0;
        dmaBurstSpan = XEiJ.dmaCycleUnit << 4 + (dmaBT >> 2);
        dmaBurstInterval = dmaBurstSpan << 1 + (dmaBR & 3);
        dmaBurstStart = Long.MAX_VALUE;
        dmaBurstEnd = 0L;
        for (n = 0; n < 8; ++n) {
            HD63450.dmaInnerRequest[n] = 0;
            HD63450.dmaInnerAcknowleged[n] = 0;
        }
        for (n = 0; n < 4; ++n) {
            HD63450.dmaInnerClock[n] = Long.MAX_VALUE;
            TickerQueue.tkqRemove(dmaTickerArray[n]);
        }
    }

    public static int dmaAcknowledge() {
        for (int i = 0; i < 8; ++i) {
            int n = dmaInnerRequest[i];
            if (dmaInnerAcknowleged[i] == n) continue;
            HD63450.dmaInnerAcknowleged[i] = n;
            return (i & 1) == 0 ? dmaNIV[i >> 1] : dmaEIV[i >> 1];
        }
        return 0;
    }

    public static void dmaDone() {
        for (int i = 0; i < 8; ++i) {
            if (dmaInnerRequest[i] == dmaInnerAcknowleged[i]) continue;
            XEiJ.mpuIRR |= 0x10;
            return;
        }
    }

    public static void dmaStart(int n) {
        if ((dmaCOC[n] | dmaBLC[n] | dmaNDT[n] | dmaERR[n] | dmaACT[n]) != 0) {
            HD63450.dmaErrorExit(n, 2);
            return;
        }
        if ((dmaDTYP[n] == 0 || dmaDTYP[n] == 16) && dmaDPS[n] == 8 && dmaSIZE[n] == 0 && (dmaREQG[n] == 2 || dmaREQG[n] == 3) || dmaXRM[n] == 64 || dmaMAC[n] == 12 || dmaDAC[n] == 3 || dmaCHAIN[n] == 4 || dmaSIZE[n] == 3 && (dmaDTYP[n] != 0 && dmaDTYP[n] != 16 || dmaDPS[n] != 0)) {
            HD63450.dmaErrorExit(n, 1);
            return;
        }
        if (dmaDPS[n] == 8 && dmaSIZE[n] == 48) {
            HD63450.dmaErrorExit(n, 1);
            return;
        }
        HD63450.dmaMemoryCarry[n] = -1;
        HD63450.dmaDeviceCarry[n] = -1;
        HD63450.dmaRequestTime[n] = XEiJ.mpuClockTime;
        HD63450.dmaACT[n] = 8;
        if (dmaCHAIN[n] == 8) {
            if (dmaBTC[n] == 0) {
                HD63450.dmaErrorExit(n, 15);
                return;
            }
            if ((dmaBAR[n] & 1) != 0) {
                HD63450.dmaErrorExit(n, 7);
                return;
            }
            try {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.dmaWaitTime : XEiJ.dmaNoWaitTime;
                MemoryMappedDevice[] memoryMappedDeviceArray = dmaBFCMap[n];
                int n2 = dmaBAR[n];
                HD63450.dmaMAR[n] = memoryMappedDeviceArray[n2 >>> 12].mmdRws(n2) << 16 | memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRwz(n2 + 2);
                HD63450.dmaMTC[n] = memoryMappedDeviceArray[n2 + 4 >>> 12].mmdRwz(n2 + 4);
                int n3 = n;
                dmaBAR[n3] = dmaBAR[n3] + 6;
                XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 3L;
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
            }
            catch (M68kException m68kException) {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
                HD63450.dmaErrorExit(n, 11);
                return;
            }
            int n4 = n;
            dmaBTC[n4] = dmaBTC[n4] - 1;
        } else if (dmaCHAIN[n] == 12) {
            if ((dmaBAR[n] & 1) != 0) {
                HD63450.dmaErrorExit(n, 7);
                return;
            }
            try {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.dmaWaitTime : XEiJ.dmaNoWaitTime;
                MemoryMappedDevice[] memoryMappedDeviceArray = dmaBFCMap[n];
                int n5 = dmaBAR[n];
                HD63450.dmaMAR[n] = memoryMappedDeviceArray[n5 >>> 12].mmdRws(n5) << 16 | memoryMappedDeviceArray[n5 + 2 >>> 12].mmdRwz(n5 + 2);
                HD63450.dmaMTC[n] = memoryMappedDeviceArray[n5 + 4 >>> 12].mmdRwz(n5 + 4);
                HD63450.dmaBAR[n] = memoryMappedDeviceArray[n5 + 6 >>> 12].mmdRws(n5 + 6) << 16 | memoryMappedDeviceArray[n5 + 8 >>> 12].mmdRwz(n5 + 8);
                XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 5L;
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
            }
            catch (M68kException m68kException) {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
                HD63450.dmaErrorExit(n, 11);
                return;
            }
        }
        if (dmaMTC[n] == 0) {
            HD63450.dmaErrorExit(n, 13);
            return;
        }
        int n6 = dmaDPS[n] == 0 ? (dmaSIZE[n] == 0 ? ((dmaMAR[n] & 1) == 0 && dmaMACValue[n] == 0 ? 6 : ((dmaMAR[n] & 1) != 0 && dmaMACValue[n] == 0 ? 8 : (dmaDIR[n] == 0 ? 8 : 10))) : (dmaSIZE[n] == 16 || dmaSIZE[n] == 32 ? (dmaDIR[n] == 0 ? 4 : 0) : 0)) : (dmaSIZE[n] == 0 ? 4 + ((dmaMAR[n] & 1) != 0 && dmaMACValue[n] == 0 ? 1 : 0) + ((dmaDAR[n] & 1) != 0 && dmaDACValue[n] == 0 ? 1 : 0) : (HD63450.dmaAdditionalCycles[n] = 0));
        if (SUK.sukOn && n == 1 && dmaDAR[n] == (SUK.sukExpansion ? 0xEA0000 : 15294496) + 21 && dmaDIR[n] == 128) {
            SUK.sukDregDMACStart();
            return;
        }
        if (dmaREQG[n] == 0) {
            dmaBurstStart = XEiJ.mpuClockTime;
            dmaBurstEnd = dmaBurstStart + dmaBurstSpan;
            HD63450.dmaTransfer(n);
        } else if (dmaREQG[n] != 2 || dmaPCT[n] != 0) {
            HD63450.dmaTransfer(n);
        }
    }

    public static void dmaContinue(int n) {
        if (dmaREQG[n] == 0) {
            if (XEiJ.mpuClockTime < dmaBurstEnd) {
                HD63450.dmaInnerClock[n] = dmaRequestTime[n];
                TickerQueue.tkqAdd(dmaTickerArray[n], dmaInnerClock[n]);
            } else {
                if ((dmaBurstStart += dmaBurstInterval) < XEiJ.mpuClockTime) {
                    dmaBurstStart = XEiJ.mpuClockTime + dmaBurstInterval;
                }
                dmaBurstEnd = dmaBurstStart + dmaBurstSpan;
                HD63450.dmaInnerClock[n] = dmaBurstStart;
                TickerQueue.tkqAdd(dmaTickerArray[n], dmaInnerClock[n]);
            }
        } else if (dmaREQG[n] == 1) {
            HD63450.dmaInnerClock[n] = dmaRequestTime[n];
            TickerQueue.tkqAdd(dmaTickerArray[n], dmaInnerClock[n]);
        }
    }

    public static void dmaHalt(int n, int n2) {
        if ((~dmaHLT[n] & n2) != 0) {
            if (dmaACT[n] == 0) {
                HD63450.dmaErrorExit(n, 2);
                return;
            }
            HD63450.dmaHLT[n] = 32;
            HD63450.dmaRequestTime[n] = Long.MAX_VALUE;
            if (dmaInnerClock[n] != Long.MAX_VALUE) {
                HD63450.dmaInnerClock[n] = Long.MAX_VALUE;
                TickerQueue.tkqRemove(dmaTickerArray[n]);
            }
        } else if ((dmaHLT[n] & ~n2) != 0) {
            HD63450.dmaHLT[n] = 0;
            if (dmaACT[n] == 0) {
                return;
            }
            HD63450.dmaRequestTime[n] = XEiJ.mpuClockTime;
            if (dmaREQG[n] == 0) {
                dmaBurstStart = XEiJ.mpuClockTime;
                dmaBurstEnd = dmaBurstStart + dmaBurstSpan;
            }
            HD63450.dmaContinue(n);
        }
    }

    public static void dmaComplete(int n) {
        HD63450.dmaRequestTime[n] = Long.MAX_VALUE;
        HD63450.dmaCOC[n] = 128;
        HD63450.dmaERR[n] = 0;
        HD63450.dmaACT[n] = 0;
        HD63450.dmaSTR[n] = 0;
        HD63450.dmaCNT[n] = 0;
        HD63450.dmaSAB[n] = 0;
        HD63450.dmaErrorCode[n] = 0;
        if (dmaITE[n] != 0) {
            int n2 = n << 1;
            dmaInnerRequest[n2] = dmaInnerRequest[n2] + 1;
            XEiJ.mpuIRR |= 0x10;
        }
        if (dmaInnerClock[n] != Long.MAX_VALUE) {
            HD63450.dmaInnerClock[n] = Long.MAX_VALUE;
            TickerQueue.tkqRemove(dmaTickerArray[n]);
        }
    }

    public static void dmaErrorExit(int n, int n2) {
        HD63450.dmaRequestTime[n] = Long.MAX_VALUE;
        HD63450.dmaCOC[n] = 128;
        HD63450.dmaERR[n] = 16;
        HD63450.dmaACT[n] = 0;
        HD63450.dmaSTR[n] = 0;
        HD63450.dmaCNT[n] = 0;
        HD63450.dmaHLT[n] = 0;
        HD63450.dmaSAB[n] = 0;
        HD63450.dmaErrorCode[n] = n2;
        if (dmaITE[n] != 0) {
            int n3 = n << 1 | 1;
            dmaInnerRequest[n3] = dmaInnerRequest[n3] + 1;
            XEiJ.mpuIRR |= 0x10;
        }
        if (dmaInnerClock[n] != Long.MAX_VALUE) {
            HD63450.dmaInnerClock[n] = Long.MAX_VALUE;
            TickerQueue.tkqRemove(dmaTickerArray[n]);
        }
    }

    public static void dmaFallPCL(int n) {
        HD63450.dmaPCS[n] = 0;
        HD63450.dmaPCT[n] = 2;
        if (dmaACT[n] != 0 && (dmaREQG[n] & 2) != 0) {
            HD63450.dmaInnerClock[n] = XEiJ.mpuClockTime + XEiJ.dmaCycleUnit * 1L;
            TickerQueue.tkqAdd(dmaTickerArray[n], dmaInnerClock[n]);
        }
    }

    public static void dmaRisePCL(int n) {
        HD63450.dmaPCS[n] = 1;
        HD63450.dmaPCT[n] = 0;
        HD63450.dmaInnerClock[n] = Long.MAX_VALUE;
        TickerQueue.tkqRemove(dmaTickerArray[n]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dmaTransfer(int n) {
        int n2;
        MemoryMappedDevice[] memoryMappedDeviceArray;
        if (dmaHLT[n] != 0) {
            return;
        }
        int n3 = 0;
        try {
            XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.dmaWaitTime : XEiJ.dmaNoWaitTime;
            switch (dmaSIZE[n]) {
                case 0: {
                    if (dmaDIR[n] == 0) {
                        n3 = 9;
                        memoryMappedDeviceArray = dmaMFCMap[n];
                        n2 = dmaMAR[n];
                        int n4 = dmaMACValue[n];
                        int n5 = dmaMemoryCarry[n];
                        if (0 <= n5) {
                            HD63450.dmaMemoryCarry[n] = -1;
                        } else if ((n2 & 1) == 0 && n4 == 1 && 2 <= dmaMTC[n]) {
                            n5 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                            HD63450.dmaMemoryCarry[n] = n5 & 0xFF;
                            n5 >>= 8;
                        } else if ((n2 & 1) != 0 && n4 == -1 && 2 <= dmaMTC[n]) {
                            n5 = memoryMappedDeviceArray[n2 - 1 >>> 12].mmdRwz(n2 - 1);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                            HD63450.dmaMemoryCarry[n] = n5 >> 8;
                            n5 &= 0xFF;
                        } else {
                            n5 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                        }
                        HD63450.dmaMAR[n] = n2 + n4;
                        n3 = 10;
                        memoryMappedDeviceArray = dmaDFCMap[n];
                        n2 = dmaDAR[n];
                        n4 = dmaDACValue[n];
                        int n6 = dmaDeviceCarry[n];
                        if (0 <= n6) {
                            if ((n2 & 1) != 0) {
                                n5 = n6 << 8 | n5;
                                memoryMappedDeviceArray[n2 - 1 >>> 12].mmdWw(n2 - 1, n5);
                            } else {
                                n5 = n5 << 8 | n6;
                                memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n5);
                            }
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                            HD63450.dmaDeviceCarry[n] = -1;
                        } else if (((n2 & 1) == 0 ? n4 == 1 : n4 == -1) && 2 <= dmaMTC[n]) {
                            HD63450.dmaDeviceCarry[n] = n5;
                        } else {
                            memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n5);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                        }
                        HD63450.dmaDAR[n] = n2 + n4;
                        break;
                    }
                    n3 = 10;
                    memoryMappedDeviceArray = dmaDFCMap[n];
                    n2 = dmaDAR[n];
                    int n7 = dmaDACValue[n];
                    int n8 = dmaDeviceCarry[n];
                    if (0 <= n8) {
                        HD63450.dmaDeviceCarry[n] = -1;
                    } else if ((n2 & 1) == 0 && n7 == 1 && 2 <= dmaMTC[n]) {
                        n8 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                        HD63450.dmaDeviceCarry[n] = n8 & 0xFF;
                        n8 >>= 8;
                    } else if ((n2 & 1) != 0 && n7 == -1 && 2 <= dmaMTC[n]) {
                        n8 = memoryMappedDeviceArray[n2 - 1 >>> 12].mmdRwz(n2 - 1);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                        HD63450.dmaDeviceCarry[n] = n8 >> 8;
                        n8 &= 0xFF;
                    } else {
                        n8 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                    }
                    HD63450.dmaDAR[n] = n2 + n7;
                    n3 = 9;
                    memoryMappedDeviceArray = dmaMFCMap[n];
                    n2 = dmaMAR[n];
                    n7 = dmaMACValue[n];
                    int n9 = dmaMemoryCarry[n];
                    if (0 <= n9) {
                        if ((n2 & 1) != 0) {
                            n8 = n9 << 8 | n8;
                            memoryMappedDeviceArray[n2 - 1 >>> 12].mmdWw(n2 - 1, n8);
                        } else {
                            n8 = n8 << 8 | n9;
                            memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n8);
                        }
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                        HD63450.dmaMemoryCarry[n] = -1;
                    } else if (((n2 & 1) == 0 ? n7 == 1 : n7 == -1) && 2 <= dmaMTC[n]) {
                        HD63450.dmaMemoryCarry[n] = n8;
                    } else {
                        memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n8);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                    }
                    HD63450.dmaMAR[n] = n2 + n7;
                    break;
                }
                case 16: {
                    int n10;
                    if (dmaDIR[n] == 0) {
                        n3 = 9;
                        memoryMappedDeviceArray = dmaMFCMap[n];
                        n2 = dmaMAR[n];
                        int n11 = dmaMACValue[n];
                        if ((n2 & 1) != 0) {
                            HD63450.dmaErrorExit(n, 5);
                            return;
                        }
                        int n12 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                        HD63450.dmaMAR[n] = n2 + n11 * 2;
                        n3 = 10;
                        memoryMappedDeviceArray = dmaDFCMap[n];
                        n2 = dmaDAR[n];
                        n11 = dmaDACValue[n];
                        if (dmaDPS[n] == 0) {
                            memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n12 >> 8);
                            memoryMappedDeviceArray[n2 + 2 >>> 12].mmdWb(n2 + 2, n12);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles * 2L;
                        } else {
                            if ((n2 & 1) != 0) {
                                HD63450.dmaErrorExit(n, 6);
                                return;
                            }
                            memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n12);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                        }
                        HD63450.dmaDAR[n] = n2 + n11 * 2;
                        break;
                    }
                    n3 = 10;
                    memoryMappedDeviceArray = dmaDFCMap[n];
                    n2 = dmaDAR[n];
                    int n13 = dmaDACValue[n];
                    if (dmaDPS[n] == 0) {
                        n10 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2) << 8;
                        n10 |= memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRbz(n2 + 2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 2L;
                    } else {
                        if ((n2 & 1) != 0) {
                            HD63450.dmaErrorExit(n, 6);
                            return;
                        }
                        n10 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                    }
                    HD63450.dmaDAR[n] = n2 + n13 * 2;
                    n3 = 9;
                    memoryMappedDeviceArray = dmaMFCMap[n];
                    n2 = dmaMAR[n];
                    n13 = dmaMACValue[n];
                    if ((n2 & 1) != 0) {
                        HD63450.dmaErrorExit(n, 5);
                        return;
                    }
                    memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n10);
                    XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                    HD63450.dmaMAR[n] = n2 + n13 * 2;
                    break;
                }
                case 32: {
                    int n14;
                    if (dmaDIR[n] == 0) {
                        n3 = 9;
                        memoryMappedDeviceArray = dmaMFCMap[n];
                        n2 = dmaMAR[n];
                        int n15 = dmaMACValue[n];
                        if ((n2 & 1) != 0) {
                            HD63450.dmaErrorExit(n, 5);
                            return;
                        }
                        int n16 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2) << 16;
                        n16 |= memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRwz(n2 + 2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 2L;
                        HD63450.dmaMAR[n] = n2 + n15 * 4;
                        n3 = 10;
                        memoryMappedDeviceArray = dmaDFCMap[n];
                        n2 = dmaDAR[n];
                        n15 = dmaDACValue[n];
                        if (dmaDPS[n] == 0) {
                            memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n16 >> 24);
                            memoryMappedDeviceArray[n2 + 2 >>> 12].mmdWb(n2 + 2, n16 >> 16);
                            memoryMappedDeviceArray[n2 + 4 >>> 12].mmdWb(n2 + 4, n16 >> 8);
                            memoryMappedDeviceArray[n2 + 6 >>> 12].mmdWb(n2 + 6, n16);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles * 4L;
                        } else {
                            if ((n2 & 1) != 0) {
                                HD63450.dmaErrorExit(n, 6);
                                return;
                            }
                            memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n16 >> 16);
                            memoryMappedDeviceArray[n2 + 2 >>> 12].mmdWw(n2 + 2, n16);
                            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles * 2L;
                        }
                        HD63450.dmaDAR[n] = n2 + n15 * 4;
                        break;
                    }
                    n3 = 10;
                    memoryMappedDeviceArray = dmaDFCMap[n];
                    n2 = dmaDAR[n];
                    int n17 = dmaDACValue[n];
                    if (dmaDPS[n] == 0) {
                        n14 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2) << 24;
                        n14 |= memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRbz(n2 + 2) << 16;
                        n14 |= memoryMappedDeviceArray[n2 + 4 >>> 12].mmdRbz(n2 + 4) << 8;
                        n14 |= memoryMappedDeviceArray[n2 + 6 >>> 12].mmdRbz(n2 + 6);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 4L;
                    } else {
                        if ((n2 & 1) != 0) {
                            HD63450.dmaErrorExit(n, 6);
                            return;
                        }
                        n14 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2) << 16;
                        n14 |= memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRwz(n2 + 2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 2L;
                    }
                    HD63450.dmaDAR[n] = n2 + n17 * 4;
                    n3 = 9;
                    memoryMappedDeviceArray = dmaMFCMap[n];
                    n2 = dmaMAR[n];
                    n17 = dmaMACValue[n];
                    if ((n2 & 1) != 0) {
                        HD63450.dmaErrorExit(n, 5);
                        return;
                    }
                    memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n14 >> 16);
                    memoryMappedDeviceArray[n2 + 2 >>> 12].mmdWw(n2 + 2, n14);
                    XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles * 2L;
                    HD63450.dmaMAR[n] = n2 + n17 * 4;
                    break;
                }
                case 48: {
                    if (dmaDIR[n] == 0) {
                        n3 = 9;
                        memoryMappedDeviceArray = dmaMFCMap[n];
                        n2 = dmaMAR[n];
                        int n18 = dmaMACValue[n];
                        int n19 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                        HD63450.dmaMAR[n] = n2 + n18;
                        n3 = 10;
                        memoryMappedDeviceArray = dmaDFCMap[n];
                        n2 = dmaDAR[n];
                        n18 = dmaDACValue[n];
                        memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n19);
                        XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                        HD63450.dmaDAR[n] = n2 + n18;
                        break;
                    }
                    n3 = 10;
                    memoryMappedDeviceArray = dmaDFCMap[n];
                    n2 = dmaDAR[n];
                    int n20 = dmaDACValue[n];
                    int n21 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2);
                    XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles;
                    HD63450.dmaDAR[n] = n2 + n20;
                    n3 = 9;
                    memoryMappedDeviceArray = dmaMFCMap[n];
                    n2 = dmaMAR[n];
                    n20 = dmaMACValue[n];
                    memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n21);
                    XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaWriteCycles;
                    HD63450.dmaMAR[n] = n2 + n20;
                }
            }
            XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaAdditionalCycles[n];
            XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
        }
        catch (M68kException m68kException) {
            XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
            HD63450.dmaErrorExit(n, n3);
            return;
        }
        int n22 = n;
        dmaMTC[n22] = dmaMTC[n22] - 1;
        if (dmaMTC[n] != 0) {
            HD63450.dmaContinue(n);
            return;
        }
        if (dmaCHAIN[n] == 8) {
            if (dmaBTC[n] == 0) {
                HD63450.dmaBLC[n] = 64;
                HD63450.dmaNDT[n] = 0;
                HD63450.dmaComplete(n);
                return;
            }
            try {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.dmaWaitTime : XEiJ.dmaNoWaitTime;
                memoryMappedDeviceArray = dmaBFCMap[n];
                n2 = dmaBAR[n];
                HD63450.dmaMAR[n] = memoryMappedDeviceArray[n2 >>> 12].mmdRws(n2) << 16 | memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRwz(n2 + 2);
                HD63450.dmaMTC[n] = memoryMappedDeviceArray[n2 + 4 >>> 12].mmdRwz(n2 + 4);
                int n23 = n;
                dmaBAR[n23] = dmaBAR[n23] + 6;
                XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 3L;
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
            }
            catch (M68kException m68kException) {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
                HD63450.dmaErrorExit(n, 11);
                return;
            }
            int n24 = n;
            dmaBTC[n24] = dmaBTC[n24] - 1;
            if (dmaMTC[n] == 0) {
                HD63450.dmaErrorExit(n, 13);
                return;
            }
            if ((dmaSIZE[n] == 16 || dmaSIZE[n] == 32) && (dmaMAR[n] & 1) != 0) {
                HD63450.dmaErrorExit(n, 5);
                return;
            }
            HD63450.dmaContinue(n);
            return;
        }
        if (dmaCHAIN[n] == 12) {
            if (dmaBAR[n] == 0) {
                HD63450.dmaBLC[n] = 64;
                HD63450.dmaNDT[n] = 0;
                HD63450.dmaComplete(n);
                return;
            }
            if ((dmaBAR[n] & 1) != 0) {
                HD63450.dmaErrorExit(n, 7);
                return;
            }
            try {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.dmaWaitTime : XEiJ.dmaNoWaitTime;
                memoryMappedDeviceArray = dmaBFCMap[n];
                n2 = dmaBAR[n];
                HD63450.dmaMAR[n] = memoryMappedDeviceArray[n2 >>> 12].mmdRws(n2) << 16 | memoryMappedDeviceArray[n2 + 2 >>> 12].mmdRwz(n2 + 2);
                HD63450.dmaMTC[n] = memoryMappedDeviceArray[n2 + 4 >>> 12].mmdRwz(n2 + 4);
                HD63450.dmaBAR[n] = memoryMappedDeviceArray[n2 + 6 >>> 12].mmdRws(n2 + 6) << 16 | memoryMappedDeviceArray[n2 + 8 >>> 12].mmdRwz(n2 + 8);
                XEiJ.mpuClockTime += XEiJ.dmaCycleUnit * (long)dmaReadCycles * 5L;
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
            }
            catch (M68kException m68kException) {
                XEiJ.busWaitTime = XEiJ.busWaitCycles ? XEiJ.mpuWaitTime : XEiJ.mpuNoWaitTime;
                HD63450.dmaErrorExit(n, 11);
                return;
            }
            if (dmaMTC[n] == 0) {
                HD63450.dmaErrorExit(n, 13);
                return;
            }
            if ((dmaSIZE[n] == 16 || dmaSIZE[n] == 32) && (dmaMAR[n] & 1) != 0) {
                HD63450.dmaErrorExit(n, 5);
                return;
            }
            HD63450.dmaContinue(n);
            return;
        }
        if (dmaCNT[n] == 0) {
            HD63450.dmaBLC[n] = 0;
            HD63450.dmaNDT[n] = 0;
            HD63450.dmaComplete(n);
            return;
        }
        HD63450.dmaBLC[n] = 64;
        HD63450.dmaCNT[n] = 0;
        if (dmaITE[n] != 0) {
            int n25 = n << 1;
            dmaInnerRequest[n25] = dmaInnerRequest[n25] + 1;
            XEiJ.mpuIRR |= 0x10;
        }
        HD63450.dmaMTC[n] = dmaBTC[n];
        HD63450.dmaMAR[n] = dmaBAR[n];
        if (dmaMTC[n] == 0) {
            HD63450.dmaErrorExit(n, 13);
            return;
        }
        if ((dmaSIZE[n] == 16 || dmaSIZE[n] == 32) && (dmaMAR[n] & 1) != 0) {
            HD63450.dmaErrorExit(n, 5);
            return;
        }
        HD63450.dmaContinue(n);
    }

    public static int dmaReadByte(int n) {
        int n2;
        int n3 = n & 0xFF;
        if (n3 == 255) {
            n2 = dmaBT | dmaBR;
        } else {
            int n4 = n3 >> 6;
            switch (n3 & 0x3F) {
                case 0: {
                    n2 = dmaCOC[n4] | dmaBLC[n4] | dmaNDT[n4] | dmaERR[n4] | dmaACT[n4] | dmaDIT[n4] | dmaPCT[n4] | dmaPCS[n4];
                    break;
                }
                case 1: {
                    n2 = dmaErrorCode[n4];
                    break;
                }
                case 4: {
                    n2 = dmaXRM[n4] | dmaDTYP[n4] | dmaDPS[n4] | dmaPCL[n4];
                    break;
                }
                case 5: {
                    n2 = dmaDIR[n4] | dmaBTD[n4] | dmaSIZE[n4] | dmaCHAIN[n4] | dmaREQG[n4];
                    break;
                }
                case 6: {
                    n2 = dmaMAC[n4] | dmaDAC[n4];
                    break;
                }
                case 7: {
                    n2 = dmaSTR[n4] | dmaCNT[n4] | dmaHLT[n4] | dmaSAB[n4] | dmaITE[n4];
                    break;
                }
                case 10: {
                    n2 = dmaMTC[n4] >> 8;
                    break;
                }
                case 11: {
                    n2 = dmaMTC[n4] & 0xFF;
                    break;
                }
                case 12: {
                    n2 = dmaMAR[n4] >>> 24;
                    break;
                }
                case 13: {
                    n2 = dmaMAR[n4] >> 16 & 0xFF;
                    break;
                }
                case 14: {
                    n2 = (char)dmaMAR[n4] >> 8;
                    break;
                }
                case 15: {
                    n2 = dmaMAR[n4] & 0xFF;
                    break;
                }
                case 20: {
                    n2 = dmaDAR[n4] >>> 24;
                    break;
                }
                case 21: {
                    n2 = dmaDAR[n4] >> 16 & 0xFF;
                    break;
                }
                case 22: {
                    n2 = (char)dmaDAR[n4] >> 8;
                    break;
                }
                case 23: {
                    n2 = dmaDAR[n4] & 0xFF;
                    break;
                }
                case 26: {
                    n2 = dmaBTC[n4] >> 8;
                    break;
                }
                case 27: {
                    n2 = dmaBTC[n4] & 0xFF;
                    break;
                }
                case 28: {
                    n2 = dmaBAR[n4] >>> 24;
                    break;
                }
                case 29: {
                    n2 = dmaBAR[n4] >> 16 & 0xFF;
                    break;
                }
                case 30: {
                    n2 = (char)dmaBAR[n4] >> 8;
                    break;
                }
                case 31: {
                    n2 = dmaBAR[n4] & 0xFF;
                    break;
                }
                case 37: {
                    n2 = dmaNIV[n4];
                    break;
                }
                case 39: {
                    n2 = dmaEIV[n4];
                    break;
                }
                case 41: {
                    n2 = dmaMFC[n4];
                    break;
                }
                case 45: {
                    n2 = dmaCP[n4];
                    break;
                }
                case 49: {
                    n2 = dmaDFC[n4];
                    break;
                }
                case 57: {
                    n2 = dmaBFC[n4];
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public static int dmaReadWord(int n) {
        int n2 = n & 0xFF;
        int n3 = n2 >> 6;
        return switch (n2 & 0x3F) {
            case 10 -> dmaMTC[n3];
            case 12 -> dmaMAR[n3] >>> 16;
            case 14 -> (char)dmaMAR[n3];
            case 20 -> dmaDAR[n3] >>> 16;
            case 22 -> (char)dmaDAR[n3];
            case 26 -> dmaBTC[n3];
            case 28 -> dmaBAR[n3] >>> 16;
            case 30 -> (char)dmaBAR[n3];
            default -> HD63450.dmaReadByte(n) << 8 | HD63450.dmaReadByte(n + 1);
        };
    }

    public static int dmaReadLong(int n) {
        int n2 = (n &= 0xFFFFFF) & 0xFF;
        int n3 = n2 >> 6;
        return switch (n2 & 0x3F) {
            case 12 -> dmaMAR[n3];
            case 20 -> dmaDAR[n3];
            case 28 -> dmaBAR[n3];
            default -> HD63450.dmaReadWord(n) << 16 | HD63450.dmaReadWord(n + 2);
        };
    }

    public static void dmaWriteByte(int n, int n2) {
        n2 &= 0xFF;
        int n3 = n & 0xFF;
        if (n3 == 255) {
            dmaBT = n2 & 0xC;
            dmaBR = n2 & 3;
            dmaBurstSpan = XEiJ.dmaCycleUnit << 4 + (dmaBT >> 2);
            dmaBurstInterval = dmaBurstSpan << 1 + (dmaBR & 3);
            return;
        }
        int n4 = n3 >> 6;
        switch (n3 & 0x3F) {
            case 0: {
                if ((n2 & 0x80) != 0) {
                    HD63450.dmaCOC[n4] = 0;
                }
                if ((n2 & 0x40) != 0) {
                    HD63450.dmaBLC[n4] = 0;
                }
                if ((n2 & 0x20) != 0) {
                    HD63450.dmaNDT[n4] = 0;
                }
                if ((n2 & 0x10) != 0) {
                    HD63450.dmaERR[n4] = 0;
                    HD63450.dmaErrorCode[n4] = 0;
                }
                if ((n2 & 4) != 0) {
                    HD63450.dmaDIT[n4] = 0;
                }
                return;
            }
            case 1: {
                return;
            }
            case 4: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaXRM[n4] = n2 & 0xC0;
                HD63450.dmaDTYP[n4] = n2 & 0x30;
                HD63450.dmaDPS[n4] = n2 & 8;
                HD63450.dmaDACValue[n4] = (dmaDAC[n4] == 1 ? 1 : (dmaDAC[n4] == 2 ? -1 : 0)) * (dmaDPS[n4] == 0 ? 2 : 1);
                HD63450.dmaPCL[n4] = n2 & 3;
                return;
            }
            case 5: {
                HD63450.dmaDIR[n4] = n2 & 0x80;
                HD63450.dmaBTD[n4] = n2 & 0x40;
                HD63450.dmaSIZE[n4] = n2 & 0x30;
                HD63450.dmaCHAIN[n4] = n2 & 0xC;
                HD63450.dmaREQG[n4] = n2 & 3;
                return;
            }
            case 6: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMAC[n4] = n2 & 0xC;
                HD63450.dmaMACValue[n4] = dmaMAC[n4] == 4 ? 1 : (dmaMAC[n4] == 8 ? -1 : 0);
                HD63450.dmaDAC[n4] = n2 & 3;
                HD63450.dmaDACValue[n4] = (dmaDAC[n4] == 1 ? 1 : (dmaDAC[n4] == 2 ? -1 : 0)) * (dmaDPS[n4] == 0 ? 2 : 1);
                return;
            }
            case 7: {
                if (dmaHLT[n4] != (n2 & 0x20)) {
                    HD63450.dmaHalt(n4, n2 & 0x20);
                }
                HD63450.dmaITE[n4] = n2 & 8;
                if ((n2 & 0x40) != 0) {
                    if (dmaACT[n4] == 0 && (n2 & 0x80) == 0 || dmaBLC[n4] != 0) {
                        HD63450.dmaErrorExit(n4, 2);
                        return;
                    }
                    if (dmaCHAIN[n4] != 0) {
                        HD63450.dmaErrorExit(n4, 1);
                        return;
                    }
                    HD63450.dmaCNT[n4] = 64;
                }
                if ((n2 & 0x10) != 0) {
                    HD63450.dmaCOC[n4] = 0;
                    HD63450.dmaBLC[n4] = 0;
                    HD63450.dmaNDT[n4] = 0;
                    HD63450.dmaHLT[n4] = 0;
                    HD63450.dmaCNT[n4] = 0;
                    if (dmaACT[n4] != 0 || (n2 & 0x80) != 0) {
                        HD63450.dmaErrorExit(n4, 17);
                    }
                    return;
                }
                if ((n2 & 0x80) != 0) {
                    HD63450.dmaStart(n4);
                }
                return;
            }
            case 10: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMTC[n4] = n2 << 8 | dmaMTC[n4] & 0xFF;
                return;
            }
            case 11: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMTC[n4] = dmaMTC[n4] & 0xFFFFFF00 | n2;
                return;
            }
            case 12: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMAR[n4] = n2 << 24 | dmaMAR[n4] & 0xFFFFFF;
                return;
            }
            case 13: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMAR[n4] = n2 << 16 | dmaMAR[n4] & 0xFF00FFFF;
                return;
            }
            case 14: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMAR[n4] = dmaMAR[n4] & 0xFFFF00FF | n2 << 8;
                return;
            }
            case 15: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMAR[n4] = dmaMAR[n4] & 0xFFFFFF00 | n2;
                return;
            }
            case 20: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaDAR[n4] = n2 << 24 | dmaDAR[n4] & 0xFFFFFF;
                return;
            }
            case 21: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaDAR[n4] = n2 << 16 | dmaDAR[n4] & 0xFF00FFFF;
                return;
            }
            case 22: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaDAR[n4] = dmaDAR[n4] & 0xFFFF00FF | n2 << 8;
                return;
            }
            case 23: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaDAR[n4] = dmaDAR[n4] & 0xFFFFFF00 | n2;
                return;
            }
            case 26: {
                HD63450.dmaBTC[n4] = n2 << 8 | dmaBTC[n4] & 0xFF;
                return;
            }
            case 27: {
                HD63450.dmaBTC[n4] = dmaBTC[n4] & 0xFFFFFF00 | n2;
                return;
            }
            case 28: {
                HD63450.dmaBAR[n4] = n2 << 24 | dmaBAR[n4] & 0xFFFFFF;
                return;
            }
            case 29: {
                HD63450.dmaBAR[n4] = n2 << 16 | dmaBAR[n4] & 0xFF00FFFF;
                return;
            }
            case 30: {
                HD63450.dmaBAR[n4] = dmaBAR[n4] & 0xFFFF00FF | n2 << 8;
                return;
            }
            case 31: {
                HD63450.dmaBAR[n4] = dmaBAR[n4] & 0xFFFFFF00 | n2;
                return;
            }
            case 37: {
                HD63450.dmaNIV[n4] = n2;
                return;
            }
            case 39: {
                HD63450.dmaEIV[n4] = n2;
                return;
            }
            case 41: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaMFC[n4] = n2 & 4;
                HD63450.dmaMFCMap[n4] = dmaMFC[n4] == 0 ? DataBreakPoint.dbpUserMap : DataBreakPoint.dbpSuperMap;
                return;
            }
            case 45: {
                HD63450.dmaCP[n4] = n2 & 3;
                return;
            }
            case 49: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                    return;
                }
                HD63450.dmaDFC[n4] = n2 & 4;
                HD63450.dmaDFCMap[n4] = dmaDFC[n4] == 0 ? DataBreakPoint.dbpUserMap : DataBreakPoint.dbpSuperMap;
                return;
            }
            case 57: {
                HD63450.dmaBFC[n4] = n2 & 4;
                HD63450.dmaBFCMap[n4] = dmaBFC[n4] == 0 ? DataBreakPoint.dbpUserMap : DataBreakPoint.dbpSuperMap;
                return;
            }
        }
    }

    public static void dmaWriteWord(int n, int n2) {
        n2 = (char)n2;
        int n3 = n & 0xFF;
        int n4 = n3 >> 6;
        switch (n3 & 0x3F) {
            case 10: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaMTC[n4] = n2;
                }
                return;
            }
            case 12: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaMAR[n4] = n2 << 16 | (char)dmaMAR[n4];
                }
                return;
            }
            case 14: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaMAR[n4] = dmaMAR[n4] & 0xFFFF0000 | n2;
                }
                return;
            }
            case 20: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaDAR[n4] = n2 << 16 | (char)dmaDAR[n4];
                }
                return;
            }
            case 22: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaDAR[n4] = dmaDAR[n4] & 0xFFFF0000 | n2;
                }
                return;
            }
            case 26: {
                HD63450.dmaBTC[n4] = (char)n2;
                return;
            }
            case 28: {
                HD63450.dmaBAR[n4] = n2 << 16 | (char)dmaBAR[n4];
                return;
            }
            case 30: {
                HD63450.dmaBAR[n4] = dmaBAR[n4] & 0xFFFF0000 | n2;
                return;
            }
        }
        HD63450.dmaWriteByte(n, n2 >> 8);
        HD63450.dmaWriteByte(n + 1, n2);
    }

    public static void dmaWriteLong(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = n3 >> 6;
        switch (n3 & 0x3F) {
            case 12: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaMAR[n4] = n2;
                    if ((n2 & 0xFF000000) != 0 && 3 <= XEiJ.currentMPU) {
                        System.out.printf("%08x DMA_MAR[%d]=%08X\n", XEiJ.regPC0, n4, n2);
                    }
                }
                return;
            }
            case 20: {
                if (dmaACT[n4] != 0) {
                    HD63450.dmaErrorExit(n4, 2);
                } else {
                    HD63450.dmaDAR[n4] = n2;
                    if ((n2 & 0xFF000000) != 0 && 3 <= XEiJ.currentMPU) {
                        System.out.printf("%08x DMA_DAR[%d]=%08X\n", XEiJ.regPC0, n4, n2);
                    }
                }
                return;
            }
            case 28: {
                HD63450.dmaBAR[n4] = n2;
                if ((n2 & 0xFF000000) != 0 && 3 <= XEiJ.currentMPU) {
                    System.out.printf("%08x DMA_BAR[%d]=%08X\n", XEiJ.regPC0, n4, n2);
                }
                return;
            }
        }
        HD63450.dmaWriteWord(n, n2 >> 16);
        HD63450.dmaWriteWord(n + 2, n2);
    }

    static {
        dmaRequestTime = new long[4];
        dmaInnerRequest = new int[8];
        dmaInnerAcknowleged = new int[8];
        dmaInnerClock = new long[4];
        dmaMemoryCarry = new int[4];
        dmaDeviceCarry = new int[4];
        dmaAdditionalCycles = new int[4];
        dmaTickerArray = new TickerQueue.Ticker[]{new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                HD63450.dmaTransfer(0);
            }
        }, new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                HD63450.dmaTransfer(1);
            }
        }, new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                HD63450.dmaTransfer(2);
            }
        }, new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                HD63450.dmaTransfer(3);
            }
        }};
    }
}

