/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ByteArray;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.Multilingual;
import xeij.SPC;
import xeij.Settings;
import xeij.XEiJ;

public class HostCDROM {
    public static final boolean HCD_ENABLED = true;
    static final int HCD_DEFAULT_SCSI_ID = 6;
    static final int HCD_DEFAULT_VOLUME = 25;
    static final int HCD_PLAY_QUEUE_SIZE = 4;
    static final int HCD_PLAY_SECTORS = 30;
    static final int HCD_PLAY_MILLIS = 400;
    static final int HCD_PLAY_BYTES = 70560;
    static final int ERROR_NOT_READY = 21;
    static final int ERROR_WRONG_DISK = 34;
    static final int ERROR_NO_MORE_ITEMS = 259;
    static final long INVALID_HANDLE_VALUE = -1L;
    static final int GENERIC_ALL = 0x10000000;
    static final int GENERIC_EXECUTE = 0x20000000;
    static final int GENERIC_WRITE = 0x40000000;
    static final int GENERIC_READ = Integer.MIN_VALUE;
    static final int FILE_SHARE_READ = 1;
    static final int FILE_SHARE_WRITE = 2;
    static final int FILE_SHARE_DELETE = 4;
    static final int CREATE_NEW = 1;
    static final int CREATE_ALWAYS = 2;
    static final int OPEN_EXISTING = 3;
    static final int OPEN_ALWAYS = 4;
    static final int TRUNCATE_EXISTING = 5;
    static final int FILE_BEGIN = 0;
    static final int FILE_CURRENT = 1;
    static final int FILE_END = 2;
    static final int DRIVE_UNKNOWN = 0;
    static final int DRIVE_NO_ROOT_DIR = 1;
    static final int DRIVE_REMOVABLE = 2;
    static final int DRIVE_FIXED = 3;
    static final int DRIVE_REMOTE = 4;
    static final int DRIVE_CDROM = 5;
    static final int DRIVE_RAMDISK = 6;
    static final int IOCTL_CDROM_READ_TOC = 147456;
    static final int IOCTL_CDROM_RAW_READ = 147518;
    static final int IOCTL_CDROM_READ_TOC_EX = 147540;
    static final int IOCTL_SCSI_PASS_THROUGH_DIRECT = 315412;
    static final int IOCTL_SCSI_PASS_THROUGH_DIRECT_EX = 315464;
    static final int IOCTL_STORAGE_CHECK_VERIFY2 = 2951168;
    static final int IOCTL_STORAGE_LOAD_MEDIA2 = 2951180;
    static final int IOCTL_STORAGE_QUERY_PROPERTY = 2954240;
    static final int IOCTL_STORAGE_CHECK_VERIFY = 2967552;
    static final int IOCTL_STORAGE_MEDIA_REMOVAL = 2967556;
    static final int IOCTL_STORAGE_EJECT_MEDIA = 2967560;
    static final int IOCTL_STORAGE_LOAD_MEDIA = 2967564;
    static final int CDROM_READ_TOC_EX_FORMAT_TOC = 0;
    static final int MAXIMUM_NUMBER_TRACKS = 100;
    static final int YellowMode2 = 0;
    static final int XAForm2 = 1;
    static final int CDDA = 2;
    static final int RawWithC2AndSubCode = 3;
    static final int RawWithC2 = 4;
    static final int RawWithSubCode = 5;
    static final int StorageDeviceProperty = 0;
    static final int PropertyStandardQuery = 0;
    static final int BusTypeUnknown = 0;
    static final int BusTypeScsi = 1;
    static final int BusTypeAtapi = 2;
    static final int BusTypeAta = 3;
    static final int BusType1394 = 4;
    static final int BusTypeSsa = 5;
    static final int BusTypeFibre = 6;
    static final int BusTypeUsb = 7;
    static final int BusTypeRAID = 8;
    static final int BusTypeiScsi = 9;
    static final int BusTypeSas = 10;
    static final int BusTypeSata = 11;
    static final int BusTypeSd = 12;
    static final int BusTypeMmc = 13;
    static final int BusTypeVirtual = 14;
    static final int BusTypeFileBackedVirtual = 15;
    static final int BusTypeSpaces = 16;
    static final int BusTypeNvme = 17;
    static final int BusTypeSCM = 18;
    static final int BusTypeUfs = 19;
    static final int BusTypeNvmeof = 20;
    static final int BusTypeMax = 21;
    static final int BusTypeMaxReserved = 127;
    static boolean hcdAvailable;
    static boolean hcdDebugInfo;
    static boolean hcdConnectNext;
    static boolean hcdConnected;
    static int hcdSCSIIdNext;
    public static int hcdSCSIId;
    static int hcdVolumeInt;
    static float hcdVolumeFloat;
    static JSpinner hcdIdSpinner;
    static SpinnerNumberModel hcdIdModel;
    static JLabel hcdVolumeLabel;
    static JSlider hcdVolumeSlider;
    public static JMenu hcdMenu;
    static MemoryLayout TRACK_DATA;
    static MemoryLayout CDROM_TOC;
    static MemoryLayout CDROM_READ_TOC_EX;
    static MemoryLayout RAW_READ_INFO;
    static MemoryLayout STORAGE_DEVICE_DESCRIPTOR;
    static MemoryLayout STORAGE_PROPERTY_QUERY;
    static Linker linker;
    static Arena arena;
    static MethodHandle CloseHandle;
    static MethodHandle CreateFileA;
    static MethodHandle DeviceIoControl;
    static MethodHandle GetDiskFreeSpaceA;
    static MethodHandle GetDriveTypeA;
    static MethodHandle GetLastError;
    static MethodHandle GetLogicalDrives;
    static MethodHandle QueryDosDeviceA;
    static MethodHandle ReadFile;
    static MethodHandle SetFilePointerEx;
    static int hcdDriveLetter;
    static String hcdRootPath;
    static String hcdDevicePath;
    public static String hcdDeviceName;
    static byte[] hcdVendorProduct;
    static volatile boolean hcdRunning;
    static volatile boolean hcdPlaying;
    static volatile boolean hcdPausing;
    static volatile int hcdAudioStatus;
    static MemorySegment hcdReadTocEx;
    static MemorySegment hcdToc;
    static MemorySegment hcdBytesReturned;
    static MemorySegment hcdBufferSegment;
    static MemorySegment hcdReadInfo;
    static MemorySegment hcdHandle;
    static SourceDataLine hcdSourceDataLine;
    static byte[][] hcdPlayQueueArray;
    static volatile int hcdPlayQueueWrite;
    static volatile int hcdPlayQueueRead;
    static Thread hcdReadThread;
    static volatile int hcdStartSector;
    static volatile int hcdCurrentSector;
    static volatile int hcdEndSector;
    static int[] hcdTOCAddressArray;
    static int hcdTOCFirstTrack;
    static int hcdTOCLastTrack;
    static int hcdDataOffset;
    static Thread hcdPlayThread;
    static volatile int hcdRequested;
    static volatile int hcdCompleted;
    static volatile int hcdRetrieved;
    static volatile SPC.SCUnit hcdUnit;
    static volatile SPC.SPCChip hcdChip;
    static volatile byte[] hcdResultBuffer;
    static volatile int hcdResultLength;
    static volatile int hcdResultSense0;
    static volatile int hcdResultSense2;
    static volatile int hcdResultStatus;
    static volatile int hcdResultMessage;
    static volatile int hcdBytesPerSector;

    static MethodHandle downcallHandle(MemorySegment memorySegment, FunctionDescriptor functionDescriptor) {
        return linker.downcallHandle(memorySegment, functionDescriptor, new Linker.Option[0]);
    }

    public static void hcdInit() {
        block29: {
            hcdAvailable = XEiJ.prgIsWindows;
            hcdDebugInfo = Settings.sgsGetOnOff("hcddebug");
            hcdConnected = hcdConnectNext = Settings.sgsGetOnOff("hcdconnect");
            hcdSCSIIdNext = Settings.sgsGetInt("hcdscsiid", 6);
            if (hcdSCSIIdNext < 0 || 15 < hcdSCSIIdNext) {
                hcdSCSIIdNext = 6;
            }
            hcdSCSIId = hcdSCSIIdNext;
            hcdVolumeInt = Settings.sgsGetInt("hcdvolume", 25);
            if (hcdVolumeInt < 0 || 100 < hcdVolumeInt) {
                hcdVolumeInt = 25;
            }
            if (hcdDebugInfo) {
                System.out.printf("volume=%d\n", hcdVolumeInt);
            }
            hcdVolumeFloat = (float)hcdVolumeInt / 100.0f;
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    Object object = actionEvent.getSource();
                    switch (string = actionEvent.getActionCommand()) {
                        case "Connect on next execution": {
                            hcdConnectNext = ((JCheckBoxMenuItem)object).isSelected();
                            break;
                        }
                        case "Debug info": {
                            hcdDebugInfo = ((JCheckBoxMenuItem)object).isSelected();
                            break;
                        }
                        default: {
                            System.out.println("unknown action command " + string);
                        }
                    }
                }
            };
            JComponent[] jComponentArray = new JComponent[6];
            jComponentArray[0] = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(hcdConnectNext, "Connect on next execution", actionListener), "ja", "\u6b21\u56de\u306e\u5b9f\u884c\u6642\u306b\u63a5\u7d9a\u3059\u308b");
            Component[] componentArray = new Component[4];
            componentArray[0] = Box.createHorizontalStrut(20);
            componentArray[1] = ComponentFactory.createLabel("SCSI ID ");
            hcdIdModel = new SpinnerNumberModel(hcdSCSIIdNext, 0, 15, 1);
            hcdIdSpinner = ComponentFactory.createNumberSpinner(hcdIdModel, 2, new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    hcdSCSIIdNext = hcdIdModel.getNumber().intValue();
                }
            });
            componentArray[2] = hcdIdSpinner;
            componentArray[3] = Box.createHorizontalGlue();
            jComponentArray[1] = ComponentFactory.createHorizontalBox(componentArray);
            Component[] componentArray2 = new Component[4];
            componentArray2[0] = Box.createHorizontalGlue();
            componentArray2[1] = Multilingual.mlnText(ComponentFactory.createLabel("Volume "), "ja", "\u97f3\u91cf ");
            hcdVolumeLabel = ComponentFactory.createLabel(String.valueOf(hcdVolumeInt));
            componentArray2[2] = hcdVolumeLabel;
            componentArray2[3] = Box.createHorizontalGlue();
            jComponentArray[2] = ComponentFactory.createHorizontalBox(componentArray2);
            Component[] componentArray3 = new Component[1];
            hcdVolumeSlider = ComponentFactory.setPreferredSize(ComponentFactory.createHorizontalSlider(0, 100, hcdVolumeInt, 10, 1, new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    hcdVolumeInt = ((JSlider)changeEvent.getSource()).getValue();
                    if (hcdDebugInfo) {
                        System.out.printf("volume=%d\n", hcdVolumeInt);
                    }
                    hcdVolumeFloat = (float)hcdVolumeInt / 100.0f;
                    hcdVolumeLabel.setText(String.valueOf(hcdVolumeInt));
                }
            }), LnF.lnfFontSize * 18, LnF.lnfFontSize * 2 + 28);
            componentArray3[0] = hcdVolumeSlider;
            jComponentArray[3] = ComponentFactory.createHorizontalBox(componentArray3);
            jComponentArray[4] = ComponentFactory.createHorizontalSeparator();
            jComponentArray[5] = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(hcdDebugInfo, "Debug info", actionListener), "ja", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831");
            hcdMenu = Multilingual.mlnText(ComponentFactory.createMenu("Host CD-ROM", jComponentArray), "ja", "\u30db\u30b9\u30c8 CD-ROM");
            hcdMenu.setEnabled(false);
            if (!hcdAvailable) {
                hcdConnected = false;
                return;
            }
            TRACK_DATA = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("Reserved"), ValueLayout.JAVA_BYTE.withName("Adr_Control"), ValueLayout.JAVA_BYTE.withName("TrackNumber"), ValueLayout.JAVA_BYTE.withName("Reserved1"), MemoryLayout.sequenceLayout(4L, ValueLayout.JAVA_BYTE).withName("Address"));
            CDROM_TOC = MemoryLayout.structLayout(MemoryLayout.sequenceLayout(2L, ValueLayout.JAVA_BYTE).withName("Length"), ValueLayout.JAVA_BYTE.withName("FirstTrack"), ValueLayout.JAVA_BYTE.withName("LastTrack"), MemoryLayout.sequenceLayout(100L, TRACK_DATA).withName("TrackData"));
            CDROM_READ_TOC_EX = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("Msf_Reserved1_Format"), ValueLayout.JAVA_BYTE.withName("SessionTrack"), ValueLayout.JAVA_BYTE.withName("Reserved2"), ValueLayout.JAVA_BYTE.withName("Reserved3"));
            RAW_READ_INFO = MemoryLayout.structLayout(ValueLayout.JAVA_LONG.withName("DiskOffset"), ValueLayout.JAVA_INT.withName("SectorCount"), ValueLayout.JAVA_INT.withName("TrackMode"));
            STORAGE_DEVICE_DESCRIPTOR = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("Version"), ValueLayout.JAVA_INT.withName("Size"), ValueLayout.JAVA_BYTE.withName("DeviceType"), ValueLayout.JAVA_BYTE.withName("DeviceTypeModifier"), ValueLayout.JAVA_BYTE.withName("RemovableMedia"), ValueLayout.JAVA_BYTE.withName("CommandQueueing"), ValueLayout.JAVA_INT.withName("VendorIdOffset"), ValueLayout.JAVA_INT.withName("ProductIdOffset"), ValueLayout.JAVA_INT.withName("ProductRevisionOffset"), ValueLayout.JAVA_INT.withName("SerialNumberOffset"), ValueLayout.JAVA_INT.withName("BusType"), ValueLayout.JAVA_INT.withName("RawPropertiesLength"), MemoryLayout.sequenceLayout(1L, ValueLayout.JAVA_BYTE).withName("RawDeviceProperties"), MemoryLayout.paddingLayout(3L));
            STORAGE_PROPERTY_QUERY = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("PropertyId"), ValueLayout.JAVA_INT.withName("QueryType"), MemoryLayout.sequenceLayout(1L, ValueLayout.JAVA_BYTE).withName("AdditionalParameters"), MemoryLayout.paddingLayout(3L));
            linker = Linker.nativeLinker();
            arena = Arena.ofAuto();
            SymbolLookup symbolLookup = SymbolLookup.libraryLookup("kernel32", arena);
            try {
                CloseHandle = HostCDROM.downcallHandle(symbolLookup.findOrThrow("CloseHandle"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
                CreateFileA = HostCDROM.downcallHandle(symbolLookup.findOrThrow("CreateFileA"), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
                DeviceIoControl = HostCDROM.downcallHandle(symbolLookup.findOrThrow("DeviceIoControl"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                GetDiskFreeSpaceA = HostCDROM.downcallHandle(symbolLookup.findOrThrow("GetDiskFreeSpaceA"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                GetDriveTypeA = HostCDROM.downcallHandle(symbolLookup.findOrThrow("GetDriveTypeA"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
                GetLastError = HostCDROM.downcallHandle(symbolLookup.findOrThrow("GetLastError"), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]));
                GetLogicalDrives = HostCDROM.downcallHandle(symbolLookup.findOrThrow("GetLogicalDrives"), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]));
                QueryDosDeviceA = HostCDROM.downcallHandle(symbolLookup.findOrThrow("QueryDosDeviceA"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
                ReadFile = HostCDROM.downcallHandle(symbolLookup.findOrThrow("ReadFile"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                SetFilePointerEx = HostCDROM.downcallHandle(symbolLookup.findOrThrow("SetFilePointerEx"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
            }
            catch (NoSuchElementException noSuchElementException) {
                if (hcdDebugInfo) {
                    noSuchElementException.printStackTrace();
                }
                hcdAvailable = false;
                hcdConnected = false;
                return;
            }
            hcdDriveLetter = 0;
            hcdRootPath = null;
            hcdDevicePath = null;
            hcdDeviceName = null;
            try {
                MemorySegment memorySegment;
                Object object;
                int n;
                int n2 = 0;
                n2 = GetLogicalDrives.invoke();
                if (n2 == 0 && (n = GetLastError.invoke()) != -1) {
                    if (hcdDebugInfo) {
                        System.out.printf("GetLogicalDrives returned error %d\n", n);
                    }
                    hcdAvailable = false;
                    hcdConnected = false;
                    return;
                }
                for (int i = 65; i <= 90; ++i) {
                    if ((n2 & 1 << i - 65) == 0 || GetDriveTypeA.invoke(arena.allocateFrom((String)(object = String.format("%c:\\", i)))) != 5) continue;
                    hcdDriveLetter = i;
                    hcdRootPath = object;
                    break;
                }
                if (hcdDriveLetter == 0) {
                    if (hcdDebugInfo) {
                        System.out.println("CD-ROM drive not found");
                    }
                    hcdAvailable = false;
                    hcdConnected = false;
                    return;
                }
                hcdDevicePath = String.format("\\\\.\\%c:", hcdDriveLetter);
                hcdDeviceName = String.format("%c:", hcdDriveLetter);
                if (hcdDebugInfo) {
                    System.out.printf("CD-ROM drive is %s\n", hcdDeviceName);
                }
                if ((memorySegment = CreateFileA.invoke(arena.allocateFrom(hcdDevicePath), 0, 3, MemorySegment.NULL, 3, 0, MemorySegment.NULL)).address() == -1L && (n = GetLastError.invoke()) != -1) {
                    if (hcdDebugInfo) {
                        System.out.printf("CreateFileA returned error %d\n", n);
                    }
                } else {
                    object = arena.allocate(STORAGE_PROPERTY_QUERY);
                    MemorySegment memorySegment2 = arena.allocate(1024L);
                    MemorySegment memorySegment3 = arena.allocate(ValueLayout.JAVA_INT);
                    object.set(ValueLayout.JAVA_INT, STORAGE_PROPERTY_QUERY.byteOffset(MemoryLayout.PathElement.groupElement("PropertyId")), 0);
                    object.set(ValueLayout.JAVA_INT, STORAGE_PROPERTY_QUERY.byteOffset(MemoryLayout.PathElement.groupElement("QueryType")), 0);
                    if (DeviceIoControl.invoke(memorySegment, 2954240, (MemorySegment)object, (int)object.byteSize(), memorySegment2, (int)memorySegment2.byteSize(), memorySegment3, MemorySegment.NULL) == 0 && (n = GetLastError.invoke()) != -1) {
                        if (hcdDebugInfo) {
                            System.out.printf("DeviceIoControl IOCTL_STORAGE_QUERY_PROPERTY returned error %d\n", n);
                        }
                    } else {
                        int n3;
                        hcdVendorProduct = new byte[28];
                        Arrays.fill(hcdVendorProduct, (byte)32);
                        for (n3 = 0; n3 < 3; ++n3) {
                            int n4;
                            int n5;
                            int n6 = memorySegment2.get(ValueLayout.JAVA_INT, STORAGE_DEVICE_DESCRIPTOR.byteOffset(MemoryLayout.PathElement.groupElement(n3 == 0 ? "VendorIdOffset" : (n3 == 1 ? "ProductIdOffset" : "ProductRevisionOffset"))));
                            if (n6 == 0) continue;
                            int n7 = n3 == 0 ? 0 : (n5 = n3 == 1 ? 8 : 24);
                            int n8 = n3 == 0 ? 8 : (n3 == 1 ? 16 : 4);
                            for (int i = 0; i < n8 && (n4 = 0xFF & memorySegment2.get(ValueLayout.JAVA_BYTE, (long)n6++)) != 0; ++i) {
                                HostCDROM.hcdVendorProduct[n5++] = (byte)(32 <= n4 && n4 <= 126 ? n4 : 63);
                            }
                        }
                        if (hcdDebugInfo) {
                            System.out.print("VendorProduct is ");
                            for (n3 = 0; n3 < 28; ++n3) {
                                System.out.printf("%c", 0xFF & hcdVendorProduct[n3]);
                            }
                            System.out.println();
                            n3 = memorySegment2.get(ValueLayout.JAVA_INT, STORAGE_DEVICE_DESCRIPTOR.byteOffset(MemoryLayout.PathElement.groupElement("BusType")));
                            System.out.printf("BusType is %s\n", n3 == 0 ? "BusTypeUnknown" : (n3 == 1 ? "BusTypeScsi" : (n3 == 2 ? "BusTypeAtapi" : (n3 == 3 ? "BusTypeAta" : (n3 == 4 ? "BusType1394" : (n3 == 5 ? "BusTypeSsa" : (n3 == 6 ? "BusTypeFibre" : (n3 == 7 ? "BusTypeUsb" : (n3 == 8 ? "BusTypeRAID" : (n3 == 9 ? "BusTypeiScsi" : (n3 == 10 ? "BusTypeSas" : (n3 == 11 ? "BusTypeSata" : (n3 == 12 ? "BusTypeSd" : (n3 == 13 ? "BusTypeMmc" : (n3 == 14 ? "BusTypeVirtual" : (n3 == 15 ? "BusTypeFileBackedVirtual" : (n3 == 16 ? "BusTypeSpaces" : (n3 == 17 ? "BusTypeNvme" : (n3 == 18 ? "BusTypeSCM" : (n3 == 19 ? "BusTypeUfs" : (n3 == 20 ? "BusTypeNvmeof" : (n3 == 21 ? "BusTypeMax" : (n3 == 127 ? "BusTypeMaxReserved" : String.valueOf(n3))))))))))))))))))))))));
                        }
                    }
                    CloseHandle.invoke(memorySegment);
                }
            }
            catch (Throwable throwable) {
                if (hcdDebugInfo) {
                    throwable.printStackTrace();
                }
                hcdAvailable = false;
                hcdConnected = false;
                return;
            }
            hcdMenu.setEnabled(true);
            hcdRunning = true;
            hcdReadTocEx = arena.allocate(CDROM_READ_TOC_EX);
            hcdToc = arena.allocate(CDROM_TOC);
            hcdBytesReturned = arena.allocate(ValueLayout.JAVA_INT);
            hcdBufferSegment = arena.allocate(70560L);
            hcdReadInfo = arena.allocate(RAW_READ_INFO);
            hcdHandle = null;
            hcdSourceDataLine = null;
            try {
                AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 2, true, false);
                hcdSourceDataLine = AudioSystem.getSourceDataLine(audioFormat);
                hcdSourceDataLine.open(audioFormat, 141120);
                hcdSourceDataLine.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (!hcdDebugInfo) break block29;
                lineUnavailableException.printStackTrace();
            }
        }
        hcdPlayQueueArray = new byte[4][];
        for (int i = 0; i < 4; ++i) {
            HostCDROM.hcdPlayQueueArray[i] = new byte[70560];
        }
        hcdPlayQueueWrite = 0;
        hcdPlayQueueRead = 0;
        hcdReadThread = new Thread(() -> {
            while (hcdRunning) {
                int n;
                if (hcdCompleted != hcdRequested) {
                    HostCDROM.hcdCommandComplete_2nd();
                    hcdCompleted = hcdRequested;
                    continue;
                }
                if (hcdHandle == null || !hcdPlaying || hcdPausing || hcdEndSector <= hcdCurrentSector || hcdPlayQueueWrite - hcdPlayQueueRead == 4) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                byte[] byArray = hcdPlayQueueArray[hcdPlayQueueWrite & 3];
                int n2 = Math.min(30, hcdEndSector - hcdCurrentSector);
                hcdReadInfo.set(ValueLayout.JAVA_LONG, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("DiskOffset")), 2048L * (long)hcdCurrentSector);
                hcdReadInfo.set(ValueLayout.JAVA_INT, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("SectorCount")), n2);
                hcdReadInfo.set(ValueLayout.JAVA_INT, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("TrackMode")), 2);
                try {
                    if (DeviceIoControl.invoke(hcdHandle, 147518, hcdReadInfo, (int)hcdReadInfo.byteSize(), hcdBufferSegment, 2352 * n2, hcdBytesReturned, MemorySegment.NULL) == 0 && (n = GetLastError.invoke()) != -1) {
                        if (hcdDebugInfo) {
                            System.out.printf("DeviceIoControl IOCTL_CDROM_RAW_READ returned error %d\n", n);
                        }
                        hcdPlaying = false;
                        hcdAudioStatus = 20;
                        Arrays.fill(byArray, (byte)0);
                    }
                }
                catch (Throwable throwable) {
                    if (hcdDebugInfo) {
                        throwable.printStackTrace();
                    }
                    hcdPlaying = false;
                    hcdAudioStatus = 20;
                    Arrays.fill(byArray, (byte)0);
                }
                for (n = 0; n < 588 * n2; ++n) {
                    int n3 = hcdBufferSegment.get(ValueLayout.JAVA_BYTE, (long)(4 * n + 1)) << 8 | 0xFF & hcdBufferSegment.get(ValueLayout.JAVA_BYTE, (long)(4 * n + 0));
                    int n4 = hcdBufferSegment.get(ValueLayout.JAVA_BYTE, (long)(4 * n + 3)) << 8 | 0xFF & hcdBufferSegment.get(ValueLayout.JAVA_BYTE, (long)(4 * n + 2));
                    n3 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, Math.round((float)n3 * hcdVolumeFloat)));
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, Math.round((float)n4 * hcdVolumeFloat)));
                    byArray[4 * n + 0] = (byte)n3;
                    byArray[4 * n + 1] = (byte)(n3 >> 8);
                    byArray[4 * n + 2] = (byte)n4;
                    byArray[4 * n + 3] = (byte)(n4 >> 8);
                }
                if (n2 < 30) {
                    Arrays.fill(byArray, 2352 * n2, 70560, (byte)0);
                }
                hcdCurrentSector += n2;
                ++hcdPlayQueueWrite;
            }
        });
        hcdReadThread.start();
        hcdPlayThread = new Thread(() -> {
            while (hcdRunning) {
                if (!hcdPlaying || hcdPausing || hcdCurrentSector - hcdStartSector < 240 && hcdPlayQueueRead == hcdPlayQueueWrite) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (hcdPlayQueueRead == hcdPlayQueueWrite) {
                    hcdPlaying = false;
                    hcdAudioStatus = 20;
                    continue;
                }
                if (hcdSourceDataLine == null) {
                    ++hcdPlayQueueRead;
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                hcdSourceDataLine.write(hcdPlayQueueArray[hcdPlayQueueRead & 3], 0, 70560);
                ++hcdPlayQueueRead;
                if (hcdEndSector > hcdCurrentSector) continue;
                hcdPlaying = false;
                hcdAudioStatus = 19;
            }
        });
        hcdPlayThread.start();
    }

    public static void hcdTini() {
        hcdRunning = false;
        if (hcdReadThread != null) {
            hcdReadThread.interrupt();
            try {
                hcdReadThread.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            hcdReadThread = null;
        }
        if (hcdPlayThread != null) {
            hcdPlayThread.interrupt();
            try {
                hcdPlayThread.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            hcdPlayThread = null;
        }
        if (hcdSourceDataLine != null) {
            hcdSourceDataLine.stop();
            hcdSourceDataLine.close();
            hcdSourceDataLine = null;
        }
        Settings.sgsPutOnOff("hcddebug", hcdDebugInfo);
        Settings.sgsPutOnOff("hcdconnect", hcdConnectNext);
        Settings.sgsPutInt("hcdscsiid", hcdSCSIIdNext);
        Settings.sgsPutInt("hcdvolume", hcdVolumeInt);
    }

    public static void hcdReset() {
        if (hcdConnected) {
            hcdRequested = 0;
            hcdCompleted = 0;
            hcdRetrieved = 0;
            hcdTOCAddressArray = null;
            hcdDataOffset = -1;
            hcdUnit = null;
            hcdChip = null;
            hcdResultBuffer = null;
            hcdResultLength = 0;
            hcdResultSense0 = 0;
            hcdResultSense2 = 0;
            hcdResultStatus = 0;
            hcdResultMessage = 0;
            hcdBytesPerSector = 2048;
            hcdPlaying = false;
            hcdPausing = false;
            hcdAudioStatus = 21;
        }
    }

    static boolean hcdOpen() {
        if (hcdHandle != null) {
            return true;
        }
        if (hcdRootPath == null) {
            return false;
        }
        try {
            int n;
            MemorySegment memorySegment = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment2 = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment3 = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment4 = arena.allocate(ValueLayout.JAVA_INT);
            if (GetDiskFreeSpaceA.invoke(arena.allocateFrom(hcdRootPath), memorySegment, memorySegment2, memorySegment3, memorySegment4) == 0 && (n = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("GetDiskFreeSpaceA returned error %d\n", n);
                }
                return false;
            }
            if (hcdDebugInfo) {
                System.out.printf("sectorsPerCluster=%d\n", memorySegment.get(ValueLayout.JAVA_INT, 0L));
                System.out.printf("bytesPerSector=%d\n", memorySegment2.get(ValueLayout.JAVA_INT, 0L));
                System.out.printf("numberOfFreeClusters=%d\n", memorySegment3.get(ValueLayout.JAVA_INT, 0L));
                System.out.printf("totalNumberOfClusters=%d\n", memorySegment4.get(ValueLayout.JAVA_INT, 0L));
            }
            if ((hcdHandle = CreateFileA.invoke(arena.allocateFrom(hcdDevicePath), Integer.MIN_VALUE, 3, MemorySegment.NULL, 3, 0, MemorySegment.NULL)).address() == -1L && (n = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("CreateFileA returned error %d\n", n);
                }
                hcdHandle = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            if (hcdDebugInfo) {
                throwable.printStackTrace();
            }
            hcdHandle = null;
            return false;
        }
        return true;
    }

    static void hcdClose() {
        block3: {
            if (hcdHandle == null) {
                return;
            }
            try {
                CloseHandle.invoke(hcdHandle);
            }
            catch (Throwable throwable) {
                if (!hcdDebugInfo) break block3;
                throwable.printStackTrace();
            }
        }
        hcdHandle = null;
        hcdTOCAddressArray = null;
        hcdDataOffset = -1;
    }

    static byte[] hcdReadTOC(boolean bl) {
        if (!HostCDROM.hcdOpen()) {
            return null;
        }
        try {
            int n;
            hcdReadTocEx.set(ValueLayout.JAVA_BYTE, CDROM_READ_TOC_EX.byteOffset(MemoryLayout.PathElement.groupElement("Msf_Reserved1_Format")), (byte)((bl ? 1 : 0) << 7 | 0 | 0));
            hcdReadTocEx.set(ValueLayout.JAVA_BYTE, CDROM_READ_TOC_EX.byteOffset(MemoryLayout.PathElement.groupElement("SessionTrack")), (byte)1);
            hcdReadTocEx.set(ValueLayout.JAVA_BYTE, CDROM_READ_TOC_EX.byteOffset(MemoryLayout.PathElement.groupElement("Reserved2")), (byte)0);
            hcdReadTocEx.set(ValueLayout.JAVA_BYTE, CDROM_READ_TOC_EX.byteOffset(MemoryLayout.PathElement.groupElement("Reserved3")), (byte)0);
            if (DeviceIoControl.invoke(hcdHandle, 147540, hcdReadTocEx, (int)hcdReadTocEx.byteSize(), hcdToc, (int)hcdToc.byteSize(), hcdBytesReturned, MemorySegment.NULL) == 0 && (n = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("DeviceIoControl IOCTL_CDROM_READ_TOC_EX returned error %d\n", n);
                }
                HostCDROM.hcdClose();
                return n == 0 || n == 21 || n == 34 ? null : new byte[]{};
            }
            int n2 = 0xFF & hcdToc.get(ValueLayout.JAVA_BYTE, CDROM_TOC.byteOffset(MemoryLayout.PathElement.groupElement("Length"), MemoryLayout.PathElement.sequenceElement(0L)));
            int n3 = 0xFF & hcdToc.get(ValueLayout.JAVA_BYTE, CDROM_TOC.byteOffset(MemoryLayout.PathElement.groupElement("Length"), MemoryLayout.PathElement.sequenceElement(1L)));
            int n4 = 256 * n2 + n3;
            byte[] byArray = new byte[2 + n4];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = hcdToc.get(ValueLayout.JAVA_BYTE, (long)i);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (hcdDebugInfo) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    static void hcdPlay(int n, int n2) {
        if (!hcdPlaying && !HostCDROM.hcdOpen()) {
            return;
        }
        hcdPlayQueueRead = hcdPlayQueueWrite;
        hcdStartSector = n;
        hcdCurrentSector = n;
        hcdEndSector = n2;
        hcdPlaying = true;
        hcdPausing = false;
        hcdAudioStatus = 17;
    }

    static void hcdPause() {
        if (!hcdPlaying) {
            return;
        }
        hcdPausing = true;
        hcdAudioStatus = 18;
    }

    static void hcdResume() {
        if (!hcdPlaying) {
            return;
        }
        hcdStartSector = hcdCurrentSector;
        hcdPausing = false;
        hcdAudioStatus = 17;
    }

    static void hcdSetBytesPerSector(int n) {
        if (n == 2048 || n == 2336 || n == 2352) {
            hcdBytesPerSector = n;
            if (hcdDebugInfo) {
                System.out.printf("bytesPerSector=%d\n", n);
            }
        }
    }

    static byte[] hcdRead(int n, int n2) {
        if (hcdDebugInfo) {
            System.out.printf("hcdRead(%d,%d)\n", n, n2);
        }
        if (!HostCDROM.hcdOpen()) {
            return null;
        }
        byte[] byArray = new byte[hcdBytesPerSector * n2];
        try {
            int n3;
            int n4;
            if (hcdBytesPerSector == 2048 && SetFilePointerEx.invoke(hcdHandle, 2048L * (long)n, MemorySegment.NULL, 0) == 0 && (n4 = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("SetFilePointerEx returned error %d\n", n4);
                }
                HostCDROM.hcdClose();
                return n4 == 0 || n4 == 21 || n4 == 34 ? null : new byte[]{};
            }
            for (int i = 0; i < n2; i += n3) {
                n3 = Math.min(30, n2 - i);
                if (hcdBytesPerSector == 2048) {
                    if (ReadFile.invoke(hcdHandle, hcdBufferSegment, 2048 * n3, hcdBytesReturned, MemorySegment.NULL) == 0 && (n4 = GetLastError.invoke()) != -1) {
                        if (hcdDebugInfo) {
                            System.out.printf("ReadFile returned error %d\n", n4);
                        }
                        HostCDROM.hcdClose();
                        return n4 == 0 || n4 == 21 || n4 == 34 ? null : new byte[]{};
                    }
                } else {
                    hcdReadInfo.set(ValueLayout.JAVA_LONG, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("DiskOffset")), 2048L * (long)(n + i));
                    hcdReadInfo.set(ValueLayout.JAVA_INT, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("SectorCount")), n3);
                    hcdReadInfo.set(ValueLayout.JAVA_INT, RAW_READ_INFO.byteOffset(MemoryLayout.PathElement.groupElement("TrackMode")), hcdBytesPerSector == 2336 ? 0 : 2);
                    if (DeviceIoControl.invoke(hcdHandle, 147518, hcdReadInfo, (int)hcdReadInfo.byteSize(), hcdBufferSegment, hcdBytesPerSector * n3, hcdBytesReturned, MemorySegment.NULL) == 0 && (n4 = GetLastError.invoke()) != -1) {
                        if (hcdDebugInfo) {
                            System.out.printf("DeviceIoControl IOCTL_CDROM_RAW_READ returned error %d\n", n4);
                        }
                        HostCDROM.hcdClose();
                        return n4 == 0 || n4 == 21 || n4 == 34 ? null : new byte[]{};
                    }
                }
                for (int j = 0; j < hcdBytesPerSector * n3; ++j) {
                    byArray[HostCDROM.hcdBytesPerSector * i + j] = hcdBufferSegment.get(ValueLayout.JAVA_BYTE, (long)j);
                }
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (hcdDebugInfo) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    static byte[] hcdReadCapacity() {
        if (!HostCDROM.hcdOpen()) {
            return null;
        }
        try {
            int n;
            MemorySegment memorySegment = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment2 = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment3 = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment memorySegment4 = arena.allocate(ValueLayout.JAVA_INT);
            if (GetDiskFreeSpaceA.invoke(arena.allocateFrom(hcdRootPath), memorySegment, memorySegment2, memorySegment3, memorySegment4) == 0 && (n = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("GetDiskFreeSpaceA returned error %d\n", n);
                }
                HostCDROM.hcdClose();
                return n == 0 || n == 21 || n == 34 ? null : new byte[]{};
            }
            byte[] byArray = new byte[8];
            ByteArray.byaWl(byArray, 0, memorySegment.get(ValueLayout.JAVA_INT, 0L) * memorySegment4.get(ValueLayout.JAVA_INT, 0L) - 1);
            ByteArray.byaWl(byArray, 4, memorySegment2.get(ValueLayout.JAVA_INT, 0L));
            return byArray;
        }
        catch (Throwable throwable) {
            if (hcdDebugInfo) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    static void hcdEject() {
        block5: {
            HostCDROM.hcdClose();
            try {
                int n;
                MemorySegment memorySegment = CreateFileA.invoke(arena.allocateFrom(hcdDevicePath), 0, 3, MemorySegment.NULL, 3, 0, MemorySegment.NULL);
                if (memorySegment.address() == -1L && (n = GetLastError.invoke()) != -1) {
                    if (hcdDebugInfo) {
                        System.out.printf("CreateFileA returned error %d\n", n);
                    }
                    return;
                }
                MemorySegment memorySegment2 = arena.allocate(ValueLayout.JAVA_INT);
                if (DeviceIoControl.invoke(memorySegment, 2967560, MemorySegment.NULL, 0, MemorySegment.NULL, 0, memorySegment2, MemorySegment.NULL) == 0 && (n = GetLastError.invoke()) != -1 && hcdDebugInfo) {
                    System.out.printf("DeviceIoControl IOCTL_STORAGE_EJECT_MEDIA returned error %d\n", n);
                }
                CloseHandle.invoke(memorySegment);
            }
            catch (Throwable throwable) {
                if (!hcdDebugInfo) break block5;
                throwable.printStackTrace();
            }
        }
    }

    public static void hcdCommandComplete_1st(SPC.SCUnit sCUnit, int n) {
        if (hcdDebugInfo) {
            sCUnit.scuPrintCommand(n);
        }
        hcdUnit = sCUnit;
        hcdChip = sCUnit.scuChip;
        hcdResultBuffer = null;
        hcdResultLength = 0;
        hcdResultSense0 = 0;
        hcdResultSense2 = 0;
        hcdResultStatus = 0;
        hcdResultMessage = 0;
        if (n != 3 && n != 18 && HostCDROM.hcdChip.spiLUN != 0) {
            sCUnit.scuNotReady();
            return;
        }
        switch (n) {
            case 1: {
                HostCDROM.hcdDoRezeroUnit_1st();
                break;
            }
            case 3: {
                sCUnit.scuDoRequestSense();
                break;
            }
            case 18: {
                HostCDROM.hcdDoInquiry_1st();
                break;
            }
            case 26: {
                HostCDROM.hcdDoModeSense6_1st();
                break;
            }
            case 66: {
                HostCDROM.hcdDoReadSubChannel_1st();
                break;
            }
            case 69: {
                HostCDROM.hcdDoPlayAudio10_1st();
                break;
            }
            case 71: {
                HostCDROM.hcdDoPlayAudioMSF_1st();
                break;
            }
            case 75: {
                HostCDROM.hcdDoPauseResume_1st();
                break;
            }
            case 165: {
                HostCDROM.hcdDoPlayAudio12_1st();
                break;
            }
            case 21: {
                HostCDROM.hcdDoModeSelect6_1st();
                break;
            }
            case 0: 
            case 8: 
            case 27: 
            case 37: 
            case 40: 
            case 67: 
            case 216: {
                ++hcdRequested;
                if (hcdReadThread == null) break;
                hcdReadThread.interrupt();
                break;
            }
            default: {
                hcdUnit.scuDoInvalid();
            }
        }
    }

    static void hcdCommandComplete_2nd() {
        int n = HostCDROM.hcdChip.spiCommandBuffer[0] & 0xFF;
        switch (n) {
            case 0: {
                HostCDROM.hcdDoTestUnitReady_2nd();
                break;
            }
            case 8: {
                HostCDROM.hcdDoRead6_2nd();
                break;
            }
            case 27: {
                HostCDROM.hcdDoStartStopUnit_2nd();
                break;
            }
            case 37: {
                HostCDROM.hcdDoReadCapacity_2nd();
                break;
            }
            case 40: {
                HostCDROM.hcdDoRead10_2nd();
                break;
            }
            case 67: {
                HostCDROM.hcdDoReadTOC_2nd();
                break;
            }
            case 216: {
                HostCDROM.hcdDoReadCDDA_2nd();
            }
        }
    }

    static void hcdDoTestUnitReady_2nd() {
        if (!HostCDROM.hcdOpen()) {
            HostCDROM.hcdNotReady();
            return;
        }
        try {
            int n;
            MemorySegment memorySegment = arena.allocate(ValueLayout.JAVA_INT);
            if (DeviceIoControl.invoke(hcdHandle, 2967552, MemorySegment.NULL, 0, MemorySegment.NULL, 0, memorySegment, MemorySegment.NULL) == 0 && (n = GetLastError.invoke()) != -1) {
                if (hcdDebugInfo) {
                    System.out.printf("DeviceIoControl IOCTL_STORAGE_CHECK_VERIFY returned error %d\n", n);
                }
                HostCDROM.hcdNotReady();
                return;
            }
        }
        catch (Throwable throwable) {
            if (hcdDebugInfo) {
                throwable.printStackTrace();
            }
            HostCDROM.hcdNotReady();
            return;
        }
        HostCDROM.hcdGood();
    }

    static void hcdDoRezeroUnit_1st() {
        hcdRequested = 0;
        hcdCompleted = 0;
        hcdRetrieved = 0;
        hcdBytesPerSector = 2048;
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDoRead6_2nd() {
        byte[] byArray;
        if (!HostCDROM.hcdOpen()) {
            HostCDROM.hcdNotReady();
            return;
        }
        int n = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 0) & 0x1FFFFF;
        int n2 = HostCDROM.hcdChip.spiCommandBuffer[4] & 0xFF;
        if (n2 == 0) {
            n2 = 256;
        }
        if ((byArray = HostCDROM.hcdRead(n, n2)) == null) {
            HostCDROM.hcdNotReady();
            return;
        }
        if (byArray.length == 0) {
            HostCDROM.hcdMediumError();
            return;
        }
        hcdResultBuffer = byArray;
        hcdResultLength = byArray.length;
    }

    static void hcdDoInquiry_1st() {
        boolean bl;
        boolean bl2 = bl = (HostCDROM.hcdChip.spiCommandBuffer[1] & 1) != 0;
        if (bl) {
            hcdUnit.scuIllegalRequest();
            return;
        }
        int n = HostCDROM.hcdChip.spiCommandBuffer[4] & 0xFF;
        byte[] byArray = new byte[36];
        if (HostCDROM.hcdChip.spiLUN != 0) {
            byArray[0] = 127;
        } else {
            byArray[0] = 5;
            byArray[1] = -128;
            byArray[2] = 2;
            byArray[3] = 1;
            byArray[4] = 31;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 0;
            System.arraycopy(hcdVendorProduct, 0, byArray, 8, 28);
        }
        if (hcdDebugInfo) {
            HostCDROM.hcdDumpBuffer(byArray, byArray.length);
        }
        hcdChip.spiDataInPhase(byArray, 0, Math.min(n, byArray.length), 0);
    }

    static void hcdDoModeSelect6_1st() {
        int n = HostCDROM.hcdChip.spiCommandBuffer[4] & 0xFF;
        hcdChip.spiDataOutPhase(HostCDROM.hcdChip.spiDataOutBuffer, 0, n, 0);
    }

    static void hcdDoModeSense6_1st() {
        boolean bl = (HostCDROM.hcdChip.spiCommandBuffer[1] & 8) != 0;
        int n = HostCDROM.hcdChip.spiCommandBuffer[2] >> 6 & 3;
        if (n == 3) {
            hcdUnit.scuIllegalRequest();
            return;
        }
        int n2 = HostCDROM.hcdChip.spiCommandBuffer[2] & 0x3F;
        int n3 = HostCDROM.hcdChip.spiCommandBuffer[4] & 0xFF;
        if (n2 != 1 && n2 != 3 && n2 != 14 && n2 != 49 && n2 != 63) {
            hcdUnit.scuIllegalRequest();
            return;
        }
        byte[] byArray = new byte[256];
        byArray[0] = 3;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        int n4 = 4;
        if (!bl) {
            if (n == 0) {
                byArray[n4 + 6] = (byte)(hcdBytesPerSector >> 8);
                byArray[n4 + 7] = (byte)hcdBytesPerSector;
            } else if (n == 1) {
                byArray[n4 + 6] = -1;
                byArray[n4 + 7] = -1;
            } else {
                byArray[n4 + 6] = 8;
                byArray[n4 + 7] = 0;
            }
            byArray[0] = (byte)(byArray[0] + 8);
            byArray[3] = (byte)(byArray[3] + 8);
            n4 += 8;
        }
        if (n2 == 1 || n2 == 63) {
            byArray[n4 + 0] = 1;
            byArray[n4 + 1] = 6;
            if (n == 0) {
                byArray[n4 + 2] = 17;
                byArray[n4 + 3] = 0;
            } else if (n == 1) {
                byArray[n4 + 2] = 0;
                byArray[n4 + 3] = 0;
            } else {
                byArray[n4 + 2] = 17;
                byArray[n4 + 3] = 0;
            }
            byArray[0] = (byte)(byArray[0] + 8);
            n4 += 8;
        }
        if (n2 == 3 || n2 == 63) {
            byArray[n4 + 0] = 3;
            byArray[n4 + 1] = 22;
            byArray[n4 + 20] = n == 0 ? 32 : (n == 1 ? 0 : 32);
            byArray[0] = (byte)(byArray[0] + 24);
            n4 += 24;
        }
        if (n2 == 14 || n2 == 63) {
            byArray[n4 + 0] = 14;
            byArray[n4 + 1] = 14;
            if (n == 0) {
                byte by = (byte)(hcdVolumeInt * 255 / 100);
                byArray[n4 + 15] = by;
                byArray[n4 + 13] = by;
                byArray[n4 + 11] = by;
                byArray[n4 + 9] = by;
            } else if (n == 1) {
                byArray[n4 + 15] = -1;
                byArray[n4 + 13] = -1;
                byArray[n4 + 11] = -1;
                byArray[n4 + 9] = -1;
            } else {
                byArray[n4 + 15] = 63;
                byArray[n4 + 13] = 63;
                byArray[n4 + 11] = 63;
                byArray[n4 + 9] = 63;
            }
            n4 += 16;
        }
        if (n2 == 49 || n2 == 63) {
            byArray[n4 + 0] = 49;
            byArray[n4 + 1] = 2;
            byArray[n4 + 2] = n == 0 ? 24 : (n == 1 ? 0 : 24);
            byArray[0] = (byte)(byArray[0] + 4);
            n4 += 4;
        }
        if (hcdDebugInfo) {
            HostCDROM.hcdDumpBuffer(byArray, n4);
        }
        hcdChip.spiDataInPhase(byArray, 0, Math.min(n3, n4), 0);
    }

    static void hcdDoStartStopUnit_2nd() {
        int n = HostCDROM.hcdChip.spiCommandBuffer[4] & 3;
        if (n == 2) {
            HostCDROM.hcdEject();
        }
        HostCDROM.hcdGood();
    }

    static void hcdDoReadCapacity_2nd() {
        if (!HostCDROM.hcdOpen()) {
            HostCDROM.hcdNotReady();
            return;
        }
        byte[] byArray = HostCDROM.hcdReadCapacity();
        if (byArray == null) {
            HostCDROM.hcdNotReady();
            return;
        }
        if (byArray.length == 0) {
            HostCDROM.hcdMediumError();
            return;
        }
        hcdResultBuffer = byArray;
        hcdResultLength = byArray.length;
    }

    static void hcdDoRead10_2nd() {
        if (!HostCDROM.hcdOpen()) {
            HostCDROM.hcdNotReady();
            return;
        }
        int n = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 2);
        int n2 = ByteArray.byaRwz(HostCDROM.hcdChip.spiCommandBuffer, 7);
        if (n2 == 0) {
            HostCDROM.hcdGood();
            return;
        }
        byte[] byArray = HostCDROM.hcdRead(n, n2);
        if (byArray == null) {
            HostCDROM.hcdNotReady();
            return;
        }
        if (byArray.length == 0) {
            HostCDROM.hcdMediumError();
            return;
        }
        hcdResultBuffer = byArray;
        hcdResultLength = byArray.length;
    }

    static void hcdDoReadSubChannel_1st() {
        boolean bl = (HostCDROM.hcdChip.spiCommandBuffer[1] & 2) != 0;
        boolean bl2 = (HostCDROM.hcdChip.spiCommandBuffer[2] & 0x40) != 0;
        int n = HostCDROM.hcdChip.spiCommandBuffer[3] & 0xFF;
        int n2 = ByteArray.byaRwz(HostCDROM.hcdChip.spiCommandBuffer, 7);
        if (bl2 && n == 1) {
            int n3 = 0;
            int n4 = hcdTOCFirstTrack;
            int n5 = 0;
            if (hcdPlaying && hcdTOCAddressArray != null) {
                n3 = hcdCurrentSector;
                while (n4 + 1 <= hcdTOCLastTrack && hcdTOCAddressArray[n4 + 1 - hcdTOCFirstTrack] <= n3) {
                    ++n4;
                }
                n5 = n3 - hcdTOCAddressArray[n4 - hcdTOCFirstTrack];
            }
            byte[] byArray = new byte[16];
            byArray[1] = (byte)hcdAudioStatus;
            if (hcdAudioStatus == 19 || hcdAudioStatus == 20) {
                hcdAudioStatus = 21;
            }
            byArray[2] = 0;
            byArray[3] = 12;
            byArray[3] = 1;
            byArray[5] = 16;
            byArray[6] = (byte)(n4 / 10 << 4 | n4 % 10);
            byArray[7] = 1;
            if (bl) {
                int n6 = n3 + 150;
                byArray[8] = 0;
                byArray[9] = (byte)(n6 / 4500);
                byArray[10] = (byte)(n6 / 75 % 60);
                byArray[11] = (byte)(n6 % 75);
                byArray[12] = 0;
                byArray[13] = (byte)(n5 / 4500);
                byArray[14] = (byte)(n5 / 75 % 60);
                byArray[15] = (byte)(n5 % 75);
            } else {
                byArray[8] = (byte)(n3 >> 24);
                byArray[9] = (byte)(n3 >> 16);
                byArray[10] = (byte)(n3 >> 8);
                byArray[11] = (byte)n3;
                byArray[12] = (byte)(n5 >> 24);
                byArray[13] = (byte)(n5 >> 16);
                byArray[14] = (byte)(n5 >> 8);
                byArray[15] = (byte)n5;
            }
            if (hcdDebugInfo) {
                HostCDROM.hcdDumpBuffer(byArray, byArray.length);
            }
            hcdChip.spiDataInPhase(byArray, 0, Math.min(n2, byArray.length), 0);
        } else {
            HostCDROM.hcdIllegalRequest();
        }
    }

    static void hcdDoReadTOC_2nd() {
        int n;
        int n2;
        boolean bl = (HostCDROM.hcdChip.spiCommandBuffer[1] & 2) != 0;
        int n3 = HostCDROM.hcdChip.spiCommandBuffer[6] & 0xFF;
        if (n3 == 0) {
            n3 = 1;
        }
        if (170 < n3) {
            HostCDROM.hcdIllegalRequest();
            return;
        }
        int n4 = ByteArray.byaRwz(HostCDROM.hcdChip.spiCommandBuffer, 7);
        byte[] byArray = HostCDROM.hcdReadTOC(bl);
        if (byArray == null) {
            HostCDROM.hcdNotReady();
            return;
        }
        if (byArray.length == 0) {
            HostCDROM.hcdMediumError();
            return;
        }
        hcdTOCAddressArray = new int[(byArray.length - 4) / 8];
        hcdTOCFirstTrack = byArray[2] & 0xFF;
        hcdTOCLastTrack = byArray[3] & 0xFF;
        for (n2 = 0; n2 < hcdTOCAddressArray.length; ++n2) {
            HostCDROM.hcdTOCAddressArray[n2] = bl ? -150 + (byArray[4 + 8 * n2 + 5] & 0xFF) * 4500 + (byArray[4 + 8 * n2 + 6] & 0xFF) * 75 + (byArray[4 + 8 * n2 + 7] & 0xFF) : (byArray[4 + 8 * n2 + 4] & 0xFF) << 24 | (byArray[4 + 8 * n2 + 5] & 0xFF) << 16 | (byArray[4 + 8 * n2 + 6] & 0xFF) << 8 | byArray[4 + 8 * n2 + 7] & 0xFF;
        }
        n2 = byArray.length;
        for (n = 4; n < n2 - 8 && (0xFF & byArray[n + 2]) < n3; n += 8) {
        }
        if (4 < n) {
            for (int i = 0; i < n2 - n; ++i) {
                byArray[4 + i] = byArray[n + i];
            }
            ByteArray.byaWw(byArray, 0, (n2 -= n - 4) - 2);
        }
        hcdResultBuffer = byArray;
        hcdResultLength = Math.min(n2, n4);
    }

    static void hcdDoPlayAudio10_1st() {
        int n = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 2);
        int n2 = ByteArray.byaRwz(HostCDROM.hcdChip.spiCommandBuffer, 7);
        HostCDROM.hcdPlay(n, n + n2);
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDoPlayAudioMSF_1st() {
        int n = -150 + (HostCDROM.hcdChip.spiCommandBuffer[3] & 0xFF) * 4500 + (HostCDROM.hcdChip.spiCommandBuffer[4] & 0xFF) * 75 + (HostCDROM.hcdChip.spiCommandBuffer[5] & 0xFF);
        int n2 = -150 + (HostCDROM.hcdChip.spiCommandBuffer[6] & 0xFF) * 4500 + (HostCDROM.hcdChip.spiCommandBuffer[7] & 0xFF) * 75 + (HostCDROM.hcdChip.spiCommandBuffer[8] & 0xFF);
        HostCDROM.hcdPlay(n, n2);
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDoPauseResume_1st() {
        boolean bl;
        boolean bl2 = bl = (HostCDROM.hcdChip.spiCommandBuffer[8] & 1) != 0;
        if (bl) {
            HostCDROM.hcdResume();
        } else {
            HostCDROM.hcdPause();
        }
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDoPlayAudio12_1st() {
        int n = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 2);
        int n2 = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 6);
        HostCDROM.hcdPlay(n, n + n2);
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDoReadCDDA_2nd() {
        if (!HostCDROM.hcdOpen()) {
            HostCDROM.hcdNotReady();
            return;
        }
        int n = ByteArray.byaRls(HostCDROM.hcdChip.spiCommandBuffer, 2);
        int n2 = ByteArray.byaRwz(HostCDROM.hcdChip.spiCommandBuffer, 8);
        if (n2 == 0) {
            HostCDROM.hcdGood();
            return;
        }
        byte[] byArray = HostCDROM.hcdRead(n, n2);
        if (byArray == null) {
            HostCDROM.hcdNotReady();
            return;
        }
        if (byArray.length == 0) {
            HostCDROM.hcdMediumError();
            return;
        }
        hcdResultBuffer = byArray;
        hcdResultLength = byArray.length;
    }

    static void hcdGood() {
        hcdResultSense0 = 0;
        hcdResultSense2 = 0;
        hcdResultStatus = 0;
        hcdResultMessage = 0;
    }

    static void hcdNotReady() {
        hcdResultSense0 = 112;
        hcdResultSense2 = 2;
        hcdResultStatus = 2;
        hcdResultMessage = 0;
    }

    static void hcdUnitAttention() {
        hcdResultSense0 = 112;
        hcdResultSense2 = 6;
        hcdResultStatus = 2;
        hcdResultMessage = 0;
    }

    static void hcdDataProtect() {
        hcdResultSense0 = 112;
        hcdResultSense2 = 7;
        hcdResultStatus = 2;
        hcdResultMessage = 0;
    }

    static void hcdMediumError() {
        hcdResultSense0 = 112;
        hcdResultSense2 = 3;
        hcdResultStatus = 2;
        hcdResultMessage = 0;
    }

    static void hcdIllegalRequest() {
        hcdResultSense0 = 112;
        hcdResultSense2 = 5;
        hcdResultStatus = 2;
        hcdResultMessage = 0;
    }

    public static void hcdReadINTSPSNS() {
        if (hcdRetrieved != hcdCompleted) {
            if (hcdResultBuffer != null) {
                hcdChip.spiDataInPhase(hcdResultBuffer, 0, hcdResultLength, 0);
            } else {
                HostCDROM.hcdChip.spiSenseBuffer[HostCDROM.hcdChip.spiLUN][0] = (byte)hcdResultSense0;
                HostCDROM.hcdChip.spiSenseBuffer[HostCDROM.hcdChip.spiLUN][2] = (byte)hcdResultSense2;
                hcdChip.spiStatusPhase(hcdResultStatus, hcdResultMessage);
            }
            hcdChip.spiSetInterruptStatus(16);
            hcdRetrieved = hcdCompleted;
        }
    }

    public static void hcdDataOutComplete(int n) {
        switch (n) {
            case 21: {
                HostCDROM.hcdDoModeSelect6_2nd();
                break;
            }
            default: {
                hcdChip.spiStatusPhase(0, 0);
            }
        }
    }

    static void hcdDoModeSelect6_2nd() {
        int n;
        int n2 = HostCDROM.hcdChip.spiCommandBuffer[0] & 0xFF;
        if (hcdDebugInfo) {
            hcdUnit.scuPrintDataOut(n2);
        }
        if ((n = 4) + 8 <= HostCDROM.hcdChip.spiBufferLimit && (HostCDROM.hcdChip.spiDataOutBuffer[3] & 0xFF) == 8) {
            HostCDROM.hcdSetBytesPerSector((HostCDROM.hcdChip.spiDataOutBuffer[n + 6] & 0xFF) << 8 | HostCDROM.hcdChip.spiDataOutBuffer[n + 7] & 0xFF);
            n += 8;
        }
        while (n + 1 <= HostCDROM.hcdChip.spiBufferLimit) {
            int n3 = HostCDROM.hcdChip.spiDataOutBuffer[n] & 0x3F;
            if (n + 8 <= HostCDROM.hcdChip.spiBufferLimit && n3 == 1) {
                n += 8;
                continue;
            }
            if (n + 24 <= HostCDROM.hcdChip.spiBufferLimit && n3 == 3) {
                n += 24;
                continue;
            }
            if (n + 16 <= HostCDROM.hcdChip.spiBufferLimit && n3 == 14) {
                hcdVolumeInt = (HostCDROM.hcdChip.spiDataOutBuffer[n + 9] & 0xFF) * 100 / 255;
                if (hcdDebugInfo) {
                    System.out.printf("volume=%d\n", hcdVolumeInt);
                }
                hcdVolumeFloat = (float)hcdVolumeInt / 100.0f;
                hcdVolumeSlider.setValue(hcdVolumeInt);
                hcdVolumeLabel.setText(String.valueOf(hcdVolumeInt));
                n += 16;
                continue;
            }
            if (n + 4 > HostCDROM.hcdChip.spiBufferLimit || n3 != 49) break;
            n += 4;
        }
        hcdChip.spiStatusPhase(0, 0);
    }

    static void hcdDumpBuffer(byte[] byArray, int n) {
        System.out.print("[");
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                System.out.print(",");
            }
            System.out.printf("0x%02x", byArray[i] & 0xFF);
        }
        System.out.println("]");
    }
}

