/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.BranchLog;
import xeij.DataBreakPoint;
import xeij.EFPBox;
import xeij.FEFunction;
import xeij.HD63450;
import xeij.HFS;
import xeij.IOInterrupt;
import xeij.InstructionBreakPoint;
import xeij.M68kException;
import xeij.MC68901;
import xeij.MainMemory;
import xeij.MemoryMappedDevice;
import xeij.TickerQueue;
import xeij.WaitInstruction;
import xeij.XEiJ;
import xeij.Z8530;

public class MC68EC030 {
    public static final boolean M30_DIV_ZERO_V_FLAG = true;
    public static boolean m30DivZeroVFlag;
    public static final byte[] FP_OFFSET_TO_NUMBER;

    public static void mpuCore() {
        while (XEiJ.mpuClockTime < XEiJ.mpuClockLimit) {
            try {
                while (XEiJ.mpuClockTime < XEiJ.mpuClockLimit) {
                    int n;
                    XEiJ.mpuTraceFlag = XEiJ.regSRT1;
                    XEiJ.mpuCycleCount = 0;
                    XEiJ.regPC0 = n = XEiJ.regPC;
                    XEiJ.regPC = n + 2;
                    XEiJ.regOC = InstructionBreakPoint.ibpOp1MemoryMap[n >>> 12].mmdRwz(n);
                    block2 : switch (XEiJ.regOC >>> 6) {
                        case 0: {
                            MC68EC030.irpOriByte();
                            break;
                        }
                        case 1: {
                            MC68EC030.irpOriWord();
                            break;
                        }
                        case 2: {
                            MC68EC030.irpOriLong();
                            break;
                        }
                        case 3: {
                            MC68EC030.irpCmp2Chk2Byte();
                            break;
                        }
                        case 4: 
                        case 12: 
                        case 20: 
                        case 28: 
                        case 36: 
                        case 44: 
                        case 52: 
                        case 60: {
                            MC68EC030.irpBtstReg();
                            break;
                        }
                        case 5: 
                        case 13: 
                        case 21: 
                        case 29: 
                        case 37: 
                        case 45: 
                        case 53: 
                        case 61: {
                            MC68EC030.irpBchgReg();
                            break;
                        }
                        case 6: 
                        case 14: 
                        case 22: 
                        case 30: 
                        case 38: 
                        case 46: 
                        case 54: 
                        case 62: {
                            MC68EC030.irpBclrReg();
                            break;
                        }
                        case 7: 
                        case 15: 
                        case 23: 
                        case 31: 
                        case 39: 
                        case 47: 
                        case 55: 
                        case 63: {
                            MC68EC030.irpBsetReg();
                            break;
                        }
                        case 8: {
                            MC68EC030.irpAndiByte();
                            break;
                        }
                        case 9: {
                            MC68EC030.irpAndiWord();
                            break;
                        }
                        case 10: {
                            MC68EC030.irpAndiLong();
                            break;
                        }
                        case 11: {
                            MC68EC030.irpCmp2Chk2Word();
                            break;
                        }
                        case 16: {
                            MC68EC030.irpSubiByte();
                            break;
                        }
                        case 17: {
                            MC68EC030.irpSubiWord();
                            break;
                        }
                        case 18: {
                            MC68EC030.irpSubiLong();
                            break;
                        }
                        case 19: {
                            MC68EC030.irpCmp2Chk2Long();
                            break;
                        }
                        case 24: {
                            MC68EC030.irpAddiByte();
                            break;
                        }
                        case 25: {
                            MC68EC030.irpAddiWord();
                            break;
                        }
                        case 26: {
                            MC68EC030.irpAddiLong();
                            break;
                        }
                        case 32: {
                            MC68EC030.irpBtstImm();
                            break;
                        }
                        case 33: {
                            MC68EC030.irpBchgImm();
                            break;
                        }
                        case 34: {
                            MC68EC030.irpBclrImm();
                            break;
                        }
                        case 35: {
                            MC68EC030.irpBsetImm();
                            break;
                        }
                        case 40: {
                            MC68EC030.irpEoriByte();
                            break;
                        }
                        case 41: {
                            MC68EC030.irpEoriWord();
                            break;
                        }
                        case 42: {
                            MC68EC030.irpEoriLong();
                            break;
                        }
                        case 43: {
                            MC68EC030.irpCasByte();
                            break;
                        }
                        case 48: {
                            MC68EC030.irpCmpiByte();
                            break;
                        }
                        case 49: {
                            MC68EC030.irpCmpiWord();
                            break;
                        }
                        case 50: {
                            MC68EC030.irpCmpiLong();
                            break;
                        }
                        case 51: {
                            MC68EC030.irpCasWord();
                            break;
                        }
                        case 56: {
                            MC68EC030.irpMovesByte();
                            break;
                        }
                        case 57: {
                            MC68EC030.irpMovesWord();
                            break;
                        }
                        case 58: {
                            MC68EC030.irpMovesLong();
                            break;
                        }
                        case 59: {
                            MC68EC030.irpCasLong();
                            break;
                        }
                        case 64: 
                        case 72: 
                        case 80: 
                        case 88: 
                        case 96: 
                        case 104: 
                        case 112: 
                        case 120: {
                            MC68EC030.irpMoveToDRByte();
                            break;
                        }
                        case 66: 
                        case 74: 
                        case 82: 
                        case 90: 
                        case 98: 
                        case 106: 
                        case 114: 
                        case 122: {
                            MC68EC030.irpMoveToMMByte();
                            break;
                        }
                        case 67: 
                        case 75: 
                        case 83: 
                        case 91: 
                        case 99: 
                        case 107: 
                        case 115: 
                        case 123: {
                            MC68EC030.irpMoveToMPByte();
                            break;
                        }
                        case 68: 
                        case 76: 
                        case 84: 
                        case 92: 
                        case 100: 
                        case 108: 
                        case 116: 
                        case 124: {
                            MC68EC030.irpMoveToMNByte();
                            break;
                        }
                        case 69: 
                        case 77: 
                        case 85: 
                        case 93: 
                        case 101: 
                        case 109: 
                        case 117: 
                        case 125: {
                            MC68EC030.irpMoveToMWByte();
                            break;
                        }
                        case 70: 
                        case 78: 
                        case 86: 
                        case 94: 
                        case 102: 
                        case 110: 
                        case 118: 
                        case 126: {
                            MC68EC030.irpMoveToMXByte();
                            break;
                        }
                        case 71: {
                            MC68EC030.irpMoveToZWByte();
                            break;
                        }
                        case 79: {
                            MC68EC030.irpMoveToZLByte();
                            break;
                        }
                        case 128: 
                        case 136: 
                        case 144: 
                        case 152: 
                        case 160: 
                        case 168: 
                        case 176: 
                        case 184: {
                            MC68EC030.irpMoveToDRLong();
                            break;
                        }
                        case 129: 
                        case 137: 
                        case 145: 
                        case 153: 
                        case 161: 
                        case 169: 
                        case 177: 
                        case 185: {
                            MC68EC030.irpMoveaLong();
                            break;
                        }
                        case 130: 
                        case 138: 
                        case 146: 
                        case 154: 
                        case 162: 
                        case 170: 
                        case 178: 
                        case 186: {
                            MC68EC030.irpMoveToMMLong();
                            break;
                        }
                        case 131: 
                        case 139: 
                        case 147: 
                        case 155: 
                        case 163: 
                        case 171: 
                        case 179: 
                        case 187: {
                            MC68EC030.irpMoveToMPLong();
                            break;
                        }
                        case 132: 
                        case 140: 
                        case 148: 
                        case 156: 
                        case 164: 
                        case 172: 
                        case 180: 
                        case 188: {
                            MC68EC030.irpMoveToMNLong();
                            break;
                        }
                        case 133: 
                        case 141: 
                        case 149: 
                        case 157: 
                        case 165: 
                        case 173: 
                        case 181: 
                        case 189: {
                            MC68EC030.irpMoveToMWLong();
                            break;
                        }
                        case 134: 
                        case 142: 
                        case 150: 
                        case 158: 
                        case 166: 
                        case 174: 
                        case 182: 
                        case 190: {
                            MC68EC030.irpMoveToMXLong();
                            break;
                        }
                        case 135: {
                            MC68EC030.irpMoveToZWLong();
                            break;
                        }
                        case 143: {
                            MC68EC030.irpMoveToZLLong();
                            break;
                        }
                        case 192: 
                        case 200: 
                        case 208: 
                        case 216: 
                        case 224: 
                        case 232: 
                        case 240: 
                        case 248: {
                            MC68EC030.irpMoveToDRWord();
                            break;
                        }
                        case 193: 
                        case 201: 
                        case 209: 
                        case 217: 
                        case 225: 
                        case 233: 
                        case 241: 
                        case 249: {
                            MC68EC030.irpMoveaWord();
                            break;
                        }
                        case 194: 
                        case 202: 
                        case 210: 
                        case 218: 
                        case 226: 
                        case 234: 
                        case 242: 
                        case 250: {
                            MC68EC030.irpMoveToMMWord();
                            break;
                        }
                        case 195: 
                        case 203: 
                        case 211: 
                        case 219: 
                        case 227: 
                        case 235: 
                        case 243: 
                        case 251: {
                            MC68EC030.irpMoveToMPWord();
                            break;
                        }
                        case 196: 
                        case 204: 
                        case 212: 
                        case 220: 
                        case 228: 
                        case 236: 
                        case 244: 
                        case 252: {
                            MC68EC030.irpMoveToMNWord();
                            break;
                        }
                        case 197: 
                        case 205: 
                        case 213: 
                        case 221: 
                        case 229: 
                        case 237: 
                        case 245: 
                        case 253: {
                            MC68EC030.irpMoveToMWWord();
                            break;
                        }
                        case 198: 
                        case 206: 
                        case 214: 
                        case 222: 
                        case 230: 
                        case 238: 
                        case 246: 
                        case 254: {
                            MC68EC030.irpMoveToMXWord();
                            break;
                        }
                        case 199: {
                            MC68EC030.irpMoveToZWWord();
                            break;
                        }
                        case 207: {
                            MC68EC030.irpMoveToZLWord();
                            break;
                        }
                        case 256: {
                            MC68EC030.irpNegxByte();
                            break;
                        }
                        case 257: {
                            MC68EC030.irpNegxWord();
                            break;
                        }
                        case 258: {
                            MC68EC030.irpNegxLong();
                            break;
                        }
                        case 259: {
                            MC68EC030.irpMoveFromSR();
                            break;
                        }
                        case 260: 
                        case 268: 
                        case 276: 
                        case 284: 
                        case 292: 
                        case 300: 
                        case 308: 
                        case 316: {
                            MC68EC030.irpChkLong();
                            break;
                        }
                        case 262: 
                        case 270: 
                        case 278: 
                        case 286: 
                        case 294: 
                        case 302: 
                        case 310: 
                        case 318: {
                            MC68EC030.irpChkWord();
                            break;
                        }
                        case 263: 
                        case 271: 
                        case 279: 
                        case 287: 
                        case 295: 
                        case 303: 
                        case 311: 
                        case 319: {
                            MC68EC030.irpLea();
                            break;
                        }
                        case 264: {
                            MC68EC030.irpClrByte();
                            break;
                        }
                        case 265: {
                            MC68EC030.irpClrWord();
                            break;
                        }
                        case 266: {
                            MC68EC030.irpClrLong();
                            break;
                        }
                        case 267: {
                            MC68EC030.irpMoveFromCCR();
                            break;
                        }
                        case 272: {
                            MC68EC030.irpNegByte();
                            break;
                        }
                        case 273: {
                            MC68EC030.irpNegWord();
                            break;
                        }
                        case 274: {
                            MC68EC030.irpNegLong();
                            break;
                        }
                        case 275: {
                            MC68EC030.irpMoveToCCR();
                            break;
                        }
                        case 280: {
                            MC68EC030.irpNotByte();
                            break;
                        }
                        case 281: {
                            MC68EC030.irpNotWord();
                            break;
                        }
                        case 282: {
                            MC68EC030.irpNotLong();
                            break;
                        }
                        case 283: {
                            MC68EC030.irpMoveToSR();
                            break;
                        }
                        case 288: {
                            MC68EC030.irpNbcd();
                            break;
                        }
                        case 289: {
                            MC68EC030.irpPea();
                            break;
                        }
                        case 290: {
                            MC68EC030.irpMovemToMemWord();
                            break;
                        }
                        case 291: {
                            MC68EC030.irpMovemToMemLong();
                            break;
                        }
                        case 296: {
                            MC68EC030.irpTstByte();
                            break;
                        }
                        case 297: {
                            MC68EC030.irpTstWord();
                            break;
                        }
                        case 298: {
                            MC68EC030.irpTstLong();
                            break;
                        }
                        case 299: {
                            MC68EC030.irpTas();
                            break;
                        }
                        case 304: {
                            MC68EC030.irpMuluMulsLong();
                            break;
                        }
                        case 305: {
                            MC68EC030.irpDivuDivsLong();
                            break;
                        }
                        case 306: {
                            MC68EC030.irpMovemToRegWord();
                            break;
                        }
                        case 307: {
                            MC68EC030.irpMovemToRegLong();
                            break;
                        }
                        case 313: {
                            switch (XEiJ.regOC & 0x3F) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    MC68EC030.irpTrap();
                                    break block2;
                                }
                                case 15: {
                                    MC68EC030.irpTrap15();
                                    break block2;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: {
                                    MC68EC030.irpLinkWord();
                                    break block2;
                                }
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: {
                                    MC68EC030.irpUnlk();
                                    break block2;
                                }
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: {
                                    MC68EC030.irpMoveToUsp();
                                    break block2;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    MC68EC030.irpMoveFromUsp();
                                    break block2;
                                }
                                case 48: {
                                    MC68EC030.irpReset();
                                    break block2;
                                }
                                case 49: {
                                    MC68EC030.irpNop();
                                    break block2;
                                }
                                case 50: {
                                    MC68EC030.irpStop();
                                    break block2;
                                }
                                case 51: {
                                    MC68EC030.irpRte();
                                    break block2;
                                }
                                case 52: {
                                    MC68EC030.irpRtd();
                                    break block2;
                                }
                                case 53: {
                                    MC68EC030.irpRts();
                                    break block2;
                                }
                                case 54: {
                                    MC68EC030.irpTrapv();
                                    break block2;
                                }
                                case 55: {
                                    MC68EC030.irpRtr();
                                    break block2;
                                }
                                case 58: {
                                    MC68EC030.irpMovecFromControl();
                                    break block2;
                                }
                                case 59: {
                                    MC68EC030.irpMovecToControl();
                                    break block2;
                                }
                            }
                            MC68EC030.irpIllegal();
                            break;
                        }
                        case 314: {
                            MC68EC030.irpJsr();
                            break;
                        }
                        case 315: {
                            MC68EC030.irpJmp();
                            break;
                        }
                        case 320: 
                        case 328: 
                        case 336: 
                        case 344: 
                        case 352: 
                        case 360: 
                        case 368: 
                        case 376: {
                            MC68EC030.irpAddqByte();
                            break;
                        }
                        case 321: 
                        case 329: 
                        case 337: 
                        case 345: 
                        case 353: 
                        case 361: 
                        case 369: 
                        case 377: {
                            MC68EC030.irpAddqWord();
                            break;
                        }
                        case 322: 
                        case 330: 
                        case 338: 
                        case 346: 
                        case 354: 
                        case 362: 
                        case 370: 
                        case 378: {
                            MC68EC030.irpAddqLong();
                            break;
                        }
                        case 323: {
                            MC68EC030.irpSt();
                            break;
                        }
                        case 324: 
                        case 332: 
                        case 340: 
                        case 348: 
                        case 356: 
                        case 364: 
                        case 372: 
                        case 380: {
                            MC68EC030.irpSubqByte();
                            break;
                        }
                        case 325: 
                        case 333: 
                        case 341: 
                        case 349: 
                        case 357: 
                        case 365: 
                        case 373: 
                        case 381: {
                            MC68EC030.irpSubqWord();
                            break;
                        }
                        case 326: 
                        case 334: 
                        case 342: 
                        case 350: 
                        case 358: 
                        case 366: 
                        case 374: 
                        case 382: {
                            MC68EC030.irpSubqLong();
                            break;
                        }
                        case 327: {
                            MC68EC030.irpSf();
                            break;
                        }
                        case 331: {
                            MC68EC030.irpShi();
                            break;
                        }
                        case 335: {
                            MC68EC030.irpSls();
                            break;
                        }
                        case 339: {
                            MC68EC030.irpShs();
                            break;
                        }
                        case 343: {
                            MC68EC030.irpSlo();
                            break;
                        }
                        case 347: {
                            MC68EC030.irpSne();
                            break;
                        }
                        case 351: {
                            MC68EC030.irpSeq();
                            break;
                        }
                        case 355: {
                            MC68EC030.irpSvc();
                            break;
                        }
                        case 359: {
                            MC68EC030.irpSvs();
                            break;
                        }
                        case 363: {
                            MC68EC030.irpSpl();
                            break;
                        }
                        case 367: {
                            MC68EC030.irpSmi();
                            break;
                        }
                        case 371: {
                            MC68EC030.irpSge();
                            break;
                        }
                        case 375: {
                            MC68EC030.irpSlt();
                            break;
                        }
                        case 379: {
                            MC68EC030.irpSgt();
                            break;
                        }
                        case 383: {
                            MC68EC030.irpSle();
                            break;
                        }
                        case 384: {
                            MC68EC030.irpBrasw();
                            break;
                        }
                        case 385: 
                        case 386: {
                            MC68EC030.irpBras();
                            break;
                        }
                        case 387: {
                            MC68EC030.irpBrasl();
                            break;
                        }
                        case 388: {
                            MC68EC030.irpBsrsw();
                            break;
                        }
                        case 389: 
                        case 390: {
                            MC68EC030.irpBsrs();
                            break;
                        }
                        case 391: {
                            MC68EC030.irpBsrsl();
                            break;
                        }
                        case 392: {
                            MC68EC030.irpBhisw();
                            break;
                        }
                        case 393: 
                        case 394: {
                            MC68EC030.irpBhis();
                            break;
                        }
                        case 395: {
                            MC68EC030.irpBhisl();
                            break;
                        }
                        case 396: {
                            MC68EC030.irpBlssw();
                            break;
                        }
                        case 397: 
                        case 398: {
                            MC68EC030.irpBlss();
                            break;
                        }
                        case 399: {
                            MC68EC030.irpBlssl();
                            break;
                        }
                        case 400: {
                            MC68EC030.irpBhssw();
                            break;
                        }
                        case 401: 
                        case 402: {
                            MC68EC030.irpBhss();
                            break;
                        }
                        case 403: {
                            MC68EC030.irpBhssl();
                            break;
                        }
                        case 404: {
                            MC68EC030.irpBlosw();
                            break;
                        }
                        case 405: 
                        case 406: {
                            MC68EC030.irpBlos();
                            break;
                        }
                        case 407: {
                            MC68EC030.irpBlosl();
                            break;
                        }
                        case 408: {
                            MC68EC030.irpBnesw();
                            break;
                        }
                        case 409: 
                        case 410: {
                            MC68EC030.irpBnes();
                            break;
                        }
                        case 411: {
                            MC68EC030.irpBnesl();
                            break;
                        }
                        case 412: {
                            MC68EC030.irpBeqsw();
                            break;
                        }
                        case 413: 
                        case 414: {
                            MC68EC030.irpBeqs();
                            break;
                        }
                        case 415: {
                            MC68EC030.irpBeqsl();
                            break;
                        }
                        case 416: {
                            MC68EC030.irpBvcsw();
                            break;
                        }
                        case 417: 
                        case 418: {
                            MC68EC030.irpBvcs();
                            break;
                        }
                        case 419: {
                            MC68EC030.irpBvcsl();
                            break;
                        }
                        case 420: {
                            MC68EC030.irpBvssw();
                            break;
                        }
                        case 421: 
                        case 422: {
                            MC68EC030.irpBvss();
                            break;
                        }
                        case 423: {
                            MC68EC030.irpBvssl();
                            break;
                        }
                        case 424: {
                            MC68EC030.irpBplsw();
                            break;
                        }
                        case 425: 
                        case 426: {
                            MC68EC030.irpBpls();
                            break;
                        }
                        case 427: {
                            MC68EC030.irpBplsl();
                            break;
                        }
                        case 428: {
                            MC68EC030.irpBmisw();
                            break;
                        }
                        case 429: 
                        case 430: {
                            MC68EC030.irpBmis();
                            break;
                        }
                        case 431: {
                            MC68EC030.irpBmisl();
                            break;
                        }
                        case 432: {
                            MC68EC030.irpBgesw();
                            break;
                        }
                        case 433: 
                        case 434: {
                            MC68EC030.irpBges();
                            break;
                        }
                        case 435: {
                            MC68EC030.irpBgesl();
                            break;
                        }
                        case 436: {
                            MC68EC030.irpBltsw();
                            break;
                        }
                        case 437: 
                        case 438: {
                            MC68EC030.irpBlts();
                            break;
                        }
                        case 439: {
                            MC68EC030.irpBltsl();
                            break;
                        }
                        case 440: {
                            MC68EC030.irpBgtsw();
                            break;
                        }
                        case 441: 
                        case 442: {
                            MC68EC030.irpBgts();
                            break;
                        }
                        case 443: {
                            MC68EC030.irpBgtsl();
                            break;
                        }
                        case 444: {
                            MC68EC030.irpBlesw();
                            break;
                        }
                        case 445: 
                        case 446: {
                            MC68EC030.irpBles();
                            break;
                        }
                        case 447: {
                            MC68EC030.irpBlesl();
                            break;
                        }
                        case 448: 
                        case 449: 
                        case 450: 
                        case 451: 
                        case 456: 
                        case 457: 
                        case 458: 
                        case 459: 
                        case 464: 
                        case 465: 
                        case 466: 
                        case 467: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 475: 
                        case 480: 
                        case 481: 
                        case 482: 
                        case 483: 
                        case 488: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 496: 
                        case 497: 
                        case 498: 
                        case 499: 
                        case 504: 
                        case 505: 
                        case 506: 
                        case 507: {
                            MC68EC030.irpMoveq();
                            break;
                        }
                        case 452: 
                        case 460: 
                        case 468: 
                        case 476: 
                        case 484: 
                        case 492: 
                        case 500: 
                        case 508: {
                            MC68EC030.irpMvsByte();
                            break;
                        }
                        case 453: 
                        case 461: 
                        case 469: 
                        case 477: 
                        case 485: 
                        case 493: 
                        case 501: 
                        case 509: {
                            MC68EC030.irpMvsWord();
                            break;
                        }
                        case 454: 
                        case 462: 
                        case 470: 
                        case 478: 
                        case 486: 
                        case 494: 
                        case 502: 
                        case 510: {
                            MC68EC030.irpMvzByte();
                            break;
                        }
                        case 455: 
                        case 463: 
                        case 471: 
                        case 479: 
                        case 487: 
                        case 495: 
                        case 503: 
                        case 511: {
                            MC68EC030.irpMvzWord();
                            break;
                        }
                        case 512: 
                        case 520: 
                        case 528: 
                        case 536: 
                        case 544: 
                        case 552: 
                        case 560: 
                        case 568: {
                            MC68EC030.irpOrToRegByte();
                            break;
                        }
                        case 513: 
                        case 521: 
                        case 529: 
                        case 537: 
                        case 545: 
                        case 553: 
                        case 561: 
                        case 569: {
                            MC68EC030.irpOrToRegWord();
                            break;
                        }
                        case 514: 
                        case 522: 
                        case 530: 
                        case 538: 
                        case 546: 
                        case 554: 
                        case 562: 
                        case 570: {
                            MC68EC030.irpOrToRegLong();
                            break;
                        }
                        case 515: 
                        case 523: 
                        case 531: 
                        case 539: 
                        case 547: 
                        case 555: 
                        case 563: 
                        case 571: {
                            MC68EC030.irpDivuWord();
                            break;
                        }
                        case 516: 
                        case 524: 
                        case 532: 
                        case 540: 
                        case 548: 
                        case 556: 
                        case 564: 
                        case 572: {
                            MC68EC030.irpOrToMemByte();
                            break;
                        }
                        case 517: 
                        case 525: 
                        case 533: 
                        case 541: 
                        case 549: 
                        case 557: 
                        case 565: 
                        case 573: {
                            MC68EC030.irpOrToMemWord();
                            break;
                        }
                        case 518: 
                        case 526: 
                        case 534: 
                        case 542: 
                        case 550: 
                        case 558: 
                        case 566: 
                        case 574: {
                            MC68EC030.irpOrToMemLong();
                            break;
                        }
                        case 519: 
                        case 527: 
                        case 535: 
                        case 543: 
                        case 551: 
                        case 559: 
                        case 567: 
                        case 575: {
                            MC68EC030.irpDivsWord();
                            break;
                        }
                        case 576: 
                        case 584: 
                        case 592: 
                        case 600: 
                        case 608: 
                        case 616: 
                        case 624: 
                        case 632: {
                            MC68EC030.irpSubToRegByte();
                            break;
                        }
                        case 577: 
                        case 585: 
                        case 593: 
                        case 601: 
                        case 609: 
                        case 617: 
                        case 625: 
                        case 633: {
                            MC68EC030.irpSubToRegWord();
                            break;
                        }
                        case 578: 
                        case 586: 
                        case 594: 
                        case 602: 
                        case 610: 
                        case 618: 
                        case 626: 
                        case 634: {
                            MC68EC030.irpSubToRegLong();
                            break;
                        }
                        case 579: 
                        case 587: 
                        case 595: 
                        case 603: 
                        case 611: 
                        case 619: 
                        case 627: 
                        case 635: {
                            MC68EC030.irpSubaWord();
                            break;
                        }
                        case 580: 
                        case 588: 
                        case 596: 
                        case 604: 
                        case 612: 
                        case 620: 
                        case 628: 
                        case 636: {
                            MC68EC030.irpSubToMemByte();
                            break;
                        }
                        case 581: 
                        case 589: 
                        case 597: 
                        case 605: 
                        case 613: 
                        case 621: 
                        case 629: 
                        case 637: {
                            MC68EC030.irpSubToMemWord();
                            break;
                        }
                        case 582: 
                        case 590: 
                        case 598: 
                        case 606: 
                        case 614: 
                        case 622: 
                        case 630: 
                        case 638: {
                            MC68EC030.irpSubToMemLong();
                            break;
                        }
                        case 583: 
                        case 591: 
                        case 599: 
                        case 607: 
                        case 615: 
                        case 623: 
                        case 631: 
                        case 639: {
                            MC68EC030.irpSubaLong();
                            break;
                        }
                        case 640: 
                        case 641: 
                        case 642: 
                        case 643: 
                        case 644: 
                        case 645: 
                        case 646: 
                        case 647: 
                        case 648: 
                        case 649: 
                        case 650: 
                        case 651: 
                        case 652: 
                        case 653: 
                        case 654: 
                        case 655: 
                        case 656: 
                        case 657: 
                        case 658: 
                        case 659: 
                        case 660: 
                        case 661: 
                        case 662: 
                        case 663: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 667: 
                        case 668: 
                        case 669: 
                        case 670: 
                        case 671: 
                        case 672: 
                        case 673: 
                        case 674: 
                        case 675: 
                        case 676: 
                        case 677: 
                        case 678: 
                        case 679: 
                        case 680: 
                        case 681: 
                        case 682: 
                        case 683: 
                        case 684: 
                        case 685: 
                        case 686: 
                        case 687: 
                        case 688: 
                        case 689: 
                        case 690: 
                        case 691: 
                        case 692: 
                        case 693: 
                        case 694: 
                        case 695: 
                        case 696: 
                        case 697: 
                        case 698: 
                        case 699: 
                        case 700: 
                        case 701: 
                        case 702: 
                        case 703: {
                            MC68EC030.irpAline();
                            break;
                        }
                        case 704: 
                        case 712: 
                        case 720: 
                        case 728: 
                        case 736: 
                        case 744: 
                        case 752: 
                        case 760: {
                            MC68EC030.irpCmpByte();
                            break;
                        }
                        case 705: 
                        case 713: 
                        case 721: 
                        case 729: 
                        case 737: 
                        case 745: 
                        case 753: 
                        case 761: {
                            MC68EC030.irpCmpWord();
                            break;
                        }
                        case 706: 
                        case 714: 
                        case 722: 
                        case 730: 
                        case 738: 
                        case 746: 
                        case 754: 
                        case 762: {
                            MC68EC030.irpCmpLong();
                            break;
                        }
                        case 707: 
                        case 715: 
                        case 723: 
                        case 731: 
                        case 739: 
                        case 747: 
                        case 755: 
                        case 763: {
                            MC68EC030.irpCmpaWord();
                            break;
                        }
                        case 708: 
                        case 716: 
                        case 724: 
                        case 732: 
                        case 740: 
                        case 748: 
                        case 756: 
                        case 764: {
                            MC68EC030.irpEorByte();
                            break;
                        }
                        case 709: 
                        case 717: 
                        case 725: 
                        case 733: 
                        case 741: 
                        case 749: 
                        case 757: 
                        case 765: {
                            MC68EC030.irpEorWord();
                            break;
                        }
                        case 710: 
                        case 718: 
                        case 726: 
                        case 734: 
                        case 742: 
                        case 750: 
                        case 758: 
                        case 766: {
                            MC68EC030.irpEorLong();
                            break;
                        }
                        case 711: 
                        case 719: 
                        case 727: 
                        case 735: 
                        case 743: 
                        case 751: 
                        case 759: 
                        case 767: {
                            MC68EC030.irpCmpaLong();
                            break;
                        }
                        case 768: 
                        case 776: 
                        case 784: 
                        case 792: 
                        case 800: 
                        case 808: 
                        case 816: 
                        case 824: {
                            MC68EC030.irpAndToRegByte();
                            break;
                        }
                        case 769: 
                        case 777: 
                        case 785: 
                        case 793: 
                        case 801: 
                        case 809: 
                        case 817: 
                        case 825: {
                            MC68EC030.irpAndToRegWord();
                            break;
                        }
                        case 770: 
                        case 778: 
                        case 786: 
                        case 794: 
                        case 802: 
                        case 810: 
                        case 818: 
                        case 826: {
                            MC68EC030.irpAndToRegLong();
                            break;
                        }
                        case 771: 
                        case 779: 
                        case 787: 
                        case 795: 
                        case 803: 
                        case 811: 
                        case 819: 
                        case 827: {
                            MC68EC030.irpMuluWord();
                            break;
                        }
                        case 772: 
                        case 780: 
                        case 788: 
                        case 796: 
                        case 804: 
                        case 812: 
                        case 820: 
                        case 828: {
                            MC68EC030.irpAndToMemByte();
                            break;
                        }
                        case 773: 
                        case 781: 
                        case 789: 
                        case 797: 
                        case 805: 
                        case 813: 
                        case 821: 
                        case 829: {
                            MC68EC030.irpAndToMemWord();
                            break;
                        }
                        case 774: 
                        case 782: 
                        case 790: 
                        case 798: 
                        case 806: 
                        case 814: 
                        case 822: 
                        case 830: {
                            MC68EC030.irpAndToMemLong();
                            break;
                        }
                        case 775: 
                        case 783: 
                        case 791: 
                        case 799: 
                        case 807: 
                        case 815: 
                        case 823: 
                        case 831: {
                            MC68EC030.irpMulsWord();
                            break;
                        }
                        case 832: 
                        case 840: 
                        case 848: 
                        case 856: 
                        case 864: 
                        case 872: 
                        case 880: 
                        case 888: {
                            MC68EC030.irpAddToRegByte();
                            break;
                        }
                        case 833: 
                        case 841: 
                        case 849: 
                        case 857: 
                        case 865: 
                        case 873: 
                        case 881: 
                        case 889: {
                            MC68EC030.irpAddToRegWord();
                            break;
                        }
                        case 834: 
                        case 842: 
                        case 850: 
                        case 858: 
                        case 866: 
                        case 874: 
                        case 882: 
                        case 890: {
                            MC68EC030.irpAddToRegLong();
                            break;
                        }
                        case 835: 
                        case 843: 
                        case 851: 
                        case 859: 
                        case 867: 
                        case 875: 
                        case 883: 
                        case 891: {
                            MC68EC030.irpAddaWord();
                            break;
                        }
                        case 836: 
                        case 844: 
                        case 852: 
                        case 860: 
                        case 868: 
                        case 876: 
                        case 884: 
                        case 892: {
                            MC68EC030.irpAddToMemByte();
                            break;
                        }
                        case 837: 
                        case 845: 
                        case 853: 
                        case 861: 
                        case 869: 
                        case 877: 
                        case 885: 
                        case 893: {
                            MC68EC030.irpAddToMemWord();
                            break;
                        }
                        case 838: 
                        case 846: 
                        case 854: 
                        case 862: 
                        case 870: 
                        case 878: 
                        case 886: 
                        case 894: {
                            MC68EC030.irpAddToMemLong();
                            break;
                        }
                        case 839: 
                        case 847: 
                        case 855: 
                        case 863: 
                        case 871: 
                        case 879: 
                        case 887: 
                        case 895: {
                            MC68EC030.irpAddaLong();
                            break;
                        }
                        case 896: 
                        case 904: 
                        case 912: 
                        case 920: 
                        case 928: 
                        case 936: 
                        case 944: 
                        case 952: {
                            MC68EC030.irpXxrToRegByte();
                            break;
                        }
                        case 897: 
                        case 905: 
                        case 913: 
                        case 921: 
                        case 929: 
                        case 937: 
                        case 945: 
                        case 953: {
                            MC68EC030.irpXxrToRegWord();
                            break;
                        }
                        case 898: 
                        case 906: 
                        case 914: 
                        case 922: 
                        case 930: 
                        case 938: 
                        case 946: 
                        case 954: {
                            MC68EC030.irpXxrToRegLong();
                            break;
                        }
                        case 899: {
                            MC68EC030.irpAsrToMem();
                            break;
                        }
                        case 900: 
                        case 908: 
                        case 916: 
                        case 924: 
                        case 932: 
                        case 940: 
                        case 948: 
                        case 956: {
                            MC68EC030.irpXxlToRegByte();
                            break;
                        }
                        case 901: 
                        case 909: 
                        case 917: 
                        case 925: 
                        case 933: 
                        case 941: 
                        case 949: 
                        case 957: {
                            MC68EC030.irpXxlToRegWord();
                            break;
                        }
                        case 902: 
                        case 910: 
                        case 918: 
                        case 926: 
                        case 934: 
                        case 942: 
                        case 950: 
                        case 958: {
                            MC68EC030.irpXxlToRegLong();
                            break;
                        }
                        case 903: {
                            MC68EC030.irpAslToMem();
                            break;
                        }
                        case 907: {
                            MC68EC030.irpLsrToMem();
                            break;
                        }
                        case 911: {
                            MC68EC030.irpLslToMem();
                            break;
                        }
                        case 915: {
                            MC68EC030.irpRoxrToMem();
                            break;
                        }
                        case 919: {
                            MC68EC030.irpRoxlToMem();
                            break;
                        }
                        case 923: {
                            MC68EC030.irpRorToMem();
                            break;
                        }
                        case 927: {
                            MC68EC030.irpRolToMem();
                            break;
                        }
                        case 931: {
                            MC68EC030.irpBftst();
                            break;
                        }
                        case 935: {
                            MC68EC030.irpBfextu();
                            break;
                        }
                        case 939: {
                            MC68EC030.irpBfchg();
                            break;
                        }
                        case 943: {
                            MC68EC030.irpBfexts();
                            break;
                        }
                        case 947: {
                            MC68EC030.irpBfclr();
                            break;
                        }
                        case 951: {
                            MC68EC030.irpBfffo();
                            break;
                        }
                        case 955: {
                            MC68EC030.irpBfset();
                            break;
                        }
                        case 959: {
                            MC68EC030.irpBfins();
                            break;
                        }
                        case 960: {
                            MC68EC030.irpPgen();
                            break;
                        }
                        case 968: {
                            MC68EC030.irpFgen();
                            break;
                        }
                        case 969: {
                            MC68EC030.irpFscc();
                            break;
                        }
                        case 970: {
                            MC68EC030.irpFbccWord();
                            break;
                        }
                        case 971: {
                            MC68EC030.irpFbccLong();
                            break;
                        }
                        case 972: {
                            MC68EC030.irpFsave();
                            break;
                        }
                        case 973: {
                            MC68EC030.irpFrestore();
                            break;
                        }
                        case 1016: 
                        case 1017: 
                        case 1018: 
                        case 1019: {
                            MC68EC030.irpFpack();
                            break;
                        }
                        case 961: 
                        case 962: 
                        case 963: 
                        case 964: 
                        case 965: 
                        case 966: 
                        case 967: 
                        case 974: 
                        case 975: 
                        case 976: 
                        case 977: 
                        case 978: 
                        case 979: 
                        case 980: 
                        case 981: 
                        case 982: 
                        case 983: 
                        case 984: 
                        case 985: 
                        case 986: 
                        case 987: 
                        case 988: 
                        case 989: 
                        case 990: 
                        case 991: 
                        case 992: 
                        case 993: 
                        case 994: 
                        case 995: 
                        case 996: 
                        case 997: 
                        case 998: 
                        case 999: 
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1004: 
                        case 1005: 
                        case 1006: 
                        case 1007: 
                        case 1008: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 1012: 
                        case 1013: 
                        case 1014: 
                        case 1015: 
                        case 1020: 
                        case 1021: 
                        case 1022: 
                        case 1023: {
                            MC68EC030.irpFline();
                            break;
                        }
                        case 312: {
                            MC68EC030.irpEmx();
                            break;
                        }
                        default: {
                            MC68EC030.irpIllegal();
                        }
                    }
                    if (XEiJ.mpuTraceFlag != 0) {
                        XEiJ.mpuCycleCount += 34;
                        MC68EC030.irpException(9, XEiJ.regPC, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 8192, XEiJ.regPC0);
                    }
                    TickerQueue.tkqRun(XEiJ.mpuClockTime += XEiJ.mpuModifiedUnit * (long)XEiJ.mpuCycleCount);
                    n = XEiJ.mpuIMR & XEiJ.mpuIRR;
                    if (n != 0) {
                        switch (n) {
                            case 1: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: 
                            case 15: 
                            case 17: 
                            case 19: 
                            case 21: 
                            case 23: 
                            case 25: 
                            case 27: 
                            case 29: 
                            case 31: 
                            case 33: 
                            case 35: 
                            case 37: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 45: 
                            case 47: 
                            case 49: 
                            case 51: 
                            case 53: 
                            case 55: 
                            case 57: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 65: 
                            case 67: 
                            case 69: 
                            case 71: 
                            case 73: 
                            case 75: 
                            case 77: 
                            case 79: 
                            case 81: 
                            case 83: 
                            case 85: 
                            case 87: 
                            case 89: 
                            case 91: 
                            case 93: 
                            case 95: 
                            case 97: 
                            case 99: 
                            case 101: 
                            case 103: 
                            case 105: 
                            case 107: 
                            case 109: 
                            case 111: 
                            case 113: 
                            case 115: 
                            case 117: 
                            case 119: 
                            case 121: 
                            case 123: 
                            case 125: 
                            case 127: 
                            case 129: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 137: 
                            case 139: 
                            case 141: 
                            case 143: 
                            case 145: 
                            case 147: 
                            case 149: 
                            case 151: 
                            case 153: 
                            case 155: 
                            case 157: 
                            case 159: 
                            case 161: 
                            case 163: 
                            case 165: 
                            case 167: 
                            case 169: 
                            case 171: 
                            case 173: 
                            case 175: 
                            case 177: 
                            case 179: 
                            case 181: 
                            case 183: 
                            case 185: 
                            case 187: 
                            case 189: 
                            case 191: 
                            case 193: 
                            case 195: 
                            case 197: 
                            case 199: 
                            case 201: 
                            case 203: 
                            case 205: 
                            case 207: 
                            case 209: 
                            case 211: 
                            case 213: 
                            case 215: 
                            case 217: 
                            case 219: 
                            case 221: 
                            case 223: 
                            case 225: 
                            case 227: 
                            case 229: 
                            case 231: 
                            case 233: 
                            case 235: 
                            case 237: 
                            case 239: 
                            case 241: 
                            case 243: 
                            case 245: 
                            case 247: 
                            case 249: 
                            case 251: 
                            case 253: 
                            case 255: {
                                XEiJ.mpuIRR &= 0xFFFFFFFE;
                                n = XEiJ.sysAcknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 7);
                                break;
                            }
                            case 2: 
                            case 6: 
                            case 10: 
                            case 14: 
                            case 18: 
                            case 22: 
                            case 26: 
                            case 30: 
                            case 34: 
                            case 38: 
                            case 42: 
                            case 46: 
                            case 50: 
                            case 54: 
                            case 58: 
                            case 62: 
                            case 66: 
                            case 70: 
                            case 74: 
                            case 78: 
                            case 82: 
                            case 86: 
                            case 90: 
                            case 94: 
                            case 98: 
                            case 102: 
                            case 106: 
                            case 110: 
                            case 114: 
                            case 118: 
                            case 122: 
                            case 126: 
                            case 130: 
                            case 134: 
                            case 138: 
                            case 142: 
                            case 146: 
                            case 150: 
                            case 154: 
                            case 158: 
                            case 162: 
                            case 166: 
                            case 170: 
                            case 174: 
                            case 178: 
                            case 182: 
                            case 186: 
                            case 190: 
                            case 194: 
                            case 198: 
                            case 202: 
                            case 206: 
                            case 210: 
                            case 214: 
                            case 218: 
                            case 222: 
                            case 226: 
                            case 230: 
                            case 234: 
                            case 238: 
                            case 242: 
                            case 246: 
                            case 250: 
                            case 254: {
                                XEiJ.mpuIRR &= 0xFFFFFFFD;
                                n = MC68901.mfpAcknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 6);
                                break;
                            }
                            case 4: 
                            case 12: 
                            case 20: 
                            case 28: 
                            case 36: 
                            case 44: 
                            case 52: 
                            case 60: 
                            case 68: 
                            case 76: 
                            case 84: 
                            case 92: 
                            case 100: 
                            case 108: 
                            case 116: 
                            case 124: 
                            case 132: 
                            case 140: 
                            case 148: 
                            case 156: 
                            case 164: 
                            case 172: 
                            case 180: 
                            case 188: 
                            case 196: 
                            case 204: 
                            case 212: 
                            case 220: 
                            case 228: 
                            case 236: 
                            case 244: 
                            case 252: {
                                XEiJ.mpuIRR &= 0xFFFFFFFB;
                                n = Z8530.sccAcknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 5);
                                break;
                            }
                            case 16: 
                            case 48: 
                            case 80: 
                            case 112: 
                            case 144: 
                            case 176: 
                            case 208: 
                            case 240: {
                                XEiJ.mpuIRR &= 0xFFFFFFEF;
                                n = HD63450.dmaAcknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 3);
                                break;
                            }
                            case 32: 
                            case 96: 
                            case 160: 
                            case 224: {
                                XEiJ.mpuIRR &= 0xFFFFFFDF;
                                n = XEiJ.eb2Acknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 2);
                                break;
                            }
                            case 64: 
                            case 192: {
                                XEiJ.mpuIRR &= 0xFFFFFFBF;
                                n = IOInterrupt.ioiAcknowledge();
                                if (n == 0) break;
                                MC68EC030.irpInterrupt(n, 1);
                            }
                        }
                    }
                    XEiJ.mpuIRR |= XEiJ.mpuDIRR;
                    XEiJ.mpuDIRR = 0;
                }
            }
            catch (M68kException m68kException) {
                if (M68kException.m6eNumber == -2) {
                    if (!MC68EC030.irpWaitException()) break;
                    continue;
                }
                if (M68kException.m6eNumber == -1) {
                    XEiJ.regPC = XEiJ.regPC0;
                    XEiJ.mpuStop1(null);
                    break;
                }
                if (951058432 << M68kException.m6eNumber < 0) {
                    XEiJ.regPC = XEiJ.regPC0;
                }
                try {
                    int n = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
                    int n2 = XEiJ.regRn[15];
                    XEiJ.regSRT0 = 0;
                    XEiJ.regSRT1 = 0;
                    if (XEiJ.regSRS == 0) {
                        XEiJ.regSRS = 8192;
                        XEiJ.mpuUSP = n2;
                        n2 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
                        DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
                        InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
                    }
                    if (M68kException.m6eNumber <= 3) {
                        HFS.hfsState = 0;
                        XEiJ.mpuClockTime += 50L * XEiJ.mpuModifiedUnit;
                        XEiJ.regRn[15] = n2 -= 92;
                        XEiJ.busWl(n2 + 88, 0);
                        XEiJ.busWl(n2 + 84, 0);
                        XEiJ.busWl(n2 + 80, 0);
                        XEiJ.busWl(n2 + 76, 0);
                        XEiJ.busWl(n2 + 72, 0);
                        XEiJ.busWl(n2 + 68, 0);
                        XEiJ.busWl(n2 + 64, 0);
                        XEiJ.busWl(n2 + 60, 0);
                        XEiJ.busWl(n2 + 56, 0);
                        XEiJ.busWl(n2 + 52, 0);
                        XEiJ.busWl(n2 + 48, 0);
                        XEiJ.busWl(n2 + 44, 0);
                        XEiJ.busWl(n2 + 40, 0);
                        XEiJ.busWl(n2 + 36, 0);
                        XEiJ.busWl(n2 + 32, 0);
                        XEiJ.busWl(n2 + 28, 0);
                        XEiJ.busWl(n2 + 24, 0);
                        XEiJ.busWl(n2 + 20, 0);
                        XEiJ.busWl(n2 + 16, M68kException.m6eAddress);
                        XEiJ.busWl(n2 + 12, 0);
                        XEiJ.busWw(n2 + 10, M68kException.m6eDirection << 6 | (M68kException.m6eSize == 0 ? 16 : (M68kException.m6eSize == 1 ? 32 : 0)));
                        XEiJ.busWw(n2 + 8, 0);
                        XEiJ.busWw(n2 + 6, 0xB000 | M68kException.m6eNumber << 2);
                    } else if (1675339061381824512L << M68kException.m6eNumber < 0L) {
                        XEiJ.mpuClockTime += 34L * XEiJ.mpuModifiedUnit;
                        XEiJ.regRn[15] = n2 -= 12;
                        XEiJ.busWl(n2 + 8, M68kException.m6eAddress);
                        XEiJ.busWw(n2 + 6, 0x2000 | M68kException.m6eNumber << 2);
                    } else {
                        XEiJ.mpuClockTime += 34L * XEiJ.mpuModifiedUnit;
                        XEiJ.regRn[15] = n2 -= 8;
                        XEiJ.busWw(n2 + 6, 0 | M68kException.m6eNumber << 2);
                    }
                    XEiJ.busWl(n2 + 2, XEiJ.regPC);
                    XEiJ.busWw(n2, n);
                    MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + (M68kException.m6eNumber << 2)));
                    if (!XEiJ.dbgStopOnError || !XEiJ.dbgDoStopOnError()) continue;
                }
                catch (M68kException m68kException2) {
                    XEiJ.dbgDoubleBusFault();
                }
                break;
            }
        }
        BranchLog.blgStop();
    }

    public static boolean irpWaitException() {
        XEiJ.regPC = XEiJ.regPC0;
        int n = 8 + (XEiJ.regOC & 7);
        XEiJ.regRn[n] = XEiJ.regRn[n] + WaitInstruction.REWIND_AR[XEiJ.regOC >> 3];
        try {
            if (XEiJ.mpuTraceFlag != 0) {
                XEiJ.mpuCycleCount += 34;
                MC68EC030.irpException(9, XEiJ.regPC, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 8192, XEiJ.regPC0);
            }
            TickerQueue.tkqRun(XEiJ.mpuClockTime);
            int n2 = XEiJ.mpuIMR & XEiJ.mpuIRR;
            if (n2 != 0) {
                if ((n2 &= -n2) == 2) {
                    XEiJ.mpuIRR &= 0xFFFFFFFD;
                    n2 = MC68901.mfpAcknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 6);
                    }
                } else if (n2 == 16) {
                    XEiJ.mpuIRR &= 0xFFFFFFEF;
                    n2 = HD63450.dmaAcknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 3);
                    }
                } else if (n2 == 4) {
                    XEiJ.mpuIRR &= 0xFFFFFFFB;
                    n2 = Z8530.sccAcknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 5);
                    }
                } else if (n2 == 64) {
                    XEiJ.mpuIRR &= 0xFFFFFFBF;
                    n2 = IOInterrupt.ioiAcknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 1);
                    }
                } else if (n2 == 32) {
                    XEiJ.mpuIRR &= 0xFFFFFFDF;
                    n2 = XEiJ.eb2Acknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 2);
                    }
                } else if (n2 == 1) {
                    XEiJ.mpuIRR &= 0xFFFFFFFE;
                    n2 = XEiJ.sysAcknowledge();
                    if (n2 != 0) {
                        MC68EC030.irpInterrupt(n2, 7);
                    }
                }
            }
            XEiJ.mpuIRR |= XEiJ.mpuDIRR;
            XEiJ.mpuDIRR = 0;
        }
        catch (M68kException m68kException) {
            XEiJ.dbgDoubleBusFault();
            return false;
        }
        return true;
    }

    public static void irpOriByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRbs(n2 + 1);
        if (n < 8) {
            if (n2 == 0 && n == 0 && XEiJ.dbgOriByteZeroD0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] | 0xFF & n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            XEiJ.mpuCycleCount += 20;
            XEiJ.regCCR |= 0x1F & n2;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltByte(n);
            XEiJ.busWb(n5, n2 |= XEiJ.busRbs(n5));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpOriWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            n2 = XEiJ.busRwse(n2);
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] | (char)n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 20;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            MC68EC030.irpSetSR(XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR | XEiJ.busRwse(n5));
        } else {
            int n6 = XEiJ.regPC;
            XEiJ.regPC = n6 + 2;
            n6 = XEiJ.busRwse(n6);
            XEiJ.mpuCycleCount += 12;
            int n7 = MC68EC030.efaMltWord(n);
            XEiJ.busWw(n7, n6 |= XEiJ.busRws(n7));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n6 - '\u0001' >> 31 & 4 | ((short)n6 < 0 ? 8 : 0);
        }
    }

    public static void irpOriLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        n3 = XEiJ.busRlse(n3);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 16;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] | n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            XEiJ.mpuCycleCount += 20;
            int n6 = MC68EC030.efaMltLong(n2);
            n = XEiJ.busRls(n6) | n3;
            XEiJ.busWl(n6, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCmp2Chk2Byte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = XEiJ.regRn[n];
            XEiJ.regRn[n] = XEiJ.MPU_BITREV_TABLE_0[n2 & 0x7FF] | XEiJ.MPU_BITREV_TABLE_1[n2 << 10 >>> 21] | XEiJ.MPU_BITREV_TABLE_2[n2 >>> 22];
        } else {
            int n3;
            int n4;
            XEiJ.mpuCycleCount += 8;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            n5 = XEiJ.busRwze(n5);
            int n6 = XEiJ.regRn[n5 >> 12];
            if (0 <= (short)n5) {
                n6 = (byte)n6;
            }
            int n7 = MC68EC030.efaCntByte(n);
            byte by = XEiJ.busRbs(n7);
            int n8 = XEiJ.busRbs(n7 + 1);
            if (Integer.compareUnsigned(by, n6) < 0 && Integer.compareUnsigned(by, n8) <= 0 || n6 == n8) {
                n4 = n8;
                n3 = n6;
            } else if (Integer.compareUnsigned(n6, n8) < 0 && Integer.compareUnsigned(n8, by) < 0) {
                n4 = by;
                n3 = n6;
            } else {
                n4 = n6;
                n3 = by;
            }
            int n9 = n4 - n3;
            int n10 = (n4 & (n3 ^ n9) ^ (n3 | n9)) >>> 31;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | n9 >>> 28 & 8 | (n9 == 0 ? 4 : 0) | ((n4 ^ n3) & (n4 ^ n9)) >>> 31 << 1 | n10;
            if ((n5 >> 11 & n10) != 0) {
                XEiJ.mpuCycleCount += -2;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 6;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpBtstReg() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 16;
            int n3 = XEiJ.regPC;
            XEiJ.regPC = n3 + 2;
            n3 = XEiJ.regRn[n] + XEiJ.busRwse(n3);
            XEiJ.regRn[n2] = 0xFFFF0000 & XEiJ.regRn[n2] | XEiJ.busRbz(n3) << 8 | XEiJ.busRbz(n3 + 2);
        } else {
            int n4 = XEiJ.regRn[n2];
            if (n < 8) {
                XEiJ.mpuCycleCount += 6;
                XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.regRn[n] >>> n4 & 1) << 2;
            } else {
                XEiJ.mpuCycleCount += 4;
                XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.busRbs(MC68EC030.efaAnyByte(n)) >>> (n4 & 7) & 1) << 2;
            }
        }
    }

    public static void irpBchgReg() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 24;
            int n3 = XEiJ.regPC;
            XEiJ.regPC = n3 + 2;
            n3 = XEiJ.regRn[n] + XEiJ.busRwse(n3);
            XEiJ.regRn[n2] = XEiJ.busRbs(n3) << 24 | XEiJ.busRbz(n3 + 2) << 16 | XEiJ.busRbz(n3 + 4) << 8 | XEiJ.busRbz(n3 + 6);
        } else {
            int n4;
            int n5 = XEiJ.regRn[n2];
            if (n < 8) {
                n4 = XEiJ.regRn[n];
                n5 = 1 << n5;
                XEiJ.regRn[n] = n4 ^ n5;
                XEiJ.mpuCycleCount += (char)n5 != '\u0000' ? 6 : 8;
            } else {
                XEiJ.mpuCycleCount += 8;
                int n6 = MC68EC030.efaMltByte(n);
                byte by = XEiJ.busRbs(n6);
                n4 = by;
                n5 = 1 << (n5 & 7);
                XEiJ.busWb(n6, by ^ n5);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n4 & n5) - 1 >>> 31 << 2;
        }
    }

    public static void irpBclrReg() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regRn[XEiJ.regOC >> 9];
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 16;
            int n3 = XEiJ.regPC;
            XEiJ.regPC = n3 + 2;
            n3 = XEiJ.regRn[n] + XEiJ.busRwse(n3);
            XEiJ.busWb(n3, n2 >> 8);
            XEiJ.busWb(n3 + 2, n2);
        } else {
            int n4;
            if (n < 8) {
                n4 = XEiJ.regRn[n];
                n2 = 1 << n2;
                XEiJ.regRn[n] = n4 & ~n2;
                XEiJ.mpuCycleCount += (char)n2 != '\u0000' ? 8 : 10;
            } else {
                XEiJ.mpuCycleCount += 8;
                int n5 = MC68EC030.efaMltByte(n);
                byte by = XEiJ.busRbs(n5);
                n4 = by;
                n2 = 1 << (n2 & 7);
                XEiJ.busWb(n5, by & ~n2);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n4 & n2) - 1 >>> 31 << 2;
        }
    }

    public static void irpBsetReg() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regRn[XEiJ.regOC >> 9];
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 24;
            int n3 = XEiJ.regPC;
            XEiJ.regPC = n3 + 2;
            n3 = XEiJ.regRn[n] + XEiJ.busRwse(n3);
            XEiJ.busWb(n3, n2 >> 24);
            XEiJ.busWb(n3 + 2, n2 >> 16);
            XEiJ.busWb(n3 + 4, n2 >> 8);
            XEiJ.busWb(n3 + 6, n2);
        } else {
            int n4;
            if (n < 8) {
                n4 = XEiJ.regRn[n];
                n2 = 1 << n2;
                XEiJ.regRn[n] = n4 | n2;
                XEiJ.mpuCycleCount += (char)n2 != '\u0000' ? 6 : 8;
            } else {
                XEiJ.mpuCycleCount += 8;
                int n5 = MC68EC030.efaMltByte(n);
                byte by = XEiJ.busRbs(n5);
                n4 = by;
                n2 = 1 << (n2 & 7);
                XEiJ.busWb(n5, by | n2);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n4 & n2) - 1 >>> 31 << 2;
        }
    }

    public static void irpAndiByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRbs(n2 + 1);
        if (n < 8) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] & (0xFFFFFF00 | n2);
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            XEiJ.mpuCycleCount += 20;
            XEiJ.regCCR &= n2;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltByte(n);
            XEiJ.busWb(n5, n2 &= XEiJ.busRbs(n5));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpAndiWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            n2 = XEiJ.busRwse(n2);
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] & (0xFFFF0000 | n2);
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 20;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            MC68EC030.irpSetSR((XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR) & XEiJ.busRwse(n5));
        } else {
            int n6 = XEiJ.regPC;
            XEiJ.regPC = n6 + 2;
            n6 = XEiJ.busRwse(n6);
            XEiJ.mpuCycleCount += 12;
            int n7 = MC68EC030.efaMltWord(n);
            XEiJ.busWw(n7, n6 &= XEiJ.busRws(n7));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n6 - '\u0001' >> 31 & 4 | ((short)n6 < 0 ? 8 : 0);
        }
    }

    public static void irpAndiLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        n3 = XEiJ.busRlse(n3);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 16;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] & n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            XEiJ.mpuCycleCount += 20;
            int n6 = MC68EC030.efaMltLong(n2);
            n = XEiJ.busRls(n6) & n3;
            XEiJ.busWl(n6, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCmp2Chk2Word() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            XEiJ.regRn[n] = Integer.reverseBytes(XEiJ.regRn[n]);
        } else {
            int n2;
            int n3;
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regPC;
            XEiJ.regPC = n4 + 2;
            n4 = XEiJ.busRwze(n4);
            int n5 = XEiJ.regRn[n4 >> 12];
            if (0 <= (short)n4) {
                n5 = (short)n5;
            }
            int n6 = MC68EC030.efaCntWord(n);
            int n7 = XEiJ.busRws(n6);
            int n8 = XEiJ.busRws(n6 + 2);
            if (Integer.compareUnsigned(n7, n5) < 0 && Integer.compareUnsigned(n7, n8) <= 0 || n5 == n8) {
                n3 = n8;
                n2 = n5;
            } else if (Integer.compareUnsigned(n5, n8) < 0 && Integer.compareUnsigned(n8, n7) < 0) {
                n3 = n7;
                n2 = n5;
            } else {
                n3 = n5;
                n2 = n7;
            }
            int n9 = n3 - n2;
            int n10 = (n3 & (n2 ^ n9) ^ (n2 | n9)) >>> 31;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | n9 >>> 28 & 8 | (n9 == 0 ? 4 : 0) | ((n3 ^ n2) & (n3 ^ n9)) >>> 31 << 1 | n10;
            if ((n4 >> 11 & n10) != 0) {
                XEiJ.mpuCycleCount += -2;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 6;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpSubiByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRbs(n3 + 1);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 - n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n5);
            n = by3;
            by = (byte)(by3 - n3);
            XEiJ.busWb(n5, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | ((n ^ n3) & (n ^ by)) >>> 31 << 1 | (n & (n3 ^ by) ^ (n3 | by)) >> 31 & 0x11;
    }

    public static void irpSubiWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRwse(n3);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)(s2 - n3);
            s = (short)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltWord(n2);
            n = XEiJ.busRws(n5);
            s = (short)(n - n3);
            XEiJ.busWw(n5, s);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | ((n ^ n3) & (n ^ s)) >>> 31 << 1 | (n & (n3 ^ s) ^ (n3 | s)) >> 31 & 0x11;
    }

    public static void irpSubiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = XEiJ.regPC;
        XEiJ.regPC = n4 + 4;
        n4 = XEiJ.busRlse(n4);
        if (n3 < 8) {
            XEiJ.mpuCycleCount += 16;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = n2 - n4;
        } else {
            XEiJ.mpuCycleCount += 20;
            int n5 = MC68EC030.efaMltLong(n3);
            n2 = XEiJ.busRls(n5);
            n = n2 - n4;
            XEiJ.busWl(n5, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n2 ^ n4) & (n2 ^ n)) >>> 31 << 1 | (n2 & (n4 ^ n) ^ (n4 | n)) >> 31 & 0x11;
    }

    public static void irpCmp2Chk2Long() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = XEiJ.regRn[n];
            XEiJ.regRn[n] = Integer.numberOfLeadingZeros(n2);
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n3;
            int n4;
            XEiJ.mpuCycleCount += 8;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            n5 = XEiJ.busRwze(n5);
            int n6 = XEiJ.regRn[n5 >> 12];
            int n7 = MC68EC030.efaCntLong(n);
            int n8 = XEiJ.busRls(n7);
            int n9 = XEiJ.busRls(n7 + 4);
            if (Integer.compareUnsigned(n8, n6) < 0 && Integer.compareUnsigned(n8, n9) <= 0 || n6 == n9) {
                n4 = n9;
                n3 = n6;
            } else if (Integer.compareUnsigned(n6, n9) < 0 && Integer.compareUnsigned(n9, n8) < 0) {
                n4 = n8;
                n3 = n6;
            } else {
                n4 = n6;
                n3 = n8;
            }
            int n10 = n4 - n3;
            int n11 = (n4 & (n3 ^ n10) ^ (n3 | n10)) >>> 31;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | n10 >>> 28 & 8 | (n10 == 0 ? 4 : 0) | ((n4 ^ n3) & (n4 ^ n10)) >>> 31 << 1 | n11;
            if ((n5 >> 11 & n11) != 0) {
                XEiJ.mpuCycleCount += -2;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 6;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpAddiByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRbs(n3 + 1);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 + n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n5);
            n = by3;
            by = (byte)(by3 + n3);
            XEiJ.busWb(n5, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | ((n ^ by) & (n3 ^ by)) >>> 31 << 1 | ((n | n3) ^ (n ^ n3) & by) >> 31 & 0x11;
    }

    public static void irpAddiWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRwse(n3);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)(s2 + n3);
            s = (short)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltWord(n2);
            n = XEiJ.busRws(n5);
            s = (short)(n + n3);
            XEiJ.busWw(n5, s);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | ((n ^ s) & (n3 ^ s)) >>> 31 << 1 | ((n | n3) ^ (n ^ n3) & s) >> 31 & 0x11;
    }

    public static void irpAddiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = XEiJ.regPC;
        XEiJ.regPC = n4 + 4;
        n4 = XEiJ.busRlse(n4);
        if (n3 < 8) {
            XEiJ.mpuCycleCount += 16;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = n2 + n4;
        } else {
            XEiJ.mpuCycleCount += 20;
            int n5 = MC68EC030.efaMltLong(n3);
            n2 = XEiJ.busRls(n5);
            n = n2 + n4;
            XEiJ.busWl(n5, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n2 ^ n) & (n4 ^ n)) >>> 31 << 1 | ((n2 | n4) ^ (n2 ^ n4) & n) >> 31 & 0x11;
    }

    public static void irpBtstImm() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRbs(n2 + 1);
        if (n < 8) {
            XEiJ.mpuCycleCount += 10;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.regRn[n] >>> n2 & 1) << 2;
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.busRbs(MC68EC030.efaMemByte(n)) >>> (n2 & 7) & 1) << 2;
        }
    }

    public static void irpBchgImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRbs(n3 + 1);
        if (n2 < 8) {
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n ^ n3;
            XEiJ.mpuCycleCount += (char)n3 != '\u0000' ? 10 : 12;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltByte(n2);
            byte by = XEiJ.busRbs(n4);
            n = by;
            n3 = 1 << (n3 & 7);
            XEiJ.busWb(n4, by ^ n3);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpBclrImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRbs(n3 + 1);
        if (n2 < 8) {
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n & ~n3;
            XEiJ.mpuCycleCount += (char)n3 != '\u0000' ? 12 : 14;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltByte(n2);
            byte by = XEiJ.busRbs(n4);
            n = by;
            n3 = 1 << (n3 & 7);
            XEiJ.busWb(n4, by & ~n3);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpBsetImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        n3 = XEiJ.busRbs(n3 + 1);
        if (n2 < 8) {
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n | n3;
            XEiJ.mpuCycleCount += (char)n3 != '\u0000' ? 10 : 12;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltByte(n2);
            byte by = XEiJ.busRbs(n4);
            n = by;
            n3 = 1 << (n3 & 7);
            XEiJ.busWb(n4, by | n3);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpEoriByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRbs(n2 + 1);
        if (n < 8) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] ^ 0xFF & n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            XEiJ.mpuCycleCount += 20;
            XEiJ.regCCR ^= 0x1F & n2;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltByte(n);
            XEiJ.busWb(n5, n2 ^= XEiJ.busRbs(n5));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpEoriWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            n2 = XEiJ.busRwse(n2);
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] ^ (char)n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 20;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            MC68EC030.irpSetSR((XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR) ^ XEiJ.busRwse(n5));
        } else {
            int n6 = XEiJ.regPC;
            XEiJ.regPC = n6 + 2;
            n6 = XEiJ.busRwse(n6);
            XEiJ.mpuCycleCount += 12;
            int n7 = MC68EC030.efaMltWord(n);
            XEiJ.busWw(n7, n6 ^= XEiJ.busRws(n7));
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n6 - '\u0001' >> 31 & 4 | ((short)n6 < 0 ? 8 : 0);
        }
    }

    public static void irpEoriLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        n3 = XEiJ.busRlse(n3);
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 16;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] ^ n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            XEiJ.mpuCycleCount += 20;
            int n6 = MC68EC030.efaMltLong(n2);
            n = XEiJ.busRls(n6) ^ n3;
            XEiJ.busWl(n6, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCasByte() throws M68kException {
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        if (((n = XEiJ.busRwze(n)) & 0xFFFFFE38) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n2 = n & 7;
        byte by = (byte)XEiJ.regRn[n2];
        int n3 = MC68EC030.efaMltByte(XEiJ.regOC & 0x3F);
        byte by2 = XEiJ.busRbs(n3);
        byte by3 = (byte)(by2 - by);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (by3 < 0 ? 8 : 0) | (by3 == 0 ? 4 : 0) | ((by2 ^ by) & (by2 ^ by3)) >>> 31 << 1 | (by2 & (by ^ by3) ^ (by | by3)) >>> 31;
        if (by3 == 0) {
            XEiJ.mpuCycleCount += 16;
            XEiJ.busWb(n3, XEiJ.regRn[n >> 6]);
        } else {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regRn[n2] = 0xFFFFFF00 & XEiJ.regRn[n2] | 0xFF & by2;
        }
    }

    public static void irpCmpiByte() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRbs(n2 + 1);
        byte by = n < 8 ? (byte)XEiJ.regRn[n] : XEiJ.busRbs(MC68EC030.efaMemByte(n));
        byte by2 = (byte)(by - n2);
        XEiJ.regCCR = by2 >> 28 & 8 | (by2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by ^ n2) & (by ^ by2)) >>> 31 << 1 | (by & (n2 ^ by2) ^ (n2 | by2)) >>> 31;
    }

    public static void irpCmpiWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        n2 = XEiJ.busRwse(n2);
        int n3 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaMemWord(n));
        short s = (short)(n3 - n2);
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n3 ^ n2) & (n3 ^ s)) >>> 31 << 1 | (n3 & (n2 ^ s) ^ (n2 | s)) >>> 31;
    }

    public static void irpCmpiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = XEiJ.regPC;
        XEiJ.regPC = n4 + 4;
        n4 = XEiJ.busRlse(n4);
        if (n3 < 8) {
            XEiJ.mpuCycleCount += 14;
            n2 = XEiJ.regRn[n3];
            n = n2 - n4;
        } else {
            XEiJ.mpuCycleCount += 12;
            n2 = XEiJ.busRls(MC68EC030.efaMemLong(n3));
            n = n2 - n4;
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n2 ^ n4) & (n2 ^ n)) >>> 31 << 1 | (n2 & (n4 ^ n) ^ (n4 | n)) >>> 31;
    }

    public static void irpCasWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n == 60) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 4;
            if (((n2 = XEiJ.busRlse(n2)) & 0xE380E38) != 0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            int n3 = n2 >>> 16 & 7;
            int n4 = n2 & 7;
            int n5 = XEiJ.regRn[n2 >>> 28];
            int n6 = XEiJ.regRn[n2 >>> 12 & 0xF];
            int n7 = XEiJ.busRws(n5);
            int n8 = XEiJ.busRws(n6);
            short s = (short)XEiJ.regRn[n3];
            short s2 = (short)(n7 - s);
            if (s2 == 0) {
                s = (short)XEiJ.regRn[n4];
                XEiJ.regCCR = s2 >> 28 & 8 | ((s2 = (short)(n8 - s)) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n8 ^ s) & (n8 ^ s2)) >>> 31 << 1 | (n8 & (s ^ s2) ^ (s | s2)) >>> 31;
                if (s2 == 0) {
                    XEiJ.mpuCycleCount += 28;
                    XEiJ.busWw(n5, XEiJ.regRn[n2 >>> 22 & 7]);
                    XEiJ.busWw(n6, XEiJ.regRn[n2 >>> 6 & 7]);
                } else {
                    XEiJ.mpuCycleCount += 20;
                    XEiJ.regRn[n3] = 0xFFFF0000 & XEiJ.regRn[n3] | (char)n7;
                    XEiJ.regRn[n4] = 0xFFFF0000 & XEiJ.regRn[n4] | (char)n8;
                }
            } else {
                XEiJ.mpuCycleCount += 20;
                XEiJ.regCCR = s2 >> 28 & 8 | (s2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n7 ^ s) & (n7 ^ s2)) >>> 31 << 1 | (n7 & (s ^ s2) ^ (s | s2)) >>> 31;
                XEiJ.regRn[n3] = 0xFFFF0000 & XEiJ.regRn[n3] | (char)n7;
                XEiJ.regRn[n4] = 0xFFFF0000 & XEiJ.regRn[n4] | (char)n8;
            }
        } else {
            int n9 = XEiJ.regPC;
            XEiJ.regPC = n9 + 2;
            if (((n9 = XEiJ.busRwze(n9)) & 0xFFFFFE38) != 0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            int n10 = n9 & 7;
            short s = (short)XEiJ.regRn[n10];
            int n11 = MC68EC030.efaMltWord(n);
            int n12 = XEiJ.busRws(n11);
            short s3 = (short)(n12 - s);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s3 < 0 ? 8 : 0) | (s3 == 0 ? 4 : 0) | ((n12 ^ s) & (n12 ^ s3)) >>> 31 << 1 | (n12 & (s ^ s3) ^ (s | s3)) >>> 31;
            if (s3 == 0) {
                XEiJ.mpuCycleCount += 16;
                XEiJ.busWw(n11, XEiJ.regRn[n9 >> 6]);
            } else {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n10] = 0xFFFF0000 & XEiJ.regRn[n10] | (char)n12;
            }
        }
    }

    public static void irpMovesByte() throws M68kException {
        int n = XEiJ.busRwze((XEiJ.regPC += 2) - 2);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        int n2 = MC68EC030.efaMltByte(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuSFC == 1 || XEiJ.mpuSFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuSFC == 5 || XEiJ.mpuSFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 0;
                throw M68kException.m6eSignal;
            }
            XEiJ.regRn[n3] = n3 < 8 ? XEiJ.regRn[n3] & 0xFFFFFF00 | memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2) : (int)memoryMappedDeviceArray[n2 >>> 12].mmdRbs(n2);
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuDFC == 1 || XEiJ.mpuDFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuDFC == 5 || XEiJ.mpuDFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 0;
                throw M68kException.m6eSignal;
            }
            memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, XEiJ.regRn[n3]);
        }
    }

    public static void irpMovesWord() throws M68kException {
        int n = XEiJ.busRwze((XEiJ.regPC += 2) - 2);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        int n2 = MC68EC030.efaMltWord(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            int n4;
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuSFC == 1 || XEiJ.mpuSFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuSFC == 5 || XEiJ.mpuSFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 1;
                throw M68kException.m6eSignal;
            }
            if ((n2 & 1) == 0) {
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
            } else {
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2) << 8;
                n4 |= memoryMappedDeviceArray[++n2 >>> 12].mmdRbz(n2);
            }
            XEiJ.regRn[n3] = n3 < 8 ? XEiJ.regRn[n3] & 0xFFFF0000 | n4 : (int)((short)n4);
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuDFC == 1 || XEiJ.mpuDFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuDFC == 5 || XEiJ.mpuDFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 1;
                throw M68kException.m6eSignal;
            }
            int n5 = XEiJ.regRn[n3];
            if ((n2 & 1) == 0) {
                memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n5);
            } else {
                memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n5 >> 8);
                memoryMappedDeviceArray[++n2 >>> 12].mmdWb(n2, n5);
            }
        }
    }

    public static void irpMovesLong() throws M68kException {
        int n = XEiJ.busRwze((XEiJ.regPC += 2) - 2);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        int n2 = MC68EC030.efaMltLong(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            int n4;
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuSFC == 1 || XEiJ.mpuSFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuSFC == 5 || XEiJ.mpuSFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 2;
                throw M68kException.m6eSignal;
            }
            if ((n2 & 3) == 0) {
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRls(n2);
            } else if ((n2 & 1) == 0) {
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRws(n2) << 16;
                n4 |= memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdRwz(n2);
            } else {
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRbs(n2) << 24;
                n4 |= memoryMappedDeviceArray[++n2 >>> 12].mmdRwz(n2) << 8;
                n4 |= memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdRbz(n2);
            }
            XEiJ.regRn[n3] = n4;
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray;
            if (XEiJ.mpuDFC == 1 || XEiJ.mpuDFC == 2) {
                memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            } else if (XEiJ.mpuDFC == 5 || XEiJ.mpuDFC == 6) {
                memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            } else {
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 2;
                throw M68kException.m6eSignal;
            }
            int n5 = XEiJ.regRn[n3];
            if ((n2 & 3) == 0) {
                memoryMappedDeviceArray[n2 >>> 12].mmdWl(n2, n5);
            } else if ((n2 & 1) == 0) {
                memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n5 >> 16);
                memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdWw(n2, n5);
            } else {
                memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n5 >> 24);
                memoryMappedDeviceArray[++n2 >>> 12].mmdWw(n2, n5 >> 8);
                memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdWb(n2, n5);
            }
        }
    }

    public static void irpCasLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n == 60) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 4;
            if (((n2 = XEiJ.busRlse(n2)) & 0xE380E38) != 0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            int n3 = n2 >>> 16 & 7;
            int n4 = n2 & 7;
            int n5 = XEiJ.regRn[n2 >>> 28];
            int n6 = XEiJ.regRn[n2 >>> 12 & 0xF];
            int n7 = XEiJ.busRls(n5);
            int n8 = XEiJ.busRls(n6);
            int n9 = XEiJ.regRn[n3];
            int n10 = n7 - n9;
            if (n10 == 0) {
                n9 = XEiJ.regRn[n4];
                XEiJ.regCCR = n10 >> 28 & 8 | ((n10 = n8 - n9) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n8 ^ n9) & (n8 ^ n10)) >>> 31 << 1 | (n8 & (n9 ^ n10) ^ (n9 | n10)) >>> 31;
                if (n10 == 0) {
                    XEiJ.mpuCycleCount += 44;
                    XEiJ.busWl(n5, XEiJ.regRn[n2 >>> 22 & 7]);
                    XEiJ.busWl(n6, XEiJ.regRn[n2 >>> 6 & 7]);
                } else {
                    XEiJ.mpuCycleCount += 28;
                    XEiJ.regRn[n3] = n7;
                    XEiJ.regRn[n4] = n8;
                }
            } else {
                XEiJ.mpuCycleCount += 28;
                XEiJ.regCCR = n10 >> 28 & 8 | (n10 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n7 ^ n9) & (n7 ^ n10)) >>> 31 << 1 | (n7 & (n9 ^ n10) ^ (n9 | n10)) >>> 31;
                XEiJ.regRn[n3] = n7;
                XEiJ.regRn[n4] = n8;
            }
        } else {
            int n11 = XEiJ.regPC;
            XEiJ.regPC = n11 + 2;
            if (((n11 = XEiJ.busRwze(n11)) & 0xFFFFFE38) != 0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            int n12 = n11 & 7;
            int n13 = XEiJ.regRn[n12];
            int n14 = MC68EC030.efaMltLong(n);
            int n15 = XEiJ.busRls(n14);
            int n16 = n15 - n13;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n16 < 0 ? 8 : 0) | (n16 == 0 ? 4 : 0) | ((n15 ^ n13) & (n15 ^ n16)) >>> 31 << 1 | (n15 & (n13 ^ n16) ^ (n13 | n16)) >>> 31;
            if (n16 == 0) {
                XEiJ.mpuCycleCount += 24;
                XEiJ.busWl(n14, XEiJ.regRn[n11 >> 6]);
            } else {
                XEiJ.mpuCycleCount += 16;
                XEiJ.regRn[n12] = n15;
            }
        }
    }

    public static void irpMoveToDRByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        XEiJ.regRn[n2] = 0xFFFFFF00 & XEiJ.regRn[n2] | 0xFF & n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToMMByte() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        XEiJ.busWb(XEiJ.regRn[XEiJ.regOC >> 9], n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToMPByte() throws M68kException {
        int n;
        int n2;
        XEiJ.mpuCycleCount += 8;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = XEiJ.regOC >> 9;
        int n5 = n2 = n3 < 8 ? XEiJ.regRn[n3] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n3));
        if (n4 < 15) {
            int n6 = n4;
            int n7 = XEiJ.regRn[n6];
            n = n7;
            XEiJ.regRn[n6] = n7 + 1;
        } else {
            XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
            n = XEiJ.regRn[15] - 2;
        }
        XEiJ.busWb(n, n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToMNByte() throws M68kException {
        int n;
        int n2;
        XEiJ.mpuCycleCount += 8;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = XEiJ.regOC >> 9;
        int n5 = n2 = n3 < 8 ? XEiJ.regRn[n3] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n3));
        if (n4 < 15) {
            int n6 = n4;
            n = XEiJ.regRn[n6] = XEiJ.regRn[n6] - 1;
        } else {
            n = XEiJ.regRn[15] - 2;
        }
        XEiJ.busWb(n, n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToMWByte() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9;
        int n3 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        int n4 = XEiJ.regPC;
        XEiJ.regPC = n4 + 2;
        XEiJ.busWb(XEiJ.regRn[n2] + XEiJ.busRwse(n4), n3);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToMXByte() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 14;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9;
        int n4 = n2 < 8 ? XEiJ.regRn[n2] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n2));
        int n5 = XEiJ.regPC;
        XEiJ.regPC = n5 + 2;
        n5 = XEiJ.busRwze(n5);
        XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n5 & 0x1FF];
        int n6 = ((~n5 & 0x180) == 0 ? 0 : XEiJ.regRn[n3]) + (n5 << 23 >= 0 ? (byte)n5 : (n5 << 26 >= 0 ? (byte)0 : (n5 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
        int n7 = (~n5 & 0x140) == 0 ? 0 : (n = (n5 << 20 >= 0 ? (int)XEiJ.regRn[n5 >> 12] : XEiJ.regRn[n5 >> 12]) << (n5 >> 9 & 3));
        XEiJ.busWb((n5 & 0x103) <= 256 ? n6 + n : (n5 << 29 >= 0 ? XEiJ.busRls(n6 + n) : XEiJ.busRls(n6) + n) + ((n5 & 2) == 0 ? 0 : ((n5 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4))), n4);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n4];
    }

    public static void irpMoveToZWByte() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        XEiJ.busWb(XEiJ.busRwse(n3), n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToZLByte() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        XEiJ.busWb(XEiJ.busRlse(n3), n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToDRLong() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveaLong() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regRn[(XEiJ.regOC >> 9) - 8] = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
    }

    public static void irpMoveToMMLong() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        XEiJ.busWl(XEiJ.regRn[(XEiJ.regOC >> 9) - 8], n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMPLong() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = (XEiJ.regOC >> 9) - 8;
        int n4 = XEiJ.regRn[n3] + 4;
        XEiJ.regRn[n3] = n4;
        XEiJ.busWl(n4 - 4, n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMNLong() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = (XEiJ.regOC >> 9) - 8;
        int n4 = XEiJ.regRn[n3] - 4;
        XEiJ.regRn[n3] = n4;
        XEiJ.busWl(n4, n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMWLong() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        XEiJ.busWl(XEiJ.regRn[(XEiJ.regOC >> 9) - 8] + XEiJ.busRwse(n3), n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMXLong() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 18;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = (XEiJ.regOC >> 9) - 8;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : XEiJ.busRls(MC68EC030.efaAnyLong(n2));
        int n5 = XEiJ.regPC;
        XEiJ.regPC = n5 + 2;
        n5 = XEiJ.busRwze(n5);
        XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n5 & 0x1FF];
        int n6 = ((~n5 & 0x180) == 0 ? 0 : XEiJ.regRn[n3]) + (n5 << 23 >= 0 ? (byte)n5 : (n5 << 26 >= 0 ? (byte)0 : (n5 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
        int n7 = (~n5 & 0x140) == 0 ? 0 : (n = (n5 << 20 >= 0 ? (int)XEiJ.regRn[n5 >> 12] : XEiJ.regRn[n5 >> 12]) << (n5 >> 9 & 3));
        XEiJ.busWl((n5 & 0x103) <= 256 ? n6 + n : (n5 << 29 >= 0 ? XEiJ.busRls(n6 + n) : XEiJ.busRls(n6) + n) + ((n5 & 2) == 0 ? 0 : ((n5 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4))), n4);
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToZWLong() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        XEiJ.busWl(XEiJ.busRwse(n3), n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToZLLong() throws M68kException {
        XEiJ.mpuCycleCount += 20;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        XEiJ.busWl(XEiJ.busRlse(n3), n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToDRWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        XEiJ.regRn[n2] = 0xFFFF0000 & XEiJ.regRn[n2] | (char)n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
    }

    public static void irpMoveaWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regRn[XEiJ.regOC >> 9 & 0xF] = n < 16 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
    }

    public static void irpMoveToMMWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        XEiJ.busWw(XEiJ.regRn[XEiJ.regOC >> 9 & 0xF], n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMPWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        int n4 = XEiJ.regRn[n3] + 2;
        XEiJ.regRn[n3] = n4;
        XEiJ.busWw(n4 - 2, n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMNWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        int n4 = XEiJ.regRn[n3] - 2;
        XEiJ.regRn[n3] = n4;
        XEiJ.busWw(n4, n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMWWord() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 0xF;
        int n3 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n4 = XEiJ.regPC;
        XEiJ.regPC = n4 + 2;
        XEiJ.busWw(XEiJ.regRn[n2] + XEiJ.busRwse(n4), n3);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
    }

    public static void irpMoveToMXWord() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 14;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 0xF;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : XEiJ.busRws(MC68EC030.efaAnyWord(n2));
        int n5 = XEiJ.regPC;
        XEiJ.regPC = n5 + 2;
        n5 = XEiJ.busRwze(n5);
        XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n5 & 0x1FF];
        int n6 = ((~n5 & 0x180) == 0 ? 0 : XEiJ.regRn[n3]) + (n5 << 23 >= 0 ? (byte)n5 : (n5 << 26 >= 0 ? (byte)0 : (n5 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
        int n7 = (~n5 & 0x140) == 0 ? 0 : (n = (n5 << 20 >= 0 ? (int)XEiJ.regRn[n5 >> 12] : XEiJ.regRn[n5 >> 12]) << (n5 >> 9 & 3));
        XEiJ.busWw((n5 & 0x103) <= 256 ? n6 + n : (n5 << 29 >= 0 ? XEiJ.busRls(n6 + n) : XEiJ.busRls(n6) + n) + ((n5 & 2) == 0 ? 0 : ((n5 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4))), n4);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n4 - '\u0001' >> 31 & 4 | ((short)n4 < 0 ? 8 : 0);
    }

    public static void irpMoveToZWWord() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        XEiJ.busWw(XEiJ.busRwse(n3), n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToZLWord() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 4;
        XEiJ.busWw(XEiJ.busRlse(n3), n2);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpNegxByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & -by2 - (XEiJ.regCCR >> 4);
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n4 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n4);
            n = by3;
            by = (byte)(-by3 - (XEiJ.regCCR >> 4));
            XEiJ.busWb(n4, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 4 : 0) | (n & by) >>> 31 << 1 | (n | by) >> 31 & 0x11;
    }

    public static void irpNegxWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n3 | (char)(-s2 - (XEiJ.regCCR >> 4));
            s = (short)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n4 = MC68EC030.efaMltWord(n2);
            n = XEiJ.busRws(n4);
            s = (short)(-n - (XEiJ.regCCR >> 4));
            XEiJ.busWw(n4, s);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 4 : 0) | (n & s) >>> 31 << 1 | (n | s) >> 31 & 0x11;
    }

    public static void irpNegxLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        if (n3 < 8) {
            XEiJ.mpuCycleCount += 6;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = -n2 - (XEiJ.regCCR >> 4);
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltLong(n3);
            n2 = XEiJ.busRls(n4);
            n = -n2 - (XEiJ.regCCR >> 4);
            XEiJ.busWl(n4, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 4 : 0) | (n2 & n) >>> 31 << 1 | (n2 | n) >> 31 & 0x11;
    }

    public static void irpMoveFromSR() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 6;
            XEiJ.regRn[n] = 0xFFFF0000 & XEiJ.regRn[n] | XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWw(MC68EC030.efaMltWord(n), XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR);
        }
    }

    public static void irpChkLong() throws M68kException {
        XEiJ.mpuCycleCount += 14;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        int n4 = n2 - n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n3 < 0 ? 8 : 0) | (n3 == 0 ? 4 : 0) | ((n2 ^ n3) & (n2 ^ n4)) >>> 31 << 1 | (n2 & (n3 ^ n4) ^ (n3 | n4)) >>> 31;
        if (n3 < 0 || n2 < n3) {
            XEiJ.mpuCycleCount += -8;
            M68kException.m6eAddress = XEiJ.regPC0;
            M68kException.m6eNumber = 6;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpChkWord() throws M68kException {
        XEiJ.mpuCycleCount += 10;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        short s = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        short s2 = (short)(n2 - s);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | ((n2 ^ s) & (n2 ^ s2)) >>> 31 << 1 | (n2 & (s ^ s2) ^ (s | s2)) >>> 31;
        if (s < 0 || n2 < s) {
            XEiJ.mpuCycleCount += -4;
            M68kException.m6eAddress = XEiJ.regPC0;
            M68kException.m6eNumber = 6;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpLea() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            byte by = (byte)XEiJ.regRn[n];
            XEiJ.regRn[n] = by;
            XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            XEiJ.regRn[(XEiJ.regOC >> 9) - 24] = MC68EC030.efaLeaPea(n);
        }
    }

    public static void irpClrByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFFFF00;
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpClrWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFF0000;
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWw(MC68EC030.efaMltWord(n), 0);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpClrLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 6;
            XEiJ.regRn[n] = 0;
        } else {
            XEiJ.mpuCycleCount += 12;
            XEiJ.busWl(MC68EC030.efaMltLong(n), 0);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpMoveFromCCR() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            XEiJ.regRn[n] = 0xFFFF0000 & XEiJ.regRn[n] | XEiJ.regCCR;
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWw(MC68EC030.efaMltWord(n), XEiJ.regCCR);
        }
    }

    public static void irpNegByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & -by2;
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n4 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n4);
            n = by3;
            by = -by3;
            XEiJ.busWb(n4, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (n & by) >>> 31 << 1 | (n | by) >> 31 & 0x11;
    }

    public static void irpNegWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n3 | (char)(-s2);
            s = (short)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n4 = MC68EC030.efaMltWord(n2);
            n = XEiJ.busRws(n4);
            s = (short)(-n);
            XEiJ.busWw(n4, s);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (n & s) >>> 31 << 1 | (n | s) >> 31 & 0x11;
    }

    public static void irpNegLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        if (n3 < 8) {
            XEiJ.mpuCycleCount += 6;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = -n2;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltLong(n3);
            n2 = XEiJ.busRls(n4);
            n = -n2;
            XEiJ.busWl(n4, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | (n2 & n) >>> 31 << 1 | (n2 | n) >> 31 & 0x11;
    }

    public static void irpMoveToCCR() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regCCR = 0x1F & (n < 8 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n)));
    }

    public static void irpNotByte() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = n2;
            int n4 = XEiJ.regRn[n3] ^ 0xFF;
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            XEiJ.mpuCycleCount += 8;
            int n5 = MC68EC030.efaMltByte(n2);
            n = ~XEiJ.busRbs(n5);
            XEiJ.busWb(n5, n);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n];
    }

    public static void irpNotWord() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n3 = n2;
            int n4 = XEiJ.regRn[n3] ^ 0xFFFF;
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            XEiJ.mpuCycleCount += 8;
            int n5 = MC68EC030.efaMltWord(n2);
            n = ~XEiJ.busRws(n5);
            XEiJ.busWw(n5, n);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n - '\u0001' >> 31 & 4 | ((short)n < 0 ? 8 : 0);
    }

    public static void irpNotLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 6;
            int n3 = n2;
            int n4 = ~XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n5 = MC68EC030.efaMltLong(n2);
            n = ~XEiJ.busRls(n5);
            XEiJ.busWl(n5, n);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToSR() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        MC68EC030.irpSetSR(n < 8 ? XEiJ.regRn[n] : XEiJ.busRwz(MC68EC030.efaAnyWord(n)));
    }

    public static void irpNbcd() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 6;
            XEiJ.regRn[n] = 0xFFFFFF00 & XEiJ.regRn[n] | MC68EC030.irpSbcd(0, XEiJ.regRn[n]);
        } else if (n < 16) {
            XEiJ.mpuCycleCount += 20;
            int n2 = XEiJ.regOC - 18432;
            int n3 = XEiJ.regRn[15] - 4;
            XEiJ.busWl(n3, XEiJ.regRn[n2]);
            int n4 = XEiJ.regPC;
            XEiJ.regPC = n4 + 4;
            XEiJ.regRn[n2] = n3;
            XEiJ.regRn[15] = XEiJ.regRn[n2] + XEiJ.busRlse(n4);
        } else {
            XEiJ.mpuCycleCount += 8;
            int n5 = MC68EC030.efaMltByte(n);
            XEiJ.busWb(n5, MC68EC030.irpSbcd(0, XEiJ.busRbs(n5)));
        }
    }

    public static void irpPea() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2;
            XEiJ.mpuCycleCount += 4;
            int n3 = XEiJ.regRn[n];
            XEiJ.regRn[n] = n2 = n3 << 16 | n3 >>> 16;
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            XEiJ.mpuCycleCount += 8;
            int n4 = MC68EC030.efaLeaPea(n);
            XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
            XEiJ.busWl(XEiJ.regRn[15], n4);
        }
    }

    public static void irpMovemToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = XEiJ.regRn[n];
            int n3 = n2;
            byte by = (byte)n3;
            n3 = by;
            XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)by;
            XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n4 = XEiJ.busRwze(XEiJ.regPC);
            XEiJ.regPC += 2;
            if (n >> 3 == 4) {
                int n5 = n - 24;
                int n6 = XEiJ.regRn[n5];
                XEiJ.regRn[n5] = n6 - 2;
                int n7 = n6;
                int n8 = 15;
                while (n4 != 0) {
                    if ((n4 & 1) != 0) {
                        XEiJ.busWw(n6 -= 2, XEiJ.regRn[n8]);
                    }
                    --n8;
                    n4 >>>= 1;
                }
                XEiJ.regRn[n5] = n6;
                XEiJ.mpuCycleCount += 8 + (n7 - n6 << 1);
            } else {
                int n9;
                int n10 = n9 = MC68EC030.efaCltWord(n);
                int n11 = 0;
                while (n4 != 0) {
                    if ((n4 & 1) != 0) {
                        XEiJ.busWw(n9, XEiJ.regRn[n11]);
                        n9 += 2;
                    }
                    ++n11;
                    n4 >>>= 1;
                }
                XEiJ.mpuCycleCount += 4 + (n9 - n10 << 1);
            }
        }
    }

    public static void irpMovemToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            short s = (short)XEiJ.regRn[n];
            XEiJ.regRn[n] = s;
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n2 = XEiJ.busRwze(XEiJ.regPC);
            XEiJ.regPC += 2;
            if (n >> 3 == 4) {
                int n3 = n - 24;
                int n4 = XEiJ.regRn[n3];
                XEiJ.regRn[n3] = n4 - 4;
                int n5 = n4;
                int n6 = 15;
                while (n2 != 0) {
                    if ((n2 & 1) != 0) {
                        XEiJ.busWl(n4 -= 4, XEiJ.regRn[n6]);
                    }
                    --n6;
                    n2 >>>= 1;
                }
                XEiJ.regRn[n3] = n4;
                XEiJ.mpuCycleCount += 8 + (n5 - n4 << 1);
            } else {
                int n7;
                int n8 = n7 = MC68EC030.efaCltLong(n);
                int n9 = 0;
                while (n2 != 0) {
                    if ((n2 & 1) != 0) {
                        XEiJ.busWl(n7, XEiJ.regRn[n9]);
                        n7 += 4;
                    }
                    ++n9;
                    n2 >>>= 1;
                }
                XEiJ.mpuCycleCount += 4 + (n7 - n8 << 1);
            }
        }
    }

    public static void irpTstByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & (n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n)))];
    }

    public static void irpTstWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpTstLong() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpTas() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            n = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = 0x80 | n;
        } else {
            XEiJ.mpuCycleCount += 14;
            int n3 = MC68EC030.efaMltByte(n2);
            byte by = XEiJ.busRbs(n3);
            n = by;
            XEiJ.busWb(n3, 0x80 | by);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n];
    }

    public static void irpMuluMulsLong() throws M68kException {
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        if (((n = XEiJ.busRwze(n)) & 0xFFFF83F8) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n2 = n >> 12;
        int n3 = n & 0x800;
        int n4 = n & 0x400;
        int n5 = n & 7;
        XEiJ.mpuCycleCount += 72;
        int n6 = XEiJ.regOC & 0x3F;
        long l = n6 < 8 ? XEiJ.regRn[n6] : XEiJ.busRls(MC68EC030.efaAnyLong(n6));
        long l2 = XEiJ.regRn[n2];
        if (n3 == 0) {
            long l3 = (0xFFFFFFFFL & l2) * (0xFFFFFFFFL & l);
            int n7 = XEiJ.regRn[n2] = (int)l3;
            if (n4 == 0) {
                XEiJ.regCCR = n7 >> 28 & 8 | (n7 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | (l3 >>> 32 != 0L ? 2 : 0);
            } else {
                XEiJ.regRn[n5] = (int)(l3 >>> 32);
                XEiJ.regCCR = XEiJ.regCCR & 0x10 | (l3 > 0L ? 0 : (l3 < 0L ? 8 : 4));
            }
        } else {
            long l4 = l2 * l;
            int n8 = XEiJ.regRn[n2] = (int)l4;
            if (n4 == 0) {
                XEiJ.regCCR = n8 >> 28 & 8 | (n8 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((long)n8 != l4 ? 2 : 0);
            } else {
                XEiJ.regRn[n5] = (int)(l4 >> 32);
                XEiJ.regCCR = XEiJ.regCCR & 0x10 | (l4 > 0L ? 0 : (l4 < 0L ? 8 : 4));
            }
        }
        m30DivZeroVFlag = false;
    }

    public static void irpDivuDivsLong() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0xFFFF83F8) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 & 0x800;
        int n5 = n2 & 0x400;
        int n6 = n2 & 7;
        int n7 = XEiJ.regOC & 0x3F;
        int n8 = n = n7 < 8 ? XEiJ.regRn[n7] : XEiJ.busRls(MC68EC030.efaAnyLong(n7));
        if (n4 == 0) {
            XEiJ.mpuCycleCount += 130;
            long l = (long)n & 0xFFFFFFFFL;
            if (n5 == 0) {
                if (n == 0) {
                    int n9;
                    long l2;
                    XEiJ.regCCR = n6 == n3 ? XEiJ.regCCR & 0x10 | ((l2 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL) < 0L ? 8 : 0) | (l2 == 0L ? 4 : 0) | (m30DivZeroVFlag ? 2 : 0) : XEiJ.regCCR & 0x10 | ((n9 = XEiJ.regRn[n3]) < 0 ? 8 : 0) | (n9 == 0 ? 4 : 0) | (m30DivZeroVFlag ? 2 : 0);
                    XEiJ.mpuCycleCount += 4;
                    M68kException.m6eAddress = XEiJ.regPC0;
                    M68kException.m6eNumber = 5;
                    throw M68kException.m6eSignal;
                }
                long l3 = (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                long l4 = (long)((double)l3 / (double)l);
                int n10 = XEiJ.regRn[n3] = (int)l4;
                if (n6 != n3) {
                    XEiJ.regRn[n6] = (int)(l3 - l * l4);
                }
                XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n10 < 0 ? 8 : 0) | (n10 == 0 ? 4 : 0);
            } else {
                if (n == 0) {
                    long l5 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | ((int)l5 < 0 && (int)l5 != Integer.MAX_VALUE || (int)l5 == Integer.MIN_VALUE ? 8 : 0) | ((int)l5 == 0 ? 4 : 0) | (m30DivZeroVFlag ? 2 : 0);
                    XEiJ.mpuCycleCount += 4;
                    M68kException.m6eAddress = XEiJ.regPC0;
                    M68kException.m6eNumber = 5;
                    throw M68kException.m6eSignal;
                }
                long l6 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                long l7 = Long.divideUnsigned(l6, l);
                int n11 = (int)l7;
                if (l7 >>> 32 != 0L) {
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | ((int)l6 < 0 ? 8 : 0) | ((int)l6 == 0 ? 4 : 0) | 2;
                } else {
                    XEiJ.regRn[n3] = (int)l7;
                    if (n6 != n3) {
                        XEiJ.regRn[n6] = (int)(l6 - l * l7);
                    }
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n11 < 0 ? 8 : 0) | (n11 == 0 ? 4 : 0);
                }
            }
        } else {
            XEiJ.mpuCycleCount += 150;
            if (n5 == 0) {
                long l = n;
                if (n == 0) {
                    long l8 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                    XEiJ.regCCR = n6 == n3 ? XEiJ.regCCR & 0x10 | 4 | (m30DivZeroVFlag ? 2 : 0) : XEiJ.regCCR & 0x10 | 4 | (m30DivZeroVFlag ? 2 : 0);
                    XEiJ.mpuCycleCount += 4;
                    M68kException.m6eAddress = XEiJ.regPC0;
                    M68kException.m6eNumber = 5;
                    throw M68kException.m6eSignal;
                }
                long l9 = XEiJ.regRn[n3];
                long l10 = l9 / l;
                if ((long)((int)l10) != l10) {
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (l9 == Integer.MIN_VALUE && n == -1 ? 4 : 0) | 2;
                } else {
                    int n12 = XEiJ.regRn[n3] = (int)l10;
                    if (n6 != n3) {
                        XEiJ.regRn[n6] = (int)(l9 - l * l10);
                    }
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n12 < 0 ? 8 : 0) | (n12 == 0 ? 4 : 0);
                }
            } else {
                long l = n;
                if (n == 0) {
                    long l11 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4 | (m30DivZeroVFlag ? 2 : 0);
                    XEiJ.mpuCycleCount += 4;
                    M68kException.m6eAddress = XEiJ.regPC0;
                    M68kException.m6eNumber = 5;
                    throw M68kException.m6eSignal;
                }
                long l12 = (long)XEiJ.regRn[n6] << 32 | (long)XEiJ.regRn[n3] & 0xFFFFFFFFL;
                long l13 = l12 / l;
                if ((long)((int)l13) != l13) {
                    int n13 = (int)(l13 >> 32);
                    int n14 = (int)l13;
                    int n15 = (int)(l12 >> 32);
                    int n16 = (int)l12;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | ((n13 == 0 || n13 == -1) && n14 != 0 ? (n14 << 24 < 0 ? 8 : 0) | (n14 << 24 == 0 ? 4 : 0) : (n16 == Integer.MIN_VALUE || n15 == Integer.MIN_VALUE && n16 != 0 || n16 == Integer.MAX_VALUE && n15 != Integer.MAX_VALUE || n15 == Integer.MAX_VALUE && n16 != Integer.MAX_VALUE || n16 == -1 && 0 <= n15 ? 8 : 0) | (n16 == 0 ? 4 : 0)) | 2;
                } else {
                    int n17 = XEiJ.regRn[n3] = (int)l13;
                    if (n6 != n3) {
                        XEiJ.regRn[n6] = (int)(l12 - l * l13);
                    }
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n17 < 0 ? 8 : 0) | (n17 == 0 ? 4 : 0);
                }
            }
        }
        m30DivZeroVFlag = false;
    }

    public static void irpMovemToRegWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = XEiJ.regRn[n];
            if ((XEiJ.regCCR & 2) != 0) {
                XEiJ.regRn[n] = n2 = n2 >> 31 ^ Integer.MIN_VALUE;
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n3;
            int n4 = XEiJ.busRwze(XEiJ.regPC);
            XEiJ.regPC += 2;
            if (n >> 3 == 3) {
                XEiJ.mpuCycleCount += 12;
                var2_3 = n - 16;
                n3 = XEiJ.regRn[var2_3];
            } else {
                XEiJ.mpuCycleCount += 8;
                var2_3 = 16;
                n3 = MC68EC030.efaCntWord(n);
            }
            int n5 = n3;
            int n6 = 0;
            while (n4 != 0) {
                if ((n4 & 1) != 0) {
                    XEiJ.regRn[n6] = XEiJ.busRws(n3);
                    n3 += 2;
                }
                ++n6;
                n4 >>>= 1;
            }
            XEiJ.regRn[var2_3] = n3;
            XEiJ.mpuCycleCount += n3 - n5 << 1;
        }
    }

    public static void irpMovemToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.busRwze(XEiJ.regPC);
        XEiJ.regPC += 2;
        if (n2 >> 3 == 3) {
            XEiJ.mpuCycleCount += 12;
            var2_2 = n2 - 16;
            n = XEiJ.regRn[var2_2];
        } else {
            XEiJ.mpuCycleCount += 8;
            var2_2 = 16;
            n = MC68EC030.efaCntLong(n2);
        }
        int n4 = n;
        int n5 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                XEiJ.regRn[n5] = XEiJ.busRls(n);
                n += 4;
            }
            ++n5;
            n3 >>>= 1;
        }
        XEiJ.regRn[var2_2] = n;
        XEiJ.mpuCycleCount += n - n4 << 1;
    }

    public static void irpTrap() throws M68kException {
        XEiJ.mpuCycleCount += 34;
        int n = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        int n2 = XEiJ.regRn[15];
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n2;
            n2 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n2 -= 8;
        XEiJ.busWw(n2 + 6, 0 | XEiJ.regOC - 20000 << 2);
        XEiJ.busWl(n2 + 2, XEiJ.regPC);
        XEiJ.busWw(n2, n);
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + (XEiJ.regOC - 20000 << 2)));
    }

    public static void irpTrap15() throws M68kException {
        if ((XEiJ.regRn[0] & 0xFF) == 142) {
            MainMemory.mmrCheckHuman();
        }
        XEiJ.mpuCycleCount += 34;
        int n = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        int n2 = XEiJ.regRn[15];
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n2;
            n2 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n2 -= 8;
        XEiJ.busWw(n2 + 6, 47);
        XEiJ.busWl(n2 + 2, XEiJ.regPC);
        XEiJ.busWw(n2, n);
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + 188));
    }

    public static void irpLinkWord() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regOC - 20040;
        int n2 = XEiJ.regRn[15] - 4;
        XEiJ.busWl(n2, XEiJ.regRn[n]);
        int n3 = XEiJ.regPC;
        XEiJ.regPC = n3 + 2;
        XEiJ.regRn[n] = n2;
        XEiJ.regRn[15] = XEiJ.regRn[n] + XEiJ.busRwse(n3);
    }

    public static void irpUnlk() throws M68kException {
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC - 20048;
        int n2 = XEiJ.regRn[n];
        XEiJ.regRn[15] = n2 + 4;
        XEiJ.regRn[n] = XEiJ.busRls(n2);
    }

    public static void irpMoveToUsp() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        XEiJ.mpuUSP = XEiJ.regRn[XEiJ.regOC - 20056];
    }

    public static void irpMoveFromUsp() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        XEiJ.regRn[XEiJ.regOC - 20064] = XEiJ.mpuUSP;
    }

    public static void irpReset() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 132;
        XEiJ.irpReset();
    }

    public static void irpNop() throws M68kException {
        XEiJ.mpuCycleCount += 4;
    }

    public static void irpStop() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 4;
        MC68EC030.irpSetSR(XEiJ.busRwse((XEiJ.regPC += 2) - 2));
        if (XEiJ.mpuTraceFlag == 0) {
            XEiJ.regPC = XEiJ.regPC0;
            XEiJ.mpuClockTime += 4000000L;
            XEiJ.mpuLastNano += 4000L;
        }
    }

    public static void irpRte() throws M68kException {
        int n;
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 20;
        int n2 = XEiJ.busRws((n = XEiJ.regRn[15]) + 6) & 0xF000;
        XEiJ.regRn[15] = n + (n2 == 0 ? 8 : (n2 == 4096 ? 8 : (n2 == 8192 ? 12 : (n2 == 36864 ? 20 : (n2 == 40960 ? 32 : (n2 == 45056 ? 92 : 8))))));
        int n3 = XEiJ.busRwz(n);
        int n4 = XEiJ.busRls(n + 2);
        MC68EC030.irpSetSR(n3);
        MC68EC030.irpSetPC(n4);
        if (n2 == 4096) {
            n2 = XEiJ.busRws((n = XEiJ.regRn[15]) + 6) & 0xF000;
            XEiJ.regRn[15] = n + (n2 == 0 ? 8 : (n2 == 4096 ? 8 : (n2 == 8192 ? 12 : (n2 == 36864 ? 20 : (n2 == 40960 ? 32 : (n2 == 45056 ? 92 : 8))))));
            n3 = XEiJ.busRwz(n);
            n4 = XEiJ.busRlse(n + 2);
            MC68EC030.irpSetSR(n3);
            MC68EC030.irpSetPC(n4);
        }
    }

    public static void irpRtd() throws M68kException {
        XEiJ.mpuCycleCount += 20;
        int n = XEiJ.regRn[15];
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        XEiJ.regRn[15] = n + 4 + XEiJ.busRwse(n2);
        MC68EC030.irpSetPC(XEiJ.busRls(n));
    }

    public static void irpRts() throws M68kException {
        XEiJ.mpuCycleCount += 16;
        int n = XEiJ.regRn[15];
        XEiJ.regRn[15] = n + 4;
        MC68EC030.irpSetPC(XEiJ.busRls(n));
    }

    public static void irpTrapv() throws M68kException {
        if ((XEiJ.regCCR & 2) == 0) {
            XEiJ.mpuCycleCount += 4;
        } else {
            M68kException.m6eAddress = XEiJ.regPC0;
            M68kException.m6eNumber = 7;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpRtr() throws M68kException {
        XEiJ.mpuCycleCount += 20;
        int n = XEiJ.regRn[15];
        XEiJ.regRn[15] = n + 6;
        XEiJ.regCCR = 0x1F & XEiJ.busRwz(n);
        MC68EC030.irpSetPC(XEiJ.busRls(n + 2));
    }

    public static void irpMovecFromControl() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 10;
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        n = XEiJ.busRwze(n);
        switch (n & 0xFFF) {
            case 0: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuSFC;
                break;
            }
            case 1: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuDFC;
                break;
            }
            case 2: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuCACR;
                break;
            }
            case 2048: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuUSP;
                break;
            }
            case 2049: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuVBR;
                break;
            }
            case 2050: {
                XEiJ.regRn[n >> 12] = XEiJ.mpuCAAR;
                break;
            }
            case 2051: {
                XEiJ.regRn[n >> 12] = XEiJ.regSRM != 0 ? XEiJ.regRn[15] : XEiJ.mpuMSP;
                break;
            }
            case 2052: {
                XEiJ.regRn[n >> 12] = XEiJ.regSRM != 0 ? XEiJ.mpuISP : XEiJ.regRn[15];
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpMovecToControl() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        n = XEiJ.busRwze(n);
        int n2 = XEiJ.regRn[n >> 12];
        switch (n & 0xFFF) {
            case 0: {
                XEiJ.mpuSFC = n2 & 7;
                break;
            }
            case 1: {
                XEiJ.mpuDFC = n2 & 7;
                break;
            }
            case 2: {
                boolean bl;
                XEiJ.mpuCACR = n2 & 0x3F1F;
                boolean bl2 = bl = (XEiJ.mpuCACR & 0x101) != 0;
                if (XEiJ.mpuCacheOn == bl) break;
                XEiJ.mpuCacheOn = bl;
                XEiJ.mpuSetWait();
                break;
            }
            case 2048: {
                XEiJ.mpuUSP = n2;
                break;
            }
            case 2049: {
                XEiJ.mpuVBR = n2 & 0xFFFFFFFC;
                break;
            }
            case 2050: {
                XEiJ.mpuCAAR = n2;
                break;
            }
            case 2051: {
                if (XEiJ.regSRM != 0) {
                    XEiJ.regRn[15] = n2;
                    break;
                }
                XEiJ.mpuMSP = n2;
                break;
            }
            case 2052: {
                if (XEiJ.regSRM != 0) {
                    XEiJ.mpuISP = n2;
                    break;
                }
                XEiJ.regRn[15] = n2;
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpJsr() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = MC68EC030.efaJmpJsr(XEiJ.regOC & 0x3F);
        XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        XEiJ.busWl(XEiJ.regRn[15], XEiJ.regPC);
        MC68EC030.irpSetPC(n);
    }

    public static void irpJmp() throws M68kException {
        MC68EC030.irpSetPC(MC68EC030.efaJmpJsr(XEiJ.regOC & 0x3F));
    }

    public static void irpAddqByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 + n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n5 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n5);
            n = by3;
            by = (byte)(by3 + n3);
            XEiJ.busWb(n5, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (~n & by) >>> 31 << 1 | (n & ~by) >> 31 & 0x11;
    }

    public static void irpAddqWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
        } else {
            short s;
            int n4;
            if (n < 8) {
                XEiJ.mpuCycleCount += 4;
                int n5 = XEiJ.regRn[n];
                n4 = n5;
                short s2 = (short)n4;
                n4 = s2;
                XEiJ.regRn[n] = 0xFFFF0000 & n5 | (char)(s2 + n2);
                s = (short)XEiJ.regRn[n];
            } else {
                XEiJ.mpuCycleCount += 8;
                int n6 = MC68EC030.efaMltWord(n);
                n4 = XEiJ.busRws(n6);
                s = (short)(n4 + n2);
                XEiJ.busWw(n6, s);
            }
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (~n4 & s) >>> 31 << 1 | (n4 & ~s) >> 31 & 0x11;
        }
    }

    public static void irpAddqLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
        } else {
            int n4;
            int n5;
            if (n < 8) {
                XEiJ.mpuCycleCount += 8;
                n5 = XEiJ.regRn[n];
                XEiJ.regRn[n] = n4 = n5 + n2;
            } else {
                XEiJ.mpuCycleCount += 12;
                int n6 = MC68EC030.efaMltLong(n);
                n5 = XEiJ.busRls(n6);
                n4 = n5 + n2;
                XEiJ.busWl(n6, n4);
            }
            XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? 4 : 0) | (~n5 & n4) >>> 31 << 1 | (n5 & ~n4) >> 31 & 0x11;
        }
    }

    public static void irpSt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 6;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] | 0xFF;
        } else if (n < 16) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else {
            if (56L << n < 0L) {
                int n3 = (n & 3) + (n & 1);
                XEiJ.regPC += n3;
                XEiJ.mpuCycleCount += n3 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 255);
        }
    }

    public static void irpSubqByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 4;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 - n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += 8;
            int n5 = MC68EC030.efaMltByte(n2);
            byte by3 = XEiJ.busRbs(n5);
            n = by3;
            by = (byte)(by3 - n3);
            XEiJ.busWb(n5, by);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (n & ~by) >>> 31 << 1 | (~n & by) >> 31 & 0x11;
    }

    public static void irpSubqWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
        } else {
            short s;
            int n4;
            if (n < 8) {
                XEiJ.mpuCycleCount += 4;
                int n5 = XEiJ.regRn[n];
                n4 = n5;
                short s2 = (short)n4;
                n4 = s2;
                XEiJ.regRn[n] = 0xFFFF0000 & n5 | (char)(s2 - n2);
                s = (short)XEiJ.regRn[n];
            } else {
                XEiJ.mpuCycleCount += 8;
                int n6 = MC68EC030.efaMltWord(n);
                n4 = XEiJ.busRws(n6);
                s = (short)(n4 - n2);
                XEiJ.busWw(n6, s);
            }
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (n4 & ~s) >>> 31 << 1 | (~n4 & s) >> 31 & 0x11;
        }
    }

    public static void irpSubqLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 8;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
        } else {
            int n4;
            int n5;
            if (n < 8) {
                XEiJ.mpuCycleCount += 8;
                n5 = XEiJ.regRn[n];
                XEiJ.regRn[n] = n4 = n5 - n2;
            } else {
                XEiJ.mpuCycleCount += 12;
                int n6 = MC68EC030.efaMltLong(n);
                n5 = XEiJ.busRls(n6);
                n4 = n5 - n2;
                XEiJ.busWl(n6, n4);
            }
            XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? 4 : 0) | (n5 & ~n4) >>> 31 << 1 | (~n5 & n4) >> 31 & 0x11;
        }
    }

    public static void irpSf() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            XEiJ.mpuCycleCount += 4;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFFFF00;
        } else if (n < 16) {
            int n3 = XEiJ.regOC & 7;
            int n4 = XEiJ.regRn[n3];
            if ((short)n4 == 0) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regRn[n3] = n4 + 65535;
                XEiJ.regPC += 2;
            } else {
                XEiJ.mpuCycleCount += 10;
                XEiJ.regRn[n3] = n4 - 1;
                MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (56L << n < 0L) {
            int n5 = (n & 3) + (n & 1);
            XEiJ.regPC += n5;
            XEiJ.mpuCycleCount += 4 + (n5 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0);
        }
    }

    public static void irpShi() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-1600085856 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-1600085856 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-1600085856 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -1600085856 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSls() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0x5F5F5F5F << XEiJ.regCCR >> 31);
        }
    }

    public static void irpShs() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-1431655766 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-1431655766 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-1431655766 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -1431655766 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSlo() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0x55555555 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0x55555555 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0x55555555 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0x55555555 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSne() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-252645136 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-252645136 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-252645136 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -252645136 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSeq() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0xF0F0F0F << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSvc() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-858993460 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-858993460 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-858993460 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -858993460 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSvs() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0x33333333 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0x33333333 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0x33333333 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0x33333333 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSpl() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-16711936 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-16711936 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-16711936 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -16711936 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSmi() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0xFF00FF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0xFF00FF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0xFF00FF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0xFF00FF << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSge() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-869020621 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-869020621 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-869020621 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -869020621 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSlt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0x33CC33CC << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSgt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (-1070546896 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (-1070546896 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (-1070546896 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), -1070546896 << XEiJ.regCCR >> 31);
        }
    }

    public static void irpSle() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regPC += 2;
            } else {
                int n2 = XEiJ.regOC & 7;
                int n3 = XEiJ.regRn[n2];
                if ((short)n3 == 0) {
                    XEiJ.mpuCycleCount += 14;
                    XEiJ.regRn[n2] = n3 + 65535;
                    XEiJ.regPC += 2;
                } else {
                    XEiJ.mpuCycleCount += 10;
                    XEiJ.regRn[n2] = n3 - 1;
                    MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
                }
            }
            m30DivZeroVFlag = !m30DivZeroVFlag;
        } else if (n < 8) {
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 6;
                int n4 = n;
                XEiJ.regRn[n4] = XEiJ.regRn[n4] | 0xFF;
            } else {
                XEiJ.mpuCycleCount += 4;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            int n6 = (n & 3) + (n & 1);
            XEiJ.regPC += n6;
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += n6 << 1;
                M68kException.m6eAddress = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 4 + (n6 << 1);
        } else {
            XEiJ.mpuCycleCount += 8;
            XEiJ.busWb(MC68EC030.efaMltByte(n), 0x3FCF3FCF << XEiJ.regCCR >> 31);
        }
    }

    public static void irpBrasw() throws M68kException {
        XEiJ.mpuCycleCount += 10;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = XEiJ.busRwse(n);
        }
        MC68EC030.irpSetPC(n + n2);
    }

    public static void irpBras() throws M68kException {
        XEiJ.mpuCycleCount += 10;
        MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
    }

    public static void irpBrasl() throws M68kException {
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.mpuCycleCount += 14;
            XEiJ.regPC = n + 4;
            n2 = XEiJ.busRlse(n);
        } else {
            XEiJ.mpuCycleCount += 10;
        }
        MC68EC030.irpSetPC(n + n2);
    }

    public static void irpBsrsw() throws M68kException {
        XEiJ.mpuCycleCount += 18;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = XEiJ.busRwse(n);
        }
        XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        XEiJ.busWl(XEiJ.regRn[15], XEiJ.regPC);
        MC68EC030.irpSetPC(n + n2);
    }

    public static void irpBsrs() throws M68kException {
        XEiJ.mpuCycleCount += 18;
        XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        XEiJ.busWl(XEiJ.regRn[15], XEiJ.regPC);
        MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
    }

    public static void irpBsrsl() throws M68kException {
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.mpuCycleCount += 22;
            XEiJ.regPC = n + 4;
            n2 = XEiJ.busRlse(n);
        } else {
            XEiJ.mpuCycleCount += 18;
        }
        XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        XEiJ.busWl(XEiJ.regRn[15], XEiJ.regPC);
        MC68EC030.irpSetPC(n + n2);
    }

    public static void irpBhisw() throws M68kException {
        if (-1600085856 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25088) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBhis() throws M68kException {
        if (-1600085856 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBhisl() throws M68kException {
        if (-1600085856 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25343) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlssw() throws M68kException {
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25344) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlss() throws M68kException {
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlssl() throws M68kException {
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25599) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBhssw() throws M68kException {
        if (-1431655766 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25600) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBhss() throws M68kException {
        if (-1431655766 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBhssl() throws M68kException {
        if (-1431655766 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25855) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlosw() throws M68kException {
        if (0x55555555 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 25856) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlos() throws M68kException {
        if (0x55555555 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlosl() throws M68kException {
        if (0x55555555 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26111) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBnesw() throws M68kException {
        if (-252645136 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26112) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBnes() throws M68kException {
        if (-252645136 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBnesl() throws M68kException {
        if (-252645136 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26367) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBeqsw() throws M68kException {
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26368) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBeqs() throws M68kException {
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBeqsl() throws M68kException {
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26623) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvcsw() throws M68kException {
        if (-858993460 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26624) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvcs() throws M68kException {
        if (-858993460 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvcsl() throws M68kException {
        if (-858993460 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26879) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvssw() throws M68kException {
        if (0x33333333 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 26880) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvss() throws M68kException {
        if (0x33333333 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBvssl() throws M68kException {
        if (0x33333333 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27135) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBplsw() throws M68kException {
        if (-16711936 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27136) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBpls() throws M68kException {
        if (-16711936 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBplsl() throws M68kException {
        if (-16711936 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27391) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBmisw() throws M68kException {
        if (0xFF00FF << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27392) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBmis() throws M68kException {
        if (0xFF00FF << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBmisl() throws M68kException {
        if (0xFF00FF << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27647) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBgesw() throws M68kException {
        if (-869020621 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27648) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBges() throws M68kException {
        if (-869020621 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBgesl() throws M68kException {
        if (-869020621 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27903) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBltsw() throws M68kException {
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 27904) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlts() throws M68kException {
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBltsl() throws M68kException {
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 28159) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBgtsw() throws M68kException {
        if (-1070546896 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 28160) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBgts() throws M68kException {
        if (-1070546896 << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBgtsl() throws M68kException {
        if (-1070546896 << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 28415) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlesw() throws M68kException {
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == 0) {
                XEiJ.regPC = n + 2;
                n2 = XEiJ.busRwse(n);
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 28416) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 2;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBles() throws M68kException {
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            XEiJ.mpuCycleCount += 10;
            MC68EC030.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpBlesl() throws M68kException {
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            int n = XEiJ.regPC;
            int n2 = XEiJ.regOC;
            if (n2 == -1) {
                XEiJ.mpuCycleCount += 14;
                XEiJ.regPC = n + 4;
                n2 = XEiJ.busRlse(n);
            } else {
                XEiJ.mpuCycleCount += 10;
            }
            MC68EC030.irpSetPC(n + n2);
        } else if (XEiJ.regOC == 28671) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.regPC += 4;
        } else {
            XEiJ.mpuCycleCount += 8;
        }
    }

    public static void irpMoveq() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        byte by = (byte)XEiJ.regOC;
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = by;
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvsByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        byte by = n < 8 ? (byte)XEiJ.regRn[n] : XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = by;
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvsWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvzByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? 0xFF & XEiJ.regRn[n] : XEiJ.busRbz(MC68EC030.efaAnyByte(n));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = 0x10 & XEiJ.regCCR | (n2 == 0 ? 4 : 0);
    }

    public static void irpMvzWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRwz(MC68EC030.efaAnyWord(n));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = 0x10 & XEiJ.regCCR | (n2 == 0 ? 4 : 0);
    }

    public static void irpOrToRegByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] | 0xFF & (n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n)));
        XEiJ.regRn[n2] = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpOrToRegWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] | (n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRwz(MC68EC030.efaAnyWord(n)));
        XEiJ.regRn[n2] = n3;
        short s = (short)n3;
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpOrToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            XEiJ.regRn[n3] = n = XEiJ.regRn[n3] | XEiJ.regRn[n2];
        } else {
            XEiJ.mpuCycleCount += n2 == 60 ? 8 : 6;
            XEiJ.regRn[n3] = n = XEiJ.regRn[n3] | XEiJ.busRls(MC68EC030.efaAnyLong(n2));
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpDivuWord() throws M68kException {
        XEiJ.mpuCycleCount += 140;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRwz(MC68EC030.efaAnyWord(n));
        int n4 = XEiJ.regRn[n2];
        if (n3 == 0) {
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n4 < 0 ? 8 : 0) | (n4 >> 16 == 0 ? 4 : 0) | (m30DivZeroVFlag ? 2 : 0);
            XEiJ.mpuCycleCount += -136;
            M68kException.m6eAddress = XEiJ.regPC0;
            M68kException.m6eNumber = 5;
            throw M68kException.m6eSignal;
        }
        int n5 = (int)((double)((long)n4 & 0xFFFFFFFFL) / (double)n3);
        if (n5 >>> 16 != 0) {
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n4 < 0 ? 8 : 0) | 2;
        } else {
            XEiJ.regRn[n2] = n4 - n3 * n5 << 16 | n5;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | ((n5 = (int)((short)n5)) < 0 ? 8 : 0) | (n5 == 0 ? 4 : 0);
        }
        m30DivZeroVFlag = false;
    }

    public static void irpOrToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            XEiJ.mpuCycleCount += 8;
            int n2 = MC68EC030.efaMltByte(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | XEiJ.busRbs(n2);
            XEiJ.busWb(n2, n3);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            XEiJ.mpuCycleCount += 6;
            int n5 = XEiJ.regRn[n4];
            XEiJ.regRn[n4] = 0xFFFFFF00 & n5 | MC68EC030.irpSbcd(n5, XEiJ.regRn[n]);
        } else {
            XEiJ.mpuCycleCount += 18;
            int n6 = n;
            int n7 = XEiJ.regRn[n6] - 1;
            XEiJ.regRn[n6] = n7;
            int n8 = XEiJ.busRbz(n7);
            int n9 = (XEiJ.regOC >> 9) - 56;
            int n10 = XEiJ.regRn[n9] - 1;
            XEiJ.regRn[n9] = n10;
            int n11 = n10;
            XEiJ.busWb(n11, MC68EC030.irpSbcd(XEiJ.busRbz(n11), n8));
        }
    }

    public static void irpOrToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            XEiJ.mpuCycleCount += 8;
            int n2 = MC68EC030.efaMltWord(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | XEiJ.busRws(n2);
            XEiJ.busWw(n2, n3);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
        } else if (n < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = XEiJ.regOC >> 9 & 7;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            n5 = XEiJ.regRn[n] + XEiJ.busRwse(n5);
            XEiJ.regRn[n4] = 0xFFFFFF00 & XEiJ.regRn[n4] | n5 >> 4 & 0xF0 | n5 & 0xF;
        } else {
            XEiJ.mpuCycleCount += 16;
            int n6 = XEiJ.regPC;
            XEiJ.regPC = n6 + 2;
            int n7 = n;
            int n8 = XEiJ.regRn[n7] - 2;
            XEiJ.regRn[n7] = n8;
            n6 = XEiJ.busRws(n8) + XEiJ.busRwse(n6);
            int n9 = (XEiJ.regOC >> 9) - 56;
            int n10 = XEiJ.regRn[n9] - 1;
            XEiJ.regRn[n9] = n10;
            XEiJ.busWb(n10, n6 >> 4 & 0xF0 | n6 & 0xF);
        }
    }

    public static void irpOrToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            XEiJ.mpuCycleCount += 12;
            int n2 = MC68EC030.efaMltLong(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | XEiJ.busRls(n2);
            XEiJ.busWl(n2, n3);
            XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            int n5 = XEiJ.regRn[n];
            int n6 = XEiJ.regPC;
            XEiJ.regPC = n6 + 2;
            XEiJ.regRn[n4] = 0xFFFF0000 & XEiJ.regRn[n4] | (char)((n5 << 4 & 0xF00 | n5 & 0xF) + XEiJ.busRwse(n6));
        } else {
            int n7 = n;
            int n8 = XEiJ.regRn[n7] - 1;
            XEiJ.regRn[n7] = n8;
            byte by = XEiJ.busRbs(n8);
            int n9 = XEiJ.regPC;
            XEiJ.regPC = n9 + 2;
            int n10 = (XEiJ.regOC >> 9) - 56;
            int n11 = XEiJ.regRn[n10] - 2;
            XEiJ.regRn[n10] = n11;
            XEiJ.busWw(n11, (by << 4 & 0xF00 | by & 0xF) + XEiJ.busRwse(n9));
        }
    }

    public static void irpDivsWord() throws M68kException {
        XEiJ.mpuCycleCount += 158;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n4 = XEiJ.regRn[n2];
        if (n3 == 0) {
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4 | (m30DivZeroVFlag ? 2 : 0);
            XEiJ.mpuCycleCount += -154;
            M68kException.m6eAddress = XEiJ.regPC0;
            M68kException.m6eNumber = 5;
            throw M68kException.m6eSignal;
        }
        int n5 = n4 / n3;
        if ((short)n5 != n5) {
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n4 == Integer.MIN_VALUE || (n5 & 0xFFFF0080) == 128 || (n5 & 0xFFFF0080) == -65408 ? 8 : 0) | (n5 == 32768 || ((n5 & 0xFFFF00FF) == 0 || (n5 & 0xFFFF00FF) == -65536) && (n5 & 0xFF00) != 0 ? 4 : 0) | 2;
        } else {
            XEiJ.regRn[n2] = n4 - n3 * n5 << 16 | (char)n5;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n5 < 0 ? 8 : 0) | (n5 == 0 ? 4 : 0);
        }
        m30DivZeroVFlag = false;
    }

    public static void irpSubToRegByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 - n3;
        XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & n5;
        XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n5] | ((n4 ^ n3) & (n4 ^ n5)) >> 6 & 2 | (byte)(n4 & (n3 ^ n5) ^ (n3 | n5)) >> 7 & 0x11;
    }

    public static void irpSubToRegWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 - n3;
        XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)n5;
        XEiJ.regCCR = n5 >> 12 & 8 | (char)n5 - '\u0001' >> 14 & 4 | ((n4 ^ n3) & (n4 ^ n5)) >> 14 & 2 | (short)(n4 & (n3 ^ n5) ^ (n3 | n5)) >> 15 & 0x11;
    }

    public static void irpSubToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        XEiJ.mpuCycleCount += n2 < 16 || n2 == 60 ? 8 : 6;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : XEiJ.busRls(MC68EC030.efaAnyLong(n2));
        int n5 = XEiJ.regRn[n3];
        XEiJ.regRn[n3] = n = n5 - n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n5 ^ n4) & (n5 ^ n)) >> 30 & 2 | (n5 & (n4 ^ n) ^ (n4 | n)) >> 31 & 0x11;
    }

    public static void irpSubaWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
    }

    public static void irpSubToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 4;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFFFF00 & n3 | 0xFF & n2;
            } else {
                XEiJ.mpuCycleCount += 18;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 1;
                XEiJ.regRn[n6] = n7;
                n4 = XEiJ.busRbs(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 1;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n3 = XEiJ.busRbs(n10);
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.busWb(n10, n2);
            }
            XEiJ.regCCR = n2 >> 4 & 8 | (0xFF & n2) - 1 >> 6 & XEiJ.regCCR & 4 | ((n3 ^ n4) & (n3 ^ n2)) >> 6 & 2 | (byte)(n3 & (n4 ^ n2) ^ (n4 | n2)) >> 7 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 8;
            int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n12 = MC68EC030.efaMltByte(n);
            byte by = XEiJ.busRbs(n12);
            int n13 = by - n11;
            XEiJ.busWb(n12, n13);
            XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n13] | ((by ^ n11) & (by ^ n13)) >> 6 & 2 | (byte)(by & (n11 ^ n13) ^ (n11 | n13)) >> 7 & 0x11;
        }
    }

    public static void irpSubToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 4;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFF0000 & n3 | (char)n2;
            } else {
                XEiJ.mpuCycleCount += 18;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 2;
                XEiJ.regRn[n6] = n7;
                n4 = XEiJ.busRws(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 2;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n3 = XEiJ.busRws(n10);
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.busWw(n10, n2);
            }
            XEiJ.regCCR = n2 >> 12 & 8 | (char)n2 - '\u0001' >> 14 & XEiJ.regCCR & 4 | ((n3 ^ n4) & (n3 ^ n2)) >> 14 & 2 | (short)(n3 & (n4 ^ n2) ^ (n4 | n2)) >> 15 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 8;
            short s = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n11 = MC68EC030.efaMltWord(n);
            int n12 = XEiJ.busRws(n11);
            int n13 = n12 - s;
            XEiJ.busWw(n11, n13);
            XEiJ.regCCR = n13 >> 12 & 8 | (char)n13 - '\u0001' >> 14 & 4 | ((n12 ^ s) & (n12 ^ n13)) >> 14 & 2 | (short)(n12 & (s ^ n13) ^ (s | n13)) >> 15 & 0x11;
        }
    }

    public static void irpSubToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 8;
                n4 = XEiJ.regRn[n5];
                n3 = XEiJ.regRn[n];
                XEiJ.regRn[n5] = n2 = n4 - n3 - (XEiJ.regCCR >> 4);
            } else {
                XEiJ.mpuCycleCount += 30;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 4;
                XEiJ.regRn[n6] = n7;
                n3 = XEiJ.busRls(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 4;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n4 = XEiJ.busRls(n10);
                n2 = n4 - n3 - (XEiJ.regCCR >> 4);
                XEiJ.busWl(n10, n2);
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 4 : 0) | ((n4 ^ n3) & (n4 ^ n2)) >>> 31 << 1 | (n4 & (n3 ^ n2) ^ (n3 | n2)) >> 31 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n11 = MC68EC030.efaMltLong(n);
            int n12 = XEiJ.busRls(n11);
            int n13 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n14 = n12 - n13;
            XEiJ.busWl(n11, n14);
            XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | ((n12 ^ n13) & (n12 ^ n14)) >>> 31 << 1 | (n12 & (n13 ^ n14) ^ (n13 | n14)) >> 31 & 0x11;
        }
    }

    public static void irpSubaLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        XEiJ.mpuCycleCount += n < 16 || n == 60 ? 8 : 6;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
    }

    public static void irpAline() throws M68kException {
        XEiJ.mpuCycleCount += 34;
        int n = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        int n2 = XEiJ.regRn[15];
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n2;
            n2 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n2 -= 8;
        XEiJ.busWw(n2 + 6, 40);
        XEiJ.busWl(n2 + 2, XEiJ.regPC0);
        XEiJ.busWw(n2, n);
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + 40));
    }

    public static void irpCmpByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        byte by = (byte)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        byte by2 = n < 8 ? (byte)XEiJ.regRn[n] : XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        byte by3 = (byte)(by - by2);
        XEiJ.regCCR = by3 >> 28 & 8 | (by3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by ^ by2) & (by ^ by3)) >>> 31 << 1 | (by & (by2 ^ by3) ^ (by2 | by3)) >>> 31;
    }

    public static void irpCmpWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        short s = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        int n2 = n < 16 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        short s2 = (short)(s - n2);
        XEiJ.regCCR = s2 >> 28 & 8 | (s2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((s ^ n2) & (s ^ s2)) >>> 31 << 1 | (s & (n2 ^ s2) ^ (n2 | s2)) >>> 31;
    }

    public static void irpCmpLong() throws M68kException {
        XEiJ.mpuCycleCount += 6;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        int n3 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n4 = n2 - n3;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n2 ^ n3) & (n2 ^ n4)) >>> 31 << 1 | (n2 & (n3 ^ n4) ^ (n3 | n4)) >>> 31;
    }

    public static void irpCmpaWord() throws M68kException {
        XEiJ.mpuCycleCount += 6;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 0xF];
        int n4 = n3 - n2;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n3 ^ n2) & (n3 ^ n4)) >>> 31 << 1 | (n3 & (n2 ^ n4) ^ (n2 | n4)) >>> 31;
    }

    public static void irpEorByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            byte by;
            XEiJ.mpuCycleCount += 12;
            int n2 = n;
            int n3 = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = n3 + 1;
            byte by2 = XEiJ.busRbs(n3);
            int n4 = XEiJ.regOC >> 9 & 0xF;
            int n5 = XEiJ.regRn[n4];
            XEiJ.regRn[n4] = n5 + 1;
            byte by3 = XEiJ.busRbs(n5);
            XEiJ.regCCR = by >> 28 & 8 | ((by = (byte)(by3 - by2)) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by3 ^ by2) & (by3 ^ by)) >>> 31 << 1 | (by3 & (by2 ^ by) ^ (by2 | by)) >>> 31;
        } else {
            int n6;
            int n7 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                XEiJ.mpuCycleCount += 4;
                int n8 = n;
                int n9 = XEiJ.regRn[n8] ^ 0xFF & XEiJ.regRn[n7];
                XEiJ.regRn[n8] = n9;
                n6 = n9;
            } else {
                XEiJ.mpuCycleCount += 8;
                int n10 = MC68EC030.efaMltByte(n);
                n6 = XEiJ.regRn[n7] ^ XEiJ.busRbs(n10);
                XEiJ.busWb(n10, n6);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n6];
        }
    }

    public static void irpEorWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC & 7;
        int n3 = n >> 3;
        if (n3 == 1) {
            short s;
            XEiJ.mpuCycleCount += 12;
            int n4 = n;
            int n5 = XEiJ.regRn[n4] + 2;
            XEiJ.regRn[n4] = n5;
            int n6 = XEiJ.busRws(n5 - 2);
            int n7 = XEiJ.regOC >> 9 & 0xF;
            int n8 = XEiJ.regRn[n7] + 2;
            XEiJ.regRn[n7] = n8;
            int n9 = XEiJ.busRws(n8 - 2);
            XEiJ.regCCR = s >> 28 & 8 | ((s = (short)(n9 - n6)) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n9 ^ n6) & (n9 ^ s)) >>> 31 << 1 | (n9 & (n6 ^ s) ^ (n6 | s)) >>> 31;
        } else {
            int n10;
            int n11 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                XEiJ.mpuCycleCount += 4;
                int n12 = n2;
                int n13 = XEiJ.regRn[n12] ^ (char)XEiJ.regRn[n11];
                XEiJ.regRn[n12] = n13;
                n10 = n13;
            } else {
                XEiJ.mpuCycleCount += 8;
                int n14 = MC68EC030.efaMltWord(n);
                n10 = XEiJ.regRn[n11] ^ XEiJ.busRws(n14);
                XEiJ.busWw(n14, n10);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n10 - '\u0001' >> 31 & 4 | ((short)n10 < 0 ? 8 : 0);
        }
    }

    public static void irpEorLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2;
            XEiJ.mpuCycleCount += 20;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] + 4;
            XEiJ.regRn[n3] = n4;
            int n5 = XEiJ.busRls(n4 - 4);
            int n6 = XEiJ.regOC >> 9 & 0xF;
            int n7 = XEiJ.regRn[n6] + 4;
            XEiJ.regRn[n6] = n7;
            int n8 = XEiJ.busRls(n7 - 4);
            XEiJ.regCCR = n2 >> 28 & 8 | ((n2 = n8 - n5) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n8 ^ n5) & (n8 ^ n2)) >>> 31 << 1 | (n8 & (n5 ^ n2) ^ (n5 | n2)) >>> 31;
        } else {
            int n9;
            int n10 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                XEiJ.mpuCycleCount += 8;
                XEiJ.regRn[n] = n9 = XEiJ.regRn[n] ^ XEiJ.regRn[n10];
            } else {
                XEiJ.mpuCycleCount += 12;
                int n11 = MC68EC030.efaMltLong(n);
                n9 = XEiJ.busRls(n11) ^ XEiJ.regRn[n10];
                XEiJ.busWl(n11, n9);
            }
            XEiJ.regCCR = n9 >> 28 & 8 | (n9 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        }
    }

    public static void irpCmpaLong() throws M68kException {
        XEiJ.mpuCycleCount += 6;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 0xF];
        int n4 = n3 - n2;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n3 ^ n2) & (n3 ^ n4)) >>> 31 << 1 | (n3 & (n2 ^ n4) ^ (n2 | n4)) >>> 31;
    }

    public static void irpAndToRegByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] & (0xFFFFFF00 | (n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n))));
        XEiJ.regRn[n2] = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpAndToRegWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] & (0xFFFF0000 | (n < 8 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n))));
        XEiJ.regRn[n2] = n3;
        int n4 = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n4 - '\u0001' >> 31 & 4 | ((short)n4 < 0 ? 8 : 0);
    }

    public static void irpAndToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        if (n2 < 8) {
            XEiJ.mpuCycleCount += 8;
            int n4 = n3;
            int n5 = XEiJ.regRn[n4] & XEiJ.regRn[n2];
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            XEiJ.mpuCycleCount += n2 == 60 ? 8 : 6;
            int n6 = n3;
            int n7 = XEiJ.regRn[n6] & XEiJ.busRls(MC68EC030.efaAnyLong(n2));
            XEiJ.regRn[n6] = n7;
            n = n7;
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMuluWord() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        int n4 = n2 < 8 ? (int)XEiJ.regRn[n2] : XEiJ.busRwz(MC68EC030.efaAnyWord(n2));
        int n5 = n4 & 0x5555;
        n5 += n4 - n5 >> 1;
        int n6 = n5 & 0x3333;
        n6 += n5 - n6 >> 2;
        n6 += n6 >> 4;
        XEiJ.mpuCycleCount += 38 + ((n6 & 0xF) + (n6 >> 8 & 0xF)) << 1;
        XEiJ.regRn[n3] = n = (char)XEiJ.regRn[n3] * n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        m30DivZeroVFlag = false;
    }

    public static void irpAndToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            XEiJ.mpuCycleCount += 8;
            int n2 = MC68EC030.efaMltByte(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & XEiJ.busRbs(n2);
            XEiJ.busWb(n2, n3);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            XEiJ.mpuCycleCount += 6;
            XEiJ.regRn[n4] = 0xFFFFFF00 & XEiJ.regRn[n4] | MC68EC030.irpAbcd(XEiJ.regRn[n4], XEiJ.regRn[n]);
        } else {
            XEiJ.mpuCycleCount += 18;
            int n5 = n;
            int n6 = XEiJ.regRn[n5] - 1;
            XEiJ.regRn[n5] = n6;
            int n7 = XEiJ.busRbz(n6);
            int n8 = (XEiJ.regOC >> 9) - 88;
            int n9 = XEiJ.regRn[n8] - 1;
            XEiJ.regRn[n8] = n9;
            int n10 = n9;
            XEiJ.busWb(n10, MC68EC030.irpAbcd(XEiJ.busRbz(n10), n7));
        }
    }

    public static void irpAndToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            XEiJ.mpuCycleCount += 6;
            if (n < 8) {
                int n2 = XEiJ.regOC >> 9 & 7;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = XEiJ.regRn[n];
                XEiJ.regRn[n] = n3;
            } else {
                int n4 = (XEiJ.regOC >> 9) - 88;
                int n5 = XEiJ.regRn[n4];
                XEiJ.regRn[n4] = XEiJ.regRn[n];
                XEiJ.regRn[n] = n5;
            }
        } else {
            XEiJ.mpuCycleCount += 8;
            int n6 = MC68EC030.efaMltWord(n);
            int n7 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & XEiJ.busRws(n6);
            XEiJ.busWw(n6, n7);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n7 - '\u0001' >> 31 & 4 | ((short)n7 < 0 ? 8 : 0);
        }
    }

    public static void irpAndToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        if (n >> 3 == 1) {
            XEiJ.mpuCycleCount += 6;
            int n3 = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = XEiJ.regRn[n];
            XEiJ.regRn[n] = n3;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n4 = MC68EC030.efaMltLong(n);
            int n5 = XEiJ.busRls(n4) & XEiJ.regRn[n2];
            XEiJ.busWl(n4, n5);
            XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        }
    }

    public static void irpMulsWord() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        int n4 = n2 < 8 ? (int)XEiJ.regRn[n2] : XEiJ.busRws(MC68EC030.efaAnyWord(n2));
        int n5 = n4 << 1 ^ n4;
        int n6 = n5 & 0x5555;
        n6 += n5 - n6 >> 1;
        n5 = n6 & 0x3333;
        n5 += n6 - n5 >> 2;
        n5 += n5 >> 4;
        XEiJ.mpuCycleCount += 38 + ((n5 & 0xF) + (n5 >> 8 & 0xF)) << 1;
        XEiJ.regRn[n3] = n = (short)XEiJ.regRn[n3] * n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        m30DivZeroVFlag = false;
    }

    public static void irpAddToRegByte() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (int)XEiJ.busRbs(MC68EC030.efaAnyByte(n));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 + n3;
        XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & n5;
        XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n5] | ((n4 ^ n5) & (n3 ^ n5)) >> 6 & 2 | (byte)((n4 | n3) ^ (n4 ^ n3) & n5) >> 7 & 0x11;
    }

    public static void irpAddToRegWord() throws M68kException {
        XEiJ.mpuCycleCount += 4;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 + n3;
        XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)n5;
        XEiJ.regCCR = n5 >> 12 & 8 | (char)n5 - '\u0001' >> 14 & 4 | ((n4 ^ n5) & (n3 ^ n5)) >> 14 & 2 | (short)((n4 | n3) ^ (n4 ^ n3) & n5) >> 15 & 0x11;
    }

    public static void irpAddToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        XEiJ.mpuCycleCount += n2 < 16 || n2 == 60 ? 8 : 6;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : XEiJ.busRls(MC68EC030.efaAnyLong(n2));
        int n5 = XEiJ.regRn[n3];
        XEiJ.regRn[n3] = n = n5 + n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n5 ^ n) & (n4 ^ n)) >> 30 & 2 | ((n5 | n4) ^ (n5 ^ n4) & n) >> 31 & 0x11;
    }

    public static void irpAddaWord() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? (int)XEiJ.regRn[n] : XEiJ.busRws(MC68EC030.efaAnyWord(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
    }

    public static void irpAddToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 4;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFFFF00 & n3 | 0xFF & n2;
            } else {
                XEiJ.mpuCycleCount += 18;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 1;
                XEiJ.regRn[n6] = n7;
                n4 = XEiJ.busRbs(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 1;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n3 = XEiJ.busRbs(n10);
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.busWb(n10, n2);
            }
            XEiJ.regCCR = n2 >> 4 & 8 | (0xFF & n2) - 1 >> 6 & XEiJ.regCCR & 4 | ((n3 ^ n2) & (n4 ^ n2)) >> 6 & 2 | (byte)((n3 | n4) ^ (n3 ^ n4) & n2) >> 7 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 8;
            int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n12 = MC68EC030.efaMltByte(n);
            byte by = XEiJ.busRbs(n12);
            int n13 = by + n11;
            XEiJ.busWb(n12, n13);
            XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n13] | ((by ^ n13) & (n11 ^ n13)) >> 6 & 2 | (byte)((by | n11) ^ (by ^ n11) & n13) >> 7 & 0x11;
        }
    }

    public static void irpAddToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 4;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFF0000 & n3 | (char)n2;
            } else {
                XEiJ.mpuCycleCount += 18;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 2;
                XEiJ.regRn[n6] = n7;
                n4 = XEiJ.busRws(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 2;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n3 = XEiJ.busRws(n10);
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.busWw(n10, n2);
            }
            XEiJ.regCCR = n2 >> 12 & 8 | (char)n2 - '\u0001' >> 14 & XEiJ.regCCR & 4 | ((n3 ^ n2) & (n4 ^ n2)) >> 14 & 2 | (short)((n3 | n4) ^ (n3 ^ n4) & n2) >> 15 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 8;
            int n11 = MC68EC030.efaMltWord(n);
            int n12 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n13 = XEiJ.busRws(n11);
            int n14 = n13 + n12;
            XEiJ.busWw(n11, n14);
            XEiJ.regCCR = n14 >> 12 & 8 | (char)n14 - '\u0001' >> 14 & 4 | ((n13 ^ n14) & (n12 ^ n14)) >> 14 & 2 | (short)((n13 | n12) ^ (n13 ^ n12) & n14) >> 15 & 0x11;
        }
    }

    public static void irpAddToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 8;
                n4 = XEiJ.regRn[n5];
                n3 = XEiJ.regRn[n];
                XEiJ.regRn[n5] = n2 = n4 + n3 + (XEiJ.regCCR >> 4);
            } else {
                XEiJ.mpuCycleCount += 30;
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 4;
                XEiJ.regRn[n6] = n7;
                n3 = XEiJ.busRls(n7);
                int n8 = XEiJ.regOC >> 9 & 0xF;
                int n9 = XEiJ.regRn[n8] - 4;
                XEiJ.regRn[n8] = n9;
                int n10 = n9;
                n4 = XEiJ.busRls(n10);
                n2 = n4 + n3 + (XEiJ.regCCR >> 4);
                XEiJ.busWl(n10, n2);
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 4 : 0) | ((n4 ^ n2) & (n3 ^ n2)) >>> 31 << 1 | ((n4 | n3) ^ (n4 ^ n3) & n2) >> 31 & 0x11;
        } else {
            XEiJ.mpuCycleCount += 12;
            int n11 = MC68EC030.efaMltLong(n);
            int n12 = XEiJ.busRls(n11);
            int n13 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n14 = n12 + n13;
            XEiJ.busWl(n11, n14);
            XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | ((n12 ^ n14) & (n13 ^ n14)) >>> 31 << 1 | ((n12 | n13) ^ (n12 ^ n13) & n14) >> 31 & 0x11;
        }
    }

    public static void irpAddaLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        XEiJ.mpuCycleCount += n < 16 || n == 60 ? 8 : 6;
        int n2 = n < 16 ? XEiJ.regRn[n] : XEiJ.busRls(MC68EC030.efaAnyLong(n));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
    }

    public static void irpXxrToRegByte() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n3 << 1);
                int n4 = (byte)n2 >> n3;
                int n5 = n4 >> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & n5;
                XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? 4 : 0) | -(n4 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n6 << 1);
                int n7 = (0xFF & n2) >>> n6;
                int n8 = n7 >>> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | n8;
                XEiJ.regCCR = (n8 == 0 ? 4 : 0) | -(n7 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n10 << 1);
                int n11 = (XEiJ.regCCR & 0x10) << 3 | (0xFF & n2) >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << 8 - n10 | n9 >>> 1;
                }
                byte by = (byte)n11;
                n11 = by;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 6 + (n12 << 1);
                byte by = (byte)(n2 << 8 - n12 | (0xFF & n2) >>> n12);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | by >>> 7 & 1;
                break;
            }
            case 4: {
                int n13;
                int n14;
                int n15 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n15 << 1);
                if (n15 == 0) {
                    n14 = n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = (byte)n2 >> (n15 <= 8 ? n15 - 1 : 7);
                    n14 = n13 >> 1;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & n14;
                    n13 = -(n13 & 1) & 0x11;
                }
                XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | n13;
                break;
            }
            case 5: {
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n16 << 1);
                if (n16 == 0) {
                    byte by = (byte)n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (by < 0 ? 8 : (by == 0 ? 4 : 0));
                    break;
                }
                int n17 = n16 <= 8 ? (0xFF & n2) >>> n16 - 1 : 0;
                int n18 = n17 >>> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | n18;
                XEiJ.regCCR = (n18 == 0 ? 4 : 0) | -(n17 & 1) & 0x11;
                break;
            }
            case 6: {
                int n19;
                int n20;
                int n21 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n21 << 1);
                n21 = (n21 & 7) - (n21 >> 3);
                n21 += n21 >> 3 & 9;
                if (n21 == 0) {
                    n20 = n2;
                    n19 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n20 = (XEiJ.regCCR & 0x10) << 3 | (0xFF & n2) >>> 1;
                    if (n21 == 1) {
                        n19 = n2;
                    } else {
                        n19 = n20 >>> n21 - 2;
                        n20 = n2 << 9 - n21 | n19 >>> 1;
                    }
                    byte by = (byte)n20;
                    n20 = by;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n19 = -(n19 & 1) & 0x11;
                }
                XEiJ.regCCR = n20 >> 28 & 8 | (n20 == 0 ? 4 : 0) | n19;
                break;
            }
            default: {
                int n22;
                byte by;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n23 << 1);
                if (n23 == 0) {
                    by = (byte)n2;
                    n22 = 0;
                } else {
                    by = (byte)(n2 << 8 - (n23 &= 7) | (0xFF & n2) >>> n23);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n22 = by >>> 7 & 1;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n22;
            }
        }
    }

    public static void irpXxrToRegWord() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n3 << 1);
                int n4 = (short)n2 >> n3;
                int n5 = n4 >> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)n5;
                XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? 4 : 0) | -(n4 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n6 << 1);
                int n7 = (char)n2 >>> n6;
                int n8 = n7 >>> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | n8;
                XEiJ.regCCR = (n8 == 0 ? 4 : 0) | -(n7 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n10 << 1);
                int n11 = (XEiJ.regCCR & 0x10) << 11 | (char)n2 >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << 16 - n10 | n9 >>> 1;
                }
                short s = (short)n11;
                n11 = s;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n12 << 1);
                short s = (short)(n2 << 15 - n12 | (char)n2 >>> n12 + 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | s >>> 15 & 1;
                break;
            }
            case 4: {
                int n13;
                int n14;
                int n15 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n15 << 1);
                if (n15 == 0) {
                    n14 = n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = (short)n2 >> (n15 <= 16 ? n15 - 1 : 15);
                    n14 = n13 >> 1;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)n14;
                    n13 = -(n13 & 1) & 0x11;
                }
                XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | n13;
                break;
            }
            case 5: {
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n16 << 1);
                if (n16 == 0) {
                    short s = (short)n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : (s == 0 ? 4 : 0));
                    break;
                }
                int n17 = n16 <= 16 ? (char)n2 >>> n16 - 1 : 0;
                int n18 = n17 >>> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | n18;
                XEiJ.regCCR = (n18 == 0 ? 4 : 0) | -(n17 & 1) & 0x11;
                break;
            }
            case 6: {
                int n19;
                int n20;
                int n21 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n21 << 1);
                n21 = (n21 & 0xF) - (n21 >> 4);
                n21 += n21 >> 4 & 0x11;
                if (n21 == 0) {
                    n20 = n2;
                    n19 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n20 = (XEiJ.regCCR & 0x10) << 11 | (char)n2 >>> 1;
                    if (n21 == 1) {
                        n19 = n2;
                    } else {
                        n19 = n20 >>> n21 - 2;
                        n20 = n2 << 17 - n21 | n19 >>> 1;
                    }
                    short s = (short)n20;
                    n20 = s;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n19 = -(n19 & 1) & 0x11;
                }
                XEiJ.regCCR = n20 >> 28 & 8 | (n20 == 0 ? 4 : 0) | n19;
                break;
            }
            default: {
                int n22;
                short s;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n23 << 1);
                if (n23 == 0) {
                    s = (short)n2;
                    n22 = 0;
                } else {
                    s = (short)(n2 << 16 - (n23 &= 0xF) | (char)n2 >>> n23);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n22 = s >>> 15 & 1;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n22;
            }
        }
    }

    public static void irpXxrToRegLong() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3;
                int n4 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n4 << 1);
                int n5 = n2 >> n4;
                XEiJ.regRn[n] = n3 = n5 >> 1;
                XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? 4 : 0) | -(n5 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6;
                int n7 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n7 << 1);
                int n8 = n2 >>> n7;
                XEiJ.regRn[n] = n6 = n8 >>> 1;
                XEiJ.regCCR = (n6 == 0 ? 4 : 0) | -(n8 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n10 << 1);
                int n11 = (XEiJ.regCCR & 0x10) << 27 | n2 >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << -n10 | n9 >>> 1;
                }
                XEiJ.regRn[n] = n11;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12;
                int n13 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n13 << 1);
                XEiJ.regRn[n] = n12 = n2 << ~n13 | n2 >>> n13 + 1;
                XEiJ.regCCR = n12 >> 28 & 8 | (n12 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n12 >>> 31;
                break;
            }
            case 4: {
                int n14;
                int n15;
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n16 << 1);
                if (n16 == 0) {
                    n15 = n2;
                    n14 = XEiJ.regCCR & 0x10;
                } else {
                    n14 = n2 >> (n16 <= 32 ? n16 - 1 : 31);
                    XEiJ.regRn[n] = n15 = n14 >> 1;
                    n14 = -(n14 & 1) & 0x11;
                }
                XEiJ.regCCR = n15 >> 28 & 8 | (n15 == 0 ? 4 : 0) | n14;
                break;
            }
            case 5: {
                int n17;
                int n18 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n18 << 1);
                if (n18 == 0) {
                    int n19 = n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n19 < 0 ? 8 : (n19 == 0 ? 4 : 0));
                    break;
                }
                int n20 = n18 <= 32 ? n2 >>> n18 - 1 : 0;
                XEiJ.regRn[n] = n17 = n20 >>> 1;
                XEiJ.regCCR = (n17 == 0 ? 4 : 0) | -(n20 & 1) & 0x11;
                break;
            }
            case 6: {
                int n21;
                int n22;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n23 << 1);
                n23 -= 32 - n23 >> 6 & 0x21;
                if (n23 == 0) {
                    n22 = n2;
                    n21 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n22 = (XEiJ.regCCR & 0x10) << 27 | n2 >>> 1;
                    if (n23 == 1) {
                        n21 = n2;
                    } else {
                        n21 = n22 >>> n23 - 2;
                        n22 = n2 << 33 - n23 | n21 >>> 1;
                    }
                    XEiJ.regRn[n] = n22;
                    n21 = -(n21 & 1) & 0x11;
                }
                XEiJ.regCCR = n22 >> 28 & 8 | (n22 == 0 ? 4 : 0) | n21;
                break;
            }
            default: {
                int n24;
                int n25;
                int n26 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n26 << 1);
                if (n26 == 0) {
                    n25 = n2;
                    n24 = 0;
                } else {
                    XEiJ.regRn[n] = n25 = n2 << -(n26 &= 0x1F) | n2 >>> n26;
                    n24 = n25 >>> 31;
                }
                XEiJ.regCCR = n25 >> 28 & 8 | (n25 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n24;
            }
        }
    }

    public static void irpAsrToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRws(n2);
        int n4 = n3 >> 1;
        XEiJ.busWw(n2, n4);
        XEiJ.regCCR = (n4 < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpXxlToRegByte() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n3 << 1);
                int n4 = n2 << n3;
                byte by = (byte)(n4 << 1);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (by >> n3 + 1 != (byte)n2 ? 2 : 0) | (byte)n4 >> 7 & 0x11;
                break;
            }
            case 1: {
                int n5 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n5 << 1);
                int n6 = n2 << n5;
                byte by = (byte)(n6 << 1);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (byte)n6 >> 7 & 0x11;
                break;
            }
            case 2: {
                int n7;
                int n8 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n8 << 1);
                int n9 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n8 == 0) {
                    n7 = n2;
                } else {
                    n7 = n9 << n8 - 1;
                    n9 = n7 << 1 | (0xFF & n2) >>> 8 - n8;
                }
                byte by = (byte)n9;
                n9 = by;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = n9 >> 28 & 8 | (n9 == 0 ? 4 : 0) | (byte)n7 >> 7 & 0x11;
                break;
            }
            case 3: {
                int n10 = XEiJ.regOC >> 9 & 7;
                XEiJ.mpuCycleCount += 6 + (n10 << 1);
                byte by = (byte)(n2 << n10 | (0xFF & n2) >>> 8 - n10);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | by & 1;
                break;
            }
            case 4: {
                int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n11 << 1);
                if (n11 <= 7) {
                    int n12;
                    byte by;
                    if (n11 == 0) {
                        by = (byte)n2;
                        n12 = XEiJ.regCCR & 0x10;
                    } else {
                        n12 = n2 << n11 - 1;
                        by = (byte)(n12 << 1);
                        XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                        n12 = (by >> n11 != (byte)n2 ? 2 : 0) | (byte)n12 >> 7 & 0x11;
                    }
                    XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | n12;
                    break;
                }
                XEiJ.regRn[n] = 0xFFFFFF00 & n2;
                XEiJ.regCCR = 4 | ((byte)n2 != 0 ? 2 : 0) | (n11 == 8 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n13;
                byte by;
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n14 << 1);
                if (n14 == 0) {
                    by = (byte)n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = n14 <= 8 ? n2 << n14 - 1 : 0;
                    by = (byte)(n13 << 1);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n13 = (byte)n13 >> 7 & 0x11;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | n13;
                break;
            }
            case 6: {
                int n15;
                int n16;
                int n17 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n17 << 1);
                n17 = (n17 & 7) - (n17 >> 3);
                n17 += n17 >> 3 & 9;
                if (n17 == 0) {
                    n16 = n2;
                    n15 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n16 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n17 == 1) {
                        n15 = n2;
                    } else {
                        n15 = n16 << n17 - 2;
                        n16 = n15 << 1 | (0xFF & n2) >>> 9 - n17;
                    }
                    byte by = (byte)n16;
                    n16 = by;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n15 = (byte)n15 >> 7 & 0x11;
                }
                XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                break;
            }
            default: {
                int n18;
                byte by;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n19 << 1);
                if (n19 == 0) {
                    by = (byte)n2;
                    n18 = 0;
                } else {
                    by = (byte)(n2 << (n19 &= 7) | (0xFF & n2) >>> 8 - n19);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n18 = by & 1;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n18;
            }
        }
    }

    public static void irpXxlToRegWord() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n3 << 1);
                int n4 = n2 << n3;
                short s = (short)(n4 << 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (s >> n3 + 1 != (short)n2 ? 2 : 0) | (short)n4 >> 15 & 0x11;
                break;
            }
            case 1: {
                int n5 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n5 << 1);
                int n6 = n2 << n5;
                short s = (short)(n6 << 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (short)n6 >> 15 & 0x11;
                break;
            }
            case 2: {
                int n7;
                int n8 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n8 << 1);
                int n9 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n8 == 0) {
                    n7 = n2;
                } else {
                    n7 = n9 << n8 - 1;
                    n9 = n7 << 1 | (char)n2 >>> 16 - n8;
                }
                short s = (short)n9;
                n9 = s;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = n9 >> 28 & 8 | (n9 == 0 ? 4 : 0) | (short)n7 >> 15 & 0x11;
                break;
            }
            case 3: {
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 8 + (n10 << 1);
                short s = (short)(n2 << n10 + 1 | (char)n2 >>> 15 - n10);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | s & 1;
                break;
            }
            case 4: {
                int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n11 << 1);
                if (n11 <= 15) {
                    int n12;
                    short s;
                    if (n11 == 0) {
                        s = (short)n2;
                        n12 = XEiJ.regCCR & 0x10;
                    } else {
                        n12 = n2 << n11 - 1;
                        s = (short)(n12 << 1);
                        XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                        n12 = (s >> n11 != (short)n2 ? 2 : 0) | (short)n12 >> 15 & 0x11;
                    }
                    XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | n12;
                    break;
                }
                XEiJ.regRn[n] = 0xFFFF0000 & n2;
                XEiJ.regCCR = 4 | ((short)n2 != 0 ? 2 : 0) | (n11 == 16 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n13;
                short s;
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n14 << 1);
                if (n14 == 0) {
                    s = (short)n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = n14 <= 16 ? n2 << n14 - 1 : 0;
                    s = (short)(n13 << 1);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n13 = (short)n13 >> 15 & 0x11;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | n13;
                break;
            }
            case 6: {
                int n15;
                int n16;
                int n17 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n17 << 1);
                n17 = (n17 & 0xF) - (n17 >> 4);
                n17 += n17 >> 4 & 0x11;
                if (n17 == 0) {
                    n16 = n2;
                    n15 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n16 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n17 == 1) {
                        n15 = n2;
                    } else {
                        n15 = n16 << n17 - 2;
                        n16 = n15 << 1 | (char)n2 >>> 17 - n17;
                    }
                    short s = (short)n16;
                    n16 = s;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n15 = (short)n15 >> 15 & 0x11;
                }
                XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                break;
            }
            default: {
                int n18;
                short s;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 6 + (n19 << 1);
                if (n19 == 0) {
                    s = (short)n2;
                    n18 = 0;
                } else {
                    s = (short)(n2 << (n19 &= 0xF) | (char)n2 >>> 16 - n19);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n18 = s & 1;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n18;
            }
        }
    }

    public static void irpXxlToRegLong() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3;
                int n4 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 10 + (n4 << 1);
                int n5 = n2 << n4;
                XEiJ.regRn[n] = n3 = n5 << 1;
                XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? 4 : 0) | (n3 >> n4 + 1 != n2 ? 2 : 0) | n5 >> 31 & 0x11;
                break;
            }
            case 1: {
                int n6;
                int n7 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 10 + (n7 << 1);
                int n8 = n2 << n7;
                XEiJ.regRn[n] = n6 = n8 << 1;
                XEiJ.regCCR = n6 >> 28 & 8 | (n6 == 0 ? 4 : 0) | n8 >> 31 & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 10 + (n10 << 1);
                int n11 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 << n10 - 1;
                    n11 = n9 << 1 | n2 >>> -n10;
                }
                XEiJ.regRn[n] = n11;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | n9 >> 31 & 0x11;
                break;
            }
            case 3: {
                int n12;
                int n13 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.mpuCycleCount += 10 + (n13 << 1);
                XEiJ.regRn[n] = n12 = n2 << n13 + 1 | n2 >>> ~n13;
                XEiJ.regCCR = n12 >> 28 & 8 | (n12 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n12 & 1;
                break;
            }
            case 4: {
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 8 + (n14 << 1);
                if (n14 <= 31) {
                    int n15;
                    int n16;
                    if (n14 == 0) {
                        n16 = n2;
                        n15 = XEiJ.regCCR & 0x10;
                    } else {
                        n15 = n2 << n14 - 1;
                        XEiJ.regRn[n] = n16 = n15 << 1;
                        n15 = (n16 >> n14 != n2 ? 2 : 0) | n15 >> 31 & 0x11;
                    }
                    XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                    break;
                }
                XEiJ.regRn[n] = 0;
                XEiJ.regCCR = 4 | (n2 != 0 ? 2 : 0) | (n14 == 32 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n17;
                int n18;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 8 + (n19 << 1);
                if (n19 == 0) {
                    n18 = n2;
                    n17 = XEiJ.regCCR & 0x10;
                } else {
                    n17 = n19 <= 32 ? n2 << n19 - 1 : 0;
                    XEiJ.regRn[n] = n18 = n17 << 1;
                    n17 = n17 >> 31 & 0x11;
                }
                XEiJ.regCCR = n18 >> 28 & 8 | (n18 == 0 ? 4 : 0) | n17;
                break;
            }
            case 6: {
                int n20;
                int n21;
                int n22 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 8 + (n22 << 1);
                n22 -= 32 - n22 >> 6 & 0x21;
                if (n22 == 0) {
                    n21 = n2;
                    n20 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n21 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n22 == 1) {
                        n20 = n2;
                    } else {
                        n20 = n21 << n22 - 2;
                        n21 = n20 << 1 | n2 >>> 33 - n22;
                    }
                    XEiJ.regRn[n] = n21;
                    n20 = n20 >> 31 & 0x11;
                }
                XEiJ.regCCR = n21 >> 28 & 8 | (n21 == 0 ? 4 : 0) | n20;
                break;
            }
            default: {
                int n23;
                int n24;
                int n25 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                XEiJ.mpuCycleCount += 8 + (n25 << 1);
                if (n25 == 0) {
                    n24 = n2;
                    n23 = 0;
                } else {
                    XEiJ.regRn[n] = n24 = n2 << n25 | n2 >>> -n25;
                    n23 = n24 & 1;
                }
                XEiJ.regCCR = n24 >> 28 & 8 | (n24 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n23;
            }
        }
    }

    public static void irpAslToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRws(n2);
        short s = (short)(n3 << 1);
        XEiJ.busWw(n2, s);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | (n3 ^ s) >>> 31 << 1 | n3 >> 15 & 0x11;
    }

    public static void irpLsrToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRwz(n2);
        int n4 = n3 >>> 1;
        XEiJ.busWw(n2, n4);
        XEiJ.regCCR = (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpLslToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRws(n2);
        short s = (short)(n3 << 1);
        XEiJ.busWw(n2, s);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | n3 >> 15 & 0x11;
    }

    public static void irpRoxrToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRwz(n2);
        int n4 = -(XEiJ.regCCR & 0x10) << 11 | n3 >>> 1;
        XEiJ.busWw(n2, n4);
        XEiJ.regCCR = (n4 < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpRoxlToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRws(n2);
        short s = (short)(n3 << 1 | XEiJ.regCCR >> 4 & 1);
        XEiJ.busWw(n2, s);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | n3 >> 15 & 0x11;
    }

    public static void irpRorToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRwz(n2);
        short s = (short)(n3 << 15 | n3 >>> 1);
        XEiJ.busWw(n2, s);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | s >>> 31;
    }

    public static void irpRolToMem() throws M68kException {
        XEiJ.mpuCycleCount += 8;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68EC030.efaMltWord(n);
        int n3 = XEiJ.busRwz(n2);
        short s = (short)(n3 << 1 | n3 >>> 15);
        XEiJ.busWw(n2, s);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | s & 1;
    }

    public static void irpBftst() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
        } else {
            int n5 = MC68EC030.efaCntLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            n = n == 0 ? XEiJ.busRbs(n5) << 24 + n3 : (n == 1 ? XEiJ.busRws(n5) << 16 + n3 : (n == 2 ? (XEiJ.busRws(n5) << 8 | XEiJ.busRbz(n5 + 2)) << 8 + n3 : (n == 3 ? XEiJ.busRls(n5) << n3 : XEiJ.busRls(n5) << n3 | XEiJ.busRbz(n5 + 4) >>> 8 - n3)));
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfextu() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6 = MC68EC030.efaCntLong(n5) + (n4 >> 3);
            n = 31 - n2 + (n4 &= 7) >> 3;
            n = n == 0 ? XEiJ.busRbs(n6) << 24 + n4 : (n == 1 ? XEiJ.busRws(n6) << 16 + n4 : (n == 2 ? (XEiJ.busRws(n6) << 8 | XEiJ.busRbz(n6 + 2)) << 8 + n4 : (n == 3 ? XEiJ.busRls(n6) << n4 : XEiJ.busRls(n6) << n4 | XEiJ.busRbz(n6 + 4) >>> 8 - n4)));
        }
        XEiJ.regRn[n3] = n >>> n2;
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfchg() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n ^ -1 << n2;
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68EC030.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = XEiJ.busRbs(n6) << 24;
                n = n7 << n3;
                XEiJ.busWb(n6, (n7 ^ -1 << n2 >>> n3) >>> 24);
            } else if (n == 1) {
                int n8 = XEiJ.busRws(n6) << 16;
                n = n8 << n3;
                XEiJ.busWw(n6, (n8 ^ -1 << n2 >>> n3) >>> 16);
            } else if (n == 2) {
                int n9 = XEiJ.busRws(n6) << 16 | XEiJ.busRbz(n6 + 2) << 8;
                n = n9 << n3;
                XEiJ.busWw(n6, (n9 ^= -1 << n2 >>> n3) >>> 16);
                XEiJ.busWb(n6 + 2, n9 >>> 8);
            } else if (n == 3) {
                int n10 = XEiJ.busRls(n6);
                n = n10 << n3;
                XEiJ.busWl(n6, n10 ^ -1 << n2 >>> n3);
            } else {
                int n11 = XEiJ.busRls(n6);
                n = n11 << n3;
                XEiJ.busWl(n6, n11 ^ -1 >>> n3);
                n11 = XEiJ.busRbz(n6 + 4);
                n |= n11 >>> 8 - n3;
                XEiJ.busWb(n6 + 4, n11 ^ -1 << 8 - n3 + n2);
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfexts() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6 = MC68EC030.efaCntLong(n5) + (n4 >> 3);
            n = 31 - n2 + (n4 &= 7) >> 3;
            n = n == 0 ? XEiJ.busRbs(n6) << 24 + n4 : (n == 1 ? XEiJ.busRws(n6) << 16 + n4 : (n == 2 ? (XEiJ.busRws(n6) << 8 | XEiJ.busRbz(n6 + 2)) << 8 + n4 : (n == 3 ? XEiJ.busRls(n6) << n4 : XEiJ.busRls(n6) << n4 | XEiJ.busRbz(n6 + 4) >>> 8 - n4)));
        }
        XEiJ.regRn[n3] = n >>= n2;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfclr() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n & ~(-1 << n2);
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68EC030.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = XEiJ.busRbs(n6) << 24;
                n = n7 << n3;
                XEiJ.busWb(n6, (n7 & ~(-1 << n2 >>> n3)) >>> 24);
            } else if (n == 1) {
                int n8 = XEiJ.busRws(n6) << 16;
                n = n8 << n3;
                XEiJ.busWw(n6, (n8 & ~(-1 << n2 >>> n3)) >>> 16);
            } else if (n == 2) {
                int n9 = XEiJ.busRws(n6) << 16 | XEiJ.busRbz(n6 + 2) << 8;
                n = n9 << n3;
                XEiJ.busWw(n6, (n9 &= ~(-1 << n2 >>> n3)) >>> 16);
                XEiJ.busWb(n6 + 2, n9 >>> 8);
            } else if (n == 3) {
                int n10 = XEiJ.busRls(n6);
                n = n10 << n3;
                XEiJ.busWl(n6, n10 & ~(-1 << n2 >>> n3));
            } else {
                int n11 = XEiJ.busRls(n6);
                n = n11 << n3;
                XEiJ.busWl(n6, n11 & ~(-1 >>> n3));
                n11 = XEiJ.busRbz(n6 + 4);
                n |= n11 >>> 8 - n3;
                XEiJ.busWb(n6 + 4, n11 & ~(-1 << 8 - n3 + n2));
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfffo() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6 = MC68EC030.efaCntLong(n5) + (n4 >> 3);
            int n7 = n4 & 7;
            n = 31 - n2 + n7 >> 3;
            n = n == 0 ? XEiJ.busRbs(n6) << 24 + n7 : (n == 1 ? XEiJ.busRws(n6) << 16 + n7 : (n == 2 ? (XEiJ.busRws(n6) << 8 | XEiJ.busRbz(n6 + 2)) << 8 + n7 : (n == 3 ? XEiJ.busRls(n6) << n7 : XEiJ.busRls(n6) << n7 | XEiJ.busRbz(n6 + 4) >>> 8 - n7)));
        }
        XEiJ.regRn[n3] = Integer.numberOfLeadingZeros(n >>> n2) - n2 + n4;
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfset() throws M68kException {
        int n;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n | -1 << n2;
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68EC030.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = XEiJ.busRbs(n6) << 24;
                n = n7 << n3;
                XEiJ.busWb(n6, (n7 | -1 << n2 >>> n3) >>> 24);
            } else if (n == 1) {
                int n8 = XEiJ.busRws(n6) << 16;
                n = n8 << n3;
                XEiJ.busWw(n6, (n8 | -1 << n2 >>> n3) >>> 16);
            } else if (n == 2) {
                int n9 = XEiJ.busRws(n6) << 16 | XEiJ.busRbz(n6 + 2) << 8;
                n = n9 << n3;
                XEiJ.busWw(n6, (n9 |= -1 << n2 >>> n3) >>> 16);
                XEiJ.busWb(n6 + 2, n9 >>> 8);
            } else if (n == 3) {
                int n10 = XEiJ.busRls(n6);
                n = n10 << n3;
                XEiJ.busWl(n6, n10 | -1 << n2 >>> n3);
            } else {
                int n11 = XEiJ.busRls(n6);
                n = n11 << n3;
                XEiJ.busWl(n6, n11 | -1 >>> n3);
                n11 = XEiJ.busRbz(n6 + 4);
                n |= n11 >>> 8 - n3;
                XEiJ.busWb(n6 + 4, n11 | -1 << 8 - n3 + n2);
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfins() throws M68kException {
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        if (((n = XEiJ.busRwze(n)) & Short.MIN_VALUE) != 0 || (n & 0xFC0) > 2496 || (n & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n2 = n >> 12;
        int n3 = n << 20 >= 0 ? n >> 6 & 0x1F : XEiJ.regRn[n >> 6 & 7];
        n = -(n << 26 >= 0 ? n : XEiJ.regRn[n & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 4;
        int n4 = XEiJ.regOC & 0x3F;
        int n5 = XEiJ.regRn[n2] << n;
        if (n4 < 8) {
            int n6 = XEiJ.regRn[n4];
            n6 = (n6 << n3 | n6 >>> -n3) & ~(-1 << n) | n5;
            XEiJ.regRn[n4] = n6 << -n3 | n6 >>> n3;
        } else {
            int n7 = MC68EC030.efaCltLong(n4) + (n3 >> 3);
            n2 = 31 - n + (n3 &= 7) >> 3;
            if (n2 == 0) {
                XEiJ.busWb(n7, (XEiJ.busRbs(n7) << 24 & ~(-1 << n >>> n3) | n5 >>> n3) >>> 24);
            } else if (n2 == 1) {
                XEiJ.busWw(n7, (XEiJ.busRws(n7) << 16 & ~(-1 << n >>> n3) | n5 >>> n3) >>> 16);
            } else if (n2 == 2) {
                int n8 = (XEiJ.busRws(n7) << 16 | XEiJ.busRbz(n7 + 2) << 8) & ~(-1 << n >>> n3) | n5 >>> n3;
                XEiJ.busWw(n7, n8 >>> 16);
                XEiJ.busWb(n7 + 2, n8 >>> 8);
            } else if (n2 == 3) {
                XEiJ.busWl(n7, XEiJ.busRls(n7) & ~(-1 << n >>> n3) | n5 >>> n3);
            } else {
                XEiJ.busWl(n7, XEiJ.busRls(n7) & ~(-1 >>> n3) | n5 >>> n3);
                XEiJ.busWb(n7 + 4, XEiJ.busRbz(n7 + 4) & ~(-1 << 8 - n3 + n) | n5 << 8 - n3);
            }
        }
        XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpPgen() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = n >> 3;
        if (n2 == 0 || n2 == 2 || n2 == 5 || n2 == 6 || n == 56 || n == 57) {
            XEiJ.regPC += 2;
            if (n >= 16) {
                MC68EC030.efaAnyByte(n);
            }
        } else {
            MC68EC030.irpFline();
        }
    }

    public static void irpFgen() throws M68kException {
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
        } else {
            XEiJ.mpuCycleCount += 16;
            int n = XEiJ.regOC & 0x3F;
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            n2 = XEiJ.busRwze(n2);
            int n3 = n2 >> 10 & 7;
            int n4 = n2 >> 7 & 7;
            int n5 = n2 & 0x7F;
            XEiJ.fpuBox.epbSetRoundingPrec(XEiJ.fpuBox.epbFpcr >> 6 & 3);
            XEiJ.fpuBox.epbSetRoundingMode(XEiJ.fpuBox.epbFpcr >> 4 & 3);
            int n6 = 0;
            block0 : switch (n2 >> 13) {
                case 2: {
                    int n7;
                    XEiJ.fpuBox.epbFpsr &= 0xFF00FF;
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n3) {
                        case 0: {
                            int n8;
                            n3 = 8;
                            EFPBox.EFP eFP = XEiJ.fpuFPn[8];
                            if (n < 8) {
                                n8 = XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyLong(n);
                                n8 = XEiJ.busRls(n6);
                            }
                            eFP.seti(n8);
                            break;
                        }
                        case 1: {
                            int n9;
                            n3 = 8;
                            EFPBox.EFP eFP = XEiJ.fpuFPn[8];
                            if (n < 8) {
                                n9 = XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyLong(n);
                                n9 = XEiJ.busRls(n6);
                            }
                            eFP.setf0(n9);
                            break;
                        }
                        case 2: {
                            n6 = MC68EC030.efaAnyExtd(n);
                            n7 = XEiJ.busRls(n6);
                            long l = (long)XEiJ.busRls(n6 + 4) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n6 + 8);
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                n3 = 8;
                                XEiJ.fpuFPn[8].sety012(n7, l);
                                break;
                            }
                            n3 = 8;
                            XEiJ.fpuFPn[8].setx012(n7, l);
                            break;
                        }
                        case 3: {
                            n6 = MC68EC030.efaAnyExtd(n);
                            n3 = 8;
                            XEiJ.fpuFPn[8].setp012(XEiJ.busRls(n6), (long)XEiJ.busRls(n6 + 4) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n6 + 8));
                            break;
                        }
                        case 4: {
                            short s;
                            n3 = 8;
                            EFPBox.EFP eFP = XEiJ.fpuFPn[8];
                            if (n < 8) {
                                s = (short)XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyWord(n);
                                s = (short)XEiJ.busRws(n6);
                            }
                            eFP.seti(s);
                            break;
                        }
                        case 5: {
                            n6 = MC68EC030.efaAnyQuad(n);
                            n3 = 8;
                            XEiJ.fpuFPn[8].setd01((long)XEiJ.busRls(n6) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n6 + 4));
                            break;
                        }
                        case 6: {
                            byte by;
                            n3 = 8;
                            EFPBox.EFP eFP = XEiJ.fpuFPn[8];
                            if (n < 8) {
                                by = (byte)XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyByte(n);
                                by = XEiJ.busRbs(n6);
                            }
                            eFP.seti(by);
                            break;
                        }
                        default: {
                            if (64 <= n5) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbFmovecr(XEiJ.fpuFPn[n4], n5);
                            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                            if (!MC68EC030.irpFPPostInstruction(n6)) break block0;
                            break block0;
                        }
                    }
                    if (MC68EC030.irpFPPreInstruction()) break;
                }
                case 0: {
                    int n7;
                    if (n2 >> 13 == 0) {
                        XEiJ.fpuBox.epbFpsr &= 0xFF00FF;
                    }
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n5) {
                        case 0: {
                            XEiJ.fpuFPn[n4].sete(XEiJ.fpuFPn[n3]).finish();
                            break;
                        }
                        case 1: {
                            XEiJ.fpuBox.epbSetRoundingPrec(0);
                            XEiJ.fpuFPn[n4].round(XEiJ.fpuFPn[n3], XEiJ.fpuBox.epbRoundingMode);
                            break;
                        }
                        case 2: {
                            XEiJ.fpuFPn[n4].sinh(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 3: {
                            XEiJ.fpuBox.epbSetRoundingPrec(0);
                            XEiJ.fpuFPn[n4].trunc(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 4: 
                        case 5: {
                            XEiJ.fpuFPn[n4].sqrt(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 6: 
                        case 7: {
                            XEiJ.fpuFPn[n4].log1p(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 8: {
                            XEiJ.fpuFPn[n4].expm1(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 9: {
                            XEiJ.fpuFPn[n4].tanh(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 10: 
                        case 11: {
                            XEiJ.fpuFPn[n4].atan(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 12: {
                            XEiJ.fpuFPn[n4].asin(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 13: {
                            XEiJ.fpuFPn[n4].atanh(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 14: {
                            XEiJ.fpuFPn[n4].sin(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 15: {
                            XEiJ.fpuFPn[n4].tan(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 16: {
                            XEiJ.fpuFPn[n4].exp(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 17: {
                            XEiJ.fpuFPn[n4].exp2(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 18: 
                        case 19: {
                            XEiJ.fpuFPn[n4].exp10(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 20: {
                            XEiJ.fpuFPn[n4].log(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 21: {
                            XEiJ.fpuFPn[n4].log10(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 22: 
                        case 23: {
                            XEiJ.fpuFPn[n4].log2(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 24: {
                            XEiJ.fpuFPn[n4].abs(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 25: {
                            XEiJ.fpuFPn[n4].cosh(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 26: 
                        case 27: {
                            XEiJ.fpuFPn[n4].neg(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 28: {
                            XEiJ.fpuFPn[n4].acos(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 29: {
                            XEiJ.fpuFPn[n4].cos(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 30: {
                            XEiJ.fpuFPn[n4].getexp(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 31: {
                            XEiJ.fpuFPn[n4].getman(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 32: {
                            XEiJ.fpuFPn[n4].div(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 33: {
                            XEiJ.fpuFPn[n4].rem(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 34: {
                            XEiJ.fpuFPn[n4].add(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 35: {
                            XEiJ.fpuFPn[n4].mul(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 36: {
                            XEiJ.fpuBox.epbSetRoundingPrec(5);
                            XEiJ.fpuFPn[n4].div(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 37: {
                            XEiJ.fpuFPn[n4].ieeerem(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 38: {
                            XEiJ.fpuFPn[n4].scale(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 39: {
                            n7 = XEiJ.fpuBox.epbFpsr;
                            XEiJ.fpuFPn[8].roundmanf(XEiJ.fpuFPn[n3], 1);
                            XEiJ.fpuFPn[9].roundmanf(XEiJ.fpuFPn[n4], 1);
                            XEiJ.fpuBox.epbFpsr = n7;
                            XEiJ.fpuBox.epbSetRoundingPrec(5);
                            XEiJ.fpuFPn[n4].mul(XEiJ.fpuFPn[9], XEiJ.fpuFPn[8]);
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: {
                            XEiJ.fpuFPn[n4].sub(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            XEiJ.fpuFPn[8].sete(XEiJ.fpuFPn[n3]);
                            XEiJ.fpuFPn[n5 &= 7].cos(XEiJ.fpuFPn[8]);
                            XEiJ.fpuFPn[n4].sin(XEiJ.fpuFPn[8]);
                            break;
                        }
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: {
                            n7 = XEiJ.fpuFPn[n4].flg;
                            int n10 = XEiJ.fpuFPn[n3].flg;
                            if ((n7 | n10) << 3 < 0) {
                                XEiJ.fpuFPn[9].flg = 0x10000000;
                            } else {
                                int n11;
                                int n12 = n11 = (n7 & n10) << 1 < 0 ? 0 : XEiJ.fpuFPn[n4].compareTo(XEiJ.fpuFPn[n3]);
                                if (n11 == 0) {
                                    XEiJ.fpuFPn[9].flg = n7 < 0 ? -1073741824 : 0x40000000;
                                } else if (n11 < 0) {
                                    XEiJ.fpuFPn[9].negset1();
                                } else {
                                    XEiJ.fpuFPn[9].set1();
                                }
                            }
                            n4 = 9;
                            break;
                        }
                        case 58: 
                        case 59: 
                        case 62: 
                        case 63: {
                            XEiJ.fpuFPn[9].sete(XEiJ.fpuFPn[n3]);
                            n4 = 9;
                            break;
                        }
                        case 64: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].sete(XEiJ.fpuFPn[n3]).finish();
                            break;
                        }
                        case 65: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].sqrt(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 68: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].sete(XEiJ.fpuFPn[n3]).finish();
                            break;
                        }
                        case 69: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].sqrt(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 88: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].abs(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 90: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].neg(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 92: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].abs(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 94: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].neg(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 96: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].div(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 98: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].add(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 99: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].mul(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 100: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].div(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 102: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].add(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 103: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].mul(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 104: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n4].sub(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 108: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68EC030.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n4].sub(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 112: {
                            XEiJ.fpuFPn[n4].lgamma(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        case 113: {
                            XEiJ.fpuFPn[n4].tgamma(XEiJ.fpuFPn[n3]);
                            break;
                        }
                        default: {
                            XEiJ.regPC = XEiJ.regPC0 + 2;
                            MC68EC030.irpFline();
                            break block0;
                        }
                    }
                    XEiJ.fpuBox.epbFpsr |= XEiJ.fpuFPn[n4].flg >>> 4;
                    XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                    if (!MC68EC030.irpFPPostInstruction(n6)) break;
                    break;
                }
                case 3: {
                    XEiJ.fpuBox.epbFpsr &= 0xFFFF00FF;
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n3) {
                        case 0: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.fpuFPn[n4].geti(XEiJ.fpuBox.epbRoundingMode);
                                break;
                            }
                            n6 = MC68EC030.efaMltLong(n);
                            XEiJ.busWl(n6, XEiJ.fpuFPn[n4].geti(XEiJ.fpuBox.epbRoundingMode));
                            break;
                        }
                        case 1: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.fpuFPn[n4].getf0(XEiJ.fpuBox.epbRoundingMode);
                                break;
                            }
                            n6 = MC68EC030.efaMltLong(n);
                            XEiJ.busWl(n6, XEiJ.fpuFPn[n4].getf0(XEiJ.fpuBox.epbRoundingMode));
                            break;
                        }
                        case 2: {
                            byte[] byArray = new byte[12];
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n4].gety012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            } else {
                                XEiJ.fpuFPn[n4].getx012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            }
                            n6 = MC68EC030.efaMltExtd(n);
                            XEiJ.busWbb(n6, byArray, 0, 12);
                            break;
                        }
                        case 3: {
                            byte[] byArray = new byte[12];
                            XEiJ.fpuFPn[n4].getp012(byArray, 0, n2);
                            n6 = MC68EC030.efaMltExtd(n);
                            XEiJ.busWbb(n6, byArray, 0, 12);
                            break;
                        }
                        case 4: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.regRn[n] & 0xFFFF0000 | (char)XEiJ.fpuFPn[n4].gets(XEiJ.fpuBox.epbRoundingMode);
                                break;
                            }
                            n6 = MC68EC030.efaMltWord(n);
                            XEiJ.busWw(n6, XEiJ.fpuFPn[n4].gets(XEiJ.fpuBox.epbRoundingMode));
                            break;
                        }
                        case 5: {
                            n6 = MC68EC030.efaMltQuad(n);
                            long l = XEiJ.fpuFPn[n4].getd01(XEiJ.fpuBox.epbRoundingMode);
                            XEiJ.busWl(n6, (int)(l >>> 32));
                            XEiJ.busWl(n6 + 4, (int)l);
                            break;
                        }
                        case 6: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.regRn[n] & 0xFFFFFF00 | XEiJ.fpuFPn[n4].getb(XEiJ.fpuBox.epbRoundingMode) & 0xFF;
                                break;
                            }
                            n6 = MC68EC030.efaMltByte(n);
                            XEiJ.busWb(n6, XEiJ.fpuFPn[n4].getb(XEiJ.fpuBox.epbRoundingMode));
                            break;
                        }
                        default: {
                            byte[] byArray = new byte[12];
                            XEiJ.fpuFPn[n4].getp012(byArray, 0, XEiJ.regRn[n2 >> 4 & 7]);
                            n6 = MC68EC030.efaMltExtd(n);
                            XEiJ.busWbb(n6, byArray, 0, 12);
                        }
                    }
                    XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                    if (!MC68EC030.irpFPPostInstruction(n6)) break;
                    break;
                }
                case 4: {
                    switch (n3) {
                        case 0: 
                        case 1: {
                            int n13;
                            if (n < 16) {
                                n13 = XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyLong(n);
                                n13 = XEiJ.busRls(n6);
                            }
                            XEiJ.fpuBox.epbFpiar = n13;
                            break block0;
                        }
                        case 2: {
                            int n14;
                            if (n < 8) {
                                n14 = XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyLong(n);
                                n14 = XEiJ.busRls(n6);
                            }
                            XEiJ.fpuBox.epbFpsr = n14 & 0xFFFFFF8;
                            break block0;
                        }
                        case 3: {
                            n6 = MC68EC030.efaAnyQuad(n);
                            XEiJ.fpuBox.epbFpsr = XEiJ.busRls(n6) & 0xFFFFFF8;
                            XEiJ.fpuBox.epbFpiar = XEiJ.busRls(n6 + 4);
                            break block0;
                        }
                        case 4: {
                            int n15;
                            if (n < 8) {
                                n15 = XEiJ.regRn[n];
                            } else {
                                n6 = MC68EC030.efaAnyLong(n);
                                n15 = XEiJ.busRls(n6);
                            }
                            XEiJ.fpuBox.epbFpcr = n15 & 0xFFF0;
                            break block0;
                        }
                        case 5: {
                            n6 = MC68EC030.efaAnyQuad(n);
                            XEiJ.fpuBox.epbFpcr = XEiJ.busRls(n6) & 0xFFF0;
                            XEiJ.fpuBox.epbFpiar = XEiJ.busRls(n6 + 4);
                            break block0;
                        }
                        case 6: {
                            n6 = MC68EC030.efaAnyQuad(n);
                            XEiJ.fpuBox.epbFpcr = XEiJ.busRls(n6) & 0xFFF0;
                            XEiJ.fpuBox.epbFpsr = XEiJ.busRls(n6 + 4) & 0xFFFFFF8;
                            break block0;
                        }
                    }
                    n6 = MC68EC030.efaAnyExtd(n);
                    XEiJ.fpuBox.epbFpcr = XEiJ.busRls(n6) & 0xFFF0;
                    XEiJ.fpuBox.epbFpsr = XEiJ.busRls(n6 + 4) & 0xFFFFFF8;
                    XEiJ.fpuBox.epbFpiar = XEiJ.busRls(n6 + 8);
                    break;
                }
                case 5: {
                    switch (n3) {
                        case 0: 
                        case 1: {
                            if (n < 16) {
                                XEiJ.regRn[n] = XEiJ.fpuBox.epbFpiar;
                                break block0;
                            }
                            n6 = MC68EC030.efaMltLong(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpiar);
                            break block0;
                        }
                        case 2: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.fpuBox.epbFpsr;
                                break block0;
                            }
                            n6 = MC68EC030.efaMltLong(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpsr);
                            break block0;
                        }
                        case 3: {
                            n6 = MC68EC030.efaMltQuad(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpsr);
                            XEiJ.busWl(n6 + 4, XEiJ.fpuBox.epbFpiar);
                            break block0;
                        }
                        case 4: {
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.fpuBox.epbFpcr;
                                break block0;
                            }
                            n6 = MC68EC030.efaMltLong(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpcr);
                            break block0;
                        }
                        case 5: {
                            n6 = MC68EC030.efaMltQuad(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpcr);
                            XEiJ.busWl(n6 + 4, XEiJ.fpuBox.epbFpiar);
                            break block0;
                        }
                        case 6: {
                            n6 = MC68EC030.efaMltQuad(n);
                            XEiJ.busWl(n6, XEiJ.fpuBox.epbFpcr);
                            XEiJ.busWl(n6 + 4, XEiJ.fpuBox.epbFpsr);
                            break block0;
                        }
                    }
                    n6 = MC68EC030.efaMltExtd(n);
                    XEiJ.busWl(n6, XEiJ.fpuBox.epbFpcr);
                    XEiJ.busWl(n6 + 4, XEiJ.fpuBox.epbFpsr);
                    XEiJ.busWl(n6 + 8, XEiJ.fpuBox.epbFpiar);
                    break;
                }
                case 6: {
                    int n16;
                    byte[] byArray = new byte[12];
                    if (n >> 3 == 3) {
                        int n17 = XEiJ.regOC & 7 | 8;
                        n6 = XEiJ.regRn[n17];
                        n4 = 0;
                        for (n16 = ((n3 & 2) == 0 ? n2 : XEiJ.regRn[n2 >> 4 & 7]) << 24; n16 != 0; n16 <<= 1) {
                            if (n16 < 0) {
                                XEiJ.busRbb(n6, byArray, 0, 12);
                                if (XEiJ.fpuBox.epbIsTriple()) {
                                    XEiJ.fpuFPn[n4].sety012(byArray, 0);
                                } else {
                                    XEiJ.fpuFPn[n4].setx012(byArray, 0);
                                }
                                n6 += 12;
                            }
                            ++n4;
                        }
                        XEiJ.regRn[n17] = n6;
                        break;
                    }
                    n6 = MC68EC030.efaCntLong(n);
                    n4 = 0;
                    while (n16 != 0) {
                        if (n16 < 0) {
                            XEiJ.busRbb(n6, byArray, 0, 12);
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n4].sety012(byArray, 0);
                            } else {
                                XEiJ.fpuFPn[n4].setx012(byArray, 0);
                            }
                            n6 += 12;
                        }
                        ++n4;
                        n16 <<= 1;
                    }
                    break;
                }
                case 7: {
                    int n18;
                    byte[] byArray = new byte[12];
                    if (n >> 3 == 4) {
                        int n19 = XEiJ.regOC & 7 | 8;
                        n6 = XEiJ.regRn[n19];
                        n4 = 7;
                        for (n18 = ((n3 & 2) == 0 ? n2 : XEiJ.regRn[n2 >> 4 & 7]) << 24; n18 != 0; n18 <<= 1) {
                            if (n18 < 0) {
                                n6 -= 12;
                                if (XEiJ.fpuBox.epbIsTriple()) {
                                    XEiJ.fpuFPn[n4].gety012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                                } else {
                                    XEiJ.fpuFPn[n4].getx012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                                }
                                XEiJ.busWbb(n6, byArray, 0, 12);
                            }
                            --n4;
                        }
                        XEiJ.regRn[n19] = n6;
                        break;
                    }
                    n6 = MC68EC030.efaCltLong(n);
                    n4 = 0;
                    while (n18 != 0) {
                        if (n18 < 0) {
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n4].gety012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            } else {
                                XEiJ.fpuFPn[n4].getx012(byArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            }
                            XEiJ.busWbb(n6, byArray, 0, 12);
                            n6 += 12;
                        }
                        ++n4;
                        n18 <<= 1;
                    }
                    break;
                }
                default: {
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    XEiJ.regPC = XEiJ.regPC0 + 2;
                    MC68EC030.irpFline();
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFscc() throws M68kException {
        int n;
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        int n2 = XEiJ.regPC;
        XEiJ.regPC = n2 + 2;
        if (((n2 = XEiJ.busRwze(n2)) & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                MC68EC030.irpException(48, XEiJ.regPC0, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 0, 0);
                return;
            }
        }
        if ((n = XEiJ.regOC & 0x3F) < 8) {
            if (XEiJ.FPU_CCMAP_882[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
                XEiJ.mpuCycleCount += 10;
                int n3 = n;
                XEiJ.regRn[n3] = XEiJ.regRn[n3] | 0xFF;
                return;
            }
            XEiJ.mpuCycleCount += 8;
            int n4 = n;
            XEiJ.regRn[n4] = XEiJ.regRn[n4] & 0xFFFFFF00;
            return;
        }
        if (n < 16) {
            if (XEiJ.FPU_CCMAP_882[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
                XEiJ.mpuCycleCount += 16;
                XEiJ.regPC += 2;
                return;
            }
            int n5 = XEiJ.regOC & 7;
            int n6 = XEiJ.regRn[n5];
            if ((short)n6 == 0) {
                XEiJ.mpuCycleCount += 18;
                XEiJ.regRn[n5] = n6 + 65535;
                XEiJ.regPC += 2;
                return;
            }
            XEiJ.mpuCycleCount += 14;
            XEiJ.regRn[n5] = n6 - 1;
            MC68EC030.irpSetPC(XEiJ.regPC + XEiJ.busRws(XEiJ.regPC));
            return;
        }
        if (n < 58) {
            XEiJ.mpuCycleCount += 12;
            XEiJ.busWb(MC68EC030.efaMltByte(n), XEiJ.FPU_CCMAP_882[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF] ? 255 : 0);
            return;
        }
        if (n > 60) {
            XEiJ.regPC = XEiJ.regPC0 + 2;
            MC68EC030.irpFline();
            return;
        }
        int n7 = (n & 3) + (n & 1);
        XEiJ.regPC += n7;
        if (!XEiJ.FPU_CCMAP_882[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
            XEiJ.mpuCycleCount += 8 + (n7 << 1);
            return;
        }
        XEiJ.mpuCycleCount += 4 + (n7 << 1);
        M68kException.m6eAddress = XEiJ.regPC0;
        M68kException.m6eNumber = 7;
        throw M68kException.m6eSignal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFbccWord() throws M68kException {
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        if ((XEiJ.regOC & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                MC68EC030.irpException(48, XEiJ.regPC0, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 0, 0);
                return;
            }
        }
        if (XEiJ.FPU_CCMAP_882[(XEiJ.regOC & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
            XEiJ.mpuCycleCount += 10;
            int n = XEiJ.regPC;
            XEiJ.regPC = n + 2;
            n = XEiJ.busRwse(n);
            MC68EC030.irpSetPC(XEiJ.regPC0 + 2 + n);
            return;
        }
        XEiJ.mpuCycleCount += 12;
        XEiJ.regPC += 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFbccLong() throws M68kException {
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        if ((XEiJ.regOC & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                MC68EC030.irpException(48, XEiJ.regPC0, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 0, 0);
                return;
            }
        }
        if (XEiJ.FPU_CCMAP_882[(XEiJ.regOC & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
            XEiJ.mpuCycleCount += 14;
            int n = XEiJ.regPC;
            XEiJ.regPC = n + 4;
            n = XEiJ.busRlse(n);
            MC68EC030.irpSetPC(XEiJ.regPC0 + 2 + n);
            return;
        }
        XEiJ.mpuCycleCount += 12;
        XEiJ.regPC += 4;
    }

    public static void irpFsave() throws M68kException {
        int n;
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
            return;
        }
        if (XEiJ.regSRS == 0) {
            MC68EC030.irpFline();
            return;
        }
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 >> 3 == 4) {
            int n3;
            int n4 = n3 = XEiJ.regOC & 7 | 8;
            int n5 = XEiJ.regRn[n4] - 4;
            XEiJ.regRn[n4] = n5;
            n = n5;
            XEiJ.mpuCycleCount += 8;
        } else {
            n = MC68EC030.efaCltLong(n2);
        }
        XEiJ.busWl(n, 0);
    }

    public static void irpFrestore() throws M68kException {
        int n;
        if ((7 & XEiJ.currentCopro0) == 0) {
            MC68EC030.irpFline();
            return;
        }
        if (XEiJ.regSRS == 0) {
            MC68EC030.irpFline();
            return;
        }
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 >> 3 == 3) {
            int n3 = XEiJ.regOC & 7 | 8;
            n = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n + 4;
            XEiJ.mpuCycleCount += 8;
        } else {
            n = MC68EC030.efaCntLong(n2);
        }
        XEiJ.busRls(n);
        XEiJ.fpuBox.epbFpsr = 0;
        XEiJ.fpuBox.epbFpiar = 0;
    }

    public static boolean irpFPPreInstruction() throws M68kException {
        int n = XEiJ.fpuBox.epbFpcr & XEiJ.fpuBox.epbFpsr & 0xFF00;
        if (n == 0) {
            return false;
        }
        MC68EC030.irpException(FP_OFFSET_TO_NUMBER[Integer.numberOfLeadingZeros(n)], XEiJ.regPC0, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 0, 0);
        return true;
    }

    public static boolean irpFPPostInstruction(int n) throws M68kException {
        int n2 = XEiJ.fpuBox.epbFpcr & XEiJ.fpuBox.epbFpsr & 0xFF00;
        if (n2 == 0) {
            return false;
        }
        MC68EC030.irpException(FP_OFFSET_TO_NUMBER[Integer.numberOfLeadingZeros(n2)], XEiJ.regPC, XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 12288, n);
        return true;
    }

    public static void irpFpack() throws M68kException {
        if (!MainMemory.mmrFEfuncActivated) {
            MC68EC030.irpFline();
            return;
        }
        XEiJ.mpuCycleCount += 80;
        switch (XEiJ.regOC & 0xFF) {
            case 0: {
                FEFunction.fpkLMUL();
                break;
            }
            case 1: {
                FEFunction.fpkLDIV();
                break;
            }
            case 2: {
                FEFunction.fpkLMOD();
                break;
            }
            case 4: {
                FEFunction.fpkUMUL();
                break;
            }
            case 5: {
                FEFunction.fpkUDIV();
                break;
            }
            case 6: {
                FEFunction.fpkUMOD();
                break;
            }
            case 8: {
                FEFunction.fpkIMUL();
                break;
            }
            case 9: {
                FEFunction.fpkIDIV();
                break;
            }
            case 12: {
                FEFunction.fpkRANDOMIZE();
                break;
            }
            case 13: {
                FEFunction.fpkSRAND();
                break;
            }
            case 14: {
                FEFunction.fpkRAND();
                break;
            }
            case 16: {
                FEFunction.fpkSTOL();
                break;
            }
            case 17: {
                FEFunction.fpkLTOS();
                break;
            }
            case 18: {
                FEFunction.fpkSTOH();
                break;
            }
            case 19: {
                FEFunction.fpkHTOS();
                break;
            }
            case 20: {
                FEFunction.fpkSTOO();
                break;
            }
            case 21: {
                FEFunction.fpkOTOS();
                break;
            }
            case 22: {
                FEFunction.fpkSTOB();
                break;
            }
            case 23: {
                FEFunction.fpkBTOS();
                break;
            }
            case 24: {
                FEFunction.fpkIUSING();
                break;
            }
            case 26: {
                FEFunction.fpkLTOD();
                break;
            }
            case 27: {
                FEFunction.fpkDTOL();
                break;
            }
            case 28: {
                FEFunction.fpkLTOF();
                break;
            }
            case 29: {
                FEFunction.fpkFTOL();
                break;
            }
            case 30: {
                FEFunction.fpkFTOD();
                break;
            }
            case 31: {
                FEFunction.fpkDTOF();
                break;
            }
            case 32: {
                FEFunction.fpkVAL();
                break;
            }
            case 33: {
                FEFunction.fpkUSING();
                break;
            }
            case 34: {
                FEFunction.fpkSTOD();
                break;
            }
            case 35: {
                FEFunction.fpkDTOS();
                break;
            }
            case 36: {
                FEFunction.fpkECVT();
                break;
            }
            case 37: {
                FEFunction.fpkFCVT();
                break;
            }
            case 38: {
                FEFunction.fpkGCVT();
                break;
            }
            case 40: {
                FEFunction.fpkDTST();
                break;
            }
            case 41: {
                FEFunction.fpkDCMP();
                break;
            }
            case 42: {
                FEFunction.fpkDNEG();
                break;
            }
            case 43: {
                FEFunction.fpkDADD();
                break;
            }
            case 44: {
                FEFunction.fpkDSUB();
                break;
            }
            case 45: {
                FEFunction.fpkDMUL();
                break;
            }
            case 46: {
                FEFunction.fpkDDIV();
                break;
            }
            case 47: {
                FEFunction.fpkDMOD();
                break;
            }
            case 48: {
                FEFunction.fpkDABS();
                break;
            }
            case 49: {
                FEFunction.fpkDCEIL();
                break;
            }
            case 50: {
                FEFunction.fpkDFIX();
                break;
            }
            case 51: {
                FEFunction.fpkDFLOOR();
                break;
            }
            case 52: {
                FEFunction.fpkDFRAC();
                break;
            }
            case 53: {
                FEFunction.fpkDSGN();
                break;
            }
            case 54: {
                FEFunction.fpkSIN();
                break;
            }
            case 55: {
                FEFunction.fpkCOS();
                break;
            }
            case 56: {
                FEFunction.fpkTAN();
                break;
            }
            case 57: {
                FEFunction.fpkATAN();
                break;
            }
            case 58: {
                FEFunction.fpkLOG();
                break;
            }
            case 59: {
                FEFunction.fpkEXP();
                break;
            }
            case 60: {
                FEFunction.fpkSQR();
                break;
            }
            case 61: {
                FEFunction.fpkPI();
                break;
            }
            case 62: {
                FEFunction.fpkNPI();
                break;
            }
            case 63: {
                FEFunction.fpkPOWER();
                break;
            }
            case 64: {
                FEFunction.fpkRND();
                break;
            }
            case 65: {
                FEFunction.fpkSINH();
                break;
            }
            case 66: {
                FEFunction.fpkCOSH();
                break;
            }
            case 67: {
                FEFunction.fpkTANH();
                break;
            }
            case 68: {
                FEFunction.fpkATANH();
                break;
            }
            case 69: {
                FEFunction.fpkASIN();
                break;
            }
            case 70: {
                FEFunction.fpkACOS();
                break;
            }
            case 71: {
                FEFunction.fpkLOG10();
                break;
            }
            case 72: {
                FEFunction.fpkLOG2();
                break;
            }
            case 73: {
                FEFunction.fpkDFREXP();
                break;
            }
            case 74: {
                FEFunction.fpkDLDEXP();
                break;
            }
            case 75: {
                FEFunction.fpkDADDONE();
                break;
            }
            case 76: {
                FEFunction.fpkDSUBONE();
                break;
            }
            case 77: {
                FEFunction.fpkDDIVTWO();
                break;
            }
            case 78: {
                FEFunction.fpkDIEECNV();
                break;
            }
            case 79: {
                FEFunction.fpkIEEDCNV();
                break;
            }
            case 80: {
                FEFunction.fpkFVAL();
                break;
            }
            case 81: {
                FEFunction.fpkFUSING();
                break;
            }
            case 82: {
                FEFunction.fpkSTOF();
                break;
            }
            case 83: {
                FEFunction.fpkFTOS();
                break;
            }
            case 84: {
                FEFunction.fpkFECVT();
                break;
            }
            case 85: {
                FEFunction.fpkFFCVT();
                break;
            }
            case 86: {
                FEFunction.fpkFGCVT();
                break;
            }
            case 88: {
                FEFunction.fpkFTST();
                break;
            }
            case 89: {
                FEFunction.fpkFCMP();
                break;
            }
            case 90: {
                FEFunction.fpkFNEG();
                break;
            }
            case 91: {
                FEFunction.fpkFADD();
                break;
            }
            case 92: {
                FEFunction.fpkFSUB();
                break;
            }
            case 93: {
                FEFunction.fpkFMUL();
                break;
            }
            case 94: {
                FEFunction.fpkFDIV();
                break;
            }
            case 95: {
                FEFunction.fpkFMOD();
                break;
            }
            case 96: {
                FEFunction.fpkFABS();
                break;
            }
            case 97: {
                FEFunction.fpkFCEIL();
                break;
            }
            case 98: {
                FEFunction.fpkFFIX();
                break;
            }
            case 99: {
                FEFunction.fpkFFLOOR();
                break;
            }
            case 100: {
                FEFunction.fpkFFRAC();
                break;
            }
            case 101: {
                FEFunction.fpkFSGN();
                break;
            }
            case 102: {
                FEFunction.fpkFSIN();
                break;
            }
            case 103: {
                FEFunction.fpkFCOS();
                break;
            }
            case 104: {
                FEFunction.fpkFTAN();
                break;
            }
            case 105: {
                FEFunction.fpkFATAN();
                break;
            }
            case 106: {
                FEFunction.fpkFLOG();
                break;
            }
            case 107: {
                FEFunction.fpkFEXP();
                break;
            }
            case 108: {
                FEFunction.fpkFSQR();
                break;
            }
            case 109: {
                FEFunction.fpkFPI();
                break;
            }
            case 110: {
                FEFunction.fpkFNPI();
                break;
            }
            case 111: {
                FEFunction.fpkFPOWER();
                break;
            }
            case 112: {
                FEFunction.fpkFRND();
                break;
            }
            case 113: {
                FEFunction.fpkFSINH();
                break;
            }
            case 114: {
                FEFunction.fpkFCOSH();
                break;
            }
            case 115: {
                FEFunction.fpkFTANH();
                break;
            }
            case 116: {
                FEFunction.fpkFATANH();
                break;
            }
            case 117: {
                FEFunction.fpkFASIN();
                break;
            }
            case 118: {
                FEFunction.fpkFACOS();
                break;
            }
            case 119: {
                FEFunction.fpkFLOG10();
                break;
            }
            case 120: {
                FEFunction.fpkFLOG2();
                break;
            }
            case 121: {
                FEFunction.fpkFFREXP();
                break;
            }
            case 122: {
                FEFunction.fpkFLDEXP();
                break;
            }
            case 123: {
                FEFunction.fpkFADDONE();
                break;
            }
            case 124: {
                FEFunction.fpkFSUBONE();
                break;
            }
            case 125: {
                FEFunction.fpkFDIVTWO();
                break;
            }
            case 126: {
                FEFunction.fpkFIEECNV();
                break;
            }
            case 127: {
                FEFunction.fpkIEEFCNV();
                break;
            }
            case 224: {
                FEFunction.fpkCLMUL();
                break;
            }
            case 225: {
                FEFunction.fpkCLDIV();
                break;
            }
            case 226: {
                FEFunction.fpkCLMOD();
                break;
            }
            case 227: {
                FEFunction.fpkCUMUL();
                break;
            }
            case 228: {
                FEFunction.fpkCUDIV();
                break;
            }
            case 229: {
                FEFunction.fpkCUMOD();
                break;
            }
            case 230: {
                FEFunction.fpkCLTOD();
                break;
            }
            case 231: {
                FEFunction.fpkCDTOL();
                break;
            }
            case 232: {
                FEFunction.fpkCLTOF();
                break;
            }
            case 233: {
                FEFunction.fpkCFTOL();
                break;
            }
            case 234: {
                FEFunction.fpkCFTOD();
                break;
            }
            case 235: {
                FEFunction.fpkCDTOF();
                break;
            }
            case 236: {
                FEFunction.fpkCDCMP();
                break;
            }
            case 237: {
                FEFunction.fpkCDADD();
                break;
            }
            case 238: {
                FEFunction.fpkCDSUB();
                break;
            }
            case 239: {
                FEFunction.fpkCDMUL();
                break;
            }
            case 240: {
                FEFunction.fpkCDDIV();
                break;
            }
            case 241: {
                FEFunction.fpkCDMOD();
                break;
            }
            case 242: {
                FEFunction.fpkCFCMP();
                break;
            }
            case 243: {
                FEFunction.fpkCFADD();
                break;
            }
            case 244: {
                FEFunction.fpkCFSUB();
                break;
            }
            case 245: {
                FEFunction.fpkCFMUL();
                break;
            }
            case 246: {
                FEFunction.fpkCFDIV();
                break;
            }
            case 247: {
                FEFunction.fpkCFMOD();
                break;
            }
            case 248: {
                FEFunction.fpkCDTST();
                break;
            }
            case 249: {
                FEFunction.fpkCFTST();
                break;
            }
            case 250: {
                FEFunction.fpkCDINC();
                break;
            }
            case 251: {
                FEFunction.fpkCFINC();
                break;
            }
            case 252: {
                FEFunction.fpkCDDEC();
                break;
            }
            case 253: {
                FEFunction.fpkCFDEC();
                break;
            }
            case 254: {
                FEFunction.fpkFEVARG();
                break;
            }
            default: {
                XEiJ.mpuCycleCount -= 80;
                MC68EC030.irpFline();
            }
        }
    }

    public static void irpFline() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x1FF;
        if (XEiJ.regSRS == 0) {
            if (272 <= n2 && n2 <= 279 || 288 <= n2 && n2 <= 313 || 336 <= n2 && n2 <= 351 || 360 <= n2 && n2 <= 379) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
        } else if (336 <= n2 && n2 <= 351 || 360 <= n2 && n2 <= 379) {
            n = n2 & 0x3F;
            if (n >> 3 == 3) {
                n -= 8;
            }
            XEiJ.busRls(MC68EC030.efaCntLong(n));
        }
        XEiJ.mpuCycleCount += 34;
        n = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        int n3 = XEiJ.regRn[15];
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n3;
            n3 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n3 -= 8;
        XEiJ.busWw(n3 + 6, 44);
        XEiJ.busWl(n3 + 2, XEiJ.regPC0);
        XEiJ.busWw(n3, n);
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + 44));
    }

    public static void irpIllegal() throws M68kException {
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int irpAbcd(int n, int n2) {
        int n3;
        int n4 = XEiJ.regCCR >> 4;
        int n5 = n3 = (n & 0xFF) + (n2 & 0xFF) + n4;
        if (10 <= (n & 0xF) + (n2 & 0xF) + n4) {
            n5 += 6;
        }
        if (160 <= n5) {
            n5 += 96;
            XEiJ.regCCR |= 0x11;
        } else {
            XEiJ.regCCR &= 0xFFFFFFEE;
        }
        if ((n5 &= 0xFF) != 0) {
            XEiJ.regCCR &= 0xFFFFFFFB;
        }
        XEiJ.regCCR = (n5 & 0x80) != 0 ? (XEiJ.regCCR |= 8) : (XEiJ.regCCR &= 0xFFFFFFF7);
        XEiJ.regCCR &= 0xFFFFFFFD;
        return n5;
    }

    public static int irpSbcd(int n, int n2) {
        int n3;
        int n4 = XEiJ.regCCR >> 4;
        int n5 = n3 = (n & 0xFF) - (n2 & 0xFF) - n4;
        if ((n & 0xF) - (n2 & 0xF) - n4 < 0) {
            n5 -= 6;
        }
        if (n5 < 0) {
            if (n3 < 0) {
                n5 -= 96;
            }
            XEiJ.regCCR |= 0x11;
        } else {
            XEiJ.regCCR &= 0xFFFFFFEE;
        }
        if ((n5 &= 0xFF) != 0) {
            XEiJ.regCCR &= 0xFFFFFFFB;
        }
        XEiJ.regCCR = (n5 & 0x80) != 0 ? (XEiJ.regCCR |= 8) : (XEiJ.regCCR &= 0xFFFFFFF7);
        XEiJ.regCCR &= 0xFFFFFFFD;
        return n5;
    }

    public static void irpEmx() throws M68kException {
        switch (XEiJ.regOC & 0x3F) {
            case 0: {
                XEiJ.mpuCycleCount += 40;
                if (!HFS.hfsIPLBoot()) break;
                MC68EC030.irpSetPC(26624);
                break;
            }
            case 1: {
                XEiJ.mpuCycleCount += 40;
                HFS.hfsInstall();
                break;
            }
            case 2: {
                XEiJ.mpuCycleCount += 40;
                HFS.hfsStrategy();
                break;
            }
            case 3: {
                XEiJ.mpuCycleCount += 40;
                if (!HFS.hfsInterrupt()) break;
                XEiJ.mpuTraceFlag = 0;
                XEiJ.regPC = XEiJ.regPC0;
                XEiJ.mpuClockTime += 4000000L;
                XEiJ.mpuLastNano += 4000L;
                break;
            }
            case 4: {
                XEiJ.emxNop();
                break;
            }
            case 5: {
                WaitInstruction.execute();
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpSetPC(int n) throws M68kException {
        if ((n & 1) != 0) {
            M68kException.m6eNumber = 3;
            M68kException.m6eAddress = n & 0xFFFFFFFE;
            M68kException.m6eDirection = 1;
            M68kException.m6eSize = 2;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuTraceFlag |= XEiJ.regSRT0;
        BranchLog.blgJump(n);
    }

    public static void irpSetSR(int n) {
        XEiJ.regSRT1 = 0x8000 & n;
        XEiJ.regSRT0 = 0x4000 & n;
        int n2 = XEiJ.regSRM;
        XEiJ.regSRM = 0x1000 & n;
        XEiJ.regSRS = 0x2000 & n;
        if (XEiJ.regSRS == 0) {
            if (n2 != 0) {
                XEiJ.mpuMSP = XEiJ.regRn[15];
            } else {
                XEiJ.mpuISP = XEiJ.regRn[15];
            }
            XEiJ.regRn[15] = XEiJ.mpuUSP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpUserMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1UserMap;
        } else if (n2 != XEiJ.regSRM) {
            if (n2 != 0) {
                XEiJ.mpuMSP = XEiJ.regRn[15];
                XEiJ.regRn[15] = XEiJ.mpuISP;
            } else {
                XEiJ.mpuISP = XEiJ.regRn[15];
                XEiJ.regRn[15] = XEiJ.mpuMSP;
            }
        }
        XEiJ.regSRI = 0x700 & n;
        XEiJ.mpuIMR = 127 >> (XEiJ.regSRI >> 8);
        int n3 = XEiJ.mpuIMR & XEiJ.mpuISR;
        if (n3 != 0) {
            XEiJ.mpuISR ^= n3;
            if (n3 == 2) {
                MC68901.mfpDone();
            } else if (n3 == 16) {
                HD63450.dmaDone();
            } else if (n3 == 4) {
                Z8530.sccDone();
            } else if (n3 == 64) {
                IOInterrupt.ioiDone();
            } else if (n3 == 32) {
                XEiJ.eb2Done();
            } else {
                if ((n3 & 2) != 0) {
                    MC68901.mfpDone();
                }
                if (n3 << 27 < 0) {
                    HD63450.dmaDone();
                }
                if (n3 << 29 < 0) {
                    Z8530.sccDone();
                }
                if (n3 << 25 < 0) {
                    IOInterrupt.ioiDone();
                }
                if (n3 << 26 < 0) {
                    XEiJ.eb2Done();
                }
                if ((n3 & 1) != 0) {
                    XEiJ.sysDone();
                }
            }
        }
        XEiJ.mpuIMR |= ~XEiJ.mpuISR & 1;
        XEiJ.regCCR = 0x1F & n;
    }

    public static void irpInterrupt(int n, int n2) throws M68kException {
        if (XEiJ.regOC == 20082) {
            XEiJ.regPC = XEiJ.regPC0 + 4;
        }
        XEiJ.mpuClockTime += XEiJ.mpuModifiedUnit * 44L;
        int n3 = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        XEiJ.regSRI = n2 << 8;
        XEiJ.mpuIMR = 127 >> n2;
        XEiJ.mpuISR |= 128 >> n2;
        int n4 = XEiJ.regRn[15];
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n4;
            n4 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n4 -= 8;
        XEiJ.busWw(n4 + 6, 0 | n << 2);
        XEiJ.busWl(n4 + 2, XEiJ.regPC);
        XEiJ.busWw(n4, n3);
        if (XEiJ.regSRM != 0) {
            n3 = XEiJ.regSRT1 | XEiJ.regSRT0 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
            XEiJ.regSRM = 0;
            XEiJ.mpuMSP = n4;
            n4 = XEiJ.mpuISP;
            XEiJ.regRn[15] = n4 -= 8;
            XEiJ.busWw(n4 + 6, 0x1000 | n << 2);
            XEiJ.busWl(n4 + 2, XEiJ.regPC);
            XEiJ.busWw(n4, n3);
        }
        XEiJ.regPC0 = XEiJ.regPC;
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + (n << 2)));
    }

    public static void irpException(int n, int n2, int n3, int n4, int n5) throws M68kException {
        int n6 = XEiJ.regRn[15];
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT0 = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS == 0) {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = n6;
            n6 = XEiJ.regSRM != 0 ? XEiJ.mpuMSP : XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        if (n4 <= 4096) {
            XEiJ.regRn[15] = n6 -= 8;
        } else {
            XEiJ.regRn[15] = n6 -= 12;
            XEiJ.busWl(n6 + 8, n5);
        }
        XEiJ.busWw(n6 + 6, n4 | n << 2);
        XEiJ.busWl(n6 + 2, n2);
        XEiJ.busWw(n6, n3);
        MC68EC030.irpSetPC(XEiJ.busRlsf(XEiJ.mpuVBR + (n << 2)));
    }

    public static int efaAnyByte(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = n3 + 1;
                return n3;
            }
            case 31: {
                XEiJ.mpuCycleCount += 4;
                XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
                return XEiJ.regRn[15] - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 1;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 39: {
                XEiJ.mpuCycleCount += 6;
                XEiJ.regRn[15] = XEiJ.regRn[15] - 2;
                return XEiJ.regRn[15];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 10;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 60: {
                XEiJ.mpuCycleCount += 4;
                int n16 = XEiJ.regPC;
                XEiJ.regPC = n16 + 2;
                return n16 + 1;
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemByte(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = n3 + 1;
                return n3;
            }
            case 31: {
                XEiJ.mpuCycleCount += 4;
                XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
                return XEiJ.regRn[15] - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 1;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 39: {
                XEiJ.mpuCycleCount += 6;
                XEiJ.regRn[15] = XEiJ.regRn[15] - 2;
                return XEiJ.regRn[15];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 10;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltByte(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = n3 + 1;
                return n3;
            }
            case 31: {
                XEiJ.mpuCycleCount += 4;
                XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
                return XEiJ.regRn[15] - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 1;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 39: {
                XEiJ.mpuCycleCount += 6;
                XEiJ.regRn[15] = XEiJ.regRn[15] - 2;
                return XEiJ.regRn[15];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaCntByte(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 10;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n7 = XEiJ.regPC;
                XEiJ.regPC = n7 + 2;
                return n7 + XEiJ.busRwse(n7);
            }
            case 59: {
                int n8;
                XEiJ.mpuCycleCount += 10;
                int n9 = XEiJ.regPC;
                XEiJ.regPC = n9 + 2;
                int n10 = XEiJ.busRwze(n9);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n10 & 0x1FF];
                n9 = ((~n10 & 0x180) == 0 ? 0 : n9) + (n10 << 23 >= 0 ? (byte)n10 : (n10 << 26 >= 0 ? (byte)0 : (n10 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n11 = (~n10 & 0x140) == 0 ? 0 : (n8 = (n10 << 20 >= 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << (n10 >> 9 & 3));
                return (n10 & 0x103) <= 256 ? n9 + n8 : (n10 << 29 >= 0 ? XEiJ.busRls(n9 + n8) : XEiJ.busRls(n9) + n8) + ((n10 & 2) == 0 ? 0 : ((n10 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaAnyWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 2;
                XEiJ.regRn[n2] = n3;
                return n3 - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 2;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 10;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 60: {
                XEiJ.mpuCycleCount += 4;
                int n16 = XEiJ.regPC;
                XEiJ.regPC = n16 + 2;
                return n16;
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 2;
                XEiJ.regRn[n2] = n3;
                return n3 - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 2;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 10;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 4;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 2;
                XEiJ.regRn[n2] = n3;
                return n3 - 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 6;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 2;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 10;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaCntWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 10;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n7 = XEiJ.regPC;
                XEiJ.regPC = n7 + 2;
                return n7 + XEiJ.busRwse(n7);
            }
            case 59: {
                int n8;
                XEiJ.mpuCycleCount += 10;
                int n9 = XEiJ.regPC;
                XEiJ.regPC = n9 + 2;
                int n10 = XEiJ.busRwze(n9);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n10 & 0x1FF];
                n9 = ((~n10 & 0x180) == 0 ? 0 : n9) + (n10 << 23 >= 0 ? (byte)n10 : (n10 << 26 >= 0 ? (byte)0 : (n10 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n11 = (~n10 & 0x140) == 0 ? 0 : (n8 = (n10 << 20 >= 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << (n10 >> 9 & 3));
                return (n10 & 0x103) <= 256 ? n9 + n8 : (n10 << 29 >= 0 ? XEiJ.busRls(n9 + n8) : XEiJ.busRls(n9) + n8) + ((n10 & 2) == 0 ? 0 : ((n10 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaCltWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 10;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaAnyLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 8;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 4;
                XEiJ.regRn[n2] = n3;
                return n3 - 4;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 10;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 4;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 12;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 14;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 12;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 14;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 60: {
                XEiJ.mpuCycleCount += 8;
                int n16 = XEiJ.regPC;
                XEiJ.regPC = n16 + 4;
                return n16;
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 8;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 4;
                XEiJ.regRn[n2] = n3;
                return n3 - 4;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 10;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 4;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 12;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 14;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 12;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 14;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 8;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 4;
                XEiJ.regRn[n2] = n3;
                return n3 - 4;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 10;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 4;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 12;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 14;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaCntLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 12;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 14;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 12;
                int n7 = XEiJ.regPC;
                XEiJ.regPC = n7 + 2;
                return n7 + XEiJ.busRwse(n7);
            }
            case 59: {
                int n8;
                XEiJ.mpuCycleCount += 14;
                int n9 = XEiJ.regPC;
                XEiJ.regPC = n9 + 2;
                int n10 = XEiJ.busRwze(n9);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n10 & 0x1FF];
                n9 = ((~n10 & 0x180) == 0 ? 0 : n9) + (n10 << 23 >= 0 ? (byte)n10 : (n10 << 26 >= 0 ? (byte)0 : (n10 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n11 = (~n10 & 0x140) == 0 ? 0 : (n8 = (n10 << 20 >= 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << (n10 >> 9 & 3));
                return (n10 & 0x103) <= 256 ? n9 + n8 : (n10 << 29 >= 0 ? XEiJ.busRls(n9 + n8) : XEiJ.busRls(n9) + n8) + ((n10 & 2) == 0 ? 0 : ((n10 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaCltLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 12;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 14;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaAnyQuad(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 16;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 8;
                XEiJ.regRn[n2] = n3;
                return n3 - 8;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 18;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 8;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 20;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 22;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 20;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 24;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 20;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 22;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 60: {
                XEiJ.mpuCycleCount += 16;
                int n16 = XEiJ.regPC;
                XEiJ.regPC = n16 + 8;
                return n16;
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltQuad(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 16;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 16;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 8;
                XEiJ.regRn[n2] = n3;
                return n3 - 8;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 18;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 8;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 20;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 22;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 20;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 24;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaAnyExtd(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 24;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 24;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 12;
                XEiJ.regRn[n2] = n3;
                return n3 - 12;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 26;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 12;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 28;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 30;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 28;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 32;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 28;
                int n11 = XEiJ.regPC;
                XEiJ.regPC = n11 + 2;
                return n11 + XEiJ.busRwse(n11);
            }
            case 59: {
                int n12;
                XEiJ.mpuCycleCount += 30;
                int n13 = XEiJ.regPC;
                XEiJ.regPC = n13 + 2;
                int n14 = XEiJ.busRwze(n13);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n14 & 0x1FF];
                n13 = ((~n14 & 0x180) == 0 ? 0 : n13) + (n14 << 23 >= 0 ? (byte)n14 : (n14 << 26 >= 0 ? (byte)0 : (n14 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n15 = (~n14 & 0x140) == 0 ? 0 : (n12 = (n14 << 20 >= 0 ? (int)XEiJ.regRn[n14 >> 12] : XEiJ.regRn[n14 >> 12]) << (n14 >> 9 & 3));
                return (n14 & 0x103) <= 256 ? n13 + n12 : (n14 << 29 >= 0 ? XEiJ.busRls(n13 + n12) : XEiJ.busRls(n13) + n12) + ((n14 & 2) == 0 ? 0 : ((n14 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 60: {
                XEiJ.mpuCycleCount += 24;
                int n16 = XEiJ.regPC;
                XEiJ.regPC = n16 + 12;
                return n16;
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltExtd(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 24;
                return XEiJ.regRn[n - 8];
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                XEiJ.mpuCycleCount += 24;
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 12;
                XEiJ.regRn[n2] = n3;
                return n3 - 12;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                XEiJ.mpuCycleCount += 26;
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 12;
                XEiJ.regRn[n4] = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 28;
                int n6 = XEiJ.regPC;
                XEiJ.regPC = n6 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n6);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n7;
                XEiJ.mpuCycleCount += 30;
                int n8 = XEiJ.regPC;
                XEiJ.regPC = n8 + 2;
                n8 = XEiJ.busRwze(n8);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n8 & 0x1FF];
                int n9 = ((~n8 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n8 << 23 >= 0 ? (byte)n8 : (n8 << 26 >= 0 ? (byte)0 : (n8 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n10 = (~n8 & 0x140) == 0 ? 0 : (n7 = (n8 << 20 >= 0 ? (int)XEiJ.regRn[n8 >> 12] : XEiJ.regRn[n8 >> 12]) << (n8 >> 9 & 3));
                return (n8 & 0x103) <= 256 ? n9 + n7 : (n8 << 29 >= 0 ? XEiJ.busRls(n9 + n7) : XEiJ.busRls(n9) + n7) + ((n8 & 2) == 0 ? 0 : ((n8 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 28;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 32;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaLeaPea(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 4;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 8;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 12;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 8;
                int n7 = XEiJ.regPC;
                XEiJ.regPC = n7 + 2;
                return n7 + XEiJ.busRwse(n7);
            }
            case 59: {
                int n8;
                XEiJ.mpuCycleCount += 12;
                int n9 = XEiJ.regPC;
                XEiJ.regPC = n9 + 2;
                int n10 = XEiJ.busRwze(n9);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n10 & 0x1FF];
                n9 = ((~n10 & 0x180) == 0 ? 0 : n9) + (n10 << 23 >= 0 ? (byte)n10 : (n10 << 26 >= 0 ? (byte)0 : (n10 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n11 = (~n10 & 0x140) == 0 ? 0 : (n8 = (n10 << 20 >= 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << (n10 >> 9 & 3));
                return (n10 & 0x103) <= 256 ? n9 + n8 : (n10 << 29 >= 0 ? XEiJ.busRls(n9 + n8) : XEiJ.busRls(n9) + n8) + ((n10 & 2) == 0 ? 0 : ((n10 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaJmpJsr(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                XEiJ.mpuCycleCount += 8;
                return XEiJ.regRn[n - 8];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                XEiJ.mpuCycleCount += 10;
                int n2 = XEiJ.regPC;
                XEiJ.regPC = n2 + 2;
                return XEiJ.regRn[n - 32] + XEiJ.busRwse(n2);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n3;
                XEiJ.mpuCycleCount += 14;
                int n4 = XEiJ.regPC;
                XEiJ.regPC = n4 + 2;
                n4 = XEiJ.busRwze(n4);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n4 & 0x1FF];
                int n5 = ((~n4 & 0x180) == 0 ? 0 : XEiJ.regRn[n - 40]) + (n4 << 23 >= 0 ? (byte)n4 : (n4 << 26 >= 0 ? (byte)0 : (n4 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n6 = (~n4 & 0x140) == 0 ? 0 : (n3 = (n4 << 20 >= 0 ? (int)XEiJ.regRn[n4 >> 12] : XEiJ.regRn[n4 >> 12]) << (n4 >> 9 & 3));
                return (n4 & 0x103) <= 256 ? n5 + n3 : (n4 << 29 >= 0 ? XEiJ.busRls(n5 + n3) : XEiJ.busRls(n5) + n3) + ((n4 & 2) == 0 ? 0 : ((n4 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
            case 56: {
                XEiJ.mpuCycleCount += 10;
                return XEiJ.busRwse((XEiJ.regPC += 2) - 2);
            }
            case 57: {
                XEiJ.mpuCycleCount += 12;
                return XEiJ.busRlse((XEiJ.regPC += 4) - 4);
            }
            case 58: {
                XEiJ.mpuCycleCount += 10;
                int n7 = XEiJ.regPC;
                XEiJ.regPC = n7 + 2;
                return n7 + XEiJ.busRwse(n7);
            }
            case 59: {
                int n8;
                XEiJ.mpuCycleCount += 14;
                int n9 = XEiJ.regPC;
                XEiJ.regPC = n9 + 2;
                int n10 = XEiJ.busRwze(n9);
                XEiJ.mpuCycleCount += XEiJ.EFA_EXTENSION_CLK[n10 & 0x1FF];
                n9 = ((~n10 & 0x180) == 0 ? 0 : n9) + (n10 << 23 >= 0 ? (byte)n10 : (n10 << 26 >= 0 ? (byte)0 : (n10 << 27 >= 0 ? (byte)XEiJ.busRwse((XEiJ.regPC += 2) - 2) : (byte)XEiJ.busRlse((XEiJ.regPC += 4) - 4))));
                int n11 = (~n10 & 0x140) == 0 ? 0 : (n8 = (n10 << 20 >= 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << (n10 >> 9 & 3));
                return (n10 & 0x103) <= 256 ? n9 + n8 : (n10 << 29 >= 0 ? XEiJ.busRls(n9 + n8) : XEiJ.busRls(n9) + n8) + ((n10 & 2) == 0 ? 0 : ((n10 & 1) == 0 ? XEiJ.busRwse((XEiJ.regPC += 2) - 2) : XEiJ.busRlse((XEiJ.regPC += 4) - 4)));
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    static {
        FP_OFFSET_TO_NUMBER = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000006453211\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
    }
}

