/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import xeij.ADPCM;
import xeij.ComponentFactory;
import xeij.CyberStickAnalog;
import xeij.CyberStickDigital;
import xeij.DummyPad;
import xeij.Joystick;
import xeij.MegaDrive3ButtonPad;
import xeij.MegaDrive6ButtonPad;
import xeij.Multilingual;
import xeij.Normal2ButtonPad;
import xeij.OldSerialPort;
import xeij.RestorableFrame;
import xeij.Settings;
import xeij.Shiromadokun;
import xeij.XEiJ;
import xeij.XInput;

public class PPI {
    public static final int PPI_PORT_A = 15310849;
    public static final int PPI_PORT_B = 15310851;
    public static final int PPI_PORT_C = 15310853;
    public static final int PPI_CONTROL = 15310855;
    public static Joystick[] ppiJoysticks;
    public static Joystick ppiJoystick1;
    public static Joystick ppiJoystick2;
    public static boolean ppiJoyKey;
    public static boolean ppiJoyAuto;
    public static boolean ppiJoyBlock;
    public static final boolean PPI_UKUN_ON = true;
    public static final boolean PPI_UKUN_DEBUG = false;
    public static final int PPI_UKUN_VID = 1240;
    public static final int PPI_UKUN_PID = 59059;
    public static boolean ppiUkunRequestedConnection;
    public static boolean ppiUkunCurrentConnection;
    public static OldSerialPort ppiUkunOldSerialPort;
    public static String ppiUkunPortName;
    public static OldSerialPort.SerialInputStream ppiUkunOldInputStream;
    public static OldSerialPort.SerialOutputStream ppiUkunOldOutputStream;
    public static final int PPI_UKUN_NOTIFY_A = 49;
    public static final int PPI_UKUN_NOTIFY_B = 305;
    public static final int PPI_UKUN_COMMAND = 50;
    public static final int PPI_UKUN_TRANSITION = 0;
    public static volatile int ppiUkunRequestedMode;
    public static volatile int ppiUkunCurrentMode;
    public static volatile int ppiUkunPortA;
    public static volatile int ppiUkunPortB;
    public static volatile int ppiUkunPortC;
    public static volatile boolean ppiUkunSending;
    public static volatile Thread ppiUkunThread;
    public static final boolean PPI_UKUN_NANO = false;
    public static boolean ppiUkunNanoMeasuring;
    public static long[] ppiUkunNanoBestArray;
    public static long[] ppiUkunNanoWorstArray;
    public static long[] ppiUkunNanoTotalArray;
    public static long[] ppiUkunNanoCountArray;
    public static final long PPI_UKUN_WAIT = 100000000L;
    public static final boolean PPI_UKUN_INTERVAL = true;
    public static final long PPI_UKUN_INTERVAL_LIMIT = 500000000L;
    public static boolean ppiUkunIntervalOn;
    public static long ppiUkunLastVirtualTime;
    public static long ppiUkunLastRealTime;
    public static JCheckBox ppiUkunConnectCheckbox;
    public static JRadioButton ppiUkunNotifyAModeRadioButton;
    public static JRadioButton ppiUkunNotifyBModeRadioButton;
    public static JRadioButton ppiUkunCommandModeRadioButton;
    public static final boolean PPI_UKUN_JSERIALCOMM = true;
    public static final String PPI_UKUN_DESCRIPTION = "8255 emulator";
    public static boolean ppiUkunJSerialCommOn;
    public static SerialPort ppiUkunSerialPort;
    public static UkunDataListener ppiUkunDataListener;
    public static JCheckBox ppiUkunJSerialCommCheckbox;
    public static int ppiPortCData;
    public static final long PPI_CONTINUOUS_ACCESS_SPAN = 100000000000L;
    public static long ppiLastAccessTime;
    public static final boolean PPI_XINPUT_ON = true;
    public static boolean ppiXInputOn;
    public static XInput ppiXInput;
    public static int ppiXInputLastButtons;
    public static JFrame ppiFrame;
    public static JScrollPane ppiConfigurationScrollPane;

    public static void ppiInit() {
        ppiJoyKey = Settings.sgsGetOnOff("joykey");
        ppiJoyAuto = Settings.sgsGetOnOff("joyauto");
        ppiJoyBlock = Settings.sgsGetOnOff("joyblock");
        ppiJoysticks = new Joystick[]{new DummyPad(), new Normal2ButtonPad(1), new Normal2ButtonPad(2), new MegaDrive3ButtonPad(1), new MegaDrive3ButtonPad(2), new MegaDrive6ButtonPad(1), new MegaDrive6ButtonPad(2), new CyberStickAnalog(1), new CyberStickAnalog(2), new CyberStickDigital(1), new CyberStickDigital(2), new Shiromadokun(1), new Shiromadokun(2)};
        String string = Settings.sgsGetString("joystick1");
        ppiJoystick1 = ppiJoysticks[0];
        for (Joystick joystick : ppiJoysticks) {
            if (!joystick.getId().equalsIgnoreCase(string)) continue;
            ppiJoystick1 = joystick;
        }
        String string2 = Settings.sgsGetString("joystick2");
        ppiJoystick2 = ppiJoysticks[0];
        for (Joystick joystick : ppiJoysticks) {
            if (!joystick.getId().equalsIgnoreCase(string2)) continue;
            ppiJoystick2 = joystick;
        }
        ppiUkunRequestedConnection = Settings.sgsGetOnOff("joyportukun");
        ppiUkunCurrentConnection = false;
        ppiUkunPortName = null;
        ppiUkunOldSerialPort = null;
        ppiUkunOldInputStream = null;
        ppiUkunOldOutputStream = null;
        String string3 = Settings.sgsGetString("ukunmode");
        ppiUkunCurrentMode = ppiUkunRequestedMode = string3.equalsIgnoreCase("notifya") ? 49 : (string3.equalsIgnoreCase("notifyb") ? 305 : (string3.equalsIgnoreCase("command") ? 50 : 49));
        ppiUkunPortA = 255;
        ppiUkunPortB = 255;
        ppiUkunPortC = 0;
        ppiUkunSending = false;
        ppiUkunThread = null;
        ppiUkunIntervalOn = Settings.sgsGetOnOff("ukuninterval");
        ppiUkunLastVirtualTime = XEiJ.mpuClockTime;
        ppiUkunLastRealTime = System.nanoTime();
        ppiUkunJSerialCommOn = !XEiJ.prgIsWindows || Settings.sgsGetOnOff("ukunjsc");
        ppiUkunSerialPort = null;
        ppiUkunDataListener = null;
        boolean bl = ppiXInputOn = XEiJ.prgWindllLoaded && Settings.sgsGetOnOff("xinput");
        if (ppiXInputOn) {
            PPI.ppiXInputStart();
        }
        ppiXInputLastButtons = 0;
        PPI.ppiReset();
    }

    public static void ppiTini() {
        Settings.sgsPutOnOff("joykey", ppiJoyKey);
        Settings.sgsPutOnOff("joyauto", ppiJoyAuto);
        Settings.sgsPutOnOff("joyblock", ppiJoyBlock);
        for (Joystick joystick : ppiJoysticks) {
            joystick.tini();
        }
        Settings.sgsPutString("joystick1", ppiJoystick1.getId());
        Settings.sgsPutString("joystick2", ppiJoystick2.getId());
        Settings.sgsPutOnOff("joyportukun", ppiUkunRequestedConnection);
        Settings.sgsPutString("ukunmode", ppiUkunRequestedMode == 49 ? "notifya" : (ppiUkunRequestedMode == 305 ? "notifyb" : (ppiUkunRequestedMode == 50 ? "command" : "notifya")));
        Settings.sgsPutOnOff("ukuninterval", ppiUkunIntervalOn);
        Settings.sgsPutOnOff("ukunjsc", !XEiJ.prgIsWindows ? false : ppiUkunJSerialCommOn);
        PPI.ppiUkunDisconnect();
        Settings.sgsPutOnOff("xinput", ppiXInputOn);
        if (ppiXInputOn) {
            ppiXInputOn = false;
            PPI.ppiXInputEnd();
        }
    }

    public static void ppiReset() {
        ppiPortCData = 0;
        ppiLastAccessTime = 0L;
    }

    public static void ppiXInputStart() {
        if (ppiXInput == null) {
            System.out.println(Multilingual.mlnJapanese ? "XInput \u306e\u30dd\u30fc\u30ea\u30f3\u30b0\u3092\u958b\u59cb\u3057\u307e\u3059" : "Starts polling XInput");
            ppiXInput = new XInput();
        }
    }

    public static void ppiXInputEnd() {
        if (ppiXInput != null) {
            System.out.println(Multilingual.mlnJapanese ? "XInput \u306e\u30dd\u30fc\u30ea\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3059" : "Ends polling XInput");
            ppiXInput.end();
            ppiXInput = null;
        }
    }

    public static void ppiUkunConnect() {
        ppiUkunRequestedConnection = true;
        if (ppiUkunCurrentConnection) {
            PPI.ppiUkunAdjustMenu();
            return;
        }
        if (ppiUkunJSerialCommOn) {
            if (ppiUkunSerialPort == null) {
                for (SerialPort serialPort : SerialPort.getCommPorts()) {
                    if (!serialPort.getPortDescription().startsWith(PPI_UKUN_DESCRIPTION) || !serialPort.openPort()) continue;
                    ppiUkunSerialPort = serialPort;
                    break;
                }
            }
            if (ppiUkunSerialPort == null) {
                System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306e\u30b7\u30ea\u30a2\u30eb\u30dd\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" : "Serial port for JoyPortUkun (%s) not found\n", PPI_UKUN_DESCRIPTION);
                ppiUkunRequestedConnection = false;
                PPI.ppiUkunAdjustMenu();
                return;
            }
            ppiUkunPortName = ppiUkunSerialPort.getSystemPortName();
            ppiUkunSerialPort.setComPortParameters(480000000, 8, 1, 0);
            ppiUkunSerialPort.setComPortTimeouts(272, 0, 0);
        } else {
            if (ppiUkunOldSerialPort == null) {
                try {
                    ppiUkunOldSerialPort = new OldSerialPort(1240, 59059);
                }
                catch (IOException iOException) {
                    System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (VID=%04X, PID=%04X) \u306e COM \u30dd\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" : "COM port for JoyPortUkun (VID=%04X, PID=%04X) not found\n", 1240, 59059);
                    ppiUkunRequestedConnection = false;
                    PPI.ppiUkunAdjustMenu();
                    return;
                }
            }
            try {
                ppiUkunPortName = ppiUkunOldSerialPort.getPortName();
                ppiUkunOldSerialPort.speed("480000000 b8 pn s1 none");
                ppiUkunOldInputStream = ppiUkunOldSerialPort.getInputStream();
                ppiUkunOldOutputStream = ppiUkunOldSerialPort.getOutputStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ppiUkunCurrentMode = 0;
        ppiUkunCurrentConnection = true;
        PPI.ppiUkunAdjustMenu();
        if (ppiUkunJSerialCommOn) {
            System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s, %s) \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\n" : "Connected to JoyPortUkun (%s, %s)\n", ppiUkunPortName, ppiUkunSerialPort.getPortDescription());
            if (ppiUkunDataListener == null) {
                ppiUkunSending = false;
                ppiUkunDataListener = new UkunDataListener();
                ppiUkunSerialPort.addDataListener(ppiUkunDataListener);
            }
            ppiUkunSerialPort.writeBytes(new byte[]{(byte)ppiUkunRequestedMode}, 1);
        } else {
            System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s, VID=%04X, PID=%04X) \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\n" : "Connected to JoyPortUkun (%s, VID=%04X, PID=%04X)\n", ppiUkunPortName, 1240, 59059);
            if (ppiUkunThread == null) {
                ppiUkunSending = false;
                ppiUkunThread = new UkunThread();
                ppiUkunThread.start();
            }
            try {
                ppiUkunOldOutputStream.write(ppiUkunRequestedMode);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void ppiUkunDisconnect() {
        ppiUkunRequestedConnection = false;
        if (!ppiUkunCurrentConnection) {
            PPI.ppiUkunAdjustMenu();
            return;
        }
        ppiUkunCurrentMode = 0;
        ppiUkunCurrentConnection = false;
        PPI.ppiUkunAdjustMenu();
        if (ppiUkunJSerialCommOn) {
            if (ppiUkunSerialPort != null) {
                ppiUkunSerialPort.removeDataListener();
                ppiUkunDataListener = null;
                ppiUkunSerialPort.closePort();
                ppiUkunSerialPort = null;
            }
        } else {
            if (ppiUkunOldSerialPort != null) {
                try {
                    ppiUkunOldSerialPort.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ppiUkunOldSerialPort = null;
                ppiUkunOldInputStream = null;
                ppiUkunOldOutputStream = null;
            }
            while (ppiUkunThread != null) {
            }
        }
        ppiUkunSending = false;
        ppiUkunCurrentMode = ppiUkunRequestedMode;
        PPI.ppiUkunAdjustMenu();
        System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u3092\u5207\u308a\u96e2\u3057\u307e\u3057\u305f\n" : "Disconnected JoyPortUkun (%s)\n", ppiUkunPortName);
        ppiUkunPortName = null;
    }

    public static void ppiUkunNotifyAMode() {
        if (!ppiUkunRequestedConnection && !ppiUkunCurrentConnection) {
            ppiUkunRequestedMode = 49;
            ppiUkunCurrentMode = 49;
            PPI.ppiUkunAdjustMenu();
        } else if (ppiUkunRequestedConnection && ppiUkunCurrentConnection && (ppiUkunRequestedMode == 50 && ppiUkunCurrentMode == 50 || ppiUkunRequestedMode == 305 && ppiUkunCurrentMode == 305)) {
            ppiUkunRequestedMode = 49;
            ppiUkunCurrentMode = 0;
            PPI.ppiUkunAdjustMenu();
            if (ppiUkunJSerialCommOn) {
                if (ppiUkunDataListener == null) {
                    ppiUkunSending = false;
                    ppiUkunDataListener = new UkunDataListener();
                    ppiUkunSerialPort.addDataListener(ppiUkunDataListener);
                }
                ppiUkunSerialPort.writeBytes(new byte[]{49}, 1);
            } else {
                if (ppiUkunThread == null) {
                    ppiUkunSending = false;
                    ppiUkunThread = new UkunThread();
                    ppiUkunThread.start();
                }
                try {
                    ppiUkunOldOutputStream.write(49);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void ppiUkunNotifyBMode() {
        if (!ppiUkunRequestedConnection && !ppiUkunCurrentConnection) {
            ppiUkunRequestedMode = 305;
            ppiUkunCurrentMode = 305;
            PPI.ppiUkunAdjustMenu();
        } else if (ppiUkunRequestedConnection && ppiUkunCurrentConnection && (ppiUkunRequestedMode == 49 && ppiUkunCurrentMode == 49 || ppiUkunRequestedMode == 50 && ppiUkunCurrentMode == 50)) {
            ppiUkunRequestedMode = 305;
            ppiUkunCurrentMode = 0;
            PPI.ppiUkunAdjustMenu();
            if (ppiUkunJSerialCommOn) {
                if (ppiUkunDataListener == null) {
                    ppiUkunSending = false;
                    ppiUkunDataListener = new UkunDataListener();
                    ppiUkunSerialPort.addDataListener(ppiUkunDataListener);
                }
                ppiUkunSerialPort.writeBytes(new byte[]{49}, 1);
            } else {
                if (ppiUkunThread == null) {
                    ppiUkunSending = false;
                    ppiUkunThread = new UkunThread();
                    ppiUkunThread.start();
                }
                try {
                    ppiUkunOldOutputStream.write(49);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void ppiUkunCommandMode() {
        if (!ppiUkunRequestedConnection && !ppiUkunCurrentConnection) {
            ppiUkunRequestedMode = 50;
            ppiUkunCurrentMode = 50;
            PPI.ppiUkunAdjustMenu();
        } else if (ppiUkunRequestedConnection && ppiUkunCurrentConnection && (ppiUkunRequestedMode == 49 && ppiUkunCurrentMode == 49 || ppiUkunRequestedMode == 305 && ppiUkunCurrentMode == 305)) {
            ppiUkunRequestedMode = 50;
            ppiUkunCurrentMode = 0;
            PPI.ppiUkunAdjustMenu();
            if (ppiUkunJSerialCommOn) {
                if (ppiUkunDataListener == null) {
                    ppiUkunSending = false;
                    ppiUkunDataListener = new UkunDataListener();
                    ppiUkunSerialPort.addDataListener(ppiUkunDataListener);
                }
                ppiUkunSerialPort.writeBytes(new byte[]{50}, 1);
            } else {
                if (ppiUkunThread == null) {
                    ppiUkunSending = false;
                    ppiUkunThread = new UkunThread();
                    ppiUkunThread.start();
                }
                try {
                    ppiUkunOldOutputStream.write(50);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void ppiUkunMenuConnect() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PPI.ppiUkunConnect();
            }
        }, 0L);
    }

    public static void ppiUkunMenuDisconnect() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PPI.ppiUkunDisconnect();
            }
        }, 0L);
    }

    public static void ppiUkunMenuNotifyAMode() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PPI.ppiUkunNotifyAMode();
            }
        }, 0L);
    }

    public static void ppiUkunMenuNotifyBMode() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PPI.ppiUkunNotifyBMode();
            }
        }, 0L);
    }

    public static void ppiUkunMenuCommandMode() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PPI.ppiUkunCommandMode();
            }
        }, 0L);
    }

    public static void ppiUkunAdjustMenu() {
        if (ppiUkunConnectCheckbox != null) {
            if (ppiUkunConnectCheckbox.isSelected() != ppiUkunRequestedConnection) {
                ppiUkunConnectCheckbox.setSelected(ppiUkunRequestedConnection);
            }
            if (ppiUkunConnectCheckbox.isEnabled() != (ppiUkunRequestedConnection == ppiUkunCurrentConnection)) {
                ppiUkunConnectCheckbox.setEnabled(ppiUkunRequestedConnection == ppiUkunCurrentConnection);
            }
        }
        if (ppiUkunNotifyAModeRadioButton != null) {
            if (ppiUkunNotifyAModeRadioButton.isSelected() != (ppiUkunRequestedMode == 49)) {
                ppiUkunNotifyAModeRadioButton.setSelected(ppiUkunRequestedMode == 49);
            }
            if (ppiUkunNotifyAModeRadioButton.isEnabled() != (!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode)) {
                ppiUkunNotifyAModeRadioButton.setEnabled(!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode);
            }
        }
        if (ppiUkunNotifyBModeRadioButton != null) {
            if (ppiUkunNotifyBModeRadioButton.isSelected() != (ppiUkunRequestedMode == 305)) {
                ppiUkunNotifyBModeRadioButton.setSelected(ppiUkunRequestedMode == 305);
            }
            if (ppiUkunNotifyBModeRadioButton.isEnabled() != (!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode)) {
                ppiUkunNotifyBModeRadioButton.setEnabled(!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode);
            }
        }
        if (ppiUkunCommandModeRadioButton != null) {
            if (ppiUkunCommandModeRadioButton.isSelected() != (ppiUkunRequestedMode == 50)) {
                ppiUkunCommandModeRadioButton.setSelected(ppiUkunRequestedMode == 50);
            }
            if (ppiUkunCommandModeRadioButton.isEnabled() != (!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode)) {
                ppiUkunCommandModeRadioButton.setEnabled(!ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode);
            }
        }
        if (ppiUkunJSerialCommCheckbox != null) {
            if (ppiUkunJSerialCommCheckbox.isSelected() != ppiUkunJSerialCommOn) {
                ppiUkunJSerialCommCheckbox.setSelected(ppiUkunJSerialCommOn);
            }
            if (ppiUkunJSerialCommCheckbox.isEnabled() != (XEiJ.prgIsWindows && !ppiUkunCurrentConnection)) {
                ppiUkunJSerialCommCheckbox.setEnabled(XEiJ.prgIsWindows && !ppiUkunCurrentConnection);
            }
        }
    }

    public static void ppiUkunNanoStart() {
    }

    public static void ppiUkunNanoEnd() {
    }

    public static void ppiStart() {
        if (RestorableFrame.rfmGetOpened("ppi")) {
            PPI.ppiOpen();
        }
        if (ppiUkunRequestedConnection) {
            PPI.ppiUkunConnect();
        }
    }

    public static void ppiOpen() {
        if (ppiFrame == null) {
            PPI.ppiMakeFrame();
        }
        XEiJ.pnlExitFullScreen(false);
        ppiFrame.setVisible(true);
    }

    public static void ppiMakeFrame() {
        Object object;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Consider part of keyboard as joystick": {
                        ppiJoyKey = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Enabled only while the port is read repeatedly": {
                        ppiJoyAuto = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Remove key input data processed as a joystick operation": {
                        ppiJoyBlock = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "JoyPortUkun": {
                        if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                            PPI.ppiUkunMenuConnect();
                            break;
                        }
                        PPI.ppiUkunMenuDisconnect();
                        break;
                    }
                    case "Notify(A) mode": {
                        PPI.ppiUkunMenuNotifyAMode();
                        break;
                    }
                    case "Notify(B) mode": {
                        PPI.ppiUkunMenuNotifyBMode();
                        break;
                    }
                    case "Command mode": {
                        PPI.ppiUkunMenuCommandMode();
                        break;
                    }
                    case "jSerialComm": {
                        if (ppiUkunCurrentConnection) break;
                        ppiUkunJSerialCommOn = !XEiJ.prgIsWindows || ((JCheckBox)actionEvent.getSource()).isSelected();
                        PPI.ppiUkunAdjustMenu();
                        break;
                    }
                    case "Output interval adjustment": {
                        boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                        if (ppiUkunIntervalOn == bl) break;
                        if (bl) {
                            XEiJ.tmrTimer.schedule(new TimerTask(this){
                                {
                                    Objects.requireNonNull(var1_1);
                                }

                                @Override
                                public void run() {
                                    ppiUkunLastVirtualTime = XEiJ.mpuClockTime;
                                    ppiUkunLastRealTime = System.nanoTime();
                                    ppiUkunIntervalOn = true;
                                }
                            }, 0L);
                            break;
                        }
                        XEiJ.tmrTimer.schedule(new TimerTask(this){
                            {
                                Objects.requireNonNull(var1_1);
                            }

                            @Override
                            public void run() {
                                ppiUkunIntervalOn = false;
                            }
                        }, 0L);
                        break;
                    }
                    case "Nano timer": {
                        break;
                    }
                    case "XInput": {
                        if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                            if (ppiXInputOn) break;
                            ppiXInputOn = true;
                            PPI.ppiXInputStart();
                            break;
                        }
                        if (!ppiXInputOn) break;
                        ppiXInputOn = false;
                        PPI.ppiXInputEnd();
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Joystick joystick = ppiJoysticks[Integer.parseInt(actionEvent.getActionCommand())];
                if (ppiJoystick1 != joystick) {
                    ppiJoystick1.reset();
                    ppiJoystick1 = joystick;
                }
                ppiConfigurationScrollPane.setViewportView(joystick.getConfigurationPanel());
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Joystick joystick = ppiJoysticks[Integer.parseInt(actionEvent.getActionCommand())];
                if (ppiJoystick2 != joystick) {
                    ppiJoystick2.reset();
                    ppiJoystick2 = joystick;
                }
                ppiConfigurationScrollPane.setViewportView(joystick.getConfigurationPanel());
            }
        };
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Port"), "ja", "\u30dd\u30fc\u30c8"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Connect to"), "ja", "\u63a5\u7d9a"));
        arrayList.add("1");
        arrayList.add("2");
        arrayList.add(ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < ppiJoysticks.length; ++i) {
            object = ppiJoysticks[i];
            arrayList.add(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup, object == ppiJoystick1, String.valueOf(i), actionListener2), ""));
            arrayList.add(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup2, object == ppiJoystick2, String.valueOf(i), actionListener3), ""));
            arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel(((Joystick)object).getNameEn()), "ja", ((Joystick)object).getNameJa()));
        }
        JScrollPane jScrollPane = new JScrollPane(ComponentFactory.createGridPanel(3, 3 + ppiJoysticks.length, "paddingLeft=3,paddingRight=3,center", "", "italic;italic;colSpan=3,widen", "colSpan=2;rowSpan=2", arrayList.toArray(new Object[0])));
        ppiConfigurationScrollPane = new JScrollPane((ppiJoystick1 instanceof DummyPad && !(ppiJoystick2 instanceof DummyPad) || !(ppiJoystick1 instanceof Shiromadokun) && ppiJoystick2 instanceof Shiromadokun ? ppiJoystick2 : ppiJoystick1).getConfigurationPanel());
        object = new ButtonGroup();
        Component[] componentArray = new Component[11];
        Component[] componentArray2 = new Component[1];
        ppiUkunConnectCheckbox = Multilingual.mlnText(ComponentFactory.setEnabled(ComponentFactory.createCheckBox(ppiUkunRequestedConnection, "JoyPortUkun", actionListener), ppiUkunRequestedConnection == ppiUkunCurrentConnection), "ja", "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b");
        componentArray2[0] = ppiUkunConnectCheckbox;
        componentArray[0] = ComponentFactory.createFlowPanel(componentArray2);
        Component[] componentArray3 = new Component[3];
        ppiUkunNotifyAModeRadioButton = Multilingual.mlnText(ComponentFactory.setEnabled(ComponentFactory.createRadioButton((ButtonGroup)object, ppiUkunRequestedMode == 49, "Notify(A) mode", actionListener), !ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode), "ja", "Notify(A) \u30e2\u30fc\u30c9");
        componentArray3[0] = ppiUkunNotifyAModeRadioButton;
        ppiUkunNotifyBModeRadioButton = Multilingual.mlnText(ComponentFactory.setEnabled(ComponentFactory.createRadioButton((ButtonGroup)object, ppiUkunRequestedMode == 305, "Notify(B) mode", actionListener), !ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode), "ja", "Notify(B) \u30e2\u30fc\u30c9");
        componentArray3[1] = ppiUkunNotifyBModeRadioButton;
        ppiUkunCommandModeRadioButton = Multilingual.mlnText(ComponentFactory.setEnabled(ComponentFactory.createRadioButton((ButtonGroup)object, ppiUkunRequestedMode == 50, "Command mode", actionListener), !ppiUkunCurrentConnection || ppiUkunRequestedMode == ppiUkunCurrentMode), "ja", "Command \u30e2\u30fc\u30c9");
        componentArray3[2] = ppiUkunCommandModeRadioButton;
        componentArray[1] = ComponentFactory.createFlowPanel(20, 0, componentArray3);
        Component[] componentArray4 = new Component[3];
        ppiUkunJSerialCommCheckbox = ComponentFactory.setEnabled(ComponentFactory.createCheckBox(ppiUkunJSerialCommOn, "jSerialComm", actionListener), XEiJ.prgIsWindows && !ppiUkunCurrentConnection);
        componentArray4[0] = ppiUkunJSerialCommCheckbox;
        componentArray4[1] = Multilingual.mlnText(ComponentFactory.createCheckBox(ppiUkunIntervalOn, "Output interval adjustment", actionListener), "ja", "\u51fa\u529b\u9593\u9694\u8abf\u6574");
        componentArray4[2] = null;
        componentArray[2] = ComponentFactory.createFlowPanel(20, 0, componentArray4);
        componentArray[3] = ComponentFactory.createHorizontalSeparator();
        componentArray[4] = !XEiJ.prgWindllLoaded ? null : ComponentFactory.createFlowPanel(ComponentFactory.createCheckBox(ppiXInputOn, "XInput", actionListener));
        componentArray[5] = !XEiJ.prgIsWindows ? null : ComponentFactory.createHorizontalSeparator();
        componentArray[6] = ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyKey, "Consider part of keyboard as joystick", actionListener), "ja", "\u30ad\u30fc\u30dc\u30fc\u30c9\u306e\u4e00\u90e8\u3092\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u3068\u307f\u306a\u3059"));
        componentArray[7] = ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyAuto, "Enabled only while the port is read repeatedly", actionListener), "ja", "\u30dd\u30fc\u30c8\u304c\u7e70\u308a\u8fd4\u3057\u8aad\u307f\u51fa\u3055\u308c\u3066\u3044\u308b\u9593\u3060\u3051\u6709\u52b9"));
        componentArray[8] = ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyBlock, "Remove key input data processed as a joystick operation", actionListener), "ja", "\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u64cd\u4f5c\u3068\u3057\u3066\u51e6\u7406\u3055\u308c\u305f\u30ad\u30fc\u5165\u529b\u30c7\u30fc\u30bf\u3092\u53d6\u308a\u9664\u304f"));
        componentArray[9] = Box.createVerticalStrut(5);
        componentArray[10] = ComponentFactory.createHorizontalBox(ComponentFactory.createHorizontalSplitPane(jScrollPane, ppiConfigurationScrollPane));
        ppiFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("ppi", "Joystick port settings", null, ComponentFactory.setEmptyBorder(ComponentFactory.createVerticalBox(componentArray), 5, 5, 5, 5)), "ja", "\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u30dd\u30fc\u30c8\u8a2d\u5b9a");
    }

    public static boolean ppiInput(KeyEvent keyEvent, boolean bl) {
        boolean bl2 = false;
        if (ppiJoyKey && (!ppiJoyAuto || XEiJ.mpuClockTime < ppiLastAccessTime + 100000000000L) && (ppiJoystick1.input(keyEvent, bl) || ppiJoystick2.input(keyEvent, bl))) {
            bl2 = bl && ppiJoyBlock;
        }
        return bl2;
    }

    public static void ppiUkunAdjustInterval() {
        long l = XEiJ.mpuClockTime;
        long l2 = System.nanoTime();
        long l3 = l - ppiUkunLastVirtualTime;
        long l4 = l2 - ppiUkunLastRealTime;
        ppiUkunLastVirtualTime = l;
        ppiUkunLastRealTime = l2;
        if (l3 <= (l4 *= 1000L)) {
            long l5 = l4 - l3;
            l5 = Math.min(500000000L, l5);
            XEiJ.mpuClockTime += l5;
        } else {
            long l6 = l3 - l4;
            l6 = Math.min(500000000L, l6);
            if ((l6 /= 1000L) != 0L) {
                while (System.nanoTime() < l2 + l6) {
                }
            }
        }
    }

    public static int ppiReadByte(int n) {
        return switch (n & 7) {
            case 1 -> {
                if (ppiUkunCurrentConnection) {
                    if (ppiUkunCurrentMode == 305) {
                        if (ppiUkunSending) {
                            XEiJ.mpuClockTime += 100000000L;
                            while (ppiUkunSending) {
                            }
                        }
                    } else if (ppiUkunCurrentMode == 50) {
                        XEiJ.mpuClockTime += 100000000L;
                        if (ppiUkunJSerialCommOn) {
                            byte[] var4_1 = new byte[]{58};
                            ppiUkunSerialPort.writeBytes(var4_1, 1);
                            ppiUkunSerialPort.readBytes(var4_1, 1);
                            ppiUkunPortA = var4_1[0] & 0xFF;
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(58);
                                ppiUkunPortA = ppiUkunOldInputStream.read();
                            }
                            catch (IOException var4_2) {
                                var4_2.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                    }
                    yield ppiUkunPortA;
                }
                if (XEiJ.regOC >> 6 != 296) {
                    ppiLastAccessTime = XEiJ.mpuClockTime;
                }
                yield ppiJoystick1.readByte() & 0xFF;
            }
            case 3 -> {
                if (ppiUkunCurrentConnection) {
                    if (ppiUkunCurrentMode == 305) {
                        if (ppiUkunSending) {
                            XEiJ.mpuClockTime += 100000000L;
                            while (ppiUkunSending) {
                            }
                        }
                    } else if (ppiUkunCurrentMode == 50) {
                        XEiJ.mpuClockTime += 100000000L;
                        if (ppiUkunJSerialCommOn) {
                            byte[] var4_3 = new byte[]{59};
                            ppiUkunSerialPort.writeBytes(var4_3, 1);
                            ppiUkunSerialPort.readBytes(var4_3, 1);
                            ppiUkunPortB = var4_3[0] & 0xFF;
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(59);
                                ppiUkunPortB = ppiUkunOldInputStream.read();
                            }
                            catch (IOException var4_4) {
                                var4_4.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                    }
                    yield ppiUkunPortB;
                }
                if (XEiJ.regOC >> 6 != 296) {
                    ppiLastAccessTime = XEiJ.mpuClockTime;
                }
                yield ppiJoystick2.readByte() & 0xFF;
            }
            case 5 -> {
                if (ppiUkunCurrentConnection) {
                    XEiJ.mpuClockTime += 100000000L;
                    if (ppiUkunCurrentMode == 305) {
                        if (ppiUkunSending) {
                            XEiJ.mpuClockTime += 100000000L;
                            while (ppiUkunSending) {
                            }
                        }
                    } else if (ppiUkunCurrentMode == 50) {
                        XEiJ.mpuClockTime += 100000000L;
                        if (ppiUkunJSerialCommOn) {
                            byte[] var4_5 = new byte[]{60};
                            ppiUkunSerialPort.writeBytes(var4_5, 1);
                            ppiUkunSerialPort.readBytes(var4_5, 1);
                            ppiUkunPortC = var4_5[0] & 0xF0;
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(60);
                                ppiUkunPortC = ppiUkunOldInputStream.read() & 0xF0;
                            }
                            catch (IOException var4_6) {
                                var4_6.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                    }
                    yield ppiUkunPortC | ppiPortCData & 0xF;
                }
                yield ppiPortCData;
            }
            default -> 255;
        };
    }

    public static void ppiWriteByte(int n, int n2) {
        n2 &= 0xFF;
        switch (n & 7) {
            case 1: {
                if (ppiUkunCurrentConnection) {
                    if (ppiUkunIntervalOn) {
                        PPI.ppiUkunAdjustInterval();
                    } else {
                        XEiJ.mpuClockTime += 100000000L;
                    }
                    if (ppiUkunCurrentMode == 49) {
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x80 | n2 & 0x6F)}, 1);
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(0x80 | n2 & 0x6F);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                        while (ppiUkunSending) {
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode == 305) {
                        while (ppiUkunSending) {
                        }
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x80 | n2 & 0x6F)}, 1);
                            break;
                        }
                        try {
                            ppiUkunOldOutputStream.write(0x80 | n2 & 0x6F);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            PPI.ppiUkunDisconnect();
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode != 50) break;
                    if (ppiUkunJSerialCommOn) {
                        ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x80 | n2 & 0x6F)}, 1);
                        break;
                    }
                    try {
                        ppiUkunOldOutputStream.write(0x80 | n2 & 0x6F);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        PPI.ppiUkunDisconnect();
                    }
                    break;
                }
                ppiJoystick1.writeByte(n2);
                break;
            }
            case 3: {
                if (ppiUkunCurrentConnection) {
                    if (ppiUkunIntervalOn) {
                        PPI.ppiUkunAdjustInterval();
                    } else {
                        XEiJ.mpuClockTime += 100000000L;
                    }
                    if (ppiUkunCurrentMode == 49) {
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x90 | n2 & 0x6F)}, 1);
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(0x90 | n2 & 0x6F);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                        while (ppiUkunSending) {
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode == 305) {
                        while (ppiUkunSending) {
                        }
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x90 | n2 & 0x6F)}, 1);
                            break;
                        }
                        try {
                            ppiUkunOldOutputStream.write(0x90 | n2 & 0x6F);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            PPI.ppiUkunDisconnect();
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode != 50) break;
                    if (ppiUkunJSerialCommOn) {
                        ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x90 | n2 & 0x6F)}, 1);
                        break;
                    }
                    try {
                        ppiUkunOldOutputStream.write(0x90 | n2 & 0x6F);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        PPI.ppiUkunDisconnect();
                    }
                    break;
                }
                ppiJoystick2.writeByte(n2);
                break;
            }
            case 5: {
                ppiPortCData = n2;
                ADPCM.pcmSetPan(n2);
                ADPCM.pcmDivider = n2 >> 2 & 3;
                ADPCM.pcmUpdateRepeatInterval();
                if (ppiUkunCurrentConnection) {
                    if (ppiUkunIntervalOn) {
                        PPI.ppiUkunAdjustInterval();
                    } else {
                        XEiJ.mpuClockTime += 100000000L;
                    }
                    if (ppiUkunCurrentMode == 49) {
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(n2 >> 4)}, 1);
                        } else {
                            try {
                                ppiUkunOldOutputStream.write(n2 >> 4);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                PPI.ppiUkunDisconnect();
                            }
                        }
                        while (ppiUkunSending) {
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode == 305) {
                        while (ppiUkunSending) {
                        }
                        ppiUkunSending = true;
                        if (ppiUkunJSerialCommOn) {
                            ppiUkunSerialPort.writeBytes(new byte[]{(byte)(n2 >> 4)}, 1);
                            break;
                        }
                        try {
                            ppiUkunOldOutputStream.write(n2 >> 4);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            PPI.ppiUkunDisconnect();
                        }
                        break;
                    }
                    if (ppiUkunCurrentMode != 50) break;
                    if (ppiUkunJSerialCommOn) {
                        ppiUkunSerialPort.writeBytes(new byte[]{(byte)(n2 >> 4)}, 1);
                        break;
                    }
                    try {
                        ppiUkunOldOutputStream.write(n2 >> 4);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        PPI.ppiUkunDisconnect();
                    }
                    break;
                }
                ppiJoystick1.setPin8(n2 >> 4 & 1);
                ppiJoystick2.setPin8(n2 >> 5 & 1);
                ppiJoystick1.setPin6(n2 >> 6 & 1 ^ 1);
                ppiJoystick1.setPin7(n2 >> 7 & 1 ^ 1);
                break;
            }
            case 7: {
                if ((n2 & 0x80) == 0) {
                    int n3 = n2 >> 1 & 7;
                    int n4 = n2 & 1;
                    ppiPortCData = ppiPortCData & ~(1 << n3) | n4 << n3;
                    if (n3 < 4) {
                        switch (n3) {
                            case 0: 
                            case 1: {
                                ADPCM.pcmSetPan(ppiPortCData & 3);
                                break;
                            }
                            case 2: 
                            case 3: {
                                ADPCM.pcmDivider = ppiPortCData >> 2 & 3;
                                ADPCM.pcmUpdateRepeatInterval();
                            }
                        }
                        break;
                    }
                    if (ppiUkunCurrentConnection) {
                        if (ppiUkunIntervalOn) {
                            PPI.ppiUkunAdjustInterval();
                        } else {
                            XEiJ.mpuClockTime += 100000000L;
                        }
                        if (ppiUkunCurrentMode == 49) {
                            ppiUkunSending = true;
                            if (ppiUkunJSerialCommOn) {
                                ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x10 | n2 & 0xF)}, 1);
                            } else {
                                try {
                                    ppiUkunOldOutputStream.write(0x10 | n2 & 0xF);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    PPI.ppiUkunDisconnect();
                                }
                            }
                            while (ppiUkunSending) {
                            }
                        } else {
                            if (ppiUkunCurrentMode == 305) {
                                while (ppiUkunSending) {
                                }
                                ppiUkunSending = true;
                                if (ppiUkunJSerialCommOn) {
                                    ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x10 | n2 & 0xF)}, 1);
                                    break;
                                }
                                try {
                                    ppiUkunOldOutputStream.write(0x10 | n2 & 0xF);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    PPI.ppiUkunDisconnect();
                                }
                                break;
                            }
                            if (ppiUkunCurrentMode == 50) {
                                if (ppiUkunJSerialCommOn) {
                                    ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x10 | n2 & 0xF)}, 1);
                                    break;
                                }
                                try {
                                    ppiUkunOldOutputStream.write(0x10 | n2 & 0xF);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    PPI.ppiUkunDisconnect();
                                }
                            }
                        }
                    } else {
                        switch (n3) {
                            case 4: {
                                ppiJoystick1.setPin8(n4);
                                break;
                            }
                            case 5: {
                                ppiJoystick2.setPin8(n4);
                                break;
                            }
                            case 6: {
                                ppiJoystick1.setPin6(n4 ^ 1);
                                break;
                            }
                            case 7: {
                                ppiJoystick1.setPin7(n4 ^ 1);
                            }
                        }
                    }
                    break;
                }
                if ((n2 & 0x84) != 128 || !ppiUkunCurrentConnection) break;
                if (ppiUkunIntervalOn) {
                    PPI.ppiUkunAdjustInterval();
                } else {
                    XEiJ.mpuClockTime += 100000000L;
                }
                if (ppiUkunCurrentMode == 49) {
                    ppiUkunSending = true;
                    if (ppiUkunJSerialCommOn) {
                        ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x40 | (n2 & 0x78) >> 1 | n2 & 3)}, 1);
                    } else {
                        try {
                            ppiUkunOldOutputStream.write(0x40 | (n2 & 0x78) >> 1 | n2 & 3);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            PPI.ppiUkunDisconnect();
                        }
                    }
                    while (ppiUkunSending) {
                    }
                    break;
                }
                if (ppiUkunCurrentMode == 305) {
                    while (ppiUkunSending) {
                    }
                    ppiUkunSending = true;
                    if (ppiUkunJSerialCommOn) {
                        ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x40 | (n2 & 0x78) >> 1 | n2 & 3)}, 1);
                        break;
                    }
                    try {
                        ppiUkunOldOutputStream.write(0x40 | (n2 & 0x78) >> 1 | n2 & 3);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        PPI.ppiUkunDisconnect();
                    }
                    break;
                }
                if (ppiUkunCurrentMode != 50) break;
                if (ppiUkunJSerialCommOn) {
                    ppiUkunSerialPort.writeBytes(new byte[]{(byte)(0x40 | (n2 & 0x78) >> 1 | n2 & 3)}, 1);
                    break;
                }
                try {
                    ppiUkunOldOutputStream.write(0x40 | (n2 & 0x78) >> 1 | n2 & 3);
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    PPI.ppiUkunDisconnect();
                }
            }
        }
    }

    public static class UkunDataListener
    implements SerialPortDataListener {
        @Override
        public int getListeningEvents() {
            return 1;
        }

        @Override
        public void serialEvent(SerialPortEvent serialPortEvent) {
            if (serialPortEvent.getEventType() != 1) {
                return;
            }
            byte[] byArray = new byte[1];
            while (ppiUkunSerialPort.bytesAvailable() != 0 && ppiUkunSerialPort.readBytes(byArray, 1) != 0) {
                int n = byArray[0] & 0xFF;
                if ((n & 0x90) == 128) {
                    ppiUkunPortA = 0x90 | n;
                    continue;
                }
                if ((n & 0x90) == 144) {
                    ppiUkunPortB = n;
                    continue;
                }
                if (n <= 15) {
                    ppiUkunPortC = n << 4;
                    continue;
                }
                if (n == 63) {
                    ppiUkunSending = false;
                    continue;
                }
                if (n == 49) {
                    if (ppiUkunRequestedMode == 305) {
                        System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Notify(B) \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Notify(B) mode\n", ppiUkunPortName);
                        ppiUkunCurrentMode = 305;
                    } else {
                        System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Notify(A) \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Notify(A) mode\n", ppiUkunPortName);
                        ppiUkunRequestedMode = 49;
                        ppiUkunCurrentMode = 49;
                    }
                    PPI.ppiUkunAdjustMenu();
                    continue;
                }
                if (n == 50) {
                    ppiUkunRequestedMode = 50;
                    ppiUkunCurrentMode = 50;
                    PPI.ppiUkunAdjustMenu();
                    System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Command \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Command mode\n", ppiUkunPortName);
                    ppiUkunSerialPort.removeDataListener();
                    ppiUkunDataListener = null;
                    break;
                }
                System.out.printf("UkunDataListener received unknown data 0x%02x\n", n);
                ppiUkunSerialPort.removeDataListener();
                ppiUkunDataListener = null;
                break;
            }
        }
    }

    public static class UkunThread
    extends Thread {
        @Override
        public void run() {
            try {
                while (ppiUkunCurrentConnection) {
                    int n = ppiUkunOldInputStream.read();
                    if ((n & 0x90) == 128) {
                        ppiUkunPortA = 0x90 | n;
                        continue;
                    }
                    if ((n & 0x90) == 144) {
                        ppiUkunPortB = n;
                        continue;
                    }
                    if (n <= 15) {
                        ppiUkunPortC = n << 4;
                        continue;
                    }
                    if (n == 63) {
                        ppiUkunSending = false;
                        continue;
                    }
                    if (n == 49) {
                        if (ppiUkunRequestedMode == 305) {
                            System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Notify(B) \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Notify(B) mode\n", ppiUkunPortName);
                            ppiUkunCurrentMode = 305;
                        } else {
                            System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Notify(A) \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Notify(A) mode\n", ppiUkunPortName);
                            ppiUkunRequestedMode = 49;
                            ppiUkunCurrentMode = 49;
                        }
                        PPI.ppiUkunAdjustMenu();
                        continue;
                    }
                    if (n == 50) {
                        ppiUkunRequestedMode = 50;
                        ppiUkunCurrentMode = 50;
                        PPI.ppiUkunAdjustMenu();
                        System.out.printf(Multilingual.mlnJapanese ? "\u3058\u3087\u3044\u307d\u30fc\u3068 U \u541b (%s) \u306f Command \u30e2\u30fc\u30c9\u3067\u521d\u671f\u5316\u3055\u308c\u307e\u3057\u305f\n" : "JoyPortUkun (%s) has been initialized in Command mode\n", ppiUkunPortName);
                    } else if (n >= 0) {
                        System.out.printf("UkunThread received unknown data 0x%02x\n", n);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ppiUkunThread = null;
        }
    }
}

