/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import xeij.ComponentFactory;
import xeij.HD63450;
import xeij.IOInterrupt;
import xeij.InstructionBreakPoint;
import xeij.M68kException;
import xeij.Multilingual;
import xeij.Settings;
import xeij.TickerQueue;
import xeij.WaitInstruction;
import xeij.XEiJ;

public class SUK {
    public static final int SPC_BDID = 1;
    public static final int SPC_SCTL = 3;
    public static final int SPC_SCTL_RD = 128;
    public static final int SPC_SCTL_CR = 64;
    public static final int SPC_SCTL_DM = 32;
    public static final int SPC_SCTL_AE = 16;
    public static final int SPC_SCTL_PE = 8;
    public static final int SPC_SCTL_SE = 4;
    public static final int SPC_SCTL_RE = 2;
    public static final int SPC_SCTL_IE = 1;
    public static final int SPC_SCMD = 5;
    public static final int SPC_SCMD_CC = 224;
    public static final int SPC_SCMD_CC_BR = 0;
    public static final int SPC_SCMD_CC_SL = 32;
    public static final int SPC_SCMD_CC_RA = 64;
    public static final int SPC_SCMD_CC_SA = 96;
    public static final int SPC_SCMD_CC_TR = 128;
    public static final int SPC_SCMD_CC_TP = 160;
    public static final int SPC_SCMD_CC_RR = 192;
    public static final int SPC_SCMD_CC_SR = 224;
    public static final int SPC_SCMD_RO = 16;
    public static final int SPC_SCMD_IT = 8;
    public static final int SPC_SCMD_PT = 4;
    public static final int SPC_SCMD_TM = 1;
    public static final int SPC_INTS = 9;
    public static final int SPC_INTS_SL = 128;
    public static final int SPC_INTS_RS = 64;
    public static final int SPC_INTS_DC = 32;
    public static final int SPC_INTS_CC = 16;
    public static final int SPC_INTS_SR = 8;
    public static final int SPC_INTS_TO = 4;
    public static final int SPC_INTS_HE = 2;
    public static final int SPC_INTS_RC = 1;
    public static final int SPC_PSNS = 11;
    public static final int SPC_PSNS_REQ = 128;
    public static final int SPC_PSNS_ACK = 64;
    public static final int SPC_PSNS_ATN = 32;
    public static final int SPC_PSNS_SEL = 16;
    public static final int SPC_PSNS_BSY = 8;
    public static final int SPC_SDGC = 11;
    public static final int SPC_SDGC_REQ = 128;
    public static final int SPC_SDGC_ACK = 64;
    public static final int SPC_SDGC_XFER = 32;
    public static final int SPC_SDGC_BSY = 8;
    public static final int SPC_SDGC_MSG = 4;
    public static final int SPC_SDGC_CD = 2;
    public static final int SPC_SDGC_IO = 1;
    public static final int SPC_SSTS = 13;
    public static final int SPC_SSTS_INIT = 128;
    public static final int SPC_SSTS_TARG = 64;
    public static final int SPC_SSTS_BUSY = 32;
    public static final int SPC_SSTS_TRIP = 16;
    public static final int SPC_SSTS_RSIN = 8;
    public static final int SPC_SSTS_TC0 = 4;
    public static final int SPC_SSTS_DF = 2;
    public static final int SPC_SSTS_DE = 1;
    public static final int SPC_SERR = 15;
    public static final int SPC_SERR_DI = 128;
    public static final int SPC_SERR_DO = 64;
    public static final int SPC_SERR_XO = 32;
    public static final int SPC_SERR_PE = 8;
    public static final int SPC_SERR_ST = 2;
    public static final int SPC_PCTL = 17;
    public static final int SPC_PCTL_IE = 128;
    public static final int SPC_PCTL_SR = 1;
    public static final int SPC_PCTL_SR_R = 1;
    public static final int SPC_PCTL_SR_S = 0;
    public static final int SPC_MBC = 19;
    public static final int SPC_DREG = 21;
    public static final int SPC_TEMP = 23;
    public static final int SPC_TCH = 25;
    public static final int SPC_TCM = 27;
    public static final int SPC_TCL = 29;
    public static final int SPC_BYPASS = 31;
    public static final int SPC_PHASE_MASK = 7;
    public static final int SPC_DATAOUT_PHASE = 0;
    public static final int SPC_DATAIN_PHASE = 1;
    public static final int SPC_CMDOUT_PHASE = 2;
    public static final int SPC_STSIN_PHASE = 3;
    public static final int SPC_MSGOUT_PHASE = 6;
    public static final int SPC_MSGIN_PHASE = 7;
    public static final String[] SPC_REG_NAME = new String[]{"[0x00]", "BDID", "[0x02]", "SCTL", "[0x04]", "SCMD", "[0x06]", "[0x07]", "[0x08]", "INTS", "[0x0a]", "PSNS", "[0x0c]", "SSTS", "[0x0e]", "SERR", "[0x10]", "PCTL", "[0x12]", "MBC", "[0x14]", "DREG", "[0x16]", "TEMP", "[0x18]", "TCH", "[0x1a]", "TCM", "[0x1c]", "TCL", "[0x1e]", "BYPASS"};
    public static final String[] SPC_PHASE_NAME = new String[]{"data-out-phase", "data-in-phase", "command-out-phase", "status-in-phase", "???", "???", "message-out-phase", "message-in-phase"};
    public static final boolean SUK_ON = true;
    public static boolean sukOnRequest;
    public static boolean sukOn;
    public static boolean sukExpansionRequest;
    public static boolean sukExpansion;
    public static final int SUK_VID = 1240;
    public static final int SUK_PID = 59058;
    public static SerialPort sukPort1;
    public static SerialPort sukPort2;
    public static final byte[] sukRegister;
    public static boolean sukReading;
    public static JMenu sukMenu;
    public static JCheckBoxMenuItem sukConnectCheckBox;
    public static JCheckBoxMenuItem sukExpansionCheckBox;
    public static JCheckBoxMenuItem sukDebugCheckBox;
    public static JCheckBoxMenuItem sukDumpCheckBox;
    public static final boolean SUK_BYPASS = true;
    public static final int SUK_BYPASS_AHEAD = 256;
    public static int sukBypassNotRead;
    public static int sukBypassNotWritten;
    public static final SerialPortDataListener sukDataListener1;
    public static final SerialPortDataListener sukDataListener2;
    public static final int SUK_QUEUE_SIZE = 0x100000;
    public static final byte[] sukQueueArray;
    public static volatile int sukQueueWrite;
    public static volatile int sukQueueRead;
    public static int sukQueueRequired;
    public static final TickerQueue.Ticker sukQueueTicker;
    public static final WaitInstruction sukQueueInstruction;
    public static boolean sukDregStandby;
    public static int sukDregLength;
    public static int sukDregMajor;
    public static int sukDregMinor;
    public static byte[] sukDregBuffer;
    public static int sukDregWrite;
    public static int sukDregRead;
    public static int sukDregRequired;
    public static int sukDregCounter;
    public static final int SUK_MPU_AHEAD = 256;
    public static final TickerQueue.Ticker sukDregMPUTicker;
    public static final WaitInstruction sukDregMPUInstruction;
    public static final int SUK_DREG_CHANNEL = 1;
    public static final WaitInstruction sukDregDMACInstruction;
    public static final int SUK_POOL_SIZE = 511;
    public static final long SUK_POOL_SPAN = 1000000000L;
    public static final byte[] sukPoolBuffer;
    public static int sukPoolLength;
    public static final TickerQueue.Ticker sukPoolTicker;
    public static long sukIntervalTime;
    public static int sukIntervalCounter;
    public static final WaitInstruction sukIntervalInstruction;
    public static final boolean SUK_DEBUG = true;
    public static boolean sukDebugOn;
    public static final byte[] sukDebugLastRegister;
    public static final boolean SUK_DUMP = true;
    public static boolean sukDumpOn;
    public static final int SUK_DUMP_LIMIT = 4096;
    public static final byte[] sukDumpBuffer;
    public static int sukDumpLength;
    public static int sukDataPhase;

    public static void sukInit() {
        sukOnRequest = Settings.sgsGetOnOff("suk");
        sukOn = false;
        sukExpansionRequest = Settings.sgsGetOnOff("sukex");
        sukExpansion = false;
        sukPort1 = null;
        sukPort2 = null;
        SUK.sukDebugInit();
        SUK.sukDumpInit();
    }

    public static void sukTini() {
        if (sukOn) {
            SUK.sukDisconnect();
            sukOn = false;
        }
        Settings.sgsPutOnOff("suk", sukOnRequest);
        Settings.sgsPutOnOff("sukex", sukExpansionRequest);
        SUK.sukDebugTini();
        SUK.sukDumpTini();
    }

    public static JMenu sukGetMenu() {
        if (sukMenu != null) {
            return sukMenu;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Connect": {
                        sukOnRequest = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Expansion SCSI port": {
                        sukExpansionRequest = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Debug output": {
                        sukDebugOn = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Dump output": {
                        sukDumpOn = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        JComponent[] jComponentArray = new JComponent[1];
        sukConnectCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(sukOnRequest, "Connect", actionListener), "ja", "\u63a5\u7d9a");
        jComponentArray[0] = sukConnectCheckBox;
        sukMenu = Multilingual.mlnText(ComponentFactory.createMenu("SCSI Ukun Kai (experimental)", jComponentArray), "ja", "\u3059\u304b\u3058\u30fc U \u541b\u6539");
        return sukMenu;
    }

    public static void sukReset() {
        if (sukOnRequest) {
            if (!SUK.sukConnect()) {
                sukOnRequest = false;
                if (sukConnectCheckBox != null) {
                    sukConnectCheckBox.setSelected(false);
                }
            }
        } else {
            SUK.sukDisconnect();
        }
        sukOn = sukOnRequest;
        sukExpansion = sukExpansionRequest;
    }

    public static boolean sukConnect() {
        if (sukPort1 != null) {
            return true;
        }
        SerialPort serialPort = null;
        SerialPort serialPort2 = null;
        for (SerialPort serialPort3 : SerialPort.getCommPorts()) {
            if (sukDebugOn) {
                System.out.printf("systemPortName=%s vid=0x%04x pid=0x%04x\n", serialPort3.getSystemPortName(), serialPort3.getVendorID(), serialPort3.getProductID());
            }
            if (serialPort3.getVendorID() != 1240 || serialPort3.getProductID() != 59058) continue;
            if (serialPort == null) {
                serialPort = serialPort3;
                continue;
            }
            if (serialPort2 == null) {
                serialPort2 = serialPort3;
                continue;
            }
            System.out.println(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539\u306e\u30dd\u30fc\u30c8\u304c\u591a\u3059\u304e\u307e\u3059" : "Too many MB89352 bridger");
            return false;
        }
        if (serialPort2 == null) {
            System.out.println(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539\u306e\u30dd\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093" : "MB89352 bridger not found");
            return false;
        }
        if (!serialPort.openPort(0, 65536, 65536)) {
            System.out.println(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539\u306e\u30dd\u30fc\u30c8\u3092\u958b\u3051\u307e\u305b\u3093" : "Cannot open MB89352 bridger");
            return false;
        }
        if (!serialPort2.openPort(0, 65536, 65536)) {
            serialPort.closePort();
            System.out.println(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539\u306e\u30dd\u30fc\u30c8\u3092\u958b\u3051\u307e\u305b\u3093" : "Cannot open MB89352 bridger");
            return false;
        }
        serialPort.setComPortParameters(480000000, 8, 1, 0);
        serialPort2.setComPortParameters(480000000, 8, 1, 0);
        serialPort.setComPortTimeouts(16, 50, 0);
        serialPort2.setComPortTimeouts(16, 50, 0);
        byte[] byArray = new byte[]{0, 0};
        serialPort.writeBytes(byArray, 1, 0);
        serialPort.readBytes(byArray, 1, 0);
        serialPort2.writeBytes(byArray, 1, 1);
        serialPort2.readBytes(byArray, 1, 1);
        if (byArray[0] != 115 || byArray[1] != 83) {
            if (byArray[0] == 83 && byArray[1] == 115) {
                SerialPort serialPort4 = serialPort;
                serialPort = serialPort2;
                serialPort2 = serialPort4;
            } else {
                serialPort.closePort();
                serialPort2.closePort();
                System.out.println(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539\u306e\u30dd\u30fc\u30c8\u3092\u5224\u5225\u3067\u304d\u307e\u305b\u3093" : "Unable to identify MB89352 bridger");
                return false;
            }
        }
        serialPort.setComPortTimeouts(16, 0, 0);
        serialPort2.setComPortTimeouts(16, 0, 0);
        serialPort.writeBytes(new byte[]{-128}, 1);
        serialPort.writeBytes(new byte[]{-2}, 1);
        sukPort1 = serialPort;
        sukPort2 = serialPort2;
        Arrays.fill(sukRegister, (byte)0);
        sukReading = false;
        System.out.printf(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539 (%s,%s) \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\n" : "MB89352 bridger (%s,%s) connected\n", sukPort1.getSystemPortName(), sukPort2.getSystemPortName());
        SUK.sukQueueInit();
        SUK.sukPoolInit();
        SUK.sukDregInit();
        sukBypassNotRead = 0;
        sukBypassNotWritten = 0;
        sukPort1.addDataListener(sukDataListener1);
        sukPort2.addDataListener(sukDataListener2);
        return true;
    }

    public static void sukDisconnect() {
        if (sukPort1 == null) {
            return;
        }
        sukPort1.removeDataListener();
        sukPort2.removeDataListener();
        System.out.printf(Multilingual.mlnJapanese ? "\u3059\u304b\u3058\u30fc U \u541b\u6539 (%s,%s) \u3092\u5207\u308a\u96e2\u3057\u307e\u3057\u305f\n" : "MB89352 bridger (%s,%s) disconnected\n", sukPort1.getSystemPortName(), sukPort2.getSystemPortName());
        sukPort1.clearRTS();
        sukPort2.clearRTS();
        sukPort1.clearDTR();
        sukPort2.clearDTR();
        sukPort1.closePort();
        sukPort2.closePort();
        sukPort1 = null;
        sukPort2 = null;
    }

    public static int sukPeek(int n) {
        return 0xFF & sukRegister[n &= 0x1F];
    }

    public static int sukRead(int n) throws M68kException {
        int n2;
        n &= 0x1F;
        if (0 < sukBypassNotRead) {
            int n3;
            if (n != 31) {
                System.out.printf("%08x sukRead() attempted to read from a register other than bypass during receiving bypass\n", XEiJ.regPC0);
            }
            if ((n3 = SUK.sukQueueData()) < 0) {
                System.out.printf("%08x sukRead() queue is empty\n", XEiJ.regPC0);
                n3 = 0;
            }
            if (sukDebugOn) {
                System.out.printf("%08x sukRead() bypass data=0x%02x\n", XEiJ.regPC0, n3);
            }
            if (--sukBypassNotRead == 0) {
                if (sukDebugOn) {
                    System.out.printf("%08x sukRead() sukBypassNotRead=%d\n", XEiJ.regPC0, sukBypassNotRead);
                }
            } else if (sukQueueWrite - sukQueueRead == 0) {
                sukQueueRequired = Math.min(256, sukBypassNotRead);
                TickerQueue.tkqAdd(sukQueueTicker, XEiJ.mpuClockTime);
            }
            return n3;
        }
        if (n == 31) {
            if (sukBypassNotRead == 0) {
                sukBypassNotRead = -1;
                SUK.sukPoolAdd1(n);
                SUK.sukPoolFlush();
                sukQueueRequired = 3;
                InstructionBreakPoint.ibpAddWaitPoint(XEiJ.regPC0, XEiJ.regSRS, sukQueueInstruction);
                if (sukDebugOn) {
                    System.out.printf("%08x sukRead() queue instruction at pc=0x%08x required=%d\n", XEiJ.regPC0, XEiJ.regPC0, sukQueueRequired);
                }
                M68kException.m6eNumber = -2;
                throw M68kException.m6eSignal;
            }
            if (sukBypassNotRead < 0) {
                int n4 = SUK.sukQueueData();
                int n5 = SUK.sukQueueData();
                int n6 = SUK.sukQueueData();
                if (n6 < 0) {
                    System.out.printf("%08x sukRead() queue is empty\n", XEiJ.regPC0);
                    n4 = 1;
                    n5 = 0;
                    n6 = 0;
                }
                sukBypassNotRead = n5 << 8 | n4;
                if (sukDebugOn) {
                    System.out.printf("%08x sukRead() bypass lower=0x%02x\n", XEiJ.regPC0, n4);
                    System.out.printf("%08x sukRead() bypass upper=0x%02x\n", XEiJ.regPC0, n5);
                    System.out.printf("%08x sukRead() sukBypassNotRead=0x%02x\n", XEiJ.regPC0, sukBypassNotRead);
                    System.out.printf("%08x sukRead() bypass data=0x%02x\n", XEiJ.regPC0, n6);
                }
                if (--sukBypassNotRead == 0) {
                    if (sukDebugOn) {
                        System.out.printf("%08x sukRead() sukBypassNotRead=%d\n", XEiJ.regPC0, sukBypassNotRead);
                    }
                } else if (sukQueueWrite - sukQueueRead == 0) {
                    sukQueueRequired = Math.min(256, sukBypassNotRead);
                    TickerQueue.tkqAdd(sukQueueTicker, XEiJ.mpuClockTime);
                }
                return n6;
            }
        }
        if (sukDregLength - sukDregRead != 0) {
            if (n == 21) {
                if (sukDregWrite - sukDregRead == 0) {
                    System.out.printf("%08x sukRead() buffer is empty\n", XEiJ.regPC0);
                    return 0xFF & sukRegister[n];
                }
                int n7 = 0xFF & sukDregBuffer[sukDregRead++];
                if (sukDregLength - sukDregRead == 0) {
                    SUK.sukRegister[25] = 0;
                    SUK.sukRegister[27] = 0;
                    SUK.sukRegister[29] = 0;
                    if (sukDebugOn) {
                        SUK.sukDebugRegister(true, 25);
                        SUK.sukDebugRegister(true, 27);
                        SUK.sukDebugRegister(true, 29);
                        System.out.printf("%08x sukRead() sukDregRead=%d\n", XEiJ.regPC0, sukDregRead);
                    }
                }
                SUK.sukRegister[n] = (byte)n7;
                if ((XEiJ.busWaitTime == XEiJ.mpuWaitTime || XEiJ.busWaitTime == XEiJ.mpuNoWaitTime) && sukDregLength - sukDregRead != 0 && sukDregWrite - sukDregRead == 0) {
                    sukDregRequired = Math.min(256, sukDregLength - sukDregRead);
                    sukDregCounter = 0;
                    TickerQueue.tkqAdd(sukDregMPUTicker, XEiJ.mpuClockTime);
                }
                if (sukDumpOn) {
                    SUK.sukDumpAdd(n7);
                }
            } else if (n == 9) {
                SUK.sukRegister[n] = 0;
            } else if (n == 13) {
                SUK.sukRegister[n] = (byte)(0xB0 | (sukDregLength - sukDregRead < 8 ? 0 : 2));
            } else if (n == 25) {
                SUK.sukRegister[n] = (byte)(sukDregLength - sukDregRead >> 16);
            } else if (n == 27) {
                SUK.sukRegister[n] = (byte)(sukDregLength - sukDregRead >> 8);
            } else if (n == 29) {
                SUK.sukRegister[n] = (byte)(sukDregLength - sukDregRead);
            }
            if (sukDebugOn) {
                SUK.sukDebugRegister(true, n);
            }
            return 0xFF & sukRegister[n];
        }
        if (XEiJ.busWaitTime == XEiJ.dmaWaitTime || XEiJ.busWaitTime == XEiJ.dmaNoWaitTime) {
            System.out.printf("%08x sukRead() DMAC attempted to read while not in data-in-phase\n", XEiJ.regPC0);
            return 0xFF & sukRegister[n];
        }
        if (n == 21) {
            if (!sukDregStandby) {
                System.out.printf("%08x sukRead() MPU attempted to read while not in data-in-phase\n", XEiJ.regPC0);
            }
            SUK.sukDregStart();
            int n8 = SUK.sukDregMPUStart();
            SUK.sukRegister[n] = (byte)n8;
            if (sukDebugOn) {
                SUK.sukDebugRegister(true, n);
            }
            if (sukDumpOn) {
                SUK.sukDumpAdd(n8);
            }
            return n8;
        }
        if (!sukReading) {
            sukReading = true;
            SUK.sukPoolAdd1(n);
            SUK.sukPoolFlush();
            sukQueueRequired = 1;
            InstructionBreakPoint.ibpAddWaitPoint(XEiJ.regPC0, XEiJ.regSRS, sukQueueInstruction);
            M68kException.m6eNumber = -2;
            throw M68kException.m6eSignal;
        }
        int n9 = SUK.sukQueueData();
        if (n9 < 0) {
            System.out.printf("%08x sukRead() queue is empty\n", XEiJ.regPC0);
            return 0xFF & sukRegister[n];
        }
        if (n == 13 && n9 == 0) {
            n9 = ((sukRegister[25] | sukRegister[27] | sukRegister[29]) == 0 ? 4 : 0) | 1;
        }
        SUK.sukRegister[n] = (byte)n9;
        if (sukDebugOn) {
            SUK.sukDebugRegister(true, n);
        }
        if (sukDumpOn && n == 23 && ((n2 = 0xFF & sukRegister[11]) == 73 || n2 == 75 || n2 == 79)) {
            SUK.sukDumpAdd(0xFF & sukRegister[n]);
        }
        sukReading = false;
        return n9;
    }

    public static void sukWrite(int n, int n2) {
        int n3;
        n &= 0x1F;
        n2 &= 0xFF;
        if (sukBypassNotWritten != 0) {
            if (n != 31) {
                System.out.printf("%08x sukWrite() attempted to write to a register other than bypass during bypass transmission\n", XEiJ.regPC0);
            }
            SUK.sukPoolAdd1(n2);
            if (sukBypassNotWritten < 0) {
                sukBypassNotWritten = n2 << 8 | 0xFF & sukBypassNotWritten;
                if (sukDebugOn) {
                    System.out.printf("%08x sukWrite() bypass upper=0x%02x\n", XEiJ.regPC0, n2);
                    System.out.printf("%08x sukWrite() sukBypassNotWritten=%d\n", XEiJ.regPC0, sukBypassNotWritten);
                }
            } else {
                if (sukDebugOn) {
                    System.out.printf("%08x sukWrite() bypass data=0x%02x\n", XEiJ.regPC0, n2);
                }
                if (--sukBypassNotWritten == 0 && sukDebugOn) {
                    System.out.printf("%08x sukWrite() sukBypassNotWritten=%d\n", XEiJ.regPC0, sukBypassNotWritten);
                }
            }
            return;
        }
        SUK.sukRegister[n] = (byte)n2;
        if (sukDebugOn) {
            SUK.sukDebugRegister(false, n);
        }
        SUK.sukPoolAdd2(128 + n, n2);
        if (n == 31) {
            sukBypassNotWritten = -65536 + n2;
            if (sukDebugOn) {
                System.out.printf("%08x sukWrite() bypass lower=0x%02x\n", XEiJ.regPC0, n2);
            }
        }
        if (sukDumpOn) {
            if (n == 21) {
                SUK.sukDumpAdd(n2);
            } else if (n == 23) {
                n3 = 0xFF & sukRegister[11];
                if (n3 == 136 || n3 == 138 || n3 == 142) {
                    SUK.sukDumpAdd(n2);
                }
            } else if (n == 17) {
                SUK.sukDumpDump(n2 & 7);
            }
        }
        int n4 = n == 5 && (n2 & 0x10) != 0 ? 250 : (n == 5 && (n2 & 0xE0) == 32 ? 50 : (n3 = n == 9 && (n2 & 4) != 0 ? 50 : 0));
        if (n3 != 0) {
            SUK.sukPoolFlush();
            sukIntervalTime = System.nanoTime() + (long)(n3 * 1000);
            sukIntervalCounter = 0;
            InstructionBreakPoint.ibpAddWaitPoint(XEiJ.regPC, XEiJ.regSRS, sukIntervalInstruction);
            if (sukDebugOn) {
                System.out.printf("%08x sukWrite() interval instruction at pc=0x%08x time=%d\n", XEiJ.regPC0, XEiJ.regPC, sukIntervalTime);
            }
        }
        if ((sukRegister[17] & 7) == 1 && n == 5 && (n2 & 0xE0) == 128) {
            sukDregStandby = true;
            if (sukDebugOn) {
                System.out.printf("%08x sukWrite() SPC has started receiving\n", XEiJ.regPC0);
            }
        }
    }

    public static void sukQueueInit() {
        sukQueueWrite = 0;
        sukQueueRead = 0;
        sukQueueRequired = 0;
    }

    public static int sukQueueData() {
        int n = sukQueueWrite;
        int n2 = sukQueueRead;
        if (n - n2 == 0) {
            return -1;
        }
        int n3 = 0xFF & sukQueueArray[n2++ & 0xFFFFF];
        sukQueueRead = n2;
        return n3;
    }

    public static void sukDregInit() {
        sukDregStandby = false;
        sukDregLength = 0;
        sukDregMajor = 0;
        sukDregMinor = 0;
        sukDregBuffer = new byte[0];
        sukDregWrite = 0;
        sukDregRead = 0;
        sukDregRequired = 0;
        sukDregCounter = 0;
    }

    public static void sukDregStart() {
        sukDregStandby = false;
        sukDregMajor = sukDregLength = (0xFF & sukRegister[25]) << 16 | (0xFF & sukRegister[27]) << 8 | 0xFF & sukRegister[29];
        sukDregMinor = 0;
        if (sukDebugOn) {
            System.out.printf("%08x sukDregStart() sukDregLength=%d\n", XEiJ.regPC0, sukDregLength);
            System.out.printf("%08x sukDregStart() sukDregMajor=%d\n", XEiJ.regPC0, sukDregMajor);
            System.out.printf("%08x sukDregStart() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
        }
        if (sukDregBuffer.length < sukDregLength) {
            sukDregBuffer = new byte[sukDregLength];
        }
        sukDregWrite = 0;
        sukDregRead = 0;
        if (sukDebugOn) {
            System.out.printf("%08x sukDregStart() sukDregWrite=%d\n", XEiJ.regPC0, sukDregWrite);
            System.out.printf("%08x sukDregStart() sukDregRead=%d\n", XEiJ.regPC0, sukDregRead);
        }
        if (sukDregLength != 0) {
            sukDregMinor = -1;
            if (sukDebugOn) {
                System.out.printf("%08x sukDregStart() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
            }
            sukPort1.writeBytes(new byte[]{65}, 1);
        }
    }

    public static int sukDregAvailable() {
        int n;
        int n2;
        int n3 = sukQueueWrite;
        int n4 = sukQueueRead;
        if (sukDregMinor == -1 && 2 <= n3 - n4) {
            n2 = 0xFF & sukQueueArray[n4++ & 0xFFFFF];
            n = 0xFF & sukQueueArray[n4++ & 0xFFFFF];
            sukQueueRead = n4;
            sukDregMinor = n << 8 | n2;
            if (sukDebugOn) {
                System.out.printf("%08x sukDregAvailable() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
            }
            if (sukDregMajor < sukDregMinor) {
                System.out.printf("%08x sukDregAvailable() total overrun\n", XEiJ.regPC0);
                sukDregMinor = sukDregMajor;
                if (sukDebugOn) {
                    System.out.printf("%08x sukDregAvailable() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
                }
            }
            sukDregMajor -= sukDregMinor;
            if (sukDebugOn) {
                System.out.printf("%08x sukDregAvailable() sukDregMajor=%d\n", XEiJ.regPC0, sukDregMajor);
            }
        }
        n2 = n3 - n4;
        if (1 <= sukDregMinor && 1 <= n2) {
            if (sukDregMinor < n2) {
                System.out.printf("%08x sukDregAvailable() block overrun\n", XEiJ.regPC0);
                n2 = sukDregMinor;
            }
            n = n4 & 0xFFFFF;
            int n5 = Math.min(n2, 0x100000 - n);
            System.arraycopy(sukQueueArray, n, sukDregBuffer, sukDregWrite, n5);
            if (n5 < n2) {
                System.arraycopy(sukQueueArray, 0, sukDregBuffer, sukDregWrite + n5, n2 - n5);
            }
            sukQueueRead = n4 += n2;
            sukDregMinor -= n2;
            if (sukDebugOn) {
                System.out.printf("%08x sukDregAvailable() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
            }
            if (sukDregLength - (sukDregWrite += n2) == 0 && sukDebugOn) {
                System.out.printf("%08x sukDregAvailable() sukDregWrite=%d\n", XEiJ.regPC0, sukDregWrite);
            }
        }
        if (sukDregMinor == 0 && sukDregMajor != 0) {
            sukDregMinor = -1;
            if (sukDebugOn) {
                System.out.printf("%08x sukDregAvailable() sukDregMinor=%d\n", XEiJ.regPC0, sukDregMinor);
            }
            sukPort1.writeBytes(new byte[]{65}, 1);
        }
        return sukDregWrite - sukDregRead;
    }

    public static int sukDregMPUStart() throws M68kException {
        int n;
        if (sukDebugOn) {
            System.out.printf("%08x sukDregMPUStart() MPU has started receiving\n", XEiJ.regPC0);
        }
        if ((n = Math.min(256, sukDregLength - sukDregRead)) <= sukDregWrite - sukDregRead) {
            int n2 = 0xFF & sukDregBuffer[sukDregRead++];
            if (sukDregLength - sukDregRead == 0 && sukDebugOn) {
                System.out.printf("%08x sukDregMPUStart() sukDregRead=%d\n", XEiJ.regPC0, sukDregRead);
            }
            return n2;
        }
        sukDregRequired = n;
        sukDregCounter = 0;
        InstructionBreakPoint.ibpAddWaitPoint(XEiJ.regPC0, XEiJ.regSRS, sukDregMPUInstruction);
        if (sukDebugOn) {
            System.out.printf("%08x sukDregMPUStart() pc=0x%08x required=%d\n", XEiJ.regPC0, XEiJ.regPC0, n);
        }
        M68kException.m6eNumber = -2;
        throw M68kException.m6eSignal;
    }

    public static void sukDregDMACStart() {
        int n;
        if (sukDregStandby) {
            if (sukDebugOn) {
                System.out.printf("%08x sukDregDMACStart() DMAC has started receiving\n", XEiJ.regPC0);
            }
            SUK.sukDregStart();
        }
        if (sukDregLength - sukDregRead == 0) {
            System.out.printf("%08x sukDregDMACStart() DMAC attempted to read while not in data-in-phase\n", XEiJ.regPC0);
        }
        if ((n = HD63450.dmaMTC[1]) <= sukDregWrite - sukDregRead) {
            HD63450.dmaTransfer(1);
        } else {
            int n2 = XEiJ.regPC;
            sukDregRequired = n;
            sukDregCounter = 0;
            InstructionBreakPoint.ibpAddWaitPoint(n2, XEiJ.regSRS, sukDregDMACInstruction);
            if (sukDebugOn) {
                System.out.printf("%08x sukDregDMACStart() dreg dmac instruction at pc=0x%08x required=%d\n", XEiJ.regPC0, XEiJ.regPC, n);
            }
        }
    }

    public static void sukPoolInit() {
        sukPoolLength = 0;
    }

    public static void sukPoolAdd1(int n) {
        if (510 < sukPoolLength) {
            SUK.sukPoolFlush();
        }
        SUK.sukPoolBuffer[SUK.sukPoolLength++] = (byte)n;
        TickerQueue.tkqAdd(sukPoolTicker, XEiJ.mpuClockTime + 1000000000L);
    }

    public static void sukPoolAdd2(int n, int n2) {
        if (509 < sukPoolLength) {
            SUK.sukPoolFlush();
        }
        SUK.sukPoolBuffer[SUK.sukPoolLength++] = (byte)n;
        SUK.sukPoolBuffer[SUK.sukPoolLength++] = (byte)n2;
        TickerQueue.tkqAdd(sukPoolTicker, XEiJ.mpuClockTime + 1000000000L);
    }

    public static void sukPoolFlush() {
        if (0 < sukPoolLength) {
            sukPort1.writeBytes(sukPoolBuffer, sukPoolLength);
            sukPoolLength = 0;
        }
    }

    public static void sukDebugInit() {
        sukDebugOn = Settings.sgsGetOnOff("sukdebug");
    }

    public static void sukDebugTini() {
        Settings.sgsPutOnOff("sukdebug", sukDebugOn);
    }

    public static void sukDebugRegister(boolean bl, int n) {
        if (n != 21 && n != 31 && sukDebugLastRegister[n] != sukRegister[n]) {
            System.out.printf("%08x suk%s() %s=0x%02x\n", XEiJ.regPC0, bl ? "Read" : "Write", SPC_REG_NAME[n], 0xFF & sukRegister[n]);
            SUK.sukDebugLastRegister[n] = sukRegister[n];
        }
    }

    public static void sukDumpInit() {
        sukDumpOn = Settings.sgsGetOnOff("sukdump");
        sukDumpLength = 0;
        sukDataPhase = -1;
    }

    public static void sukDumpTini() {
        Settings.sgsPutOnOff("sukdump", sukDumpOn);
    }

    public static void sukDumpAdd(int n) {
        SUK.sukDumpDump(sukRegister[11] & 7);
        if (sukDumpLength < 4096) {
            SUK.sukDumpBuffer[SUK.sukDumpLength++] = (byte)n;
        }
    }

    public static void sukDumpDump(int n) {
        if (sukDataPhase != n) {
            if (0 <= sukDataPhase) {
                System.out.printf("%08x %s\n", XEiJ.regPC0, SPC_PHASE_NAME[sukDataPhase]);
                int n2 = sukDumpLength + 15 & 0xFFFFFFF0;
                for (int i = 0; i < n2; i += 16) {
                    int n3;
                    System.out.printf("%08x ", i);
                    for (n3 = 0; n3 < 16; ++n3) {
                        if (i + n3 < sukDumpLength) {
                            System.out.printf("%02x ", 0xFF & sukDumpBuffer[i + n3]);
                            continue;
                        }
                        System.out.print("   ");
                    }
                    for (n3 = 0; n3 < 16; ++n3) {
                        if (i + n3 < sukDumpLength) {
                            if (32 <= sukDumpBuffer[i + n3] && sukDumpBuffer[i + n3] <= 126) {
                                System.out.printf("%c", 0xFF & sukDumpBuffer[i + n3]);
                                continue;
                            }
                            System.out.print(".");
                            continue;
                        }
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
            sukDataPhase = sukDataPhase == 7 && n == 0 ? -1 : n;
            sukDumpLength = 0;
        }
    }

    static {
        sukRegister = new byte[32];
        sukDataListener1 = new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent serialPortEvent) {
                if (serialPortEvent.getEventType() != 1) {
                    return;
                }
                int n = sukPort1.bytesAvailable();
                byte[] byArray = new byte[n];
                sukPort1.readBytes(byArray, n);
                int n2 = sukQueueWrite;
                int n3 = sukQueueRead;
                if (0x100000 - (n2 - n3) < n) {
                    System.out.printf("%08x sukDataListener1.serialEvent() queue is full\n", XEiJ.regPC0);
                    return;
                }
                int n4 = n2 & 0xFFFFF;
                int n5 = Math.min(n, 0x100000 - n4);
                System.arraycopy(byArray, 0, sukQueueArray, n4, n5);
                if (n5 < n) {
                    System.arraycopy(byArray, n5, sukQueueArray, 0, n - n5);
                }
                sukQueueWrite = n2 += n;
            }
        };
        sukDataListener2 = new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent serialPortEvent) {
                if (serialPortEvent.getEventType() != 1) {
                    return;
                }
                byte[] byArray = serialPortEvent.getReceivedData();
                if (byArray == null) {
                    return;
                }
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    if (byArray[i] != 73) continue;
                    if (sukDebugOn) {
                        System.out.printf("%08x serialEvent() interrupt\n", XEiJ.regPC0);
                    }
                    if (sukExpansion) {
                        XEiJ.eb2Interrupt(16384);
                        continue;
                    }
                    IOInterrupt.ioiSpcFall();
                    IOInterrupt.ioiSpcRise();
                }
            }
        };
        sukQueueArray = new byte[0x100000];
        sukQueueTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n = XEiJ.regPC;
                InstructionBreakPoint.ibpAddWaitPoint(n, XEiJ.regSRS, sukQueueInstruction);
                if (sukDebugOn) {
                    int n2 = sukQueueRequired;
                    System.out.printf("%08x sukQueueTicker.tick() queue instruction at pc=0x%08x required=%d\n", XEiJ.regPC0, n, n2);
                }
            }
        };
        sukQueueInstruction = new WaitInstruction(){

            @Override
            public boolean terminate() {
                return sukQueueRequired <= sukQueueWrite - sukQueueRead;
            }
        };
        sukDregMPUTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n = XEiJ.regPC;
                InstructionBreakPoint.ibpAddWaitPoint(n, XEiJ.regSRS, sukDregMPUInstruction);
                if (sukDebugOn) {
                    int n2 = sukDregRequired;
                    System.out.printf("%08x sukDregMPUTicker.tick() dreg mpu instruction at pc=0x%08x required=%d\n", XEiJ.regPC0, n, n2);
                }
            }
        };
        sukDregMPUInstruction = new WaitInstruction(){

            @Override
            public boolean terminate() {
                return (++sukDregCounter & 0xF) == 0 && sukDregRequired <= SUK.sukDregAvailable();
            }
        };
        sukDregDMACInstruction = new WaitInstruction(){

            @Override
            public boolean terminate() {
                boolean bl;
                boolean bl2 = bl = (++sukDregCounter & 0xF) == 0 && sukDregRequired <= SUK.sukDregAvailable();
                if (bl) {
                    HD63450.dmaTransfer(1);
                }
                return bl;
            }
        };
        sukPoolBuffer = new byte[511];
        sukPoolTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                SUK.sukPoolFlush();
            }
        };
        sukIntervalInstruction = new WaitInstruction(){

            @Override
            public boolean terminate() {
                return (++sukIntervalCounter & 0xF) == 0 && 0L <= System.nanoTime() - sukIntervalTime;
            }
        };
        sukDebugLastRegister = new byte[32];
        sukDumpBuffer = new byte[4096];
    }
}

