/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import xeij.ADPCM;
import xeij.HD63450;
import xeij.Multilingual;
import xeij.OPM;
import xeij.SoundMonitor;
import xeij.TickerQueue;
import xeij.XEiJ;

public class SoundSource {
    public static final boolean SND_ON = true;
    public static final int SND_SAMPLE_FREQ = 48000;
    public static final int SND_CHANNELS = 2;
    public static final int SND_SAMPLE_SHIFT = 2;
    public static final int SND_SAMPLE_BYTES = 4;
    public static SourceDataLine sndLine;
    public static boolean sndPlayOn;
    public static final int SND_BLOCK_FREQ = 25;
    public static final long SND_BLOCK_TIME = 40000000000L;
    public static final int SND_BLOCK_SAMPLES = 1920;
    public static final int SND_BLOCK_BYTES = 7680;
    public static final boolean SND_FREQ_TABLE = true;
    public static final boolean SND_INTERPOLATION_ON = true;
    public static final int SND_INTERPOLATION_BIT = 8;
    public static final int[] sndFreqConvIndex;
    public static final int[] sndFreqConvFraction;
    public static SNDRateConverter sndRateConverter;
    public static final int SND_BUFFER_SAMPLES = 5760;
    public static final int SND_BUFFER_BYTES = 23040;
    public static final byte[] sndByteBlock;
    public static long sndBlockClock;
    public static final boolean SND_BYTE_BUFFER_ENDIAN = false;
    public static ByteOrder sndNativeEndian;
    public static short[] sndShortBlock;
    public static ByteBuffer sndByteBuffer;
    public static ShortBuffer sndShortBuffer;
    public static final int SND_VOLUME_MAX = 40;
    public static final int SND_VOLUME_DEFAULT = 20;
    public static final int SND_VOLUME_STEP = 5;
    public static int sndVolume;
    public static int sndCurrentScale;
    public static int sndTargetScale;
    public static final boolean SND_ZERO_LEVEL_SHIFT = false;
    public static int sndAdaptiveShiftM;
    public static int sndAdaptiveShiftL;
    public static int sndAdaptiveShiftR;
    public static final TickerQueue.Ticker sndBlockTicker;
    public static final TickerQueue.Ticker sndPcmTicker;

    public static void sndInit() {
        sndNativeEndian = ByteOrder.nativeOrder();
        try {
            AudioFormat audioFormat = new AudioFormat(48000.0f, 16, 2, true, false);
            sndLine = AudioSystem.getSourceDataLine(audioFormat);
            sndLine.open(audioFormat, 23040);
            sndLine.start();
        }
        catch (Exception exception) {
            sndLine = null;
            sndPlayOn = false;
        }
        for (int i = 0; i < 1920; ++i) {
            int n = i * 2500;
            int n2 = n / 1920;
            SoundSource.sndFreqConvIndex[i] = 2 * n2;
            SoundSource.sndFreqConvFraction[i] = (n - n2 * 1920 << 8) / 1920;
        }
        sndCurrentScale = 0;
        sndTargetScale = sndPlayOn && sndVolume > 0 ? (int)(Math.pow(2.0, 11.0 + (double)(sndVolume - 20) / 5.0) + 0.5) : 0;
    }

    public static void sndTini() {
        if (sndLine != null) {
            sndLine.stop();
            sndLine.close();
        }
    }

    public static void sndStart() {
        SoundSource.sndReset();
        OPM.opmReset();
        ADPCM.pcmReset();
    }

    public static void sndReset() {
        ADPCM.pcmClock = Long.MAX_VALUE;
        sndBlockClock = XEiJ.mpuClockTime + 40000000000L;
        TickerQueue.tkqRemove(sndPcmTicker);
        TickerQueue.tkqAdd(sndBlockTicker, sndBlockClock);
    }

    public static void sndSetPlayOn(boolean bl) {
        if (sndLine != null && sndPlayOn != bl) {
            if (bl) {
                System.out.println(Multilingual.mlnJapanese ? "\u97f3\u58f0\u3092\u51fa\u529b\u3057\u307e\u3059" : "Sound is output");
            } else {
                System.out.println(Multilingual.mlnJapanese ? "\u97f3\u58f0\u3092\u51fa\u529b\u3057\u307e\u305b\u3093" : "Sound is not output");
            }
            sndPlayOn = bl;
            SoundSource.sndSetVolume(sndVolume);
            if (XEiJ.mpuTask != null) {
                XEiJ.mpuStart();
            }
        }
    }

    public static void sndSetVolume(int n) {
        sndVolume = Math.max(0, Math.min(40, n));
        int n2 = sndTargetScale = sndPlayOn && sndVolume > 0 ? (int)(Math.pow(2.0, 11.0 + (double)(sndVolume - 20) / 5.0) + 0.5) : 0;
        if (XEiJ.mnbVolumeLabel != null) {
            XEiJ.mnbVolumeLabel.setText(String.valueOf(sndVolume));
        }
    }

    static {
        sndFreqConvIndex = new int[1920];
        sndFreqConvFraction = new int[1920];
        sndByteBlock = new byte[23040];
        sndBlockTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                OPM.opmYM2151.generate(5000);
                if (ADPCM.pcmPointer < 5000) {
                    ADPCM.pcmFillBuffer(5000);
                }
                if ((sndTargetScale | sndCurrentScale) != 0) {
                    n = 1920;
                    (n == 1920 ? sndRateConverter : SNDRateConverter.ADAPTIVE).convert(n);
                    if (sndLine.available() != 0) {
                        try {
                            long l = System.nanoTime();
                            sndLine.write(sndByteBlock, 0, n << 2);
                            XEiJ.mpuTotalNano -= System.nanoTime() - l;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (SoundMonitor.smnIsVisible) {
                    SoundMonitor.smnUpdate();
                }
                OPM.opmYM2151.clear();
                ADPCM.pcmPointer = Math.max(0, ADPCM.pcmPointer - 5000);
                for (n = 0; n < ADPCM.pcmPointer; ++n) {
                    ADPCM.pcmBuffer[n] = ADPCM.pcmBuffer[n + 5000];
                }
                if (ADPCM.pcmOSCFreqMode != ADPCM.pcmOSCFreqRequest) {
                    ADPCM.pcmOSCFreqMode = ADPCM.pcmOSCFreqRequest;
                    ADPCM.pcmUpdateRepeatInterval();
                }
                if (XEiJ.mpuClockTime >= (sndBlockClock += 40000000000L)) {
                    sndBlockClock = XEiJ.mpuClockTime + 40000000000L;
                }
                TickerQueue.tkqAdd(sndBlockTicker, sndBlockClock);
            }
        };
        sndPcmTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (ADPCM.pcmEncodedData >= 0) {
                    int n = (ADPCM.pcmDecodedData1 >= 0 ? ADPCM.pcmDecoderTableP : ADPCM.pcmDecoderTableM)[ADPCM.pcmDecoderPointer << 8 | ADPCM.pcmEncodedData];
                    int n2 = n >> -13 << 4;
                    int n3 = n << 13 >> -13 << 4;
                    ADPCM.pcmDecoderPointer = n & 0x3F;
                    ADPCM.pcmEncodedData = -1;
                    int n4 = Math.max(Short.MIN_VALUE, Math.min(32752, ADPCM.pcmDecodedData1 + n2));
                    ADPCM.pcmInterpolationEngine.write(n4);
                    ADPCM.pcmInterpolationEngine.write(Math.max(Short.MIN_VALUE, Math.min(32752, n4 + n3)));
                } else {
                    int n = ADPCM.pcmDecodedData1;
                    n += (n >>> 31) - (-n >>> 31);
                    ADPCM.pcmInterpolationEngine.write(n);
                    ADPCM.pcmInterpolationEngine.write(n + (n >>> 31) - (-n >>> 31));
                }
                if (XEiJ.mpuClockTime >= (ADPCM.pcmClock += ADPCM.pcmInterval)) {
                    ADPCM.pcmClock = XEiJ.mpuClockTime + ADPCM.pcmInterval;
                }
                TickerQueue.tkqAdd(sndPcmTicker, ADPCM.pcmClock);
                HD63450.dmaFallPCL(3);
            }
        };
    }

    public static enum SNDRateConverter {
        ADAPTIVE{

            @Override
            public void convert(int n) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 1250 - n;
                if (n4 >= 0) {
                    do {
                        ++n2;
                    } while ((n4 -= n) >= 0);
                }
                block1: while (true) {
                    int n5 = n2 << 1;
                    int n6 = (OPM.opmBuffer[n5] + ADPCM.pcmBuffer[n5]) * sndCurrentScale >> 12;
                    int n7 = (OPM.opmBuffer[n5 + 1] + ADPCM.pcmBuffer[n5 + 1]) * sndCurrentScale >> 12;
                    n6 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n6));
                    n7 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n7));
                    do {
                        int n8 = n3 << 2;
                        SoundSource.sndByteBlock[n8] = (byte)n6;
                        SoundSource.sndByteBlock[n8 + 1] = (byte)(n6 >> 8);
                        SoundSource.sndByteBlock[n8 + 2] = (byte)n7;
                        SoundSource.sndByteBlock[n8 + 3] = (byte)(n7 >> 8);
                        sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                        if (++n3 >= n) break block1;
                    } while ((n4 += 2500) < 0);
                    do {
                        ++n2;
                    } while ((n4 -= n) >= 0);
                }
            }
        }
        ,
        THINNING_MONO{

            @Override
            public void convert(int n) {
                for (int i = 0; i < 1920; ++i) {
                    int n2 = sndFreqConvIndex[i];
                    int n3 = (OPM.opmBuffer[n2] + ADPCM.pcmBuffer[n2]) * sndCurrentScale >> 12;
                    n3 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n3));
                    int n4 = i << 1;
                    SoundSource.sndByteBlock[n4] = (byte)n3;
                    SoundSource.sndByteBlock[n4 + 1] = (byte)(n3 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                }
            }
        }
        ,
        THINNING_STEREO{

            @Override
            public void convert(int n) {
                for (int i = 0; i < 1920; ++i) {
                    int n2 = sndFreqConvIndex[i];
                    int n3 = (OPM.opmBuffer[n2] + ADPCM.pcmBuffer[n2]) * sndCurrentScale >> 12;
                    int n4 = (OPM.opmBuffer[n2 + 1] + ADPCM.pcmBuffer[n2 + 1]) * sndCurrentScale >> 12;
                    n3 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n3));
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n4));
                    int n5 = i << 2;
                    SoundSource.sndByteBlock[n5] = (byte)n3;
                    SoundSource.sndByteBlock[n5 + 1] = (byte)(n3 >> 8);
                    SoundSource.sndByteBlock[n5 + 2] = (byte)n4;
                    SoundSource.sndByteBlock[n5 + 3] = (byte)(n4 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                }
            }
        }
        ,
        LINEAR_MONO{

            @Override
            public void convert(int n) {
                for (int i = 0; i < 1920; ++i) {
                    int n2 = sndFreqConvIndex[i];
                    int n3 = sndFreqConvFraction[i];
                    int n4 = 256 - n3;
                    int n5 = ((OPM.opmBuffer[n2] + ADPCM.pcmBuffer[n2]) * n4 + (OPM.opmBuffer[n2 + 1] + ADPCM.pcmBuffer[n2 + 1]) * n3 >> 8) * sndCurrentScale >> 12;
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n5));
                    int n6 = i << 1;
                    SoundSource.sndByteBlock[n6] = (byte)n5;
                    SoundSource.sndByteBlock[n6 + 1] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                }
            }
        }
        ,
        LINEAR_STEREO{

            @Override
            public void convert(int n) {
                for (int i = 0; i < 1920; ++i) {
                    int n2 = sndFreqConvIndex[i];
                    int n3 = sndFreqConvFraction[i];
                    int n4 = 256 - n3;
                    int n5 = ((OPM.opmBuffer[n2] + ADPCM.pcmBuffer[n2]) * n4 + (OPM.opmBuffer[n2 + 2] + ADPCM.pcmBuffer[n2 + 2]) * n3 >> 8) * sndCurrentScale >> 12;
                    int n6 = ((OPM.opmBuffer[n2 + 1] + ADPCM.pcmBuffer[n2 + 1]) * n4 + (OPM.opmBuffer[n2 + 3] + ADPCM.pcmBuffer[n2 + 3]) * n3 >> 8) * sndCurrentScale >> 12;
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n5));
                    n6 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n6));
                    int n7 = i << 2;
                    SoundSource.sndByteBlock[n7] = (byte)n5;
                    SoundSource.sndByteBlock[n7 + 1] = (byte)(n5 >> 8);
                    SoundSource.sndByteBlock[n7 + 2] = (byte)n6;
                    SoundSource.sndByteBlock[n7 + 3] = (byte)(n6 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                }
            }
        }
        ,
        CONSTANT_AREA_STEREO_48000{

            @Override
            public void convert(int n) {
                int n2;
                for (n2 = 0; n2 < 5000; n2 += 2) {
                    OPM.opmBuffer[n2] = (OPM.opmBuffer[n2] + ADPCM.pcmBuffer[n2]) * sndCurrentScale >> 12;
                    OPM.opmBuffer[n2 + 1] = (OPM.opmBuffer[n2 + 1] + ADPCM.pcmBuffer[n2 + 1]) * sndCurrentScale >> 12;
                }
                n2 = 0;
                int n3 = 0;
                while (n2 < 5000) {
                    int n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 96 * OPM.opmBuffer[n2 + 0] + 29 * OPM.opmBuffer[n2 + 2] + 64 >> 7));
                    int n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 96 * OPM.opmBuffer[n2 + 1] + 29 * OPM.opmBuffer[n2 + 3] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 0] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 1] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 2] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 3] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 67 * OPM.opmBuffer[n2 + 2] + 58 * OPM.opmBuffer[n2 + 4] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 67 * OPM.opmBuffer[n2 + 3] + 58 * OPM.opmBuffer[n2 + 5] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 4] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 5] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 6] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 7] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 38 * OPM.opmBuffer[n2 + 4] + 87 * OPM.opmBuffer[n2 + 6] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 38 * OPM.opmBuffer[n2 + 5] + 87 * OPM.opmBuffer[n2 + 7] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 8] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 9] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 10] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 11] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 9 * OPM.opmBuffer[n2 + 6] + 96 * OPM.opmBuffer[n2 + 8] + 20 * OPM.opmBuffer[n2 + 10] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 9 * OPM.opmBuffer[n2 + 7] + 96 * OPM.opmBuffer[n2 + 9] + 20 * OPM.opmBuffer[n2 + 11] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 12] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 13] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 14] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 15] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 76 * OPM.opmBuffer[n2 + 10] + 49 * OPM.opmBuffer[n2 + 12] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 76 * OPM.opmBuffer[n2 + 11] + 49 * OPM.opmBuffer[n2 + 13] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 16] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 17] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 18] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 19] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 47 * OPM.opmBuffer[n2 + 12] + 78 * OPM.opmBuffer[n2 + 14] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 47 * OPM.opmBuffer[n2 + 13] + 78 * OPM.opmBuffer[n2 + 15] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 20] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 21] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 22] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 23] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 18 * OPM.opmBuffer[n2 + 14] + 96 * OPM.opmBuffer[n2 + 16] + 11 * OPM.opmBuffer[n2 + 18] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 18 * OPM.opmBuffer[n2 + 15] + 96 * OPM.opmBuffer[n2 + 17] + 11 * OPM.opmBuffer[n2 + 19] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 24] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 25] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 26] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 27] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 85 * OPM.opmBuffer[n2 + 18] + 40 * OPM.opmBuffer[n2 + 20] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 85 * OPM.opmBuffer[n2 + 19] + 40 * OPM.opmBuffer[n2 + 21] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 28] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 29] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 30] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 31] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 56 * OPM.opmBuffer[n2 + 20] + 69 * OPM.opmBuffer[n2 + 22] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 56 * OPM.opmBuffer[n2 + 21] + 69 * OPM.opmBuffer[n2 + 23] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 32] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 33] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 34] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 35] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 27 * OPM.opmBuffer[n2 + 22] + 96 * OPM.opmBuffer[n2 + 24] + 2 * OPM.opmBuffer[n2 + 26] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 27 * OPM.opmBuffer[n2 + 23] + 96 * OPM.opmBuffer[n2 + 25] + 2 * OPM.opmBuffer[n2 + 27] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 36] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 37] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 38] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 39] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 94 * OPM.opmBuffer[n2 + 26] + 31 * OPM.opmBuffer[n2 + 28] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 94 * OPM.opmBuffer[n2 + 27] + 31 * OPM.opmBuffer[n2 + 29] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 40] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 41] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 42] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 43] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 65 * OPM.opmBuffer[n2 + 28] + 60 * OPM.opmBuffer[n2 + 30] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 65 * OPM.opmBuffer[n2 + 29] + 60 * OPM.opmBuffer[n2 + 31] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 44] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 45] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 46] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 47] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 36 * OPM.opmBuffer[n2 + 30] + 89 * OPM.opmBuffer[n2 + 32] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 36 * OPM.opmBuffer[n2 + 31] + 89 * OPM.opmBuffer[n2 + 33] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 48] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 49] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 50] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 51] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 7 * OPM.opmBuffer[n2 + 32] + 96 * OPM.opmBuffer[n2 + 34] + 22 * OPM.opmBuffer[n2 + 36] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 7 * OPM.opmBuffer[n2 + 33] + 96 * OPM.opmBuffer[n2 + 35] + 22 * OPM.opmBuffer[n2 + 37] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 52] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 53] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 54] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 55] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 74 * OPM.opmBuffer[n2 + 36] + 51 * OPM.opmBuffer[n2 + 38] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 74 * OPM.opmBuffer[n2 + 37] + 51 * OPM.opmBuffer[n2 + 39] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 56] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 57] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 58] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 59] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 45 * OPM.opmBuffer[n2 + 38] + 80 * OPM.opmBuffer[n2 + 40] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 45 * OPM.opmBuffer[n2 + 39] + 80 * OPM.opmBuffer[n2 + 41] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 60] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 61] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 62] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 63] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 16 * OPM.opmBuffer[n2 + 40] + 96 * OPM.opmBuffer[n2 + 42] + 13 * OPM.opmBuffer[n2 + 44] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 16 * OPM.opmBuffer[n2 + 41] + 96 * OPM.opmBuffer[n2 + 43] + 13 * OPM.opmBuffer[n2 + 45] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 64] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 65] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 66] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 67] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 83 * OPM.opmBuffer[n2 + 44] + 42 * OPM.opmBuffer[n2 + 46] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 83 * OPM.opmBuffer[n2 + 45] + 42 * OPM.opmBuffer[n2 + 47] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 68] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 69] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 70] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 71] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 54 * OPM.opmBuffer[n2 + 46] + 71 * OPM.opmBuffer[n2 + 48] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 54 * OPM.opmBuffer[n2 + 47] + 71 * OPM.opmBuffer[n2 + 49] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 72] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 73] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 74] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 75] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 25 * OPM.opmBuffer[n2 + 48] + 96 * OPM.opmBuffer[n2 + 50] + 4 * OPM.opmBuffer[n2 + 52] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 25 * OPM.opmBuffer[n2 + 49] + 96 * OPM.opmBuffer[n2 + 51] + 4 * OPM.opmBuffer[n2 + 53] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 76] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 77] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 78] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 79] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 92 * OPM.opmBuffer[n2 + 52] + 33 * OPM.opmBuffer[n2 + 54] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 92 * OPM.opmBuffer[n2 + 53] + 33 * OPM.opmBuffer[n2 + 55] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 80] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 81] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 82] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 83] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 63 * OPM.opmBuffer[n2 + 54] + 62 * OPM.opmBuffer[n2 + 56] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 63 * OPM.opmBuffer[n2 + 55] + 62 * OPM.opmBuffer[n2 + 57] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 84] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 85] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 86] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 87] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 34 * OPM.opmBuffer[n2 + 56] + 91 * OPM.opmBuffer[n2 + 58] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 34 * OPM.opmBuffer[n2 + 57] + 91 * OPM.opmBuffer[n2 + 59] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 88] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 89] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 90] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 91] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 5 * OPM.opmBuffer[n2 + 58] + 96 * OPM.opmBuffer[n2 + 60] + 24 * OPM.opmBuffer[n2 + 62] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 5 * OPM.opmBuffer[n2 + 59] + 96 * OPM.opmBuffer[n2 + 61] + 24 * OPM.opmBuffer[n2 + 63] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 92] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 93] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 94] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 95] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 72 * OPM.opmBuffer[n2 + 62] + 53 * OPM.opmBuffer[n2 + 64] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 72 * OPM.opmBuffer[n2 + 63] + 53 * OPM.opmBuffer[n2 + 65] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 96] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 97] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 98] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 99] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 43 * OPM.opmBuffer[n2 + 64] + 82 * OPM.opmBuffer[n2 + 66] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 43 * OPM.opmBuffer[n2 + 65] + 82 * OPM.opmBuffer[n2 + 67] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 100] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 101] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 102] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 103] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 14 * OPM.opmBuffer[n2 + 66] + 96 * OPM.opmBuffer[n2 + 68] + 15 * OPM.opmBuffer[n2 + 70] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 14 * OPM.opmBuffer[n2 + 67] + 96 * OPM.opmBuffer[n2 + 69] + 15 * OPM.opmBuffer[n2 + 71] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 104] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 105] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 106] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 107] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 81 * OPM.opmBuffer[n2 + 70] + 44 * OPM.opmBuffer[n2 + 72] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 81 * OPM.opmBuffer[n2 + 71] + 44 * OPM.opmBuffer[n2 + 73] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 108] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 109] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 110] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 111] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 52 * OPM.opmBuffer[n2 + 72] + 73 * OPM.opmBuffer[n2 + 74] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 52 * OPM.opmBuffer[n2 + 73] + 73 * OPM.opmBuffer[n2 + 75] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 112] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 113] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 114] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 115] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 23 * OPM.opmBuffer[n2 + 74] + 96 * OPM.opmBuffer[n2 + 76] + 6 * OPM.opmBuffer[n2 + 78] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 23 * OPM.opmBuffer[n2 + 75] + 96 * OPM.opmBuffer[n2 + 77] + 6 * OPM.opmBuffer[n2 + 79] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 116] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 117] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 118] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 119] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 90 * OPM.opmBuffer[n2 + 78] + 35 * OPM.opmBuffer[n2 + 80] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 90 * OPM.opmBuffer[n2 + 79] + 35 * OPM.opmBuffer[n2 + 81] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 120] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 121] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 122] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 123] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 61 * OPM.opmBuffer[n2 + 80] + 64 * OPM.opmBuffer[n2 + 82] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 61 * OPM.opmBuffer[n2 + 81] + 64 * OPM.opmBuffer[n2 + 83] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 124] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 125] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 126] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 127] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 32 * OPM.opmBuffer[n2 + 82] + 93 * OPM.opmBuffer[n2 + 84] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 32 * OPM.opmBuffer[n2 + 83] + 93 * OPM.opmBuffer[n2 + 85] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 128] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 129] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 130] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 131] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 3 * OPM.opmBuffer[n2 + 84] + 96 * OPM.opmBuffer[n2 + 86] + 26 * OPM.opmBuffer[n2 + 88] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 3 * OPM.opmBuffer[n2 + 85] + 96 * OPM.opmBuffer[n2 + 87] + 26 * OPM.opmBuffer[n2 + 89] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 132] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 133] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 134] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 135] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 70 * OPM.opmBuffer[n2 + 88] + 55 * OPM.opmBuffer[n2 + 90] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 70 * OPM.opmBuffer[n2 + 89] + 55 * OPM.opmBuffer[n2 + 91] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 136] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 137] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 138] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 139] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 41 * OPM.opmBuffer[n2 + 90] + 84 * OPM.opmBuffer[n2 + 92] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 41 * OPM.opmBuffer[n2 + 91] + 84 * OPM.opmBuffer[n2 + 93] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 140] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 141] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 142] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 143] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 12 * OPM.opmBuffer[n2 + 92] + 96 * OPM.opmBuffer[n2 + 94] + 17 * OPM.opmBuffer[n2 + 96] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 12 * OPM.opmBuffer[n2 + 93] + 96 * OPM.opmBuffer[n2 + 95] + 17 * OPM.opmBuffer[n2 + 97] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 144] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 145] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 146] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 147] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 79 * OPM.opmBuffer[n2 + 96] + 46 * OPM.opmBuffer[n2 + 98] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 79 * OPM.opmBuffer[n2 + 97] + 46 * OPM.opmBuffer[n2 + 99] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 148] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 149] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 150] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 151] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 50 * OPM.opmBuffer[n2 + 98] + 75 * OPM.opmBuffer[n2 + 100] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 50 * OPM.opmBuffer[n2 + 99] + 75 * OPM.opmBuffer[n2 + 101] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 152] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 153] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 154] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 155] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 21 * OPM.opmBuffer[n2 + 100] + 96 * OPM.opmBuffer[n2 + 102] + 8 * OPM.opmBuffer[n2 + 104] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 21 * OPM.opmBuffer[n2 + 101] + 96 * OPM.opmBuffer[n2 + 103] + 8 * OPM.opmBuffer[n2 + 105] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 156] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 157] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 158] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 159] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 88 * OPM.opmBuffer[n2 + 104] + 37 * OPM.opmBuffer[n2 + 106] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 88 * OPM.opmBuffer[n2 + 105] + 37 * OPM.opmBuffer[n2 + 107] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 160] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 161] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 162] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 163] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 59 * OPM.opmBuffer[n2 + 106] + 66 * OPM.opmBuffer[n2 + 108] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 59 * OPM.opmBuffer[n2 + 107] + 66 * OPM.opmBuffer[n2 + 109] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 164] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 165] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 166] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 167] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 30 * OPM.opmBuffer[n2 + 108] + 95 * OPM.opmBuffer[n2 + 110] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 30 * OPM.opmBuffer[n2 + 109] + 95 * OPM.opmBuffer[n2 + 111] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 168] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 169] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 170] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 171] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, OPM.opmBuffer[n2 + 110] + 96 * OPM.opmBuffer[n2 + 112] + 28 * OPM.opmBuffer[n2 + 114] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, OPM.opmBuffer[n2 + 111] + 96 * OPM.opmBuffer[n2 + 113] + 28 * OPM.opmBuffer[n2 + 115] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 172] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 173] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 174] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 175] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 68 * OPM.opmBuffer[n2 + 114] + 57 * OPM.opmBuffer[n2 + 116] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 68 * OPM.opmBuffer[n2 + 115] + 57 * OPM.opmBuffer[n2 + 117] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 176] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 177] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 178] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 179] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 39 * OPM.opmBuffer[n2 + 116] + 86 * OPM.opmBuffer[n2 + 118] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 39 * OPM.opmBuffer[n2 + 117] + 86 * OPM.opmBuffer[n2 + 119] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 180] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 181] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 182] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 183] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 10 * OPM.opmBuffer[n2 + 118] + 96 * OPM.opmBuffer[n2 + 120] + 19 * OPM.opmBuffer[n2 + 122] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 10 * OPM.opmBuffer[n2 + 119] + 96 * OPM.opmBuffer[n2 + 121] + 19 * OPM.opmBuffer[n2 + 123] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 184] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 185] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 186] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 187] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 77 * OPM.opmBuffer[n2 + 122] + 48 * OPM.opmBuffer[n2 + 124] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 77 * OPM.opmBuffer[n2 + 123] + 48 * OPM.opmBuffer[n2 + 125] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 188] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 189] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 190] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 191] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 48 * OPM.opmBuffer[n2 + 124] + 77 * OPM.opmBuffer[n2 + 126] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 48 * OPM.opmBuffer[n2 + 125] + 77 * OPM.opmBuffer[n2 + 127] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 192] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 193] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 194] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 195] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 19 * OPM.opmBuffer[n2 + 126] + 96 * OPM.opmBuffer[n2 + 128] + 10 * OPM.opmBuffer[n2 + 130] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 19 * OPM.opmBuffer[n2 + 127] + 96 * OPM.opmBuffer[n2 + 129] + 10 * OPM.opmBuffer[n2 + 131] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 196] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 197] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 198] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 199] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 86 * OPM.opmBuffer[n2 + 130] + 39 * OPM.opmBuffer[n2 + 132] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 86 * OPM.opmBuffer[n2 + 131] + 39 * OPM.opmBuffer[n2 + 133] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 200] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 201] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 202] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 203] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 57 * OPM.opmBuffer[n2 + 132] + 68 * OPM.opmBuffer[n2 + 134] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 57 * OPM.opmBuffer[n2 + 133] + 68 * OPM.opmBuffer[n2 + 135] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 204] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 205] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 206] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 207] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 28 * OPM.opmBuffer[n2 + 134] + 96 * OPM.opmBuffer[n2 + 136] + OPM.opmBuffer[n2 + 138] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 28 * OPM.opmBuffer[n2 + 135] + 96 * OPM.opmBuffer[n2 + 137] + OPM.opmBuffer[n2 + 139] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 208] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 209] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 210] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 211] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 95 * OPM.opmBuffer[n2 + 138] + 30 * OPM.opmBuffer[n2 + 140] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 95 * OPM.opmBuffer[n2 + 139] + 30 * OPM.opmBuffer[n2 + 141] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 212] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 213] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 214] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 215] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 66 * OPM.opmBuffer[n2 + 140] + 59 * OPM.opmBuffer[n2 + 142] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 66 * OPM.opmBuffer[n2 + 141] + 59 * OPM.opmBuffer[n2 + 143] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 216] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 217] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 218] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 219] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 37 * OPM.opmBuffer[n2 + 142] + 88 * OPM.opmBuffer[n2 + 144] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 37 * OPM.opmBuffer[n2 + 143] + 88 * OPM.opmBuffer[n2 + 145] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 220] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 221] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 222] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 223] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 8 * OPM.opmBuffer[n2 + 144] + 96 * OPM.opmBuffer[n2 + 146] + 21 * OPM.opmBuffer[n2 + 148] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 8 * OPM.opmBuffer[n2 + 145] + 96 * OPM.opmBuffer[n2 + 147] + 21 * OPM.opmBuffer[n2 + 149] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 224] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 225] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 226] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 227] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 75 * OPM.opmBuffer[n2 + 148] + 50 * OPM.opmBuffer[n2 + 150] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 75 * OPM.opmBuffer[n2 + 149] + 50 * OPM.opmBuffer[n2 + 151] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 228] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 229] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 230] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 231] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 46 * OPM.opmBuffer[n2 + 150] + 79 * OPM.opmBuffer[n2 + 152] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 46 * OPM.opmBuffer[n2 + 151] + 79 * OPM.opmBuffer[n2 + 153] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 232] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 233] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 234] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 235] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 17 * OPM.opmBuffer[n2 + 152] + 96 * OPM.opmBuffer[n2 + 154] + 12 * OPM.opmBuffer[n2 + 156] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 17 * OPM.opmBuffer[n2 + 153] + 96 * OPM.opmBuffer[n2 + 155] + 12 * OPM.opmBuffer[n2 + 157] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 236] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 237] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 238] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 239] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 84 * OPM.opmBuffer[n2 + 156] + 41 * OPM.opmBuffer[n2 + 158] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 84 * OPM.opmBuffer[n2 + 157] + 41 * OPM.opmBuffer[n2 + 159] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 240] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 241] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 242] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 243] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 55 * OPM.opmBuffer[n2 + 158] + 70 * OPM.opmBuffer[n2 + 160] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 55 * OPM.opmBuffer[n2 + 159] + 70 * OPM.opmBuffer[n2 + 161] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 244] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 245] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 246] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 247] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 26 * OPM.opmBuffer[n2 + 160] + 96 * OPM.opmBuffer[n2 + 162] + 3 * OPM.opmBuffer[n2 + 164] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 26 * OPM.opmBuffer[n2 + 161] + 96 * OPM.opmBuffer[n2 + 163] + 3 * OPM.opmBuffer[n2 + 165] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 248] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 249] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 250] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 251] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 93 * OPM.opmBuffer[n2 + 164] + 32 * OPM.opmBuffer[n2 + 166] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 93 * OPM.opmBuffer[n2 + 165] + 32 * OPM.opmBuffer[n2 + 167] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 252] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 253] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 254] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 255] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 64 * OPM.opmBuffer[n2 + 166] + 61 * OPM.opmBuffer[n2 + 168] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 64 * OPM.opmBuffer[n2 + 167] + 61 * OPM.opmBuffer[n2 + 169] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 256] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 257] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 258] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 259] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 35 * OPM.opmBuffer[n2 + 168] + 90 * OPM.opmBuffer[n2 + 170] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 35 * OPM.opmBuffer[n2 + 169] + 90 * OPM.opmBuffer[n2 + 171] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 260] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 261] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 262] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 263] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 6 * OPM.opmBuffer[n2 + 170] + 96 * OPM.opmBuffer[n2 + 172] + 23 * OPM.opmBuffer[n2 + 174] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 6 * OPM.opmBuffer[n2 + 171] + 96 * OPM.opmBuffer[n2 + 173] + 23 * OPM.opmBuffer[n2 + 175] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 264] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 265] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 266] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 267] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 73 * OPM.opmBuffer[n2 + 174] + 52 * OPM.opmBuffer[n2 + 176] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 73 * OPM.opmBuffer[n2 + 175] + 52 * OPM.opmBuffer[n2 + 177] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 268] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 269] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 270] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 271] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 44 * OPM.opmBuffer[n2 + 176] + 81 * OPM.opmBuffer[n2 + 178] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 44 * OPM.opmBuffer[n2 + 177] + 81 * OPM.opmBuffer[n2 + 179] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 272] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 273] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 274] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 275] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 15 * OPM.opmBuffer[n2 + 178] + 96 * OPM.opmBuffer[n2 + 180] + 14 * OPM.opmBuffer[n2 + 182] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 15 * OPM.opmBuffer[n2 + 179] + 96 * OPM.opmBuffer[n2 + 181] + 14 * OPM.opmBuffer[n2 + 183] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 276] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 277] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 278] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 279] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 82 * OPM.opmBuffer[n2 + 182] + 43 * OPM.opmBuffer[n2 + 184] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 82 * OPM.opmBuffer[n2 + 183] + 43 * OPM.opmBuffer[n2 + 185] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 280] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 281] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 282] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 283] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 53 * OPM.opmBuffer[n2 + 184] + 72 * OPM.opmBuffer[n2 + 186] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 53 * OPM.opmBuffer[n2 + 185] + 72 * OPM.opmBuffer[n2 + 187] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 284] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 285] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 286] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 287] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 24 * OPM.opmBuffer[n2 + 186] + 96 * OPM.opmBuffer[n2 + 188] + 5 * OPM.opmBuffer[n2 + 190] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 24 * OPM.opmBuffer[n2 + 187] + 96 * OPM.opmBuffer[n2 + 189] + 5 * OPM.opmBuffer[n2 + 191] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 288] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 289] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 290] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 291] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 91 * OPM.opmBuffer[n2 + 190] + 34 * OPM.opmBuffer[n2 + 192] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 91 * OPM.opmBuffer[n2 + 191] + 34 * OPM.opmBuffer[n2 + 193] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 292] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 293] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 294] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 295] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 62 * OPM.opmBuffer[n2 + 192] + 63 * OPM.opmBuffer[n2 + 194] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 62 * OPM.opmBuffer[n2 + 193] + 63 * OPM.opmBuffer[n2 + 195] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 296] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 297] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 298] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 299] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 33 * OPM.opmBuffer[n2 + 194] + 92 * OPM.opmBuffer[n2 + 196] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 33 * OPM.opmBuffer[n2 + 195] + 92 * OPM.opmBuffer[n2 + 197] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 300] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 301] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 302] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 303] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 4 * OPM.opmBuffer[n2 + 196] + 96 * OPM.opmBuffer[n2 + 198] + 25 * OPM.opmBuffer[n2 + 200] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 4 * OPM.opmBuffer[n2 + 197] + 96 * OPM.opmBuffer[n2 + 199] + 25 * OPM.opmBuffer[n2 + 201] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 304] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 305] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 306] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 307] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 71 * OPM.opmBuffer[n2 + 200] + 54 * OPM.opmBuffer[n2 + 202] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 71 * OPM.opmBuffer[n2 + 201] + 54 * OPM.opmBuffer[n2 + 203] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 308] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 309] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 310] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 311] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 42 * OPM.opmBuffer[n2 + 202] + 83 * OPM.opmBuffer[n2 + 204] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 42 * OPM.opmBuffer[n2 + 203] + 83 * OPM.opmBuffer[n2 + 205] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 312] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 313] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 314] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 315] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 13 * OPM.opmBuffer[n2 + 204] + 96 * OPM.opmBuffer[n2 + 206] + 16 * OPM.opmBuffer[n2 + 208] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 13 * OPM.opmBuffer[n2 + 205] + 96 * OPM.opmBuffer[n2 + 207] + 16 * OPM.opmBuffer[n2 + 209] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 316] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 317] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 318] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 319] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 80 * OPM.opmBuffer[n2 + 208] + 45 * OPM.opmBuffer[n2 + 210] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 80 * OPM.opmBuffer[n2 + 209] + 45 * OPM.opmBuffer[n2 + 211] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 320] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 321] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 322] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 323] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 51 * OPM.opmBuffer[n2 + 210] + 74 * OPM.opmBuffer[n2 + 212] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 51 * OPM.opmBuffer[n2 + 211] + 74 * OPM.opmBuffer[n2 + 213] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 324] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 325] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 326] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 327] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 22 * OPM.opmBuffer[n2 + 212] + 96 * OPM.opmBuffer[n2 + 214] + 7 * OPM.opmBuffer[n2 + 216] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 22 * OPM.opmBuffer[n2 + 213] + 96 * OPM.opmBuffer[n2 + 215] + 7 * OPM.opmBuffer[n2 + 217] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 328] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 329] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 330] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 331] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 89 * OPM.opmBuffer[n2 + 216] + 36 * OPM.opmBuffer[n2 + 218] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 89 * OPM.opmBuffer[n2 + 217] + 36 * OPM.opmBuffer[n2 + 219] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 332] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 333] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 334] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 335] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 60 * OPM.opmBuffer[n2 + 218] + 65 * OPM.opmBuffer[n2 + 220] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 60 * OPM.opmBuffer[n2 + 219] + 65 * OPM.opmBuffer[n2 + 221] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 336] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 337] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 338] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 339] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 31 * OPM.opmBuffer[n2 + 220] + 94 * OPM.opmBuffer[n2 + 222] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 31 * OPM.opmBuffer[n2 + 221] + 94 * OPM.opmBuffer[n2 + 223] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 340] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 341] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 342] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 343] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 2 * OPM.opmBuffer[n2 + 222] + 96 * OPM.opmBuffer[n2 + 224] + 27 * OPM.opmBuffer[n2 + 226] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 2 * OPM.opmBuffer[n2 + 223] + 96 * OPM.opmBuffer[n2 + 225] + 27 * OPM.opmBuffer[n2 + 227] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 344] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 345] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 346] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 347] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 69 * OPM.opmBuffer[n2 + 226] + 56 * OPM.opmBuffer[n2 + 228] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 69 * OPM.opmBuffer[n2 + 227] + 56 * OPM.opmBuffer[n2 + 229] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 348] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 349] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 350] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 351] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 40 * OPM.opmBuffer[n2 + 228] + 85 * OPM.opmBuffer[n2 + 230] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 40 * OPM.opmBuffer[n2 + 229] + 85 * OPM.opmBuffer[n2 + 231] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 352] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 353] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 354] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 355] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 11 * OPM.opmBuffer[n2 + 230] + 96 * OPM.opmBuffer[n2 + 232] + 18 * OPM.opmBuffer[n2 + 234] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 11 * OPM.opmBuffer[n2 + 231] + 96 * OPM.opmBuffer[n2 + 233] + 18 * OPM.opmBuffer[n2 + 235] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 356] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 357] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 358] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 359] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 78 * OPM.opmBuffer[n2 + 234] + 47 * OPM.opmBuffer[n2 + 236] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 78 * OPM.opmBuffer[n2 + 235] + 47 * OPM.opmBuffer[n2 + 237] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 360] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 361] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 362] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 363] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 49 * OPM.opmBuffer[n2 + 236] + 76 * OPM.opmBuffer[n2 + 238] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 49 * OPM.opmBuffer[n2 + 237] + 76 * OPM.opmBuffer[n2 + 239] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 364] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 365] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 366] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 367] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 20 * OPM.opmBuffer[n2 + 238] + 96 * OPM.opmBuffer[n2 + 240] + 9 * OPM.opmBuffer[n2 + 242] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 20 * OPM.opmBuffer[n2 + 239] + 96 * OPM.opmBuffer[n2 + 241] + 9 * OPM.opmBuffer[n2 + 243] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 368] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 369] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 370] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 371] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 87 * OPM.opmBuffer[n2 + 242] + 38 * OPM.opmBuffer[n2 + 244] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 87 * OPM.opmBuffer[n2 + 243] + 38 * OPM.opmBuffer[n2 + 245] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 372] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 373] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 374] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 375] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 58 * OPM.opmBuffer[n2 + 244] + 67 * OPM.opmBuffer[n2 + 246] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 58 * OPM.opmBuffer[n2 + 245] + 67 * OPM.opmBuffer[n2 + 247] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 376] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 377] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 378] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 379] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n4 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 29 * OPM.opmBuffer[n2 + 246] + 96 * OPM.opmBuffer[n2 + 248] + 64 >> 7));
                    n5 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, 29 * OPM.opmBuffer[n2 + 247] + 96 * OPM.opmBuffer[n2 + 249] + 64 >> 7));
                    SoundSource.sndByteBlock[n3 + 380] = (byte)n4;
                    SoundSource.sndByteBlock[n3 + 381] = (byte)(n4 >> 8);
                    SoundSource.sndByteBlock[n3 + 382] = (byte)n5;
                    SoundSource.sndByteBlock[n3 + 383] = (byte)(n5 >> 8);
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                    n2 += 250;
                    n3 += 384;
                }
            }
        }
        ,
        LINEAR_AREA_STEREO_48000{

            @Override
            public void convert(int n) {
                int n2;
                int n3;
                int n4 = OPM.opmBuffer[5000];
                int n5 = OPM.opmBuffer[5001];
                for (n3 = 0; n3 < 5000; n3 += 2) {
                    n2 = (OPM.opmBuffer[n3] + ADPCM.pcmBuffer[n3]) * sndCurrentScale >> 12;
                    OPM.opmBuffer[n3] = n4;
                    n4 = n2;
                    n2 = (OPM.opmBuffer[n3 + 1] + ADPCM.pcmBuffer[n3 + 1]) * sndCurrentScale >> 12;
                    OPM.opmBuffer[n3 + 1] = n5;
                    n5 = n2;
                    sndCurrentScale += (sndCurrentScale - sndTargetScale >>> 31) - (sndTargetScale - sndCurrentScale >>> 31);
                }
                OPM.opmBuffer[5000] = n4;
                OPM.opmBuffer[5001] = n5;
                n3 = 0;
                n2 = 0;
                while (n3 < 5000) {
                    float f = OPM.opmBuffer[n3 + 2];
                    float f2 = OPM.opmBuffer[n3 + 4];
                    int n6 = (int)(25165.824f * (float)OPM.opmBuffer[n3] + 38073.684f * f + 2296.4907f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 1] = (byte)(n6 >> 8);
                    float f3 = 12257.963f * f + 44092.074f * f2;
                    f = OPM.opmBuffer[n3 + 6];
                    n6 = (int)(f3 + 9185.963f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 4] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 5] = (byte)(n6 >> 8);
                    float f4 = 3943.0828f * f2 + 40924.5f * f;
                    f2 = OPM.opmBuffer[n3 + 8];
                    n6 = (int)(f4 + 20668.416f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 8] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 9] = (byte)(n6 >> 8);
                    float f5 = 221.184f * f + 29663.232f * f2;
                    f = OPM.opmBuffer[n3 + 10];
                    f2 = OPM.opmBuffer[n3 + 12];
                    n6 = (int)(f5 + 34559.316f * f + 1092.2667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 12] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 13] = (byte)(n6 >> 8);
                    float f6 = 15772.331f * f + 43207.34f * f2;
                    f = OPM.opmBuffer[n3 + 14];
                    n6 = (int)(f6 + 6556.3306f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 16] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 17] = (byte)(n6 >> 8);
                    float f7 = 6032.0425f * f2 + 42890.582f * f;
                    f2 = OPM.opmBuffer[n3 + 16];
                    n6 = (int)(f7 + 16613.377f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 20] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 21] = (byte)(n6 >> 8);
                    float f8 = 884.736f * f + 33718.273f * f2;
                    f = OPM.opmBuffer[n3 + 18];
                    f2 = OPM.opmBuffer[n3 + 20];
                    n6 = (int)(f8 + 30602.582f * f + 330.41068f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 24] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 25] = (byte)(n6 >> 8);
                    float f9 = 19729.066f * f + 41437.867f * f2;
                    f = OPM.opmBuffer[n3 + 22];
                    n6 = (int)(f9 + 4369.067f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 28] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 29] = (byte)(n6 >> 8);
                    float f10 = 8563.371f * f2 + 43971.926f * f;
                    f2 = OPM.opmBuffer[n3 + 24];
                    n6 = (int)(f10 + 13000.704f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 32] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 33] = (byte)(n6 >> 8);
                    float f11 = 1990.656f * f + 37330.945f * f2;
                    f = OPM.opmBuffer[n3 + 26];
                    f2 = OPM.opmBuffer[n3 + 28];
                    n6 = (int)(f11 + 26203.477f * f + 10.922667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 36] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 37] = (byte)(n6 >> 8);
                    float f12 = 24128.17f * f + 38783.66f * f2;
                    f = OPM.opmBuffer[n3 + 30];
                    n6 = (int)(f12 + 2624.1707f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 40] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 41] = (byte)(n6 >> 8);
                    float f13 = 11537.066f * f2 + 44168.535f * f;
                    f2 = OPM.opmBuffer[n3 + 32];
                    n6 = (int)(f13 + 9830.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 44] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 45] = (byte)(n6 >> 8);
                    float f14 = 3538.944f * f + 40367.445f * f2;
                    f = OPM.opmBuffer[n3 + 34];
                    n6 = (int)(f14 + 21629.611f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 48] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 49] = (byte)(n6 >> 8);
                    float f15 = 133.80267f * f2 + 28702.037f * f;
                    f2 = OPM.opmBuffer[n3 + 36];
                    f = OPM.opmBuffer[n3 + 38];
                    n6 = (int)(f15 + 35378.516f * f2 + 1321.6427f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 52] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 53] = (byte)(n6 >> 8);
                    float f16 = 14953.131f * f2 + 43480.406f * f;
                    f2 = OPM.opmBuffer[n3 + 40];
                    n6 = (int)(f16 + 7102.464f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 56] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 57] = (byte)(n6 >> 8);
                    float f17 = 5529.6f * f + 42530.133f * f2;
                    f = OPM.opmBuffer[n3 + 42];
                    n6 = (int)(f17 + 17476.268f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 60] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 61] = (byte)(n6 >> 8);
                    float f18 = 699.05066f * f2 + 32855.383f * f;
                    f2 = OPM.opmBuffer[n3 + 44];
                    f = OPM.opmBuffer[n3 + 46];
                    n6 = (int)(f18 + 31520.086f * f2 + 461.48267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 64] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 65] = (byte)(n6 >> 8);
                    float f19 = 18811.562f * f2 + 41907.543f * f;
                    f2 = OPM.opmBuffer[n3 + 48];
                    n6 = (int)(f19 + 4816.896f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 68] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 69] = (byte)(n6 >> 8);
                    float f20 = 7962.624f * f + 43808.086f * f2;
                    f = OPM.opmBuffer[n3 + 50];
                    n6 = (int)(f20 + 13765.291f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 72] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 73] = (byte)(n6 >> 8);
                    float f21 = 1706.6666f * f2 + 36566.355f * f;
                    f2 = OPM.opmBuffer[n3 + 52];
                    f = OPM.opmBuffer[n3 + 54];
                    n6 = (int)(f21 + 27219.285f * f2 + 43.690666f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 76] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 77] = (byte)(n6 >> 8);
                    float f22 = 23112.363f * f2 + 39449.94f * f;
                    f2 = OPM.opmBuffer[n3 + 56];
                    n6 = (int)(f22 + 2973.696f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 80] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 81] = (byte)(n6 >> 8);
                    float f23 = 10838.016f * f + 44201.3f * f2;
                    f = OPM.opmBuffer[n3 + 58];
                    n6 = (int)(f23 + 10496.683f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 84] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 85] = (byte)(n6 >> 8);
                    float f24 = 3156.6506f * f2 + 39766.7f * f;
                    f2 = OPM.opmBuffer[n3 + 60];
                    n6 = (int)(f24 + 22612.65f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 88] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 89] = (byte)(n6 >> 8);
                    float f25 = 68.26667f * f + 27718.998f * f2;
                    f = OPM.opmBuffer[n3 + 62];
                    f2 = OPM.opmBuffer[n3 + 64];
                    n6 = (int)(f25 + 36175.87f * f + 1572.864f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 92] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 93] = (byte)(n6 >> 8);
                    float f26 = 14155.776f * f + 43709.78f * f2;
                    f = OPM.opmBuffer[n3 + 66];
                    n6 = (int)(f26 + 7670.443f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 96] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 97] = (byte)(n6 >> 8);
                    float f27 = 5049.0024f * f2 + 42125.996f * f;
                    f2 = OPM.opmBuffer[n3 + 68];
                    n6 = (int)(f27 + 18361.002f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 100] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 101] = (byte)(n6 >> 8);
                    float f28 = 535.2107f * f + 31970.645f * f2;
                    f = OPM.opmBuffer[n3 + 70];
                    f2 = OPM.opmBuffer[n3 + 72];
                    n6 = (int)(f28 + 32415.744f * f + 614.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 104] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 105] = (byte)(n6 >> 8);
                    float f29 = 17915.904f * f + 42333.523f * f2;
                    f = OPM.opmBuffer[n3 + 74];
                    n6 = (int)(f29 + 5286.571f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 108] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 109] = (byte)(n6 >> 8);
                    float f30 = 7383.7227f * f2 + 43600.555f * f;
                    f2 = OPM.opmBuffer[n3 + 76];
                    n6 = (int)(f30 + 14551.723f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 112] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 113] = (byte)(n6 >> 8);
                    float f31 = 1444.5227f * f + 35779.926f * f2;
                    f = OPM.opmBuffer[n3 + 78];
                    f2 = OPM.opmBuffer[n3 + 80];
                    n6 = (int)(f31 + 28213.248f * f + 98.304f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 116] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 117] = (byte)(n6 >> 8);
                    float f32 = 22118.4f * f + 40072.535f * f2;
                    f = OPM.opmBuffer[n3 + 82];
                    n6 = (int)(f32 + 3345.0667f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 120] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 121] = (byte)(n6 >> 8);
                    float f33 = 10160.811f * f2 + 44190.38f * f;
                    f2 = OPM.opmBuffer[n3 + 84];
                    n6 = (int)(f33 + 11184.811f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 124] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 125] = (byte)(n6 >> 8);
                    float f34 = 2796.2026f * f + 39122.26f * f2;
                    f = OPM.opmBuffer[n3 + 86];
                    n6 = (int)(f34 + 23617.535f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 128] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 129] = (byte)(n6 >> 8);
                    float f35 = 24.576f * f2 + 26714.111f * f;
                    f2 = OPM.opmBuffer[n3 + 88];
                    f = OPM.opmBuffer[n3 + 90];
                    n6 = (int)(f35 + 36951.383f * f2 + 1845.9307f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 132] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 133] = (byte)(n6 >> 8);
                    float f36 = 13380.267f * f2 + 43895.465f * f;
                    f2 = OPM.opmBuffer[n3 + 92];
                    n6 = (int)(f36 + 8260.267f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 136] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 137] = (byte)(n6 >> 8);
                    float f37 = 4590.2505f * f + 41678.164f * f2;
                    f = OPM.opmBuffer[n3 + 94];
                    n6 = (int)(f37 + 19267.584f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 140] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 141] = (byte)(n6 >> 8);
                    float f38 = 393.216f * f2 + 31064.064f * f;
                    f2 = OPM.opmBuffer[n3 + 96];
                    f = OPM.opmBuffer[n3 + 98];
                    n6 = (int)(f38 + 33289.56f * f2 + 789.16266f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 144] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 145] = (byte)(n6 >> 8);
                    float f39 = 17042.09f * f2 + 42715.82f * f;
                    f2 = OPM.opmBuffer[n3 + 100];
                    n6 = (int)(f39 + 5778.091f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 148] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 149] = (byte)(n6 >> 8);
                    float f40 = 6826.6665f * f + 43349.332f * f2;
                    f = OPM.opmBuffer[n3 + 102];
                    n6 = (int)(f40 + 15360.0f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 152] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 153] = (byte)(n6 >> 8);
                    float f41 = 1204.224f * f2 + 34971.65f * f;
                    f2 = OPM.opmBuffer[n3 + 104];
                    f = OPM.opmBuffer[n3 + 106];
                    n6 = (int)(f41 + 29185.365f * f2 + 174.76266f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 156] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 157] = (byte)(n6 >> 8);
                    float f42 = 21146.283f * f2 + 40651.434f * f;
                    f2 = OPM.opmBuffer[n3 + 108];
                    n6 = (int)(f42 + 3738.2827f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 160] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 161] = (byte)(n6 >> 8);
                    float f43 = 9505.45f * f + 44135.766f * f2;
                    f = OPM.opmBuffer[n3 + 110];
                    n6 = (int)(f43 + 11894.784f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 164] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 165] = (byte)(n6 >> 8);
                    float f44 = 2457.6f * f2 + 38434.133f * f;
                    f2 = OPM.opmBuffer[n3 + 112];
                    n6 = (int)(f44 + 24644.268f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 168] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 169] = (byte)(n6 >> 8);
                    float f45 = 2.7306666f * f + 25687.38f * f2;
                    f = OPM.opmBuffer[n3 + 114];
                    f2 = OPM.opmBuffer[n3 + 116];
                    n6 = (int)(f45 + 37705.047f * f + 2140.8428f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 172] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 173] = (byte)(n6 >> 8);
                    float f46 = 12626.603f * f + 44037.46f * f2;
                    f = OPM.opmBuffer[n3 + 118];
                    n6 = (int)(f46 + 8871.936f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 176] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 177] = (byte)(n6 >> 8);
                    float f47 = 4153.344f * f2 + 41186.645f * f;
                    f2 = OPM.opmBuffer[n3 + 120];
                    n6 = (int)(f47 + 20196.01f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 180] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 181] = (byte)(n6 >> 8);
                    float f48 = 273.06668f * f + 30135.637f * f2;
                    f = OPM.opmBuffer[n3 + 122];
                    f2 = OPM.opmBuffer[n3 + 124];
                    n6 = (int)(f48 + 34141.523f * f + 985.7707f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 184] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 185] = (byte)(n6 >> 8);
                    float f49 = 16190.123f * f + 43054.42f * f2;
                    f = OPM.opmBuffer[n3 + 126];
                    n6 = (int)(f49 + 6291.456f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 188] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 189] = (byte)(n6 >> 8);
                    float f50 = 6291.456f * f2 + 43054.42f * f;
                    f2 = OPM.opmBuffer[n3 + 128];
                    n6 = (int)(f50 + 16190.123f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 192] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 193] = (byte)(n6 >> 8);
                    float f51 = 985.7707f * f + 34141.523f * f2;
                    f = OPM.opmBuffer[n3 + 130];
                    f2 = OPM.opmBuffer[n3 + 132];
                    n6 = (int)(f51 + 30135.637f * f + 273.06668f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 196] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 197] = (byte)(n6 >> 8);
                    float f52 = 20196.01f * f + 41186.645f * f2;
                    f = OPM.opmBuffer[n3 + 134];
                    n6 = (int)(f52 + 4153.344f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 200] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 201] = (byte)(n6 >> 8);
                    float f53 = 8871.936f * f2 + 44037.46f * f;
                    f2 = OPM.opmBuffer[n3 + 136];
                    n6 = (int)(f53 + 12626.603f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 204] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 205] = (byte)(n6 >> 8);
                    float f54 = 2140.8428f * f + 37705.047f * f2;
                    f = OPM.opmBuffer[n3 + 138];
                    f2 = OPM.opmBuffer[n3 + 140];
                    n6 = (int)(f54 + 25687.38f * f + 2.7306666f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 208] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 209] = (byte)(n6 >> 8);
                    float f55 = 24644.268f * f + 38434.133f * f2;
                    f = OPM.opmBuffer[n3 + 142];
                    n6 = (int)(f55 + 2457.6f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 212] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 213] = (byte)(n6 >> 8);
                    float f56 = 11894.784f * f2 + 44135.766f * f;
                    f2 = OPM.opmBuffer[n3 + 144];
                    n6 = (int)(f56 + 9505.45f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 216] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 217] = (byte)(n6 >> 8);
                    float f57 = 3738.2827f * f + 40651.434f * f2;
                    f = OPM.opmBuffer[n3 + 146];
                    n6 = (int)(f57 + 21146.283f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 220] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 221] = (byte)(n6 >> 8);
                    float f58 = 174.76266f * f2 + 29185.365f * f;
                    f2 = OPM.opmBuffer[n3 + 148];
                    f = OPM.opmBuffer[n3 + 150];
                    n6 = (int)(f58 + 34971.65f * f2 + 1204.224f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 224] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 225] = (byte)(n6 >> 8);
                    float f59 = 15360.0f * f2 + 43349.332f * f;
                    f2 = OPM.opmBuffer[n3 + 152];
                    n6 = (int)(f59 + 6826.6665f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 228] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 229] = (byte)(n6 >> 8);
                    float f60 = 5778.091f * f + 42715.82f * f2;
                    f = OPM.opmBuffer[n3 + 154];
                    n6 = (int)(f60 + 17042.09f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 232] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 233] = (byte)(n6 >> 8);
                    float f61 = 789.16266f * f2 + 33289.56f * f;
                    f2 = OPM.opmBuffer[n3 + 156];
                    f = OPM.opmBuffer[n3 + 158];
                    n6 = (int)(f61 + 31064.064f * f2 + 393.216f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 236] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 237] = (byte)(n6 >> 8);
                    float f62 = 19267.584f * f2 + 41678.164f * f;
                    f2 = OPM.opmBuffer[n3 + 160];
                    n6 = (int)(f62 + 4590.2505f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 240] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 241] = (byte)(n6 >> 8);
                    float f63 = 8260.267f * f + 43895.465f * f2;
                    f = OPM.opmBuffer[n3 + 162];
                    n6 = (int)(f63 + 13380.267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 244] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 245] = (byte)(n6 >> 8);
                    float f64 = 1845.9307f * f2 + 36951.383f * f;
                    f2 = OPM.opmBuffer[n3 + 164];
                    f = OPM.opmBuffer[n3 + 166];
                    n6 = (int)(f64 + 26714.111f * f2 + 24.576f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 248] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 249] = (byte)(n6 >> 8);
                    float f65 = 23617.535f * f2 + 39122.26f * f;
                    f2 = OPM.opmBuffer[n3 + 168];
                    n6 = (int)(f65 + 2796.2026f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 252] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 253] = (byte)(n6 >> 8);
                    float f66 = 11184.811f * f + 44190.38f * f2;
                    f = OPM.opmBuffer[n3 + 170];
                    n6 = (int)(f66 + 10160.811f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 256] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 257] = (byte)(n6 >> 8);
                    float f67 = 3345.0667f * f2 + 40072.535f * f;
                    f2 = OPM.opmBuffer[n3 + 172];
                    n6 = (int)(f67 + 22118.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 260] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 261] = (byte)(n6 >> 8);
                    float f68 = 98.304f * f + 28213.248f * f2;
                    f = OPM.opmBuffer[n3 + 174];
                    f2 = OPM.opmBuffer[n3 + 176];
                    n6 = (int)(f68 + 35779.926f * f + 1444.5227f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 264] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 265] = (byte)(n6 >> 8);
                    float f69 = 14551.723f * f + 43600.555f * f2;
                    f = OPM.opmBuffer[n3 + 178];
                    n6 = (int)(f69 + 7383.7227f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 268] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 269] = (byte)(n6 >> 8);
                    float f70 = 5286.571f * f2 + 42333.523f * f;
                    f2 = OPM.opmBuffer[n3 + 180];
                    n6 = (int)(f70 + 17915.904f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 272] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 273] = (byte)(n6 >> 8);
                    float f71 = 614.4f * f + 32415.744f * f2;
                    f = OPM.opmBuffer[n3 + 182];
                    f2 = OPM.opmBuffer[n3 + 184];
                    n6 = (int)(f71 + 31970.645f * f + 535.2107f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 276] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 277] = (byte)(n6 >> 8);
                    float f72 = 18361.002f * f + 42125.996f * f2;
                    f = OPM.opmBuffer[n3 + 186];
                    n6 = (int)(f72 + 5049.0024f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 280] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 281] = (byte)(n6 >> 8);
                    float f73 = 7670.443f * f2 + 43709.78f * f;
                    f2 = OPM.opmBuffer[n3 + 188];
                    n6 = (int)(f73 + 14155.776f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 284] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 285] = (byte)(n6 >> 8);
                    float f74 = 1572.864f * f + 36175.87f * f2;
                    f = OPM.opmBuffer[n3 + 190];
                    f2 = OPM.opmBuffer[n3 + 192];
                    n6 = (int)(f74 + 27718.998f * f + 68.26667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 288] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 289] = (byte)(n6 >> 8);
                    float f75 = 22612.65f * f + 39766.7f * f2;
                    f = OPM.opmBuffer[n3 + 194];
                    n6 = (int)(f75 + 3156.6506f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 292] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 293] = (byte)(n6 >> 8);
                    float f76 = 10496.683f * f2 + 44201.3f * f;
                    f2 = OPM.opmBuffer[n3 + 196];
                    n6 = (int)(f76 + 10838.016f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 296] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 297] = (byte)(n6 >> 8);
                    float f77 = 2973.696f * f + 39449.94f * f2;
                    f = OPM.opmBuffer[n3 + 198];
                    n6 = (int)(f77 + 23112.363f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 300] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 301] = (byte)(n6 >> 8);
                    float f78 = 43.690666f * f2 + 27219.285f * f;
                    f2 = OPM.opmBuffer[n3 + 200];
                    f = OPM.opmBuffer[n3 + 202];
                    n6 = (int)(f78 + 36566.355f * f2 + 1706.6666f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 304] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 305] = (byte)(n6 >> 8);
                    float f79 = 13765.291f * f2 + 43808.086f * f;
                    f2 = OPM.opmBuffer[n3 + 204];
                    n6 = (int)(f79 + 7962.624f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 308] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 309] = (byte)(n6 >> 8);
                    float f80 = 4816.896f * f + 41907.543f * f2;
                    f = OPM.opmBuffer[n3 + 206];
                    n6 = (int)(f80 + 18811.562f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 312] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 313] = (byte)(n6 >> 8);
                    float f81 = 461.48267f * f2 + 31520.086f * f;
                    f2 = OPM.opmBuffer[n3 + 208];
                    f = OPM.opmBuffer[n3 + 210];
                    n6 = (int)(f81 + 32855.383f * f2 + 699.05066f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 316] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 317] = (byte)(n6 >> 8);
                    float f82 = 17476.268f * f2 + 42530.133f * f;
                    f2 = OPM.opmBuffer[n3 + 212];
                    n6 = (int)(f82 + 5529.6f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 320] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 321] = (byte)(n6 >> 8);
                    float f83 = 7102.464f * f + 43480.406f * f2;
                    f = OPM.opmBuffer[n3 + 214];
                    n6 = (int)(f83 + 14953.131f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 324] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 325] = (byte)(n6 >> 8);
                    float f84 = 1321.6427f * f2 + 35378.516f * f;
                    f2 = OPM.opmBuffer[n3 + 216];
                    f = OPM.opmBuffer[n3 + 218];
                    n6 = (int)(f84 + 28702.037f * f2 + 133.80267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 328] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 329] = (byte)(n6 >> 8);
                    float f85 = 21629.611f * f2 + 40367.445f * f;
                    f2 = OPM.opmBuffer[n3 + 220];
                    n6 = (int)(f85 + 3538.944f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 332] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 333] = (byte)(n6 >> 8);
                    float f86 = 9830.4f * f + 44168.535f * f2;
                    f = OPM.opmBuffer[n3 + 222];
                    n6 = (int)(f86 + 11537.066f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 336] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 337] = (byte)(n6 >> 8);
                    float f87 = 2624.1707f * f2 + 38783.66f * f;
                    f2 = OPM.opmBuffer[n3 + 224];
                    n6 = (int)(f87 + 24128.17f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 340] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 341] = (byte)(n6 >> 8);
                    float f88 = 10.922667f * f + 26203.477f * f2;
                    f = OPM.opmBuffer[n3 + 226];
                    f2 = OPM.opmBuffer[n3 + 228];
                    n6 = (int)(f88 + 37330.945f * f + 1990.656f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 344] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 345] = (byte)(n6 >> 8);
                    float f89 = 13000.704f * f + 43971.926f * f2;
                    f = OPM.opmBuffer[n3 + 230];
                    n6 = (int)(f89 + 8563.371f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 348] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 349] = (byte)(n6 >> 8);
                    float f90 = 4369.067f * f2 + 41437.867f * f;
                    f2 = OPM.opmBuffer[n3 + 232];
                    n6 = (int)(f90 + 19729.066f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 352] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 353] = (byte)(n6 >> 8);
                    float f91 = 330.41068f * f + 30602.582f * f2;
                    f = OPM.opmBuffer[n3 + 234];
                    f2 = OPM.opmBuffer[n3 + 236];
                    n6 = (int)(f91 + 33718.273f * f + 884.736f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 356] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 357] = (byte)(n6 >> 8);
                    float f92 = 16613.377f * f + 42890.582f * f2;
                    f = OPM.opmBuffer[n3 + 238];
                    n6 = (int)(f92 + 6032.0425f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 360] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 361] = (byte)(n6 >> 8);
                    float f93 = 6556.3306f * f2 + 43207.34f * f;
                    f2 = OPM.opmBuffer[n3 + 240];
                    n6 = (int)(f93 + 15772.331f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 364] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 365] = (byte)(n6 >> 8);
                    float f94 = 1092.2667f * f + 34559.316f * f2;
                    f = OPM.opmBuffer[n3 + 242];
                    f2 = OPM.opmBuffer[n3 + 244];
                    n6 = (int)(f94 + 29663.232f * f + 221.184f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 368] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 369] = (byte)(n6 >> 8);
                    float f95 = 20668.416f * f + 40924.5f * f2;
                    f = OPM.opmBuffer[n3 + 246];
                    n6 = (int)(f95 + 3943.0828f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 372] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 373] = (byte)(n6 >> 8);
                    float f96 = 9185.963f * f2 + 44092.074f * f;
                    f2 = OPM.opmBuffer[n3 + 248];
                    n6 = (int)(f96 + 12257.963f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 376] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 377] = (byte)(n6 >> 8);
                    n6 = (int)(2296.4907f * f + 38073.684f * f2 + 25165.824f * (float)OPM.opmBuffer[n3 + 250] + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 380] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 381] = (byte)(n6 >> 8);
                    f = OPM.opmBuffer[n3 + 3];
                    f2 = OPM.opmBuffer[n3 + 5];
                    n6 = (int)(25165.824f * (float)OPM.opmBuffer[n3 + 1] + 38073.684f * f + 2296.4907f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 2] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 3] = (byte)(n6 >> 8);
                    float f97 = 12257.963f * f + 44092.074f * f2;
                    f = OPM.opmBuffer[n3 + 7];
                    n6 = (int)(f97 + 9185.963f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 6] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 7] = (byte)(n6 >> 8);
                    float f98 = 3943.0828f * f2 + 40924.5f * f;
                    f2 = OPM.opmBuffer[n3 + 9];
                    n6 = (int)(f98 + 20668.416f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 10] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 11] = (byte)(n6 >> 8);
                    float f99 = 221.184f * f + 29663.232f * f2;
                    f = OPM.opmBuffer[n3 + 11];
                    f2 = OPM.opmBuffer[n3 + 13];
                    n6 = (int)(f99 + 34559.316f * f + 1092.2667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 14] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 15] = (byte)(n6 >> 8);
                    float f100 = 15772.331f * f + 43207.34f * f2;
                    f = OPM.opmBuffer[n3 + 15];
                    n6 = (int)(f100 + 6556.3306f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 18] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 19] = (byte)(n6 >> 8);
                    float f101 = 6032.0425f * f2 + 42890.582f * f;
                    f2 = OPM.opmBuffer[n3 + 17];
                    n6 = (int)(f101 + 16613.377f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 22] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 23] = (byte)(n6 >> 8);
                    float f102 = 884.736f * f + 33718.273f * f2;
                    f = OPM.opmBuffer[n3 + 19];
                    f2 = OPM.opmBuffer[n3 + 21];
                    n6 = (int)(f102 + 30602.582f * f + 330.41068f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 26] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 27] = (byte)(n6 >> 8);
                    float f103 = 19729.066f * f + 41437.867f * f2;
                    f = OPM.opmBuffer[n3 + 23];
                    n6 = (int)(f103 + 4369.067f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 30] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 31] = (byte)(n6 >> 8);
                    float f104 = 8563.371f * f2 + 43971.926f * f;
                    f2 = OPM.opmBuffer[n3 + 25];
                    n6 = (int)(f104 + 13000.704f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 34] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 35] = (byte)(n6 >> 8);
                    float f105 = 1990.656f * f + 37330.945f * f2;
                    f = OPM.opmBuffer[n3 + 27];
                    f2 = OPM.opmBuffer[n3 + 29];
                    n6 = (int)(f105 + 26203.477f * f + 10.922667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 38] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 39] = (byte)(n6 >> 8);
                    float f106 = 24128.17f * f + 38783.66f * f2;
                    f = OPM.opmBuffer[n3 + 31];
                    n6 = (int)(f106 + 2624.1707f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 42] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 43] = (byte)(n6 >> 8);
                    float f107 = 11537.066f * f2 + 44168.535f * f;
                    f2 = OPM.opmBuffer[n3 + 33];
                    n6 = (int)(f107 + 9830.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 46] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 47] = (byte)(n6 >> 8);
                    float f108 = 3538.944f * f + 40367.445f * f2;
                    f = OPM.opmBuffer[n3 + 35];
                    n6 = (int)(f108 + 21629.611f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 50] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 51] = (byte)(n6 >> 8);
                    float f109 = 133.80267f * f2 + 28702.037f * f;
                    f2 = OPM.opmBuffer[n3 + 37];
                    f = OPM.opmBuffer[n3 + 39];
                    n6 = (int)(f109 + 35378.516f * f2 + 1321.6427f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 54] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 55] = (byte)(n6 >> 8);
                    float f110 = 14953.131f * f2 + 43480.406f * f;
                    f2 = OPM.opmBuffer[n3 + 41];
                    n6 = (int)(f110 + 7102.464f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 58] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 59] = (byte)(n6 >> 8);
                    float f111 = 5529.6f * f + 42530.133f * f2;
                    f = OPM.opmBuffer[n3 + 43];
                    n6 = (int)(f111 + 17476.268f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 62] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 63] = (byte)(n6 >> 8);
                    float f112 = 699.05066f * f2 + 32855.383f * f;
                    f2 = OPM.opmBuffer[n3 + 45];
                    f = OPM.opmBuffer[n3 + 47];
                    n6 = (int)(f112 + 31520.086f * f2 + 461.48267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 66] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 67] = (byte)(n6 >> 8);
                    float f113 = 18811.562f * f2 + 41907.543f * f;
                    f2 = OPM.opmBuffer[n3 + 49];
                    n6 = (int)(f113 + 4816.896f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 70] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 71] = (byte)(n6 >> 8);
                    float f114 = 7962.624f * f + 43808.086f * f2;
                    f = OPM.opmBuffer[n3 + 51];
                    n6 = (int)(f114 + 13765.291f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 74] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 75] = (byte)(n6 >> 8);
                    float f115 = 1706.6666f * f2 + 36566.355f * f;
                    f2 = OPM.opmBuffer[n3 + 53];
                    f = OPM.opmBuffer[n3 + 55];
                    n6 = (int)(f115 + 27219.285f * f2 + 43.690666f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 78] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 79] = (byte)(n6 >> 8);
                    float f116 = 23112.363f * f2 + 39449.94f * f;
                    f2 = OPM.opmBuffer[n3 + 57];
                    n6 = (int)(f116 + 2973.696f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 82] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 83] = (byte)(n6 >> 8);
                    float f117 = 10838.016f * f + 44201.3f * f2;
                    f = OPM.opmBuffer[n3 + 59];
                    n6 = (int)(f117 + 10496.683f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 86] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 87] = (byte)(n6 >> 8);
                    float f118 = 3156.6506f * f2 + 39766.7f * f;
                    f2 = OPM.opmBuffer[n3 + 61];
                    n6 = (int)(f118 + 22612.65f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 90] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 91] = (byte)(n6 >> 8);
                    float f119 = 68.26667f * f + 27718.998f * f2;
                    f = OPM.opmBuffer[n3 + 63];
                    f2 = OPM.opmBuffer[n3 + 65];
                    n6 = (int)(f119 + 36175.87f * f + 1572.864f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 94] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 95] = (byte)(n6 >> 8);
                    float f120 = 14155.776f * f + 43709.78f * f2;
                    f = OPM.opmBuffer[n3 + 67];
                    n6 = (int)(f120 + 7670.443f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 98] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 99] = (byte)(n6 >> 8);
                    float f121 = 5049.0024f * f2 + 42125.996f * f;
                    f2 = OPM.opmBuffer[n3 + 69];
                    n6 = (int)(f121 + 18361.002f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 102] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 103] = (byte)(n6 >> 8);
                    float f122 = 535.2107f * f + 31970.645f * f2;
                    f = OPM.opmBuffer[n3 + 71];
                    f2 = OPM.opmBuffer[n3 + 73];
                    n6 = (int)(f122 + 32415.744f * f + 614.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 106] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 107] = (byte)(n6 >> 8);
                    float f123 = 17915.904f * f + 42333.523f * f2;
                    f = OPM.opmBuffer[n3 + 75];
                    n6 = (int)(f123 + 5286.571f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 110] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 111] = (byte)(n6 >> 8);
                    float f124 = 7383.7227f * f2 + 43600.555f * f;
                    f2 = OPM.opmBuffer[n3 + 77];
                    n6 = (int)(f124 + 14551.723f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 114] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 115] = (byte)(n6 >> 8);
                    float f125 = 1444.5227f * f + 35779.926f * f2;
                    f = OPM.opmBuffer[n3 + 79];
                    f2 = OPM.opmBuffer[n3 + 81];
                    n6 = (int)(f125 + 28213.248f * f + 98.304f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 118] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 119] = (byte)(n6 >> 8);
                    float f126 = 22118.4f * f + 40072.535f * f2;
                    f = OPM.opmBuffer[n3 + 83];
                    n6 = (int)(f126 + 3345.0667f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 122] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 123] = (byte)(n6 >> 8);
                    float f127 = 10160.811f * f2 + 44190.38f * f;
                    f2 = OPM.opmBuffer[n3 + 85];
                    n6 = (int)(f127 + 11184.811f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 126] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 127] = (byte)(n6 >> 8);
                    float f128 = 2796.2026f * f + 39122.26f * f2;
                    f = OPM.opmBuffer[n3 + 87];
                    n6 = (int)(f128 + 23617.535f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 130] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 131] = (byte)(n6 >> 8);
                    float f129 = 24.576f * f2 + 26714.111f * f;
                    f2 = OPM.opmBuffer[n3 + 89];
                    f = OPM.opmBuffer[n3 + 91];
                    n6 = (int)(f129 + 36951.383f * f2 + 1845.9307f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 134] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 135] = (byte)(n6 >> 8);
                    float f130 = 13380.267f * f2 + 43895.465f * f;
                    f2 = OPM.opmBuffer[n3 + 93];
                    n6 = (int)(f130 + 8260.267f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 138] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 139] = (byte)(n6 >> 8);
                    float f131 = 4590.2505f * f + 41678.164f * f2;
                    f = OPM.opmBuffer[n3 + 95];
                    n6 = (int)(f131 + 19267.584f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 142] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 143] = (byte)(n6 >> 8);
                    float f132 = 393.216f * f2 + 31064.064f * f;
                    f2 = OPM.opmBuffer[n3 + 97];
                    f = OPM.opmBuffer[n3 + 99];
                    n6 = (int)(f132 + 33289.56f * f2 + 789.16266f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 146] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 147] = (byte)(n6 >> 8);
                    float f133 = 17042.09f * f2 + 42715.82f * f;
                    f2 = OPM.opmBuffer[n3 + 101];
                    n6 = (int)(f133 + 5778.091f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 150] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 151] = (byte)(n6 >> 8);
                    float f134 = 6826.6665f * f + 43349.332f * f2;
                    f = OPM.opmBuffer[n3 + 103];
                    n6 = (int)(f134 + 15360.0f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 154] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 155] = (byte)(n6 >> 8);
                    float f135 = 1204.224f * f2 + 34971.65f * f;
                    f2 = OPM.opmBuffer[n3 + 105];
                    f = OPM.opmBuffer[n3 + 107];
                    n6 = (int)(f135 + 29185.365f * f2 + 174.76266f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 158] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 159] = (byte)(n6 >> 8);
                    float f136 = 21146.283f * f2 + 40651.434f * f;
                    f2 = OPM.opmBuffer[n3 + 109];
                    n6 = (int)(f136 + 3738.2827f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 162] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 163] = (byte)(n6 >> 8);
                    float f137 = 9505.45f * f + 44135.766f * f2;
                    f = OPM.opmBuffer[n3 + 111];
                    n6 = (int)(f137 + 11894.784f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 166] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 167] = (byte)(n6 >> 8);
                    float f138 = 2457.6f * f2 + 38434.133f * f;
                    f2 = OPM.opmBuffer[n3 + 113];
                    n6 = (int)(f138 + 24644.268f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 170] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 171] = (byte)(n6 >> 8);
                    float f139 = 2.7306666f * f + 25687.38f * f2;
                    f = OPM.opmBuffer[n3 + 115];
                    f2 = OPM.opmBuffer[n3 + 117];
                    n6 = (int)(f139 + 37705.047f * f + 2140.8428f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 174] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 175] = (byte)(n6 >> 8);
                    float f140 = 12626.603f * f + 44037.46f * f2;
                    f = OPM.opmBuffer[n3 + 119];
                    n6 = (int)(f140 + 8871.936f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 178] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 179] = (byte)(n6 >> 8);
                    float f141 = 4153.344f * f2 + 41186.645f * f;
                    f2 = OPM.opmBuffer[n3 + 121];
                    n6 = (int)(f141 + 20196.01f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 182] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 183] = (byte)(n6 >> 8);
                    float f142 = 273.06668f * f + 30135.637f * f2;
                    f = OPM.opmBuffer[n3 + 123];
                    f2 = OPM.opmBuffer[n3 + 125];
                    n6 = (int)(f142 + 34141.523f * f + 985.7707f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 186] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 187] = (byte)(n6 >> 8);
                    float f143 = 16190.123f * f + 43054.42f * f2;
                    f = OPM.opmBuffer[n3 + 127];
                    n6 = (int)(f143 + 6291.456f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 190] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 191] = (byte)(n6 >> 8);
                    float f144 = 6291.456f * f2 + 43054.42f * f;
                    f2 = OPM.opmBuffer[n3 + 129];
                    n6 = (int)(f144 + 16190.123f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 194] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 195] = (byte)(n6 >> 8);
                    float f145 = 985.7707f * f + 34141.523f * f2;
                    f = OPM.opmBuffer[n3 + 131];
                    f2 = OPM.opmBuffer[n3 + 133];
                    n6 = (int)(f145 + 30135.637f * f + 273.06668f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 198] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 199] = (byte)(n6 >> 8);
                    float f146 = 20196.01f * f + 41186.645f * f2;
                    f = OPM.opmBuffer[n3 + 135];
                    n6 = (int)(f146 + 4153.344f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 202] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 203] = (byte)(n6 >> 8);
                    float f147 = 8871.936f * f2 + 44037.46f * f;
                    f2 = OPM.opmBuffer[n3 + 137];
                    n6 = (int)(f147 + 12626.603f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 206] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 207] = (byte)(n6 >> 8);
                    float f148 = 2140.8428f * f + 37705.047f * f2;
                    f = OPM.opmBuffer[n3 + 139];
                    f2 = OPM.opmBuffer[n3 + 141];
                    n6 = (int)(f148 + 25687.38f * f + 2.7306666f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 210] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 211] = (byte)(n6 >> 8);
                    float f149 = 24644.268f * f + 38434.133f * f2;
                    f = OPM.opmBuffer[n3 + 143];
                    n6 = (int)(f149 + 2457.6f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 214] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 215] = (byte)(n6 >> 8);
                    float f150 = 11894.784f * f2 + 44135.766f * f;
                    f2 = OPM.opmBuffer[n3 + 145];
                    n6 = (int)(f150 + 9505.45f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 218] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 219] = (byte)(n6 >> 8);
                    float f151 = 3738.2827f * f + 40651.434f * f2;
                    f = OPM.opmBuffer[n3 + 147];
                    n6 = (int)(f151 + 21146.283f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 222] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 223] = (byte)(n6 >> 8);
                    float f152 = 174.76266f * f2 + 29185.365f * f;
                    f2 = OPM.opmBuffer[n3 + 149];
                    f = OPM.opmBuffer[n3 + 151];
                    n6 = (int)(f152 + 34971.65f * f2 + 1204.224f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 226] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 227] = (byte)(n6 >> 8);
                    float f153 = 15360.0f * f2 + 43349.332f * f;
                    f2 = OPM.opmBuffer[n3 + 153];
                    n6 = (int)(f153 + 6826.6665f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 230] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 231] = (byte)(n6 >> 8);
                    float f154 = 5778.091f * f + 42715.82f * f2;
                    f = OPM.opmBuffer[n3 + 155];
                    n6 = (int)(f154 + 17042.09f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 234] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 235] = (byte)(n6 >> 8);
                    float f155 = 789.16266f * f2 + 33289.56f * f;
                    f2 = OPM.opmBuffer[n3 + 157];
                    f = OPM.opmBuffer[n3 + 159];
                    n6 = (int)(f155 + 31064.064f * f2 + 393.216f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 238] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 239] = (byte)(n6 >> 8);
                    float f156 = 19267.584f * f2 + 41678.164f * f;
                    f2 = OPM.opmBuffer[n3 + 161];
                    n6 = (int)(f156 + 4590.2505f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 242] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 243] = (byte)(n6 >> 8);
                    float f157 = 8260.267f * f + 43895.465f * f2;
                    f = OPM.opmBuffer[n3 + 163];
                    n6 = (int)(f157 + 13380.267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 246] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 247] = (byte)(n6 >> 8);
                    float f158 = 1845.9307f * f2 + 36951.383f * f;
                    f2 = OPM.opmBuffer[n3 + 165];
                    f = OPM.opmBuffer[n3 + 167];
                    n6 = (int)(f158 + 26714.111f * f2 + 24.576f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 250] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 251] = (byte)(n6 >> 8);
                    float f159 = 23617.535f * f2 + 39122.26f * f;
                    f2 = OPM.opmBuffer[n3 + 169];
                    n6 = (int)(f159 + 2796.2026f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 254] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 255] = (byte)(n6 >> 8);
                    float f160 = 11184.811f * f + 44190.38f * f2;
                    f = OPM.opmBuffer[n3 + 171];
                    n6 = (int)(f160 + 10160.811f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 258] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 259] = (byte)(n6 >> 8);
                    float f161 = 3345.0667f * f2 + 40072.535f * f;
                    f2 = OPM.opmBuffer[n3 + 173];
                    n6 = (int)(f161 + 22118.4f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 262] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 263] = (byte)(n6 >> 8);
                    float f162 = 98.304f * f + 28213.248f * f2;
                    f = OPM.opmBuffer[n3 + 175];
                    f2 = OPM.opmBuffer[n3 + 177];
                    n6 = (int)(f162 + 35779.926f * f + 1444.5227f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 266] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 267] = (byte)(n6 >> 8);
                    float f163 = 14551.723f * f + 43600.555f * f2;
                    f = OPM.opmBuffer[n3 + 179];
                    n6 = (int)(f163 + 7383.7227f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 270] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 271] = (byte)(n6 >> 8);
                    float f164 = 5286.571f * f2 + 42333.523f * f;
                    f2 = OPM.opmBuffer[n3 + 181];
                    n6 = (int)(f164 + 17915.904f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 274] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 275] = (byte)(n6 >> 8);
                    float f165 = 614.4f * f + 32415.744f * f2;
                    f = OPM.opmBuffer[n3 + 183];
                    f2 = OPM.opmBuffer[n3 + 185];
                    n6 = (int)(f165 + 31970.645f * f + 535.2107f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 278] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 279] = (byte)(n6 >> 8);
                    float f166 = 18361.002f * f + 42125.996f * f2;
                    f = OPM.opmBuffer[n3 + 187];
                    n6 = (int)(f166 + 5049.0024f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 282] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 283] = (byte)(n6 >> 8);
                    float f167 = 7670.443f * f2 + 43709.78f * f;
                    f2 = OPM.opmBuffer[n3 + 189];
                    n6 = (int)(f167 + 14155.776f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 286] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 287] = (byte)(n6 >> 8);
                    float f168 = 1572.864f * f + 36175.87f * f2;
                    f = OPM.opmBuffer[n3 + 191];
                    f2 = OPM.opmBuffer[n3 + 193];
                    n6 = (int)(f168 + 27718.998f * f + 68.26667f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 290] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 291] = (byte)(n6 >> 8);
                    float f169 = 22612.65f * f + 39766.7f * f2;
                    f = OPM.opmBuffer[n3 + 195];
                    n6 = (int)(f169 + 3156.6506f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 294] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 295] = (byte)(n6 >> 8);
                    float f170 = 10496.683f * f2 + 44201.3f * f;
                    f2 = OPM.opmBuffer[n3 + 197];
                    n6 = (int)(f170 + 10838.016f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 298] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 299] = (byte)(n6 >> 8);
                    float f171 = 2973.696f * f + 39449.94f * f2;
                    f = OPM.opmBuffer[n3 + 199];
                    n6 = (int)(f171 + 23112.363f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 302] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 303] = (byte)(n6 >> 8);
                    float f172 = 43.690666f * f2 + 27219.285f * f;
                    f2 = OPM.opmBuffer[n3 + 201];
                    f = OPM.opmBuffer[n3 + 203];
                    n6 = (int)(f172 + 36566.355f * f2 + 1706.6666f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 306] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 307] = (byte)(n6 >> 8);
                    float f173 = 13765.291f * f2 + 43808.086f * f;
                    f2 = OPM.opmBuffer[n3 + 205];
                    n6 = (int)(f173 + 7962.624f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 310] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 311] = (byte)(n6 >> 8);
                    float f174 = 4816.896f * f + 41907.543f * f2;
                    f = OPM.opmBuffer[n3 + 207];
                    n6 = (int)(f174 + 18811.562f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 314] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 315] = (byte)(n6 >> 8);
                    float f175 = 461.48267f * f2 + 31520.086f * f;
                    f2 = OPM.opmBuffer[n3 + 209];
                    f = OPM.opmBuffer[n3 + 211];
                    n6 = (int)(f175 + 32855.383f * f2 + 699.05066f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 318] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 319] = (byte)(n6 >> 8);
                    float f176 = 17476.268f * f2 + 42530.133f * f;
                    f2 = OPM.opmBuffer[n3 + 213];
                    n6 = (int)(f176 + 5529.6f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 322] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 323] = (byte)(n6 >> 8);
                    float f177 = 7102.464f * f + 43480.406f * f2;
                    f = OPM.opmBuffer[n3 + 215];
                    n6 = (int)(f177 + 14953.131f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 326] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 327] = (byte)(n6 >> 8);
                    float f178 = 1321.6427f * f2 + 35378.516f * f;
                    f2 = OPM.opmBuffer[n3 + 217];
                    f = OPM.opmBuffer[n3 + 219];
                    n6 = (int)(f178 + 28702.037f * f2 + 133.80267f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 330] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 331] = (byte)(n6 >> 8);
                    float f179 = 21629.611f * f2 + 40367.445f * f;
                    f2 = OPM.opmBuffer[n3 + 221];
                    n6 = (int)(f179 + 3538.944f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 334] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 335] = (byte)(n6 >> 8);
                    float f180 = 9830.4f * f + 44168.535f * f2;
                    f = OPM.opmBuffer[n3 + 223];
                    n6 = (int)(f180 + 11537.066f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 338] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 339] = (byte)(n6 >> 8);
                    float f181 = 2624.1707f * f2 + 38783.66f * f;
                    f2 = OPM.opmBuffer[n3 + 225];
                    n6 = (int)(f181 + 24128.17f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 342] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 343] = (byte)(n6 >> 8);
                    float f182 = 10.922667f * f + 26203.477f * f2;
                    f = OPM.opmBuffer[n3 + 227];
                    f2 = OPM.opmBuffer[n3 + 229];
                    n6 = (int)(f182 + 37330.945f * f + 1990.656f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 346] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 347] = (byte)(n6 >> 8);
                    float f183 = 13000.704f * f + 43971.926f * f2;
                    f = OPM.opmBuffer[n3 + 231];
                    n6 = (int)(f183 + 8563.371f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 350] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 351] = (byte)(n6 >> 8);
                    float f184 = 4369.067f * f2 + 41437.867f * f;
                    f2 = OPM.opmBuffer[n3 + 233];
                    n6 = (int)(f184 + 19729.066f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 354] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 355] = (byte)(n6 >> 8);
                    float f185 = 330.41068f * f + 30602.582f * f2;
                    f = OPM.opmBuffer[n3 + 235];
                    f2 = OPM.opmBuffer[n3 + 237];
                    n6 = (int)(f185 + 33718.273f * f + 884.736f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 358] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 359] = (byte)(n6 >> 8);
                    float f186 = 16613.377f * f + 42890.582f * f2;
                    f = OPM.opmBuffer[n3 + 239];
                    n6 = (int)(f186 + 6032.0425f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 362] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 363] = (byte)(n6 >> 8);
                    float f187 = 6556.3306f * f2 + 43207.34f * f;
                    f2 = OPM.opmBuffer[n3 + 241];
                    n6 = (int)(f187 + 15772.331f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 366] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 367] = (byte)(n6 >> 8);
                    float f188 = 1092.2667f * f + 34559.316f * f2;
                    f = OPM.opmBuffer[n3 + 243];
                    f2 = OPM.opmBuffer[n3 + 245];
                    n6 = (int)(f188 + 29663.232f * f + 221.184f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 370] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 371] = (byte)(n6 >> 8);
                    float f189 = 20668.416f * f + 40924.5f * f2;
                    f = OPM.opmBuffer[n3 + 247];
                    n6 = (int)(f189 + 3943.0828f * f + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 374] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 375] = (byte)(n6 >> 8);
                    float f190 = 9185.963f * f2 + 44092.074f * f;
                    f2 = OPM.opmBuffer[n3 + 249];
                    n6 = (int)(f190 + 12257.963f * f2 + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 378] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 379] = (byte)(n6 >> 8);
                    n6 = (int)(2296.4907f * f + 38073.684f * f2 + 25165.824f * (float)OPM.opmBuffer[n3 + 251] + 32768.0f) >> 16;
                    SoundSource.sndByteBlock[n2 + 382] = (byte)n6;
                    SoundSource.sndByteBlock[n2 + 383] = (byte)(n6 >> 8);
                    n3 += 250;
                    n2 += 384;
                }
            }
        };


        public void initialize() {
        }

        public abstract void convert(int var1);
    }
}

